// Persistence of Vision Ray Tracer Scene Description File
// File: cface.inc
// Vers: 3
// Desc:The clock face for the grandfather clock.  The program assumes
//      that the Times Roman font is in "c:\Windows\Fonts".
// Date:June 1996
// Auth:Stephen C. Baker


#declare ScaleFactor = <0.15, 0.25, 0.25>	//use this to scale numerals to same size
#declare FitFace = <0, -0.23, 0>		//use this as translation to fit clock faces


/* 	These are 30 degree angled Roman Numeral for the clock face, a brass inner disk
	for alignment and looks, and the name of the clock manufacturer ( my self in
	this case).  They are NOT placed on a clock face disc here.  That is done later
	where they can be scaled to any size. */

/*	At the bottom of the file there are several thin cylinders angled at 30 degrees.
	These were used to align the numerals.  You will have to use them to realign the
	numbers if you change the font.  Povray 3.0 anchors the fonts on the lower left
	corner at <0, 0, 0>.  Be prepared to do many many small translations to realign
	the numbers */

#declare FaceNumerals = union {
	disc {<0,0,0>, z, 0.5, 0.48
		texture { T_Brass_3A }
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	I
		"I"
		0.50
		0
		scale ScaleFactor
		rotate <0, 0, -4>
		translate <0,.765,0>
		translate FitFace
		rotate <0,0,-29>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	II
		"II"
		0.50
		0
		scale ScaleFactor
		rotate <0, 0, -5>
		translate <0,.765,0>
		translate FitFace
		rotate <0,0,-55.5>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	// III
		"III"
		0.50
		0
		scale ScaleFactor
		rotate <0,0,-5>
		translate <0,.76,0>
		translate FitFace
		rotate <0,0,-85>
		translate <0,.01,0>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	IV
		"IV"
		0.50
		0
		scale ScaleFactor
		rotate <0,0,-5>
		translate <0,.75,0>
		translate FitFace
		rotate <0,0,-115>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	V
		"V"
		0.50
		0
		scale ScaleFactor
		rotate <0,0,-5>
		translate <0,.75,0>
		translate FitFace
		rotate <0,0,-144>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	VI
		"VI"
		0.50
		0
		scale ScaleFactor
		translate <0,.75,0>
		translate FitFace
		rotate <0,0,-181>
		translate <0.10,0,0>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	VII
		"VII"
		0.50
		0
		scale ScaleFactor
		rotate <0,0,-12>
		translate <0,.75,0>
		translate FitFace
		rotate <0,0,-203>
		translate <0.03,-0.04,0>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	VIII
		"VIII"
		0.50
		0
		scale ScaleFactor
		rotate <0,0,-12>
		translate <0,.77,0>
		translate FitFace
		rotate <0,0,-230>
		translate <0.03,-0.04,0>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	// IX
		"IX"
		0.50
		0
		scale ScaleFactor
		translate <0,.75,0>
		translate FitFace
		rotate <0,0,-270>
		translate <0,-.08,0>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	X
		"X"
		0.50
		0
		scale ScaleFactor
		translate <0,.75,0>
		translate FitFace
		rotate <0,0,-295>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	XI
		"XI"
		0.50
		0
		scale ScaleFactor
		rotate <0,0,-11>
		translate <0,.77,0>
 		translate FitFace
		rotate <0,0,-321>

	}

	text{
		ttf "c:\windows\fonts\times.ttf"	//	XII
		"XII"
		0.50
		0
		scale ScaleFactor
		translate <-0.10,.75,0>
		translate FitFace
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	Stephen
		"Stephen"
		0.50
		0
		scale 0.1
		translate <-0.15, -0.25, 0>
	}
	text{
		ttf "c:\windows\fonts\times.ttf"	//	Baker
		"Baker"
		0.50
		0
		scale 0.1
		translate <-0.1, -0.35, 0>
	}
}

// These are reference lines at 30 degrees, use them only to align numerals
/*
cylinder {<0,-2,0>,<0,2,0>,0.002	//12 & 6 reference
	translate <0,5,0>
	pigment { Red }
}
cylinder {<0,-5,0>,<0,5,0>,0.002	//3 & 9 reference
	rotate <0,0,90>
	translate <0,5.815,0>
	pigment { Green }

}
cylinder {<0,-2,0>,<0,2,0>,0.002	//5 & 11 reference
	rotate <0,0,30>
	translate <0,5.815,0>
	pigment { Blue }
}
cylinder {<0,-2,0>,<0,2,0>,0.002	//4 & 10 reference
	pigment { White }
	rotate <0,0,60>
	translate <0,5.815,0>
}
cylinder {<0,-2,0>,<0,2,0>,0.002	//1 & 7 reference
	pigment { Yellow }
	rotate <0,0,-30>
	translate <0,5.815,0>
}
cylinder {<0,-2,0>,<0,2,0>,0.002	//2 & 8 reference
	pigment { Cyan }
	rotate <0,0,-60>
	translate <0,5.815,0>
}

*/