// Persistence of Vision Ray Tracer Scene Description File
// File: fpanel.inc
// Vers: 3
// Desc: The LED (central) panel on the atomic clock.  
// Date: June 1996
// Auth: Stephen C. Baker

/*	This is the time display panel, located in ther center of the atomic clock.
	It simulates a timing counter, accurate to +/- 0.000001 second.  I know the real
	atomic clocks are even more accurate.  This is just a simulated one.  The display
	uses the same LED numerals as DWATCH.INC.  */


#include "hrglass.inc"
#include "dwatch.inc"
#declare PanelDepth = -1.001

#declare PanelDisplayLEDs = union {
     object { DigitalOne
          texture { DigitalRed }
          translate < -10,0,0>
     }
     object { DigitalZero
          texture { DigitalRed }
     }
     object { Colon
          texture { DigitalRed }
     }
     object { DigitalFour
          texture { DigitalRed }
          translate < 12,0,0>
     }
     object { DigitalEight
          texture { DigitalRed }
          translate < 22,0,0>
     }
     object { DigitalThree
          texture { DigitalRed }
          translate < 32,0,0>
     }
     object { DigitalNine
          texture { DigitalRed }
          translate < 42,0,0>
     }
     object { DigitalTwo
          texture { DigitalRed }
          translate < 52,0,0>
     }
     object { DigitalSeven
          texture { DigitalRed }
          translate < 62,0,0>

     }
}


#declare PanelMarkers = union {
     text
     {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          "Sedrial Time",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.3
          translate <-2.5,0.6,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          "10",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <-2.5,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          "1",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <-2,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          ".1",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <-1.3,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          ".01",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <-0.6,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          ".001",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <0,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          ".0001",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <.65,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          ".00001",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <1.35,-0.7,PanelDepth>
          pigment {White }
     }
     text {
          ttf          // font type (only TrueType format for now)
          "c:\windows\fonts\arial.ttf",  // Microsoft Windows-format TrueType font file name
          ".000001",   // the string to create
          0,           // the extrusion depth
          0            // offset
          scale 0.2
          translate <2.2,-0.7,PanelDepth>
          pigment {White }
     }
}


#declare PanelDisplay = union {
     box {
          <-3, -1, -1>
          < 3,  1,  1>
          pigment { Black }
     }
     object { PanelDisplayLEDs
          scale 0.07
          translate <-2, 0, -1.001>
      }
     object { PanelMarkers }
}

