// Persistence of Vision Ray Tracer Scene Description File
// File: gfclock.inc
// Vers: 3
// Desc: The Grandfather Clock.  Include cface.inc
// Date: June 1996
// Auth: Stephen C. Baker

/*	The grandfather clock is a union of the grandfather clock face from file 'cface.inc' and
	the grandfather clock body in this file.  The body is essentially a large CSG object made
	from several blocks.  However I added some touches to make it look more realistic.  The 
	head body and are simple CSG with boxes and disks.  I added a glass door to the body, 
	complete with inner pendulims and counter weights.  I even added an ovalish door knob.
	For the clock face I used a superellipsiod with my Thin_Glass texture ( see hrglass.inc )
	and framed it with a thin Bronz texture torus. */


#include "cface.inc"			// The clock face

#declare GFTexture = texture { T_Wood8	// Texture for clock body
		scale <20, 60, 1 >
		}



/*	The clock base is a box with two cylinders subtracted from it to give the
	base the appearance of feet. */

#declare GFClockBase = difference {		// The base
	box { <-1, -1, -1>, <1, 1, 1>
		scale <1.0, 0.2, 1.0>
		translate <0.0, -8.6, 0.0>
			texture {GFTexture
				translate <0,2,0>
			}
	}
	cylinder {<0, 1.5, 0>, <0, -1.5, 0>, 3.0	// sutract this cylinder
     		scale <0.7, 0.7, 1.0>
		rotate <-90.0, 0.0, 0.0>
		translate <0.0, -11.6, 0>
	}
	cylinder {<0, 1.5, 0>, <0, -1.5, 0>, 3.0	// subtract this cylinder also
        	scale <0.7, 0.7, 1.0>
		rotate <-90.0, 90.0, 0.0>
		translate <0, -11.6, 0.0>
 	}
}


/*	The doorknob is a simple union of an elongated sphere and a cylinder */
#declare DoorKnob = union {
	sphere {<0,0,0>,.1
		scale <1,1.6,0.8>
	}
	cylinder {<-0.2,0,0>,<0,0,0>,0.027}
}


/*	The grandfather clock body is an elongated box with another elongated but smaller
	box subtracted from it.  The smaller box has a black pigment so the the cavaty
	in the first box will be black.  The cavity is covered with a four sided polygon
	having a Thin_Glass texture.  The doorknob is scales and added to the right side
	of the cavity and two small brass cylinders are placed to the left of the cavity.
	These cylinders give the appearance of hinges */

#declare GFBody = union {
	difference {
     		box { <-1, -1, -1>, <1, 1, 1>		// main clock body
        		scale <0.7, 3.5, 0.7>
	        	translate <0.0, -4.9, 0.0>
			texture {GFTexture}
		}
     		box { <-1, -1, -1>, <1, 1, 1>		// cavity for clock works
        		scale <0.5, 2.4, 0.4>
		        translate <0.0, -4.7, -0.5>
			pigment { Black }
		}
	}
	polygon { 5, <-1,-1,0>,<-1,1,0>,<1,1,0>,<1,-1,0>,<-1,-1,0>  // glass door
		scale <0.5, 2.4, 1>
		translate <0.0, -4.7, -0.7>
		texture { Thin_Glass }
	}
	cylinder {<0,-0.15,0>,<0,0.15,0>,0.025		// hinge
		translate <-0.55,-3.2,-0.7>
		texture { T_Brass_3A }
	}
	cylinder {<0,-0.15,0>,<0,0.15,0>,0.025		// hinge
		translate <-0.55,-6.0,-0.7>
		texture { T_Brass_3A }
	}
	object { DoorKnob				// door knob
		scale 0.60
		rotate <0,90,0>
		translate <.57,-4.5,-0.8>
		texture { T_Brass_3A }
	}
}


/*	This is the one hand for the clockface.  The hour and minute hands are just
	differently scales values of this arrow.  The arrow itself is just a polygon
	made into an arrow shape */

#declare Arrow = object {
	polygon { 8,
		<0,0>,<.5,.5>,<.5,.125>,<4,.125>,
		<4,-.125>,<.5,-.125>,<.5,-.5>,<0,0>
	}
}

/*	The clock face is the union of the rounded numerals from cface.inc and
	totus, disks, cylinders and the arrows. */

#declare GFFace = union {			// face of clock
	object { FaceNumerals
		translate <0, 0, -1.025>
 		pigment { Black }
	}
	sphere { <0,0,0> .1			// clock face crystal
		scale <7.55,7.55,1>
		translate <0,0,-1.01>
		texture { Thin_Glass }
	}
	torus { .8, .05				// clock face frame
		rotate <-90,0,0>
		translate <0,0,-.97>
		texture { T_Brass_3A }
	}
	disc { <0, 0, 0>, <0, 1, 0>, 0.5	//clock face
		scale <1.5, 1.0, 1.5>
		rotate <-90.0, 0.0, 0.0>
		pigment { White }
		translate <0.0, 0.0, -1.02>
	}
	cylinder { <0, 0, 0>, <0, .5, 0>, 0.02	// stud for hands
		rotate <-90, 0, 0>
		translate <0, 0, -0.55>
		texture { T_Brass_3A }
	}
	object { Arrow				// the big hand
		scale <0.2, 0.116, 1>
		rotate <0,0,-25>
		translate <-0.64,.304,-1.05>
		pigment { Black }
	}
	object { Arrow				// the little hand
		scale <0.15, 0.12, 1>
		rotate <0,0,-125>
		translate <.29,.405,-1.05>
		pigment { Black }
	}
}


/*	The grandfather clock top is a union of three boxes and the grandfather
	clock face, GFFace.  The top box is the clockface housing while the other two
	smaller and lower boxes act as decorative molding */

#declare GFClockTop = union {
	object { GFFace }				// the clock face 
	box { <-1, -1, -1>, <1, 1, 1>			// top with face
		texture {GFTexture}
	}
	box { <-1, -1, -1>, <1, 1, 1>			// molding 1
        	scale <0.8, 0.2, 0.8>
		translate <0.0, -1.2, 0.0>
		texture {GFTexture}
	}
	box {<-0.5, -0.5, -0.5>, <0.5, -0.35, 0.5>	// molding 2
		scale <1.75, 1, 1.75>
		translate <0.0, -.65, 0>
		texture {GFTexture}
	}
}


/*	The Pendulum object is the grandfather clock works that can be seen through the
	door in the body.  It is made up of a flattened sphere at the end of a thin
	cylinder to simulate the pendulum.  Two fatter cylinders are at the end of two
	thin cylinders to simulate the clockworks counterweights. */

#declare Pendulum = union {
	cylinder {			// pendulum support
		<1.00, 0.00, 0.00>,
		<-1.00, 0.00, 0.00>, 0.02
		scale <1.7, 1, 1 >
		rotate <0, 0, 90 >
		translate < 0,-4, -0.5>
		rotate <0,0,1>
		texture { T_Brass_3A }
	}
	sphere { <0,0,0>,.2		// the pendulum
		scale < 1.7,1.7,.5>
		translate <.1,-6,-0.5>
		texture { T_Brass_3A }
	}
	cylinder {			// chain on weight 1
		<1.00, 0.00, 0.00>,
		<-1.00, 0.00, 0.00>, 0.01
		scale <1.3, 1, 1 >
		rotate <0, 0, 90 >
		translate < .2,-3.5, -0.6>
		texture { T_Brass_3A }
	}
	cylinder {
		<1.00, 0.00, 0.00>, 		//weight 1
		<-1.00, 0.00, 0.00>, 0.10
		scale <0.4, 1, 1 >
		rotate <0, 0, 90 >
		translate < .2,-5, -0.6>
		texture { T_Brass_3A }
	}
	cylinder {			// chain on weight 2
		<1.00, 0.00, 0.00>,
		<-1.00, 0.00, 0.00>, 0.01
		scale <1, 1, 1 >
		rotate <0, 0, 90 >
		translate < -.2,-2.5, -0.6>
		texture { T_Brass_3A }
	}
	cylinder {				//weight 2
		<1.00, 0.00, 0.00>,
		<-1.00, 0.00, 0.00>, 0.10
		scale <0.4, 1, 1 >
		rotate <0, 0, 90 >
		translate < -.2,-3.5, -0.6>
		texture { T_Brass_3A }
	}
}

/*	The grandfather clock is now a union of the top of the clock, GFClockTop; the body of
	the clock, GFBody;  the base for the clock, GFClockBase; and the clock movement, Pendulum */


#declare GrandFatherClock = union {
	object { GFClockTop }
	object { GFBody }
	object { GFClockBase }
	object { Pendulum }
}
