// Persistence of Vision Ray Tracer Scene Description File
// File: hrglass.inc
// Vers: 3
// Desc: The hourglass 
// Date: June 1996
// Auth: Stephen C. Baker

/*	The sand texture for hourglass. Made with Texture Magic */
#declare Sand = texture {
	pigment {
		colour rgb<0.97,0.93,0.72>
	}
	finish {
		crand 0.050
	}
}


/*	The texture to simulate falling sand inside the hourglass.  Texture a thin cone
	shape with this.  Made with Texture Magic */

#declare Falling_Sand = texture {
	pigment {
		agate
		agate_turb 0.91  omega 0.96
		color_map
		{
			[0.00 color rgbf<1.00, 1.00, 1.00, 1.00>]
			[0.20 color rgbf<1.00, 1.00, 1.00, 1.00>]
			[0.59 color rgb<0.93, 0.88, 0.69>]
			[0.65 color rgb<0.93, 0.88, 0.69>]
			[0.80 color rgbf<0.98, 1.00, 1.00, 1.00>]
			[1.00 color rgbf<1.00, 1.00, 1.00, 1.00>]
		}
		phase 0.40
		frequency 10
		scale <50.00,10.00,10.00>
	}
	finish {
		ambient 0.20
		diffuse 0.20
		brilliance 2.80
	}
}


/*	This is a modification of the Glass Finish from Povray 2.2.  The IOR was
	decreased to give the glass a 'thin' appearance. */

#declare Thin_Glass_Finish = finish {
	Shiny
	ambient 0
	diffuse 0
	reflection 0.1
	refraction 1
	ior 1.04		// the lowered ior
}
#declare Thin_Glass =
	texture {
		pigment {color White filter 0.85}
		finish { Thin_Glass_Finish }
}


// This is the formular for the hourglass shape.
// The formular was copied from shapesq.inc in Povray 2.2

/* Lemniscate of Gerono
  This figure looks like two teardrops with their pointed ends connected.
  It is formed by rotating the Lemniscate of Gerono about the x-axis.
  The formula is:
     x^4 - x^2 + y^2 + z^2 = 0. */

#declare Lemniscate = quartic {
	< 1,   0,   0,   0,   0,   0,   0,   0,   0, -1,
	  0,   0,   0,   0,   0,   0,   0,   0,   0,  0,
	  0,   0,   0,   0,   0,   1,   0,   0,   0,  0,
	  0,   0,   1,   0,   0>
	  sturm
}

/*	The actual hourglass shape.  It is used to create the hourglass, with
	Thin_Glass texture.  And used to create the sand inside the hourglass
	using sand texture and clipping */

#declare HourGlass = object {
     object {Lemniscate
          rotate < 0, 0, 90 >
     }
}


/*	The end caps for the hourglass ware made from simply CSG of a tourus with
	a disc on each side to give the cap a solid look */

#declare Cap = union {        // Endcaps for the hourglass case
	torus {1.0, 0.1}
    	disc { <0, 0, 0>, <0, 1, 0>, 1.0, 0.001
     		translate <0.0, 0.1, 0.0>
	}
	disc { <0, 0, 0>, <0, 1, 0>, 1.0, 0.001
     		translate <0.0, -0.1, 0.0>
    }
}

#declare Support = union {    // vertical supports for hourglass case
	cylinder {
		<0.00, -1.00, 0.00>,
		<0.00, 1.00, 0.00>, 0.05
	}
	torus { 0.05, 0.03
		translate < 0, 0, 0 >
	}
	torus { 0.04, 0.03
		translate < 0, 0.1, 0 >
	}
	torus { 0.04, 0.03
		translate < 0, -0.1, 0 >
	}
}

/*	The hourglass case.  It is made from Caps, Supports and other shapes to simulate
	the central support for the thin part of the hourglass */

#declare HourGlassCase = union {
	object { Cap					// Top Cap
		scale < 0.63, 0.63, 0.63 >
		translate <0, 1, 0>
		texture { Rosewood }
	}
	object { Cap					// Bottom Cap
		scale < 0.63, 0.63, 0.63 >
		translate <0, -1, 0>
		texture { Rosewood }
	}
     torus { 0.05, 0.03  				// Center Support
          texture { Rosewood }
     }
	cylinder {					// left wire
		<0.00, 0.00, 0.00>,
		<-0.60, 0.00, 0.00>, 0.007
		texture { T_Silver_1A }
	}
	object { Support				// left support
		translate <-0.6, 0, 0>
		texture { Rosewood }
	}
	cylinder {					// right wire
		<0.00, 0.00, 0.00>,
		<0.60, 0.00, 0.00>, 0.007
		texture { T_Silver_1A }
	}
	object { Support 				// right support
		translate <0.6, 0, 0>
		texture { Rosewood }
	}
	cylinder {					// back wire
		<0.00, 0.00, 0.00>,
		<0.00, 0.00, -0.60>, 0.007
		texture { T_Silver_1A }
	}
	object { Support 				// back support
		translate <0, 0, -0.6>
		texture { Rosewood }
	}
	cylinder {					// front wire
		<0.00, 0.00, 0.00>,
		<0.00, 0.00, 0.60>, 0.007
		texture { T_Silver_1A }
	}
	object { Support 				// front support
		translate <0, 0, 0.6>
		texture { Rosewood }
	}
}

/*	The hourglass sand in constructed as a seperate object. The top and bottom sand
	use the same formular as the hourglass.  The difference is the they are clipped
	so the son't completely fill the hour class.  The top and bottom sand are covered
	with cones to simulate the deperssion ( top sand ) and mound ( bottom sand ) that
	real sand would make inside an hourglass.  The top and bottom sand are connected
	with a thin cone made of the following sand texture */

#declare HourGlassSand = union {
	object { HourGlass			// Top Sand
	     clipped_by { box {< -.5, 0, -.5>,<.5, .5, .5 >} }
     }
	object { HourGlass			// Bottom Sand
	     clipped_by { box {< -.5, -1.0, -.5>,<.5 , -.75 , .5  >} }
	}
	cone { <0, 0, 0 >, .44, <0, .3, 0 > 0	// cover of Top Sand
	     rotate <180, 0, 0>
	     translate < 0, .5, 0>
     }
	cone { <0,0,0>,.02,<0,.75,0>,0	// Falling Sand
		translate < 0, -.75, 0>
		texture { Falling_Sand }
	}
	cone { <0, 0, 0 >, .49, <0, .15, 0 > 0	// cover of Bottom Sand
	     translate < 0, -.75, 0>
	}
     rotate < 0, 0, 0 >
}


/*	The hourglass is now simply a union of the three major shapes above.  The
	glass, case and sand.  The sand is scaled slightly smaller so that it
	doesn't appear 'outside' the glass case and has a tiny gap between itself
	and the inside of the glass */

#declare TheHourGlass = union {
	object { HourGlassCase }
	object { HourGlass
     	texture { Thin_Glass}
	}
	object {HourGlassSand
		scale < 0.95, 1, 0.95>
		texture { Sand }
	}
}

