// Persistence of Vision Ray Tracer Scene Description File
// File: Atomic.inc
// Vers: 3
// Desc:Include file for the NITS-8c atomic clock
// Date:June 1996
// Auth:Stephen C. Baker

#include "nits8c.inc"    // the plaque the contains the name of the clock
#include "fpanel.inc"    // The front display panel of the chassie

#declare RadiationSymbol = object {     // The yellow and black radiation symbol
	disc { <0,0,0>,z,2
		pigment {
			radial
			color_map {
				[0.0  color Yellow]
				[0.459 color Yellow]
				[0.460 color Black]
				[1.0  color Black]
		    }
			rotate <90,0,0>
			frequency 3
		}
		finish {
			phong 0.9
		}
	}
}


/*   The basic Panel from which the chassie is made.  The panel is four cylinders,
     four spheres made into a square, connected by a four sided polygon.  This
     gives a panel rounded edges.  A four-sided polygon is attach to the panel.
     The polygon is translated until is lines up the the outter edge of the
     'frame'.  */

#declare Panel = union {

     /*   These four cylinders and shperes make up the 'frame' of the panel */
     cylinder {<0, -1.5, 0>, <0, 1.5, 0>, 0.1 }
     cylinder {<0, -1.5, 0>, <0, 1.5, 0>, 0.1
          rotate <0.0, 0.0, 90.0>
          translate <1.5, 1.5, 0.0>
     }
     cylinder {<0, -1.5, 0>, <0, 1.5, 0>, 0.1
          translate <3.0, 0.0, 0.0>
     }
     cylinder {<0, -1.5, 0>, <0, 1.5, 0>, 0.1
          rotate <0.0, 0.0, 90.0>
          translate <1.5, -1.5, 0.0>
     }
     sphere {<0.0, 1.5, 0.0>, 0.1 }
     sphere {<0.0, -1.5, 0.0>, 0.1 }
     sphere {<3.0, 1.5, 0.0>, 0.1}
     sphere {<3.0, -1.5, 0.0>, 0.1}

     /*   This polygone lines up with the outter edge of the frame */
     polygon { 5
          <0,1.5>,<3,1.5>,<3,-1.5>,<0,-1.5>,
          <0,1.5>
           //    pigment { Yellow }
          translate <0, 0, -0.1>
     }
}


/* The basic cabinet is made up of five panels, all perpendicular to each other.
   (There is no need for the 6th, bottom one.) This creates a box with rounded edges */

#declare Cabinet = union {
     object { Panel }
     object { Panel
          rotate <0, -90, 0 >
          translate <3, 0, 0>
     }
     object { Panel
          rotate <0, 90, 0 >
          translate <0, 0, 3>
     }
     object { Panel
          rotate <0, 180, 0 >
          translate <3, 0, 3>
     }
     object { Panel
          rotate <90, 0, 0 >
          translate <0, 1.5, 1.5>
     }
}

/*   This is the atomic clock chassie.  It is made up of three 'Cabinet' objects
     with the middle one being scaled smaller than the end one's.  The left
     cabinet gets a radiation symbol.  The middle cabinet gets an LED display that
     keeps time.  The right Cabinet gets a plaque the states that the object
     is an Atomic Clock. */

#declare Chassie = union {
     object { Cabinet }            // left cabinet
     object { Cabinet              // the middle cabinet
          scale <1, 1, 0.8>
          translate < 3.0, 0, 0.62>
     }
     object { Cabinet              // the right cabinet
          translate < 6, 0, 0>
     }
     object { Plaque               // the plaque that reads 'NITS-8c'
          scale <0.4,0.8,1>
          translate <7.5,0.1,-0.001>
          pigment { Black }
     }
     object { PanelDisplay         // The LED dispay
          scale 0.22
          translate <4.5,1,0.75>
      }
	object { RadiationSymbol      // the radiation symbol
		scale 0.3
		translate <1.5,0,-0.10001>
	}

}


/*   This is the elbo jeints the electrically connect the atomic clock's
     chassie with the mirror cylinder on top */

#declare Elbo2 = union {
     intersection {           // clip a torus so the only 1/4 shows
          torus {0.5, 0.1
               translate <0.5, 0.0, 0.5>
          }
          box { <-1, -1, -1>, <1, 1, 1>
               scale <0.5, 0.5, 0.5>
          }
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.1          // connect a cylinder to noe end of 1/4 torus
          rotate <90.0, 0.0, 0.0>
          translate <0.0, 0.0, 1.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.1          // connect a cylinder to other end of 1/4 torus
          rotate <0.0, 0.0, 90.0>
          translate <1.0, 0.0, 0.0>
     }
     cylinder {<0, -0.15, 0>, <0, 0.15, 0>, 0.13       // attach end caps to both cylinders
          rotate <90.0, 0.0, 0.0>
          translate <0.0, 0.0, 1.65>
     }
     cylinder {<0, -0.15, 0>, <0, 0.15, 0>, 0.13
          rotate <0.0, 0.0, 90.0>
          translate <1.65, 0.0, 0.0>
     }
}

/*   This is the physical support for the mirror cylinder on top of
     the atomic clock.  It is made of two cylinders.  A long one for support
     and a short one to anchor the support to the chassie */

#declare CylinderSupport = union {
     cylinder  { <0,0,0>, <0,0.5,0>, 0.05 }
     cylinder  { <0,-0.1,0>, <0,0.1,0>, 0.07 }
     texture {
          pigment { Black }
          finish {
               phong 0.9
               //phong_size 10
           }
     }
}


/*   The completed mirror cylinder.  The cylinder has five 'electrical' elbo connections,
     four black 'physical' connections and two brass plates at each end and receeded into
     the cylinder. */

#declare ChromeCylinder = union {            // The main cylinder
     cylinder { <-3.7,0,0>,<3.7,0,0>,0.6
          open
          translate < 4.6, 2.5, 1.6>
          texture { T_Chrome_4D }
     }
     disc {                                  // A brass end plate
          <0, 1, 0>  // center position
          x,         // normal vector
          0.59,       // outer radius
          translate <8, 1.5, 1.60>
          texture { T_Brass_1B }
     }
     disc {                                  // Another brass end plate
          <0, 1, 0>  // center position
          x,         // normal vector
          0.59,       // outer radius
          translate <1.1, 1.5, 1.60>
          texture { T_Brass_1B }
     }
     /*   these are the four 'physical' supports for the cylinder */
     object { CylinderSupport
          translate <1.7, 1.6, 1.2>
     }
     object { CylinderSupport
          translate <1.7, 1.6, 2.05>
     }
     object { CylinderSupport
          translate <7.3, 1.6, 1.2>
     }
     object { CylinderSupport
          translate <7.3, 1.6, 2.05>
     }

     /*   These are the five 'electrical' elbo connection between the cylinder and chassie */
     object { Elbo2
          rotate <-90, 0, -90 >
          translate < 1, 5, 2.5>
          scale 0.5
          texture { T_Brass_1B }
     }
     object { Elbo2
          rotate <-90, 0, -90 >
          translate < 1, 5, 4>
          scale 0.5
          texture { T_Brass_1B }
     }
     object { Elbo2
          rotate <-90, 0, -90 >
          translate < 0.8, 4.7, 3>
          scale 0.5
          texture { T_Silver_1B }
     }
     object { Elbo2
          rotate <90, 0, -90 >
          scale 0.5
          translate < 8.7, 2.4, 1.5>
          texture { T_Silver_1B }
     }
     object { Elbo2
          rotate <90, 0, -90 >
          scale 0.6
          translate < 8.5, 2.5, 1.8>
          texture { T_Silver_1B }
     }
}

/*   The atomic clock is nothing more than a union of the completed chassie and 
     the completed mirror cylinder */

#declare AtomicClock = union {
     object { Chassie
          texture {
               pigment { SkyBlue }
               finish {
                    phong 0.7
                    phong_size 10
               }
          }
     }
     object { ChromeCylinder
     //     no_shadow
     }
}
