// Persistence of Vision Ray Tracer Scene Description File
// File: nits8c.inc
// Vers: 3
// Desc: The plaque on the front of the atomic clock that identifies it as NITS-8c.
//	This program assumes Arial Bold font to resides in C:\WINDOWS\FONTS
// Date: June 1996
// Auth:Stephen C. Baker

/*	The basic shape for the plaque.  It is a box with rounded corners.  The 
	corners are rounded only on the sides; the front and back are flat.  I start
	here by subtracting round pieces from the sides of a box.  The takes off the
	sharp edges, then I add cylinders to the corners to round them.  The text is
	the text function from Povray 3.0 */

#declare Plaque = union {
	difference {
        	box {
			<-1, -1, -1>
			< 1,  1,  1>
			scale <3,1.2,0.1>
			pigment { Black }
		}
		cylinder { <3.0,1.2,0.2>,<3.0,1.2,-0.2>,0.2 }	// these cylinders clip the corners
		cylinder { <3.0,-1.2,0.2>,<3.0,-1.2,-0.2>,0.2 }
		cylinder { <-3.0,1.2,0.2>,<-3.0,1.2,-0.2>,0.2 }
		cylinder { <-3.0,-1.2,0.2>,<-3.0,-1.2,-0.2>,0.2 }

	}
	cylinder { <2.8,1.0,0.1>,<2.8,1.0,-0.1>,0.2 }		// these cylinders round the corners
	cylinder { <-2.8,1.0,0.1>,<-2.8,1.0,-0.1>,0.2 }
	cylinder { <2.8,-1.0,0.1>,<2.8,-1.0,-0.1>,0.2 }
	cylinder { <-2.8,-1.0,0.1>,<-2.8,-1.0,-0.1>,0.2 }

	text {
        	ttf
		"c:\windows\fonts\arial.ttf",
      		"NITS-8c",
		0.01,
		0
		pigment { White }
		translate <-1.7, 0.4, -0.1>
	}
	text {
		ttf
		"c:\windows\fonts\arial.ttf",
		"Atomic Clock",
		0.01,
		0
		pigment { White }
		scale 0.5
		translate <-1.5, -0.2, -0.1>
		
	}
	text {
		ttf
		"c:\windows\fonts\arial.ttf",
		"University of Massachusetts",
          	0.01,
		0
		pigment { White }
		scale 0.3
		translate <-1.9, -0.6, -0.1>
	}
	text {
		ttf
		"c:\windows\fonts\arial.ttf",
		"Physics Department",
		0.01,
		0
		pigment { White }
		scale 0.3
		translate <-1.4, -1.0, -0.1>
	}
}
