// Persistence of Vision Ray Tracer Scene Description File
// File: wtchrgls.pov
// Vers: 3
// Desc: A wrist watch lying on the ground with an hour-glass standing behind it.
// Date: June 30, 1996
// Auth: Dan Moulding

#include "colors.inc"
#include "shapes.inc"
#include "glass.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"

#declare T_WATCH=texture { pigment { color P_Silver3 } finish { F_MetalE reflection 0.5 } }
#declare T_HG_WOOD=texture { T_Wood2 rotate <90,0,0> scale 5 }
#declare T_Leather=texture { normal { crackle .3 sine_wave turbulence 0.3 scale <1.5,3,1.5> phase 0.5 } pigment { color VeryDarkBrown } finish { brilliance 3 } }
#declare R_WATCH=<0,0,0>

// Time displayed on face of watch ( HH:MM:SS )
#declare HH=18
#declare MM=52
#declare SS=8
#declare N_SECONDS=3600*HH+60*MM+SS

camera
{
  location <13,4.5,-1.5>
  look_at <0,2,0>
}

light_source
{
  <-10,10,10>
  color White
}

light_source
{
  <10,15,-8>
  color White
}

light_source
{
  <15,15,15>
  color White
}

////////////////////////////////
//  Watch case
////////////////////////////////

// Base of Watch
cylinder
{
  <0,-.4,0>,<0,.25,0>,7
  open
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

torus
{
  6.5,.5
  scale <1,.5,1>
  translate <0,.25,0>
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

// Ring just on top of base
cylinder
{
  <0,0,0>,<0,.5,0>,6.75
  open
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

torus
{
  6.25,.5
  scale <1,.3,1>
  translate <0,.5,0>
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

// Numbered bezel
cylinder
{
  <0,.5,0>,<0,.75,0>,6.5
  open
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

cone
{
  <0,.7,0>,6.5,<0,1,0>,5.5
  open
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

#declare Count=0
#while (Count<60)
  #if (mod(Count,10)=0)
    #if (Count!=0)
      text
      {
        ttf "C:\WINDOWS\FONTS\ARIAL.TTF"
        str(Count,0,0)
        .05,0
        rotate <107,0,0>
        translate <-.5,.95,5.7>
        rotate <0,Count/60*360,0>
        pigment { color Black }
        rotate R_WATCH
      }
    #else
      triangle
      {
        <-.2,0,.2>,<.2,0,.2>,<0,0,-.2>
        rotate <15,0,0>
        translate <0,.84,6.05>
        pigment { color Black }
        rotate R_WATCH
      }
    #end
  #else
    disc
    {
      <0,0,0>,y,.1
      rotate <15,0,0>
      translate <0,.84,6.05>
      rotate <0,Count/60*360,0>
      pigment { color Black }
      rotate R_WATCH
    }
  #end
  #declare Count=Count+1.25
#end


// Wrist band holders
#declare BAND_HOLDER=
  union
  {
    difference
    {
      intersection
      {
        torus
        {
          3,6
          scale <1,.31,1.05>
          translate <0,-1.1,0>
        }
        prism
        {
          linear_sweep
          linear_spline
          -.85,.45
          5
          <4,5>,<5.5,3>,<4.75,9>,<4,9>,<4,5>
        }
        texture
        {
          T_WATCH
        }
        translate <0,.2,0>
      }
      torus
      {
        3,7
        scale <1,.28,1>
        texture
        {
          T_WATCH
        }
        translate <0,-2,0>
      }
    }
    difference
    {
      intersection
      {
        torus
        {
          3,6
          scale <1,.31,1.05>
          translate <0,-1.1,0>
        }
        prism
        {
          linear_sweep
          linear_spline
          -.85,.45
          5
          <-4,5>,<-5.5,3>,<-4.75,9>,<-4,9>,<-4,5>
        }
        texture
        {
          T_WATCH
        }
        translate <0,.2,0>
      }
      torus
      {
        3,7
        scale <1,.28,1>
        texture
        {
          T_WATCH
        }
        translate <0,-2,0>
      }
    }
  }

object
{
  BAND_HOLDER
  rotate R_WATCH
}

object
{
  BAND_HOLDER
  rotate <0,180,0>
  rotate R_WATCH
}

// Adjuster knob and housing
union
{
  union
  {
    cylinder
    {
      <0,0,0>,<0,.4,0>,.4
    }
    #declare Count=0
    #while (Count<=40)
      box
      {
        <-.01,.4,.4>,<.01,0,.45>
        rotate <0,Count/40*360,0>
      }
      #declare Count=Count+1
    #end
    sphere
    {
      <0,.4,0>,.4
    }
    rotate <0,0,-90>
    translate <7.05,0,0>
  }
  intersection
  {
    torus
    {
      3,6
      scale <1,.35,1>
      translate <0,-1.1,0>
    }
    intersection
    {
      prism
      {
        -.4,2
        9
        <6,-2.2>,<8,-1.4>,<8,-.65>,<7,-.55>,<7,.55>,<8,.65>,<8,1.4>,<6,2.2>,<6,-2.2>
      }
      cylinder
      {
        <0,-2,0>,<0,2,0>,7.3
      }
    }
  }
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}


/////////////////////////////
// Face and glass
/////////////////////////////

// Green face
disc
{
  <0,.25,0>,y,6.5
  texture
  {
    pigment { color rgb <0,.15,0> }
    finish
    {
      specular 0.6
      reflection 0.1
      metallic
    }
  }
  rotate R_WATCH
}

// Glass
object
{
  Paraboloid_Y
  rotate <180,0,0>
  scale <2.733,.25,2.733>
  translate <0,2,0>
  texture
  {
    pigment { color rgbt <1,1,1,.9> }
    finish
    {
      reflection 0.6
      specular 0.2
      diffuse 0
      phong 0.3
      phong_size 500
    }
  }
  rotate R_WATCH
  clipped_by
  {
    plane
    {
      -y,-.75
      rotate R_WATCH
    }
  }
}

////////////////////////////////////////////////////////////
// Face details
///////////////////////////////////////////////////////////

/////////////
// Main face

// America Perry Ellis logo
text
{
  ttf "C:\WINDOWS\FONTS\SCHLBKB.TTF"
  "AMERICA"
  .05,0
  scale .5
  rotate <90,0,0>
  texture
  {
    pigment { color White }
  }
  translate <-1.3,.26,1.9>
  rotate R_WATCH
}
text
{
  ttf "C:\WINDOWS\FONTS\ARIAL.TTF"
  "PERRY  ELLIS"
  .05,<.2,0,0>
  scale .3
  rotate <90,0,0>
  texture
  {
    pigment { color White }
  }
  translate <-1.29,.26,1.55>
  rotate R_WATCH
}

// Tick marks and phosphorecent spheres
#declare Count=0
#while (Count<300)
  #if (mod(Count,25)=0)
    sphere
    {
      <0,0,0>,.1
      translate <0,.25,5.3>
      rotate <0,Count/300*360,0>
      pigment { color GreenYellow }
      rotate R_WATCH
    }
  #else
    #if (mod(Count,5)=0)
      polygon
      {
        5
        <-.025,0,.15>,<-.025,0,-.15>,<.025,0,-.15,>,<.025,0,.15>,<-.025,0,.15>
        translate <0,.26,5.25>
        rotate <0,Count/300*360,0>
        pigment { color White }
        rotate R_WATCH
      }
    #else
      polygon
      {
        5
        <-.025,0,.05>,<-.025,0,-.05>,<.025,0,-.05>,<.025,0,.05>,<-.025,0,.05>
        translate <0,.26,5.35>
        rotate <0, Count/300*360,0>
        pigment { color White }
        rotate R_WATCH
      }
    #end
  #end
  #declare Count=Count+1
#end

// White circles with tick marks between them
disc
{
  <0,.255,0>,y,3.6,3.55
  rotate R_WATCH
  pigment { color White }
}

disc
{
  <0,.255,0>,y,3.85,3.8
  rotate R_WATCH
  pigment { color White }
}

#declare Count=0
#while (Count<60)
  polygon
  {
    5
    <-.025,.255,.15>,<-.025,.255,-.15>,<.025,.255,-.15>,<.025,.255,.15>,<-.025,.255,.15>
    translate <0,0,3.7>
    rotate <0,Count/60*360,0>
    rotate R_WATCH
    pigment { color White }
  }
  #declare Count=Count+1
#end

// White numbers that go around the inside of the two white circles
#declare Count=1
#while (Count<13)
  text
  {
    ttf "C:\WINDOWS\FONTS\ARIAL.TTF"
    str(Count+12,0,0)
    0.05,0
    scale .4
    rotate <90,0,0>
    translate <-0.25,0,0>
    rotate <0,-Count/12*360,0>
    #switch (Count)
      #range (4,8)
        translate <0,.255,3.25>
        #switch (Count)
          #case (4)
            rotate <0,2,0>
            #break
          #case (8)
            rotate <0,-2,0>
            #break
        #end
        #break
      #else
        translate <0,.255,3.0>
    #end
    rotate <0,Count/12*360>
    rotate R_WATCH
    pigment { color White }
  }
  #declare Count=Count+1
#end

// All of those rounded silver bars
#declare SHINY_SILVER_DEAL=
  union
  {
    cylinder
    {
      <0,-.4,0>,<0,.4,0>,.2
      texture
      {
        T_WATCH
      }
    }
    sphere
    {
      <0,-.4,0>,.2
      texture
      {
        T_WATCH
      }
    }
    sphere
    {
      <0,.4,0>,.2
      texture
      {
        T_WATCH
      }
    }
    rotate <90,0,0>
    scale <1,.25,1>
  }

object
{
  SHINY_SILVER_DEAL
  translate <-.25,.3,4.5>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <.25,.3,4.5>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,30,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,60,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,120,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,150,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,210,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,240,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,300,0>
  rotate R_WATCH
}

object
{
  SHINY_SILVER_DEAL
  translate <0,.3,4.5>
  rotate <0,330,0>
  rotate R_WATCH
}

//////////////////
// Left small face

// Silver disc with that machined look
disc
{
  <0,0,0>,y,1.6
  texture
  {
    T_WATCH
    normal
    {
      wood 0.2
      frequency 15
      rotate <90,0,0>
    }
  }
  translate <-3.2,.26,0>
  rotate R_WATCH
}

// Letters around left small face
#declare Day=0
#while (Day<7)
  #declare Letter=1
  #while (Letter<=3)
    text
    {
      ttf "C:\WINDOWS\FONTS\ARIAL.TTF"
      #switch (Day)
        #case (0)
          #switch (Letter)
            #case (1)
              "S"
              #break
            #case (2)
              "U"
              #break
            #case (3)
              "N"
              #break
          #end
          #break
        #case (1)
          #switch (Letter)
            #case (1)
              "M"
              #break
            #case (2)
              "O"
              #break
            #case (3)
              "N"
              #break
          #end
          #break
        #case (2)
          #switch (Letter)
            #case (1)
              "T"
              #break
            #case (2)
              "U"
              #break
            #case (3)
              "E"
              #break
          #end
          #break
        #case (3)
          #switch (Letter)
            #case (1)
              "W"
              #break
            #case (2)
              "E"
              #break
            #case (3)
              "D"
              #break
          #end
          #break
        #case (4)
          #switch (Letter)
            #case (1)
              "T"
              #break
            #case (2)
              "H"
              #break
            #case (3)
              "U"
              #break
          #end
          #break
        #case (5)
          #switch (Letter)
            #case (1)
              "F"
              #break
            #case (2)
              "R"
              #break
            #case (3)
              "I"
              #break
          #end
          #break
        #case (6)
          #switch (Letter)
            #case (1)
              "S"
              #break
            #case (2)
              "A"
              #break
            #case (3)
              "T"
              #break
          #end
          #break
      #end
      .05,0
      pigment { color Black }
      scale 0.36
      rotate <90,0,0>
      translate <-.08,0,1.25>
      #switch (Letter)
        #case (1)
          rotate <0,Day/7*360-11,0>
          #break
        #case (2)
          rotate <0,Day/7*360,0>
          #break
        #case (3)
          rotate <0,Day/7*360+11,0>
          #break
      #end
      #if ((Day=3) & (Letter=1))
        rotate <0,-3,0>
      #end
      translate <-3.2,.26,0>
      rotate R_WATCH
    }
    #declare Letter=Letter+1
  #end
  #declare Day=Day+1
#end

///////////////////
// Right small face

// Silver disc with that machined look
disc
{
  <0,0,0>,y,1.6
  texture
  {
    T_WATCH
    normal
    {
      wood 0.2
      frequency 15
      rotate <90,0,0>
    }
  }
  translate <3.2,.26,0>
  rotate R_WATCH
}

// Numbers around right small face
#declare Count=1
#while (Count<32)
  #if (mod(Count,2)=0)
    disc
    {
      <0,0,1.38>,y,.05
      pigment { color Black }
      rotate <0,Count/31*360,0>
      translate <3.2,.265,0>
      rotate R_WATCH
    }
  #else
    text
    {
      ttf "C:\WINDOWS\FONTS\ARIAL.TTF"
      str (Count,0,0)
      .05,0
      pigment { color Black }
      scale 0.36
      rotate <90,0,0>
      #if (Count<10)
        translate <-.06,0,1.25>
      #else
        translate <-.18,0,1.25>
      #end
      rotate <0,Count/31*360,0>
      translate <3.2,.26,0>
      rotate R_WATCH
    }
  #end
  #declare Count=Count+1
#end

////////////////////
// Bottom small face

// Silver disc with that machined look
disc
{
  <0,0,0>,y,1.6
  texture
  {
    T_WATCH
    normal
    {
      wood 0.2
      frequency 15
      rotate <90,0,0>
    }
  }
  translate <0,.26,-3.4>
  rotate R_WATCH
}

// Numbers around bottom small face
#declare Count=2
#while (Count<25)
  text
  {
    ttf "C:\WINDOWS\FONTS\ARIAL.TTF"
    str (Count,0,0)
    .05,0
    pigment { color Black }
    scale 0.36
    rotate <90,0,0>
    #if (Count<10)
      translate <-.06,0,1.25>
    #else
      translate <-0.18,0,1.25>
    #end
    rotate <0,Count/24*360,0>
    translate <0,.26,-3.4>
    rotate R_WATCH
  }
  #declare Count=Count+2
#end

////////////////////////
//  Hands
////////////////////////

////////////////////
// Big face hands

// Hour hand
union
{
  prism
  {
    linear_sweep
    linear_spline
    0,.08
    10
    <0,.15>,<-.6,.15>,<-.65,.3>,<-3.1,.2>,<-3.5,0>,<-3.1,-.2>,<-.65,-.3>,<-.6,-.15>,<0,-.15>,<0,.15>
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  polygon
  {
    6
    <-1,.081,.2>,<-2.9,.081,.1>,<-3,.081,0>,<-2.9,.081,-.1>,<-1,.081,-.2>,<-1,.081,.2>
    pigment { color GreenYellow }
  }
  cylinder
  {
    <0,0,0>,<0,.08,0>,.4
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  rotate <0,N_SECONDS/43200*360+90,0>
  translate <0,0.4,0>
  rotate R_WATCH
}

// Minute hand
union
{
  prism
  {
    linear_sweep
    linear_spline
    0,.08
    10
    <0,.1>,<-.6,.1>,<-.65,.2>,<-4.8,.13>,<-5.2,0>,<-4.8,-.13>,<-.65,-.2>,<-.6,-.1>,<0,-.1>,<0,.1>
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  polygon
  {
    6
    <-1,.081,.1>,<-4.7,.081,.05>,<-4.8,.081,0>,<-4.7,.081,-.05>,<-1,.081,-.1>,<-1,.081,.1>
    pigment { color GreenYellow }
  }
  cylinder
  {
    <0,0,0>,<0,.1,0>,.25
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  translate <0,0.6,0>
  rotate <0,N_SECONDS/3600*360+90,0>
  rotate R_WATCH
}

// Second hand
union
{
  prism
  {
    linear_sweep
    linear_spline
    0,.08
    5
    <1.8,.1>,<-5.1,.05>,<-5.1,-.05>,<1.8,-.1>,<1.8,.1>
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  cylinder
  {
    <1.8,0,0>,<1.8,.08,0>,.1
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  cylinder
  {
    <0,0,0>,<0,.08,0>,.25
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  cylinder
  {
    <-4,0,0>,<-4,.08,0>,.3
    texture
    {
      T_WATCH
      finish
      {
        reflection 0.4
      }
    }
  }
  disc
  {
    <-4,.081,0>,y,.2
    pigment { color GreenYellow }
  }
  rotate <0,N_SECONDS/60*360+90,0>
  translate <0,.8,0>
  rotate R_WATCH
}

// Mounting cylinder
cylinder
{
  <0,0,0>,<0,.95,0>,.07
  open
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

////////////////////
// Small face hands

#declare SMALL_HAND=
  union
  {
    // Long part of hand
    prism
    {
      linear_sweep
      linear_spline
      0,.05
      5
      <0,0>,<-.75,.075>,<-1.5,0>,<-.75,-.075>,<0,0>
      texture
      {
        T_WATCH
        finish
        {
          reflection 0.4
        }
      }
    }
    // Big circle
    cylinder
    {
      <0,0,0>,<0,.05,0>,.23
      texture
      {
        T_WATCH
        finish
        {
          reflection 0.4
        }
      }
    }
    // Mounting cylinder
    cylinder
    {
      <0,0,0>,<0,.125,0>,.05
      open
      texture
      {
        T_WATCH
      }
    }
    // Short end of hand
    cylinder
    {
      <.24,0,0>,<.24,.05,0>,.25
      scale <1,1,.2>
      texture
      {
        T_WATCH
        finish
        {
          reflection 0.4
        }
      }
    }
  }

// Right small hand
object
{
  SMALL_HAND
  rotate <0,277,0>
  translate <3.2,.35,0>
  rotate R_WATCH
}

// Left small hand
object
{
  SMALL_HAND
  rotate <0,399,0>
  translate <-3.2,.35,0>
  rotate R_WATCH
}

// Bottom small hand
object
{
  SMALL_HAND
  rotate <0,N_SECONDS/86400*360+90,0>
  translate <0,.35,-3.4>
  rotate R_WATCH
}

//////////////////////
// Leather wrist band
//////////////////////
#declare WRIST_BAND=
  union
  {
    prism
    {
      linear_sweep
      linear_spline
      -.5,0
      5
      <-4,-8>,<-3.5,-25>,<3.5,-25>,<4,-8>,<-4,-8>
    }
    cylinder
    {
      <0,-4,0>,<0,4,0>,.5
      rotate <90,90,0>
      translate <0,-.5,-8>
    }
    texture
    {
      T_Leather
    }
  }

object
{
  WRIST_BAND
  rotate R_WATCH
}

cylinder
{
  <0,-.5,0>,<0,0,0>,3.5
  texture
  {
    T_Leather
  }
  scale <1,1,4>
  translate <0,0,-25>
  rotate R_WATCH
}

object
{
  WRIST_BAND
  rotate <0,180,0>
  rotate R_WATCH
}

// Silver buckle
prism
{
  linear_sweep
  linear_spline
  -.3,0
  19
  <3.5,24.5>,<3.75,24.5>,<3.75,25>,<3.75,28>,<3.5,28.5>,<0,29>,<-3.5,28.5>,<-3.75,28>,<-3.75,25>,<-3.75,24.5>,<-3.5,24.5>,<-3.5,25>,<-3.5,27.5>,<-3.25,28>,<0,28.3>,<3.25,28>,<3.5,27.5>,<3.5,25>,<3.5,24.5>
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

prism
{
  linear_sweep
  linear_spline
  -.3,.1
  5
  <.5,24.5>,<.5,28.5>,<-.5,28.5>,<-.5,24.5>,<.5,24.5>
  texture
  {
    T_WATCH
  }
  rotate R_WATCH
}

//////////////////
//  Hour Glass
//////////////////
#declare Hour_Glass=
union
{
  // Top and base
  #declare HOUR_GLASS_BASE=
    superellipsoid
    {
      <1,.5>
      rotate <90,0,0>
      scale <7,.7,7>
    }

  object
  {
    HOUR_GLASS_BASE
    texture
    {
      T_HG_WOOD
    }
    rotate <0,-25,0>
    translate <0,-.3,0>
  }

  object
  {
    HOUR_GLASS_BASE
    texture
    {
      T_HG_WOOD
    }
    rotate <0,45,0>
    translate <0,14,0>
  }

  // Sand
  #declare T_Sand=
    texture
    {
      normal
      {
        granite 0.8
        scale 0.25
      }
      pigment
      {
        color LightWood
      }
      finish
      {
        reflection 0.1
        brilliance 3
      }
    }

  cone
  {
    <0,.2,0>,5.25,<0,4,0>,.2
    texture
    {
      T_Sand
    }
  }

  sphere
  {
    <0,4,7>,.2
    texture
    {
      T_Sand
    }
    scale <1,.75,1>
  }

  lathe
  {
    cubic_spline
    5
    <3.55,10.1>,<3.4,10>,<1.6,8.5>,<.3,7>,<0,6.9>
    texture
    {
      T_Sand
    }
  }

  sphere
  {
    <0,7,7>,.3
    texture
    {
      T_Sand
    }
  }

  // Glass
  lathe
  {
    cubic_spline
    7
    <5.5,-.3>,<5.5,0>,<4.5,3.25>,<1,6.5>,<4.5,9.75>,<5.5,13>,<5.5,13.3>
    texture
    {
      pigment { color rgbt <1,1,1,.8> }
      finish
      {
        reflection 0.2
        specular 0.2
        diffuse 0
        phong 0.3
        phong_size 500
      }
    }
    scale <1,1.085,1>
    sturm
  }

  // Posts
  #declare HOUR_GLASS_POST=
    lathe
    {
      cubic_spline
      16
      <.25,0>,<.5,.5>,<.25,1>,<.5,3>,<.25,4>,<.5,4.5>,<.25,5>,<.5,6>,
      <.5,7>,<.25,8>,<.5,8.5>,<.25,9>,<.5,10>,<.25,12>,<.5,12.5>,<.25,13>
      scale <1,1.085,1>
      sturm
    }

  object
  {
    HOUR_GLASS_POST
    texture
    {
      T_HG_WOOD
    }
    translate <-5.8,-.2,0>
  }

  object
  {
    HOUR_GLASS_POST
    texture
    {
      T_HG_WOOD
    }
    translate <-5.8,-.2,0>
    rotate <0,120,0>
  }

  object
  {
    HOUR_GLASS_POST
    texture
    {
      T_HG_WOOD
    }
    translate <-5.8,-.2,0>
    rotate <0,240,0>
  }

  // Falling Sand
  #declare Count=0
  #while (Count<300)
    box
    {
      <-.015,.015,-.015>,<.015,-.015,.015>
      texture
      {
        T_Sand
      }
      rotate <16*Count,50*Count,256*Count>
      translate <.1*sin(256*Count),7-(.01*Count),.1*sin(16*Count)>
    }
    #declare Count=Count+1
  #end
  #declare Count=0
  #while (Count<150)
    box
    {
      <-0.15,.015,-.015>,<.015,-.015,.015>
      texture
      {
        T_Sand
      }
      rotate <256*Count,16*Count,50*Count>
      translate <.2*sin(16*Count),7-(.02*Count),.2*sin(256*Count)>
    }
    #declare Count=Count+1
  #end
}

object
{
  Hour_Glass
  translate <-15,0,8>
}

//////////////////
// Floor
//////////////////

plane
{
  y,-.8
  texture
  {
    T_Stone9
  }
}

////////////////////
//  Sky
////////////////////
sky_sphere
{
  pigment
  {
    color CornflowerBlue
  }
}
