// This is a Persistence of Vision Ray Tracer (POV-Ray) Version 2.2 Scene file
//             POV-Ray is (Copyrighted) 1994-95, POV-Ray Team
//
// This file was generated using "Mid Night Modeller" Version 2.10
//             MNM is (Copyright) 1994-95, David R.Taylor
//
//
//******************************** HEADER *************************************

// User defined include files



#max_trace_level 5
#max_intersections 100

fog {
    color rgb<0.5, 0.5, 0.5>
    distance 1000
}


//****************** CAMERA **********************

camera {
    location <-33.1, 17, -6.2>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <-2.7, 7.7, -2>
}


//****************** TEXTURES ********************


#declare bigsky = texture {
    pigment { granite
        color_map {
            [0  color rgbf<0.3, 0.3, 1, 0>]
            [0.4  color rgbf<0.3, 0.3, 1, 0>]
            [0.7  color rgbf<0.7, 0.7, 0.7, 0>]
            [0.99  color rgbf<0.95, 0.95, 1, 0>]
        }
        turbulence 0.2
        octaves 6
        omega 0.7
        lambda 2
    }
    finish {
        ambient 1
    }
    scale <30, 30, 30>  
}


#declare Underwater_Sand = texture {
    pigment { agate   agate_turb 0.7
        color_map {
            [0  color rgbf<0.8, 0.8, 0.8, 0>]
            [0.5  color rgbf<0.85, 0.85, 0.85, 0>]
            [0.99  color rgbf<0.9, 0.9, 0.9, 0>]
        }
        turbulence 0.5
        octaves 6
        omega 0.5
        lambda 2
    }
    normal {
        ripples 1
    }
    scale <2, 2, 2>
    translate <100, 0, 0>
}

#declare Dolphin_Skin = texture {
    pigment { granite
        color_map {
            [0  color rgbf<0.65, 0.65, 0.65, 0>]
            [0.1  color rgbf<0.65, 0.65, 0.65, 0>]
            [0.15  color rgbf<0.7, 0.7, 0.7, 0>]
            [0.99  color rgbf<0.73, 0.73, 0.73, 0>]
        }
        turbulence 0.1
        octaves 6
        omega 0.5
        lambda 2
        scale <2, 2, 2>
    }
    finish {
        crand 0.3
        specular 0.3  roughness 0.05
    }
    scale <15, 15, 15>
}

#declare Beach_Ball = texture {
    pigment {
        image_map {
            gif "bball1.gif"
            map_type 1
            interpolate 2
        }
    }
    finish {
        specular 0.5  roughness 0.03
    }
    scale <5, 5, 5>
    rotate <90, 0, 0>
}

#declare Semi_clear_water = texture {
    pigment { color rgbf<0.196078, 0.6, 0.8, 0.8>
    }
    normal {
        bumps 1
        scale <1.5, 1.5, 1.5>
    }
    finish {
        reflection 0.3
        specular 0.3  roughness 0.001
        refraction 1  ior 1.33
    }
    scale <5, 5, 5>
}

#declare Underwater_bubbles = texture {
    pigment { color rgbf<1, 1, 1, 0.5>
        turbulence 0.1
        octaves 6
        omega 0.5
        lambda 2
    }
    normal {
        waves 2
    }
    finish {
        reflection 0.6
        specular 0.5  roughness 0.001
        refraction 1.33  ior 1
    }
    scale <5, 5, 5>
    rotate <90, 0, 0>
}

#declare Surfboard = texture {
    pigment {
        image_map {
            gif "surf1.gif"
            map_type 0
        }
    }
    normal {
        bumps 0.4
        scale <0.1, 0.1, 0.1>
    }
    finish {
        specular 0.5  roughness 0.05
    }
    scale <20, 20, 20>
    rotate <90, 0, 0>
    translate <4, 0, 0>
}


//****************** BLOCK LAYERS ****************



//****************** ACTION **********************


union {  // Layer name: sky
    plane { y, 0.0 
        texture { bigsky }
        scale <34.4, 34.4, 34.4>
        translate <0, 113.25, 0>
        no_shadow
    }
}

union {  // Layer name: toys
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.20000000, 17.20000000, -18.10000000>, <-7.91000091, 16.75000000, -18.10000000>, <-9.40000166, 17.20000000, -16.66000000>, <-9.35000166, 17.20000000, -9.90000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-7.96000091, 16.66799834, -18.10000000>, <-9.40000166, 17.45999698, -16.66000000>, <-9.35000166, 17.45999698, -9.90000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-7.16800130, 17.45999928, -18.10000000>, <-7.96000237, 17.89999870, -16.66000000>, <-7.91000237, 17.89999870, -10.50000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-6.20000099, 17.45999983, -18.10000000>, <-6.20000180, 17.89999968, -16.66000000>, <-6.15000180, 17.89999968, -10.50000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-9.35000166, 17.20000000, -9.90000000>, <-9.30000166, 17.20000000, -3.14000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-9.35000166, 17.45999698, -9.90000000>, <-9.30000166, 17.45999698, -3.14000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-7.91000237, 17.89999870, -10.50000000>, <-7.86000237, 17.89999870, -4.34000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-6.15000180, 17.89999968, -10.50000000>, <-6.10000180, 17.89999968, -4.34000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.20000000, 17.20000000, -18.10000000>, <-6.20000099, 17.45999983, -18.10000000>, <-6.20000180, 17.89999968, -16.66000000>, <-6.15000180, 17.89999968, -10.50000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-5.23200067, 17.46000037, -18.10000000>, <-4.44000122, 17.90000067, -16.66000000>, <-4.39000122, 17.90000067, -10.50000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-4.44000017, 16.66800032, -18.10000000>, <-3.00000032, 17.46000058, -16.66000000>, <-2.95000032, 17.46000058, -9.95000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-4.39000017, 16.75000000, -18.10000000>, <-3.00000032, 17.20000000, -16.66000000>, <-2.95000032, 17.20000000, -9.95000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.15000180, 17.89999968, -10.50000000>, <-6.10000180, 17.89999968, -4.34000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-4.39000122, 17.90000067, -10.50000000>, <-4.34000122, 17.90000067, -4.34000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-2.95000032, 17.46000058, -9.95000000>, <-2.90000032, 17.46000058, -3.24000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-2.95000032, 17.20000000, -9.95000000>, <-2.90000032, 17.20000000, -3.24000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.20000000, 17.20000000, -18.10000000>, <-4.39000017, 16.75000000, -18.10000000>, <-3.00000032, 17.20000000, -16.66000000>, <-2.95000032, 17.20000000, -9.95000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-4.34000017, 16.83199968, -18.10000000>, <-3.00000032, 16.93999942, -16.66000000>, <-2.95000032, 16.93999942, -9.95000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-5.23200067, 16.93999963, -18.10000000>, <-4.54000122, 16.59999933, -16.66000000>, <-4.49000122, 16.59999933, -10.50000000>,
            <-6.20000000, 17.20000000, -18.10000000>, <-6.20000099, 16.94000017, -18.10000000>, <-6.30000180, 16.60000032, -16.66000000>, <-6.25000180, 16.60000032, -10.50000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-2.95000032, 17.20000000, -9.95000000>, <-2.90000032, 17.20000000, -3.24000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-2.95000032, 16.93999942, -9.95000000>, <-2.90000032, 16.93999942, -3.24000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-4.49000122, 16.59999933, -10.50000000>, <-4.44000122, 16.59999933, -4.34000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-6.25000180, 16.60000032, -10.50000000>, <-6.20000180, 16.60000032, -4.34000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.20000000, 17.20000000, -18.10000000>, <-6.20000000, 17.20000000, -18.10000000>, <-6.20000000, 17.20000000, -18.10000000>, <-6.20000000, 17.20000000, -18.10000000>,
            <-7.91000091, 16.75000000, -18.10000000>, <-7.86000091, 16.83200166, -18.10000000>, <-7.16800130, 16.94000072, -18.10000000>, <-6.20000099, 16.94000017, -18.10000000>,
            <-9.40000166, 17.20000000, -16.66000000>, <-9.40000166, 16.94000302, -16.66000000>, <-8.06000237, 16.60000130, -16.66000000>, <-6.30000180, 16.60000032, -16.66000000>,
            <-9.35000166, 17.20000000, -9.90000000>, <-9.35000166, 16.94000302, -9.90000000>, <-8.01000237, 16.60000130, -10.50000000>, <-6.25000180, 16.60000032, -10.50000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-9.35000166, 17.20000000, -9.90000000>, <-9.35000166, 16.94000302, -9.90000000>, <-8.01000237, 16.60000130, -10.50000000>, <-6.25000180, 16.60000032, -10.50000000>,
            <-9.30000166, 17.20000000, -3.14000000>, <-9.30000166, 16.94000302, -3.14000000>, <-7.96000237, 16.60000130, -4.34000000>, <-6.20000180, 16.60000032, -4.34000000>,
            <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>,
            <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>, <-6.00000000, 17.30000000, -1.60000000>
        }
        texture { Surfboard }
    }
    sphere { <0.0, 0.0, 0.0>, 2.60192 
        texture { Beach_Ball }
        rotate <.0, .0, -329.184>
        rotate <.0, 50.1944, .0>
        translate <7.03598, 19.1, -6.12318>
    }
}

union {  // Layer name: bubbles
    torus { 1.8, 0.3 
        translate <-4, 10, -0.1>
    }
    
    texture { Underwater_bubbles }
}

union {  // Layer name: water
    plane { y, 0.0 
        translate <0, 17, 0>
    }
    
    texture { Semi_clear_water }
}

union {  // Layer name: land
    plane { y, 0.0 
        translate <0, -10, 0>
    }
    
    texture { Underwater_Sand }
}

union {  // Layer name: lights
    light_source {  <-131.4, 221.6, -6.2>
        color rgb<1, 1, 1>
    }
    light_source {  <-132.9, 221.2, -6.2>
        color rgb<1, 1, 1>
    }
}

union {  // Layer name: dolphin1
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.98385199, -0.00000000, 3.51446635>, <10.40286666, 0.00000000, 3.25401999>, <9.30000000, 0.00000000, 1.42857143>, <8.80000000, 0.00000000, 1.13571429>,
            <11.98385199, 0.04000000, 3.51446635>, <10.40286666, 0.04000000, 3.25401999>, <9.30000000, 0.04000000, 1.42857143>, <8.80000000, 0.04000000, 1.13571429>,
            <11.94409265, -0.00000000, 3.51008516>, <10.43977822, 0.10000000, 2.55385034>, <9.66000000, 0.10000000, 1.42857143>, <9.16000000, 0.15000000, 1.13571429>,
            <11.98385199, -0.00000000, 3.51446635>, <10.90451343, 0.05000000, 2.35354760>, <10.15000000, 0.10000000, 1.17857143>, <9.90000000, 0.12500000, 0.88571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.80000000, 0.00000000, 1.13571429>, <8.30000000, 0.00000000, 0.84285714>, <8.30000000, 0.00000000, -0.84285714>, <8.85000000, 0.00000000, -1.03571429>,
            <8.80000000, 0.04000000, 1.13571429>, <8.30000000, 0.04000000, 0.84285714>, <8.30000000, 0.04000000, -0.84285714>, <8.85000000, 0.04000000, -1.03571429>,
            <9.16000000, 0.15000000, 1.13571429>, <8.66000000, 0.20000000, 0.84285714>, <8.66000000, 0.20000000, -0.84285714>, <9.21000000, 0.15000000, -1.03571429>,
            <9.90000000, 0.12500000, 0.88571429>, <9.65000000, 0.15000000, 0.59285714>, <9.65000000, 0.15000000, -0.54285714>, <9.92500000, 0.12500000, -0.78571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.85000000, 0.00000000, -1.03571429>, <9.40000000, 0.00000000, -1.22857143>, <10.11818613, 0.00000000, -3.55265029>, <11.99620033, 0.00000000, -3.89550949>,
            <8.85000000, 0.04000000, -1.03571429>, <9.40000000, 0.04000000, -1.22857143>, <10.11818613, 0.04000000, -3.55265029>, <11.99620033, 0.04000000, -3.89550949>,
            <9.21000000, 0.15000000, -1.03571429>, <9.76000000, 0.10000000, -1.22857143>, <10.43541986, 0.10000000, -2.87666008>, <11.95633850, 0.00000000, -3.89218767>,
            <9.92500000, 0.12500000, -0.78571429>, <10.20000000, 0.10000000, -1.02857143>, <10.89881364, 0.05000000, -2.61423637>, <11.99620033, 0.00000000, -3.89550949>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.98385199, -0.00000000, 3.51446635>, <10.90451343, 0.05000000, 2.35354760>, <10.15000000, 0.10000000, 1.17857143>, <9.90000000, 0.12500000, 0.88571429>,
            <12.02361133, -0.00000000, 3.51884755>, <11.36924864, 0.00000000, 2.15324487>, <10.64000000, 0.10000000, 0.92857143>, <10.64000000, 0.10000000, 0.63571429>,
            <11.98385199, 0.04000000, 3.51446635>, <11.72708270, 0.04000000, 2.19267562>, <11.00000000, 0.04000000, 0.22857143>, <10.85000000, 0.04000000, 0.13571429>,
            <11.98385199, -0.00000000, 3.51446635>, <11.72708270, 0.00000000, 2.19267562>, <11.00000000, 0.00000000, 0.22857143>, <10.85000000, 0.00000000, 0.13571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.90000000, 0.12500000, 0.88571429>, <9.65000000, 0.15000000, 0.59285714>, <9.65000000, 0.15000000, -0.54285714>, <9.92500000, 0.12500000, -0.78571429>,
            <10.64000000, 0.10000000, 0.63571429>, <10.64000000, 0.10000000, 0.34285714>, <10.64000000, 0.10000000, -0.24285714>, <10.64000000, 0.10000000, -0.53571429>,
            <10.85000000, 0.04000000, 0.13571429>, <10.70000000, 0.04000000, 0.04285714>, <10.70000000, 0.04000000, -0.04285714>, <10.85000000, 0.04000000, -0.13571429>,
            <10.85000000, 0.00000000, 0.13571429>, <10.70000000, 0.00000000, 0.04285714>, <10.70000000, 0.00000000, -0.04285714>, <10.85000000, 0.00000000, -0.13571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.92500000, 0.12500000, -0.78571429>, <10.20000000, 0.10000000, -1.02857143>, <10.89881364, 0.05000000, -2.61423637>, <11.99620033, 0.00000000, -3.89550949>,
            <10.64000000, 0.10000000, -0.53571429>, <10.64000000, 0.10000000, -0.82857143>, <11.36220741, 0.00000000, -2.35181265>, <12.03606216, 0.00000000, -3.89883130>,
            <10.85000000, 0.04000000, -0.13571429>, <11.00000000, 0.04000000, -0.22857143>, <11.72096389, 0.04000000, -2.38170902>, <11.99620033, 0.04000000, -3.89550949>,
            <10.85000000, 0.00000000, -0.13571429>, <11.00000000, 0.00000000, -0.22857143>, <11.72096389, 0.00000000, -2.38170902>, <11.99620033, 0.00000000, -3.89550949>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.98385199, -0.00000000, 3.51446635>, <11.72708270, 0.00000000, 2.19267562>, <11.00000000, 0.00000000, 0.22857143>, <10.85000000, 0.00000000, 0.13571429>,
            <11.98385199, -0.04000000, 3.51446635>, <11.72708270, -0.04000000, 2.19267562>, <11.00000000, -0.04000000, 0.22857143>, <10.85000000, -0.04000000, 0.13571429>,
            <12.02361133, -0.00000000, 3.51884755>, <11.36924864, 0.00000000, 2.15324487>, <10.54000000, -0.10000000, 0.92857143>, <10.54000000, -0.10000000, 0.63571429>,
            <11.98385199, -0.00000000, 3.51446635>, <10.90451343, -0.05000000, 2.35354760>, <10.10000000, -0.15000000, 1.17857143>, <9.85000000, -0.15000000, 0.88571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <10.85000000, 0.00000000, 0.13571429>, <10.70000000, 0.00000000, 0.04285714>, <10.70000000, 0.00000000, -0.04285714>, <10.85000000, 0.00000000, -0.13571429>,
            <10.85000000, -0.04000000, 0.13571429>, <10.70000000, -0.04000000, 0.04285714>, <10.70000000, -0.04000000, -0.04285714>, <10.85000000, -0.04000000, -0.13571429>,
            <10.54000000, -0.10000000, 0.63571429>, <10.54000000, -0.10000000, 0.34285714>, <10.54000000, -0.10000000, -0.24285714>, <10.54000000, -0.10000000, -0.53571429>,
            <9.85000000, -0.15000000, 0.88571429>, <9.60000000, -0.15000000, 0.59285714>, <9.60000000, -0.15000000, -0.54285714>, <9.87500000, -0.15000000, -0.78571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <10.85000000, 0.00000000, -0.13571429>, <11.00000000, 0.00000000, -0.22857143>, <11.72096389, 0.00000000, -2.38170902>, <11.99620033, 0.00000000, -3.89550949>,
            <10.85000000, -0.04000000, -0.13571429>, <11.00000000, -0.04000000, -0.22857143>, <11.72096389, -0.04000000, -2.38170902>, <11.99620033, -0.04000000, -3.89550949>,
            <10.54000000, -0.10000000, -0.53571429>, <10.54000000, -0.10000000, -0.82857143>, <11.36220741, 0.00000000, -2.35181265>, <12.03606216, 0.00000000, -3.89883130>,
            <9.87500000, -0.15000000, -0.78571429>, <10.15000000, -0.15000000, -1.02857143>, <10.89881364, -0.05000000, -2.61423637>, <11.99620033, 0.00000000, -3.89550949>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.98385199, -0.00000000, 3.51446635>, <11.98385199, -0.04000000, 3.51446635>, <11.94409265, -0.00000000, 3.51008516>, <11.98385199, -0.00000000, 3.51446635>,
            <10.40286666, 0.00000000, 3.25401999>, <10.40286666, -0.04000000, 3.25401999>, <10.43977822, -0.10000000, 2.55385034>, <10.90451343, -0.05000000, 2.35354760>,
            <9.30000000, 0.00000000, 1.42857143>, <9.30000000, -0.04000000, 1.42857143>, <9.66000000, -0.20000000, 1.42857143>, <10.10000000, -0.15000000, 1.17857143>,
            <8.80000000, 0.00000000, 1.13571429>, <8.80000000, -0.04000000, 1.13571429>, <9.16000000, -0.20000000, 1.13571429>, <9.85000000, -0.15000000, 0.88571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.80000000, 0.00000000, 1.13571429>, <8.80000000, -0.04000000, 1.13571429>, <9.16000000, -0.20000000, 1.13571429>, <9.85000000, -0.15000000, 0.88571429>,
            <8.30000000, 0.00000000, 0.84285714>, <8.30000000, -0.04000000, 0.84285714>, <8.66000000, -0.20000000, 0.84285714>, <9.60000000, -0.15000000, 0.59285714>,
            <8.30000000, 0.00000000, -0.84285714>, <8.30000000, -0.04000000, -0.84285714>, <8.66000000, -0.20000000, -0.84285714>, <9.60000000, -0.15000000, -0.54285714>,
            <8.85000000, 0.00000000, -1.03571429>, <8.85000000, -0.04000000, -1.03571429>, <9.21000000, -0.20000000, -1.03571429>, <9.87500000, -0.15000000, -0.78571429>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.85000000, 0.00000000, -1.03571429>, <8.85000000, -0.04000000, -1.03571429>, <9.21000000, -0.20000000, -1.03571429>, <9.87500000, -0.15000000, -0.78571429>,
            <9.40000000, 0.00000000, -1.22857143>, <9.40000000, -0.04000000, -1.22857143>, <9.76000000, -0.20000000, -1.22857143>, <10.15000000, -0.15000000, -1.02857143>,
            <10.11818613, 0.00000000, -3.55265029>, <10.11818613, -0.04000000, -3.55265029>, <10.43541986, -0.10000000, -2.87666008>, <10.89881364, -0.05000000, -2.61423637>,
            <11.99620033, 0.00000000, -3.89550949>, <11.99620033, -0.04000000, -3.89550949>, <11.95633850, 0.00000000, -3.89218767>, <11.99620033, 0.00000000, -3.89550949>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, -1.80926616>, <-4.30000029, -1.39691861, -3.19544213>, <-4.75000052, -1.57675708, -3.61096364>, <-4.75000052, -1.62455625, -3.59629261>,
            <-3.90000000, -0.97145866, -1.80926616>, <-4.15000029, -1.91113816, -4.87080260>, <-4.50000052, -2.00221675, -4.99713871>, <-4.50000052, -2.05001592, -4.98246768>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.90250041, -1.98375986, -5.10740878>, <-4.05000074, -2.13425620, -5.42733177>, <-4.05000074, -2.18205537, -5.41266074>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.75000031, -1.99843094, -5.15520811>, <-2.90000056, -2.26629559, -5.85752461>, <-2.90000056, -2.31409476, -5.84285358>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.75000052, -1.62455625, -3.59629261>, <-4.75000052, -1.67235542, -3.58162158>, <-4.30000029, -1.58811529, -3.13675800>, <-3.90000000, -1.16265534, -1.75058203>,
            <-4.50000052, -2.05001592, -4.98246768>, <-4.50000052, -2.09781509, -4.96779665>, <-4.15000029, -2.10233484, -4.81211847>, <-3.90000000, -1.16265534, -1.75058203>,
            <-4.05000074, -2.18205537, -5.41266074>, <-4.05000074, -2.22985455, -5.39798970>, <-3.90250041, -2.17495654, -5.04872465>, <-3.90000000, -1.16265534, -1.75058203>,
            <-2.90000056, -2.31409476, -5.84285358>, <-2.90000056, -2.36189393, -5.82818254>, <-3.75000031, -2.18962762, -5.09652398>, <-3.90000000, -1.16265534, -1.75058203>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, -1.80926616>, <-3.75000031, -1.99843094, -5.15520811>, <-2.90000056, -2.26629559, -5.85752461>, <-2.90000056, -2.31409476, -5.84285358>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.59750021, -2.01310202, -5.20300744>, <-1.75000038, -2.39833498, -6.28771745>, <-1.75000038, -2.44613415, -6.27304641>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.55000005, -1.91113834, -4.87080319>, <-3.40000010, -1.97287501, -4.90154144>, <-3.40000010, -2.02067419, -4.88687041>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.50000005, -1.35290551, -3.05204462>, <-3.10000010, -1.45938881, -3.22857027>, <-3.10000010, -1.50718798, -3.21389924>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-2.90000056, -2.31409476, -5.84285358>, <-2.90000056, -2.36189393, -5.82818254>, <-3.75000031, -2.18962762, -5.09652398>, <-3.90000000, -1.16265534, -1.75058203>,
            <-1.75000038, -2.44613415, -6.27304641>, <-1.75000038, -2.49393332, -6.25837538>, <-3.59750021, -2.20429871, -5.14432331>, <-3.90000000, -1.16265534, -1.75058203>,
            <-3.40000010, -2.02067419, -4.88687041>, <-3.40000010, -2.06847336, -4.87219938>, <-3.55000005, -2.10233502, -4.81211906>, <-3.90000000, -1.16265534, -1.75058203>,
            <-3.10000010, -1.50718798, -3.21389924>, <-3.10000010, -1.55498716, -3.19922820>, <-3.50000005, -1.54410220, -2.99336049>, <-3.90000000, -1.16265534, -1.75058203>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, -1.80926616>, <-3.50000005, -1.35290551, -3.05204462>, <-3.10000010, -1.45938881, -3.22857027>, <-3.10000010, -1.50718798, -3.21389924>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.45000005, -0.79467268, -1.23328605>, <-2.80000010, -0.94590261, -1.55559910>, <-2.80000010, -0.99370178, -1.54092806>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.59750021, -0.81007726, -1.28347516>, <-3.65000038, -0.49772621, -1.11783438>, <-3.65000038, -0.88011958, -1.00046612>,
            <-3.90000000, -0.97145866, -1.80926616>, <-3.90000031, -0.81007731, -1.28347532>, <-4.30000056, -0.49772630, -1.11783467>, <-4.30000056, -0.88011967, -1.00046641>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.10000010, -1.50718798, -3.21389924>, <-3.10000010, -1.55498716, -3.19922820>, <-3.50000005, -1.54410220, -2.99336049>, <-3.90000000, -1.16265534, -1.75058203>,
            <-2.80000010, -0.99370178, -1.54092806>, <-2.80000010, -1.04150095, -1.52625703>, <-3.45000005, -0.98586937, -1.17460192>, <-3.90000000, -1.16265534, -1.75058203>,
            <-3.65000038, -0.88011958, -1.00046612>, <-3.65000038, -1.26251296, -0.88309785>, <-3.59750021, -1.00127395, -1.22479103>, <-3.90000000, -1.16265534, -1.75058203>,
            <-4.30000056, -0.88011967, -1.00046641>, <-4.30000056, -1.26251305, -0.88309815>, <-3.90000031, -1.00127400, -1.22479119>, <-3.90000000, -1.16265534, -1.75058203>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, -1.80926616>, <-3.90000000, -0.97145866, -1.80926616>, <-3.90000000, -0.97145866, -1.80926616>, <-3.90000000, -0.97145866, -1.80926616>,
            <-4.30000029, -1.39691861, -3.19544213>, <-4.45000029, -0.88269906, -1.52008167>, <-4.20250041, -0.81007736, -1.28347549>, <-3.90000031, -0.81007731, -1.28347532>,
            <-4.75000052, -1.57675708, -3.61096364>, <-5.00000052, -1.15129740, -2.22478857>, <-4.95000074, -0.49772639, -1.11783497>, <-4.30000056, -0.49772630, -1.11783467>,
            <-4.75000052, -1.62455625, -3.59629261>, <-5.00000052, -1.19909657, -2.21011754>, <-4.95000074, -0.88011976, -1.00046671>, <-4.30000056, -0.88011967, -1.00046641>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.75000052, -1.62455625, -3.59629261>, <-5.00000052, -1.19909657, -2.21011754>, <-4.95000074, -0.88011976, -1.00046671>, <-4.30000056, -0.88011967, -1.00046641>,
            <-4.75000052, -1.67235542, -3.58162158>, <-5.00000052, -1.24689574, -2.19544651>, <-4.95000074, -1.26251314, -0.88309844>, <-4.30000056, -1.26251305, -0.88309815>,
            <-4.30000029, -1.58811529, -3.13675800>, <-4.45000029, -1.07389575, -1.46139754>, <-4.20250041, -1.00127405, -1.22479135>, <-3.90000031, -1.00127400, -1.22479119>,
            <-3.90000000, -1.16265534, -1.75058203>, <-3.90000000, -1.16265534, -1.75058203>, <-3.90000000, -1.16265534, -1.75058203>, <-3.90000000, -1.16265534, -1.75058203>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, 1.80926616>, <-4.30000029, -1.39691861, 3.19544213>, <-4.75000052, -1.57675708, 3.61096364>, <-4.75000052, -1.62455625, 3.59629261>,
            <-3.90000000, -0.97145866, 1.80926616>, <-4.15000029, -1.91113816, 4.87080260>, <-4.50000052, -2.00221675, 4.99713871>, <-4.50000052, -2.05001592, 4.98246768>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.90250041, -1.98375986, 5.10740878>, <-4.05000074, -2.13425620, 5.42733177>, <-4.05000074, -2.18205537, 5.41266074>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.75000031, -1.99843094, 5.15520811>, <-2.90000056, -2.26629559, 5.85752461>, <-2.90000056, -2.31409476, 5.84285358>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.75000052, -1.62455625, 3.59629261>, <-4.75000052, -1.67235542, 3.58162158>, <-4.30000029, -1.58811529, 3.13675800>, <-3.90000000, -1.16265534, 1.75058203>,
            <-4.50000052, -2.05001592, 4.98246768>, <-4.50000052, -2.09781509, 4.96779665>, <-4.15000029, -2.10233484, 4.81211847>, <-3.90000000, -1.16265534, 1.75058203>,
            <-4.05000074, -2.18205537, 5.41266074>, <-4.05000074, -2.22985455, 5.39798970>, <-3.90250041, -2.17495654, 5.04872465>, <-3.90000000, -1.16265534, 1.75058203>,
            <-2.90000056, -2.31409476, 5.84285358>, <-2.90000056, -2.36189393, 5.82818254>, <-3.75000031, -2.18962762, 5.09652398>, <-3.90000000, -1.16265534, 1.75058203>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, 1.80926616>, <-3.75000031, -1.99843094, 5.15520811>, <-2.90000056, -2.26629559, 5.85752461>, <-2.90000056, -2.31409476, 5.84285358>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.59750021, -2.01310202, 5.20300744>, <-1.75000038, -2.39833498, 6.28771745>, <-1.75000038, -2.44613415, 6.27304641>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.55000005, -1.91113834, 4.87080319>, <-3.40000010, -1.97287501, 4.90154144>, <-3.40000010, -2.02067419, 4.88687041>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.50000005, -1.35290551, 3.05204462>, <-3.10000010, -1.45938881, 3.22857027>, <-3.10000010, -1.50718798, 3.21389924>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-2.90000056, -2.31409476, 5.84285358>, <-2.90000056, -2.36189393, 5.82818254>, <-3.75000031, -2.18962762, 5.09652398>, <-3.90000000, -1.16265534, 1.75058203>,
            <-1.75000038, -2.44613415, 6.27304641>, <-1.75000038, -2.49393332, 6.25837538>, <-3.59750021, -2.20429871, 5.14432331>, <-3.90000000, -1.16265534, 1.75058203>,
            <-3.40000010, -2.02067419, 4.88687041>, <-3.40000010, -2.06847336, 4.87219938>, <-3.55000005, -2.10233502, 4.81211906>, <-3.90000000, -1.16265534, 1.75058203>,
            <-3.10000010, -1.50718798, 3.21389924>, <-3.10000010, -1.55498716, 3.19922820>, <-3.50000005, -1.54410220, 2.99336049>, <-3.90000000, -1.16265534, 1.75058203>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, 1.80926616>, <-3.50000005, -1.35290551, 3.05204462>, <-3.10000010, -1.45938881, 3.22857027>, <-3.10000010, -1.50718798, 3.21389924>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.45000005, -0.79467268, 1.23328605>, <-2.80000010, -0.94590261, 1.55559910>, <-2.80000010, -0.99370178, 1.54092806>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.59750021, -0.81007726, 1.28347516>, <-3.65000038, -0.49772621, 1.11783438>, <-3.65000038, -0.88011958, 1.00046612>,
            <-3.90000000, -0.97145866, 1.80926616>, <-3.90000031, -0.81007731, 1.28347532>, <-4.30000056, -0.49772630, 1.11783467>, <-4.30000056, -0.88011967, 1.00046641>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.10000010, -1.50718798, 3.21389924>, <-3.10000010, -1.55498716, 3.19922820>, <-3.50000005, -1.54410220, 2.99336049>, <-3.90000000, -1.16265534, 1.75058203>,
            <-2.80000010, -0.99370178, 1.54092806>, <-2.80000010, -1.04150095, 1.52625703>, <-3.45000005, -0.98586937, 1.17460192>, <-3.90000000, -1.16265534, 1.75058203>,
            <-3.65000038, -0.88011958, 1.00046612>, <-3.65000038, -1.26251296, 0.88309785>, <-3.59750021, -1.00127395, 1.22479103>, <-3.90000000, -1.16265534, 1.75058203>,
            <-4.30000056, -0.88011967, 1.00046641>, <-4.30000056, -1.26251305, 0.88309815>, <-3.90000031, -1.00127400, 1.22479119>, <-3.90000000, -1.16265534, 1.75058203>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.90000000, -0.97145866, 1.80926616>, <-3.90000000, -0.97145866, 1.80926616>, <-3.90000000, -0.97145866, 1.80926616>, <-3.90000000, -0.97145866, 1.80926616>,
            <-4.30000029, -1.39691861, 3.19544213>, <-4.45000029, -0.88269906, 1.52008167>, <-4.20250041, -0.81007736, 1.28347549>, <-3.90000031, -0.81007731, 1.28347532>,
            <-4.75000052, -1.57675708, 3.61096364>, <-5.00000052, -1.15129740, 2.22478857>, <-4.95000074, -0.49772639, 1.11783497>, <-4.30000056, -0.49772630, 1.11783467>,
            <-4.75000052, -1.62455625, 3.59629261>, <-5.00000052, -1.19909657, 2.21011754>, <-4.95000074, -0.88011976, 1.00046671>, <-4.30000056, -0.88011967, 1.00046641>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.75000052, -1.62455625, 3.59629261>, <-5.00000052, -1.19909657, 2.21011754>, <-4.95000074, -0.88011976, 1.00046671>, <-4.30000056, -0.88011967, 1.00046641>,
            <-4.75000052, -1.67235542, 3.58162158>, <-5.00000052, -1.24689574, 2.19544651>, <-4.95000074, -1.26251314, 0.88309844>, <-4.30000056, -1.26251305, 0.88309815>,
            <-4.30000029, -1.58811529, 3.13675800>, <-4.45000029, -1.07389575, 1.46139754>, <-4.20250041, -1.00127405, 1.22479135>, <-3.90000031, -1.00127400, 1.22479119>,
            <-3.90000000, -1.16265534, 1.75058203>, <-3.90000000, -1.16265534, 1.75058203>, <-3.90000000, -1.16265534, 1.75058203>, <-3.90000000, -1.16265534, 1.75058203>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.42207025, 0.00000000, 1.13494186>, <-10.74891286, -0.08282468, 0.85969034>, <-10.87426973, 0.01812698, 0.68451180>, <-10.84326105, 0.00210383, 0.58844398>,
            <-6.45768420, 0.00000000, 1.13494186>, <-10.31409466, 0.08023215, 0.85969034>, <-10.43945153, 0.28118381, 0.68451180>, <-10.90844284, 0.56516065, 0.58844398>,
            <-6.49329816, 0.00000000, 1.13494186>, <-8.06516554, 0.25518292, 0.85969034>, <-8.10463332, 0.54424063, 0.68451180>, <-8.17362464, 0.62821748, 0.58844398>,
            <-6.46110514, 0.00000000, 1.13494186>, <-7.83389111, 0.27581631, 0.85969034>, <-7.98722422, 0.77576905, 0.68451180>, <-8.05621554, 0.90974589, 0.58844398>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-10.84326105, 0.00210383, 0.58844398>, <-10.81225237, -0.01391933, 0.49237615>, <-10.83983450, -0.04036696, 0.00254128>, <-10.79632576, -0.00639028, -0.07358784>,
            <-10.90844284, 0.56516065, 0.58844398>, <-11.37743416, 0.84913750, 0.49237615>, <-11.50501630, 0.92268987, 0.00254128>, <-11.46150755, 0.80666654, -0.07358784>,
            <-8.17362464, 0.62821748, 0.58844398>, <-8.24261596, 0.71219433, 0.49237615>, <-8.27019810, 0.88574669, 0.00254128>, <-8.22668935, 0.76972337, -0.07358784>,
            <-8.05621554, 0.90974589, 0.58844398>, <-8.12520686, 1.04372274, 0.49237615>, <-8.15278899, 1.16727511, 0.00254128>, <-8.10928025, 1.05125178, -0.07358784>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-10.79632576, -0.00639028, -0.07358784>, <-10.75281701, 0.02758640, -0.14971696>, <-10.76646718, 0.03065349, -0.33598758>, <-8.64426871, 0.01278546, -0.59618774>,
            <-11.46150755, 0.80666654, -0.07358784>, <-11.41799881, 0.69064322, -0.14971696>, <-10.33164897, 0.09371032, -0.33598758>, <-8.44466659, 0.04431388, -0.59618774>,
            <-8.22668935, 0.76972337, -0.07358784>, <-8.18318060, 0.65370005, -0.14971696>, <-8.09683077, 0.35676715, -0.33598758>, <-7.34506446, 0.17584229, -0.59618774>,
            <-8.10928025, 1.05125178, -0.07358784>, <-8.06577150, 0.93522846, -0.14971696>, <-7.92942166, 0.53829556, -0.33598758>, <-7.24526340, 0.24160650, -0.59618774>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-8.64426871, 0.01278546, -0.59618774>, <-6.52207025, -0.00508256, -0.85638790>, <-6.52207025, 0.00508256, -0.85638790>, <-8.58457543, -0.14067165, -0.59618774>,
            <-8.44466659, 0.04431388, -0.59618774>, <-6.55768420, -0.00508256, -0.85638790>, <-6.55768420, 0.00508256, -0.85638790>, <-8.47756475, -0.24872867, -0.59618774>,
            <-7.34506446, 0.17584229, -0.59618774>, <-6.59329816, -0.00508256, -0.85638790>, <-6.49329816, 0.00508256, -0.85638790>, <-7.33321940, -0.31519531, -0.59618774>,
            <-7.24526340, 0.24160650, -0.59618774>, <-6.56110514, -0.05508256, -0.85638790>, <-6.51110514, 0.00508256, -0.85638790>, <-7.19499789, -0.36549966, -0.59618774>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-8.58457543, -0.14067165, -0.59618774>, <-10.64708062, -0.28642586, -0.33598758>, <-10.67978181, -0.30029254, -0.14971696>, <-10.71076473, -0.32026954, -0.07358784>,
            <-8.47756475, -0.24872867, -0.59618774>, <-10.39744529, -0.50253991, -0.33598758>, <-10.43014649, -0.71640659, -0.14971696>, <-10.46112941, -0.83638359, -0.07358784>,
            <-7.33321940, -0.31519531, -0.59618774>, <-8.17314064, -0.63547318, -0.33598758>, <-8.18051116, -0.93252065, -0.14971696>, <-8.26149408, -0.95249765, -0.07358784>,
            <-7.19499789, -0.36549966, -0.59618774>, <-7.87889065, -0.73608188, -0.33598758>, <-7.99761031, -1.04098441, -0.14971696>, <-8.04123482, -1.08910904, -0.07358784>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-10.71076473, -0.32026954, -0.07358784>, <-10.74174765, -0.34024654, 0.00254128>, <-10.72210620, -0.26418776, 0.49237615>, <-10.72297693, -0.27394161, 0.58844398>,
            <-10.46112941, -0.83638359, -0.07358784>, <-10.49211233, -0.95636059, 0.00254128>, <-10.47247087, -0.78030181, 0.49237615>, <-10.42334161, -0.69005566, 0.58844398>,
            <-8.26149408, -0.95249765, -0.07358784>, <-8.34247700, -0.97247465, 0.00254128>, <-8.32283554, -0.99641587, 0.49237615>, <-8.22370628, -0.90616972, 0.58844398>,
            <-8.04123482, -1.08910904, -0.07358784>, <-8.08485932, -1.13723367, 0.00254128>, <-8.04539832, -1.20450579, 0.49237615>, <-8.00389300, -1.06147017, 0.58844398>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-10.72297693, -0.27394161, 0.58844398>, <-10.72384767, -0.28369546, 0.68451180>, <-10.76336926, -0.26226542, 0.85969034>, <-6.42207025, 0.00000000, 1.13494186>,
            <-10.42334161, -0.69005566, 0.58844398>, <-10.37421234, -0.59980951, 0.68451180>, <-10.31373394, -0.37837947, 0.85969034>, <-6.45768420, 0.00000000, 1.13494186>,
            <-8.22370628, -0.90616972, 0.58844398>, <-8.12457702, -0.81592357, 0.68451180>, <-8.04599944, -0.49773624, 0.85969034>, <-6.49329816, 0.00000000, 1.13494186>,
            <-8.00389300, -1.06147017, 0.58844398>, <-7.96238768, -0.91843454, 0.68451180>, <-7.81381579, -0.49982276, 0.85969034>, <-6.46110514, 0.00000000, 1.13494186>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.46110514, 0.00000000, 1.13494186>, <-7.83389111, 0.27581631, 0.85969034>, <-7.98722422, 0.77576905, 0.68451180>, <-8.05621554, 0.90974589, 0.58844398>,
            <-6.42891211, 0.00000000, 1.13494186>, <-7.60261668, 0.29644970, 0.85969034>, <-7.86981512, 1.00729746, 0.68451180>, <-7.93880644, 1.19127431, 0.58844398>,
            <-6.56452607, 0.00000000, 1.03494186>, <-7.14006781, 0.33771648, 0.85969034>, <-7.43499691, 1.17035429, 0.68451180>, <-7.50398823, 1.35433113, 0.58844398>,
            <-6.53233304, 0.00000000, 1.08494186>, <-6.90879338, 0.35834987, 0.90969034>, <-7.21758781, 1.25188270, 0.98451180>, <-7.28657913, 1.43585955, 0.76344398>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-8.05621554, 0.90974589, 0.58844398>, <-8.12520686, 1.04372274, 0.49237615>, <-8.15278899, 1.16727511, 0.00254128>, <-8.10928025, 1.05125178, -0.07358784>,
            <-7.93880644, 1.19127431, 0.58844398>, <-8.00779775, 1.37525115, 0.49237615>, <-8.03537989, 1.44880352, 0.00254128>, <-7.99187115, 1.33278020, -0.07358784>,
            <-7.50398823, 1.35433113, 0.58844398>, <-7.57297955, 1.53830798, 0.49237615>, <-7.60056169, 1.61186035, 0.00254128>, <-7.55705294, 1.49583703, -0.07358784>,
            <-7.28657913, 1.43585955, 0.76344398>, <-7.35557045, 1.61983639, 0.54237615>, <-7.38315258, 1.69338876, -0.09745872>, <-7.33964384, 1.57736544, -0.32358784>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-8.10928025, 1.05125178, -0.07358784>, <-8.06577150, 0.93522846, -0.14971696>, <-7.92942166, 0.53829556, -0.33598758>, <-7.24526340, 0.24160650, -0.59618774>,
            <-7.99187115, 1.33278020, -0.07358784>, <-7.94836240, 1.21675688, -0.14971696>, <-7.76201256, 0.71982397, -0.33598758>, <-7.14546234, 0.30737070, -0.59618774>,
            <-7.55705294, 1.49583703, -0.07358784>, <-7.51354420, 1.37981370, -0.14971696>, <-7.32719436, 0.88288080, -0.33598758>, <-6.89586021, 0.43889912, -0.59618774>,
            <-7.33964384, 1.57736544, -0.32358784>, <-7.29613509, 1.46134212, -0.54971696>, <-7.10978525, 0.96440921, -0.43598758>, <-6.83072311, 0.57336485, -0.64618774>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-7.24526340, 0.24160650, -0.59618774>, <-6.56110514, -0.05508256, -0.85638790>, <-6.51110514, 0.00508256, -0.85638790>, <-7.19499789, -0.36549966, -0.59618774>,
            <-7.14546234, 0.30737070, -0.59618774>, <-6.52891211, -0.10508256, -0.85638790>, <-6.52891211, 0.00508256, -0.85638790>, <-7.05677638, -0.41580401, -0.59618774>,
            <-6.89586021, 0.43889912, -0.59618774>, <-6.46452607, -0.00508256, -0.85638790>, <-6.46452607, 0.00508256, -0.85638790>, <-6.79239971, -0.41789052, -0.59618774>,
            <-6.83072311, 0.57336485, -0.64618774>, <-6.55166097, 0.18232049, -0.85638790>, <-6.54142677, -0.23132821, -0.85638790>, <-6.71475824, -0.53713917, -0.64618774>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-7.19499789, -0.36549966, -0.59618774>, <-7.87889065, -0.73608188, -0.33598758>, <-7.99761031, -1.04098441, -0.14971696>, <-8.04123482, -1.08910904, -0.07358784>,
            <-7.05677638, -0.41580401, -0.59618774>, <-7.58464065, -0.83669059, -0.33598758>, <-7.81470946, -1.14944818, -0.14971696>, <-7.82097555, -1.22572044, -0.07358784>,
            <-6.79239971, -0.41789052, -0.59618774>, <-7.12027335, -0.84086361, -0.33598758>, <-7.25330163, -1.29469109, -0.14971696>, <-7.24313656, -1.41818641, -0.07358784>,
            <-6.71475824, -0.53713917, -0.64618774>, <-6.88808970, -0.84295012, -0.43598758>, <-7.02189121, -1.32564338, -0.54971696>, <-7.01172614, -1.44913870, -0.32358784>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-8.04123482, -1.08910904, -0.07358784>, <-8.08485932, -1.13723367, 0.00254128>, <-8.04539832, -1.20450579, 0.49237615>, <-8.00389300, -1.06147017, 0.58844398>,
            <-7.82097555, -1.22572044, -0.07358784>, <-7.82724165, -1.30199270, 0.00254128>, <-7.76796109, -1.41259572, 0.49237615>, <-7.78407972, -1.21677062, 0.58844398>,
            <-7.24313656, -1.41818641, -0.07358784>, <-7.23297150, -1.54168172, 0.00254128>, <-7.23941559, -1.46339252, 0.49237615>, <-7.25553422, -1.31756742, 0.58844398>,
            <-7.01172614, -1.44913870, -0.32358784>, <-7.00156107, -1.57263402, -0.09745872>, <-7.00800516, -1.49434482, 0.54237615>, <-7.02412379, -1.32351971, 0.76344398>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-8.00389300, -1.06147017, 0.58844398>, <-7.96238768, -0.91843454, 0.68451180>, <-7.81381579, -0.49982276, 0.85969034>, <-6.46110514, 0.00000000, 1.13494186>,
            <-7.78407972, -1.21677062, 0.58844398>, <-7.80019835, -1.02094551, 0.68451180>, <-7.58163214, -0.50190927, 0.85969034>, <-6.42891211, 0.00000000, 1.13494186>,
            <-7.25553422, -1.31756742, 0.58844398>, <-7.27165285, -1.17174231, 0.68451180>, <-7.11726485, -0.50608229, 0.85969034>, <-6.56452607, 0.00000000, 1.03494186>,
            <-7.02412379, -1.32351971, 0.76344398>, <-7.04024243, -1.15269461, 0.98451180>, <-6.88508120, -0.50816881, 0.90969034>, <-6.53233304, 0.00000000, 1.08494186>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.53233304, 0.00000000, 1.08494186>, <-6.90879338, 0.35834987, 0.90969034>, <-7.21758781, 1.25188270, 0.98451180>, <-7.28657913, 1.43585955, 0.76344398>,
            <-6.50014002, 0.00000000, 1.13494186>, <-6.67751895, 0.37898326, 0.95969034>, <-7.00017871, 1.33341111, 1.28451180>, <-7.06917003, 1.51738796, 0.93844398>,
            <-6.13575397, 0.00000000, 1.43494186>, <-6.13575397, 0.78231955, 1.25969034>, <-6.03575397, 1.42413620, 1.28451180>, <-6.03575397, 1.62062356, 0.93844398>,
            <-5.80356095, 0.00000000, 1.58494186>, <-5.80356095, 0.78231955, 1.40969034>, <-5.80356095, 1.42413620, 1.28451180>, <-5.80356095, 1.62062356, 0.93844398>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-7.28657913, 1.43585955, 0.76344398>, <-7.35557045, 1.61983639, 0.54237615>, <-7.38315258, 1.69338876, -0.09745872>, <-7.33964384, 1.57736544, -0.32358784>,
            <-7.06917003, 1.51738796, 0.93844398>, <-7.13816134, 1.70136481, 0.59237615>, <-7.16574348, 1.77491717, -0.19745872>, <-7.12223474, 1.65889385, -0.57358784>,
            <-6.03575397, 1.62062356, 0.93844398>, <-6.03575397, 1.81711092, 0.59237615>, <-6.03575397, 1.89566488, -0.19745872>, <-6.03575397, 1.77175192, -0.57358784>,
            <-5.80356095, 1.62062356, 0.93844398>, <-5.80356095, 1.81711092, 0.59237615>, <-5.80356095, 1.89566488, -0.19745872>, <-5.80356095, 1.77175192, -0.57358784>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-7.33964384, 1.57736544, -0.32358784>, <-7.29613509, 1.46134212, -0.54971696>, <-7.10978525, 0.96440921, -0.43598758>, <-6.83072311, 0.57336485, -0.64618774>,
            <-7.12223474, 1.65889385, -0.57358784>, <-7.07872599, 1.54287053, -0.94971696>, <-6.89237615, 1.04593763, -0.53598758>, <-6.76558601, 0.70783059, -0.69618774>,
            <-6.03575397, 1.77175192, -0.57358784>, <-6.03575397, 1.64783896, -0.94971696>, <-6.03575397, 1.11711438, -0.83598758>, <-6.03575397, 0.75601591, -0.99618774>,
            <-5.80356095, 1.77175192, -0.57358784>, <-5.80356095, 1.64783896, -0.94971696>, <-5.80356095, 1.11711438, -1.18598758>, <-5.80356095, 0.75601591, -1.34618774>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.83072311, 0.57336485, -0.64618774>, <-6.55166097, 0.18232049, -0.85638790>, <-6.54142677, -0.23132821, -0.85638790>, <-6.71475824, -0.53713917, -0.64618774>,
            <-6.76558601, 0.70783059, -0.69618774>, <-6.63879587, 0.36972355, -0.85638790>, <-6.61832747, -0.46773899, -0.85638790>, <-6.63711676, -0.65638781, -0.69618774>,
            <-6.03575397, 0.75601591, -0.99618774>, <-6.03575397, 0.39491744, -1.15638790>, <-6.03575397, -0.39491744, -1.15638790>, <-6.03575397, -0.75601591, -0.99618774>,
            <-5.80356095, 0.75601591, -1.34618774>, <-5.80356095, 0.39491744, -1.50638790>, <-5.80356095, -0.39491744, -1.50638790>, <-5.80356095, -0.75601591, -1.34618774>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-6.71475824, -0.53713917, -0.64618774>, <-6.88808970, -0.84295012, -0.43598758>, <-7.02189121, -1.32564338, -0.54971696>, <-7.01172614, -1.44913870, -0.32358784>,
            <-6.63711676, -0.65638781, -0.69618774>, <-6.65590605, -0.84503664, -0.53598758>, <-6.79048078, -1.35659567, -0.94971696>, <-6.78031571, -1.48009099, -0.57358784>,
            <-6.03575397, -0.75601591, -0.99618774>, <-6.03575397, -1.11711438, -0.83598758>, <-6.03575397, -1.64783896, -0.94971696>, <-6.03575397, -1.77175192, -0.57358784>,
            <-5.80356095, -0.75601591, -1.34618774>, <-5.80356095, -1.11711438, -1.18598758>, <-5.80356095, -1.64783896, -0.94971696>, <-5.80356095, -1.77175192, -0.57358784>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-7.01172614, -1.44913870, -0.32358784>, <-7.00156107, -1.57263402, -0.09745872>, <-7.00800516, -1.49434482, 0.54237615>, <-7.02412379, -1.32351971, 0.76344398>,
            <-6.78031571, -1.48009099, -0.57358784>, <-6.77015065, -1.60358631, -0.19745872>, <-6.77659474, -1.52529711, 0.59237615>, <-6.79271337, -1.32947200, 0.93844398>,
            <-6.03575397, -1.77175192, -0.57358784>, <-6.03575397, -1.89566488, -0.19745872>, <-6.03575397, -1.81711092, 0.59237615>, <-6.03575397, -1.62062356, 0.93844398>,
            <-5.80356095, -1.77175192, -0.57358784>, <-5.80356095, -1.89566488, -0.19745872>, <-5.80356095, -1.81711092, 0.59237615>, <-5.80356095, -1.62062356, 0.93844398>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-7.02412379, -1.32351971, 0.76344398>, <-7.04024243, -1.15269461, 0.98451180>, <-6.88508120, -0.50816881, 0.90969034>, <-6.53233304, 0.00000000, 1.08494186>,
            <-6.79271337, -1.32947200, 0.93844398>, <-6.80883200, -1.13364690, 1.28451180>, <-6.65289755, -0.51025532, 0.95969034>, <-6.50014002, 0.00000000, 1.13494186>,
            <-6.03575397, -1.62062356, 0.93844398>, <-6.03575397, -1.42413620, 1.28451180>, <-6.13575397, -0.78231955, 1.25969034>, <-6.13575397, 0.00000000, 1.43494186>,
            <-5.80356095, -1.62062356, 0.93844398>, <-5.80356095, -1.42413620, 1.28451180>, <-5.80356095, -0.78231955, 1.40969034>, <-5.80356095, 0.00000000, 1.58494186>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, 0.00000000, 1.58494186>, <-5.80356095, 0.78231955, 1.40969034>, <-5.80356095, 1.42413620, 1.28451180>, <-5.80356095, 1.62062356, 0.93844398>,
            <-5.47136793, 0.00000000, 1.73494186>, <-5.47136793, 0.78231955, 1.55969034>, <-5.57136793, 1.42413620, 1.28451180>, <-5.57136793, 1.62062356, 0.93844398>,
            <-4.55200000, -1.14845559, 1.73053901>, <-4.55200000, -0.85455399, 1.76193520>, <-4.65200000, 1.66642356, 1.39324080>, <-4.65200000, 1.86013613, 1.06399650>,
            <-4.11400000, -1.17212177, 1.62054997>, <-4.26400000, -0.85455399, 1.76193520>, <-4.36400000, 1.66642356, 1.39324080>, <-4.36400000, 1.86013613, 1.06399650>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, 1.62062356, 0.93844398>, <-5.80356095, 1.81711092, 0.59237615>, <-5.80356095, 1.89566488, -0.19745872>, <-5.80356095, 1.77175192, -0.57358784>,
            <-5.57136793, 1.62062356, 0.93844398>, <-5.57136793, 1.81711092, 0.59237615>, <-5.57136793, 1.89566488, -0.19745872>, <-5.57136793, 1.77175192, -0.57358784>,
            <-4.65200000, 1.86013613, 1.06399650>, <-4.65200000, 2.05384870, 0.73475219>, <-4.65200000, 2.15128290, -0.24491740>, <-4.65200000, 1.99758779, -0.66144816>,
            <-4.36400000, 1.86013613, 1.06399650>, <-4.36400000, 2.05384870, 0.73475219>, <-4.36400000, 2.15128290, -0.24491740>, <-4.36400000, 1.99758779, -0.66144816>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, 1.77175192, -0.57358784>, <-5.80356095, 1.64783896, -0.94971696>, <-5.80356095, 1.11711438, -1.18598758>, <-5.80356095, 0.75601591, -1.34618774>,
            <-5.57136793, 1.77175192, -0.57358784>, <-5.57136793, 1.64783896, -0.94971696>, <-5.57136793, 1.11711438, -1.53598758>, <-5.57136793, 0.75601591, -1.69618774>,
            <-4.65200000, 1.99758779, -0.66144816>, <-4.65200000, 1.84389268, -1.07797892>, <-4.65200000, 1.28560986, -1.60515812>, <-4.65200000, 0.88772233, -1.80386196>,
            <-4.36400000, 1.99758779, -0.66144816>, <-4.36400000, 1.84389268, -1.07797892>, <-4.36400000, 1.28560986, -1.60515812>, <-4.21400000, 0.88772233, -1.80386196>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, 0.75601591, -1.34618774>, <-5.80356095, 0.39491744, -1.50638790>, <-5.80356095, -0.39491744, -1.50638790>, <-5.80356095, -0.75601591, -1.34618774>,
            <-5.57136793, 0.75601591, -1.69618774>, <-5.57136793, 0.39491744, -1.85638790>, <-5.57136793, -0.39491744, -1.85638790>, <-5.57136793, -0.75601591, -1.69618774>,
            <-4.65200000, 0.88772233, -1.80386196>, <-4.65200000, 0.48983479, -2.00256580>, <-4.65200000, -0.88983479, -2.00256580>, <-4.55200000, -1.08839957, -2.00527521>,
            <-4.21400000, 0.88772233, -1.80386196>, <-4.06400000, 0.48983479, -2.00256580>, <-4.06400000, -0.88983479, -2.00256580>, <-4.13900000, -1.07245268, -1.98373014>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, -0.75601591, -1.34618774>, <-5.80356095, -1.11711438, -1.18598758>, <-5.80356095, -1.64783896, -0.94971696>, <-5.80356095, -1.77175192, -0.57358784>,
            <-5.57136793, -0.75601591, -1.69618774>, <-5.57136793, -1.11711438, -1.53598758>, <-5.57136793, -1.64783896, -0.94971696>, <-5.57136793, -1.77175192, -0.57358784>,
            <-4.55200000, -1.08839957, -2.00527521>, <-4.45200000, -1.28696435, -2.00798462>, <-4.65200000, -1.64389268, -1.47797892>, <-4.65200000, -1.89758779, -0.86144816>,
            <-4.13900000, -1.07245268, -1.98373014>, <-4.21400000, -1.25507058, -1.96489449>, <-4.36400000, -1.64389268, -1.47797892>, <-4.36400000, -1.89758779, -0.86144816>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, -1.77175192, -0.57358784>, <-5.80356095, -1.89566488, -0.19745872>, <-5.80356095, -1.81711092, 0.59237615>, <-5.80356095, -1.62062356, 0.93844398>,
            <-5.57136793, -1.77175192, -0.57358784>, <-5.57136793, -1.89566488, -0.19745872>, <-5.57136793, -1.81711092, 0.59237615>, <-5.57136793, -1.62062356, 0.93844398>,
            <-4.65200000, -1.89758779, -0.86144816>, <-4.65200000, -2.15128290, -0.24491740>, <-4.65200000, -2.05384870, 0.73475219>, <-4.60200000, -1.86013613, 1.06399650>,
            <-4.36400000, -1.89758779, -0.86144816>, <-4.36400000, -2.15128290, -0.24491740>, <-4.36400000, -2.05384870, 0.73475219>, <-4.31400000, -1.86013613, 1.06399650>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-5.80356095, -1.62062356, 0.93844398>, <-5.80356095, -1.42413620, 1.28451180>, <-5.80356095, -0.78231955, 1.40969034>, <-5.80356095, 0.00000000, 1.58494186>,
            <-5.57136793, -1.62062356, 0.93844398>, <-5.57136793, -1.42413620, 1.28451180>, <-5.47136793, -0.78231955, 1.55969034>, <-5.47136793, 0.00000000, 1.73494186>,
            <-4.60200000, -1.86013613, 1.06399650>, <-4.55200000, -1.66642356, 1.39324080>, <-4.55200000, -1.43397600, 1.47812359>, <-4.55200000, -1.14845559, 1.73053901>,
            <-4.31400000, -1.86013613, 1.06399650>, <-4.26400000, -1.66642356, 1.39324080>, <-4.26400000, -1.43397600, 1.47812359>, <-4.11400000, -1.17212177, 1.62054997>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.11400000, -1.17212177, 1.62054997>, <-4.26400000, -0.85455399, 1.76193520>, <-4.36400000, 1.66642356, 1.39324080>, <-4.36400000, 1.86013613, 1.06399650>,
            <-3.67600000, -1.19578796, 1.51056093>, <-3.97600000, -0.85455399, 1.76193520>, <-4.07600000, 1.66642356, 1.39324080>, <-4.07600000, 1.86013613, 1.06399650>,
            <-3.00000000, -1.39438395, 1.74741458>, <-3.40000000, -0.85455399, 1.76193520>, <-3.50000000, 1.66642356, 1.39324080>, <-3.50000000, 1.86013613, 1.06399650>,
            <-2.91200000, -1.27141977, 1.73897679>, <-3.11200000, -0.85455399, 1.76193520>, <-3.21200000, 1.66642356, 1.39324080>, <-3.21200000, 1.86013613, 1.06399650>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.36400000, 1.86013613, 1.06399650>, <-4.36400000, 2.05384870, 0.73475219>, <-4.36400000, 2.15128290, -0.24491740>, <-4.36400000, 1.99758779, -0.66144816>,
            <-4.07600000, 1.86013613, 1.06399650>, <-4.07600000, 2.05384870, 0.73475219>, <-4.07600000, 2.15128290, -0.24491740>, <-4.07600000, 1.99758779, -0.66144816>,
            <-3.50000000, 1.86013613, 1.06399650>, <-3.50000000, 2.05384870, 0.73475219>, <-3.50000000, 2.15128290, -0.24491740>, <-3.50000000, 1.99758779, -0.66144816>,
            <-3.21200000, 1.86013613, 1.06399650>, <-3.21200000, 2.05384870, 0.73475219>, <-3.21200000, 2.15128290, -0.24491740>, <-3.21200000, 1.99758779, -0.66144816>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.36400000, 1.99758779, -0.66144816>, <-4.36400000, 1.84389268, -1.07797892>, <-4.36400000, 1.28560986, -1.60515812>, <-4.21400000, 0.88772233, -1.80386196>,
            <-4.07600000, 1.99758779, -0.66144816>, <-4.07600000, 1.84389268, -1.07797892>, <-4.07600000, 1.28560986, -1.60515812>, <-3.77600000, 0.88772233, -1.80386196>,
            <-3.50000000, 1.99758779, -0.66144816>, <-3.50000000, 1.84389268, -1.07797892>, <-3.40000000, 1.28560986, -2.00515812>, <-3.35000000, 0.88772233, -2.00386196>,
            <-3.21200000, 1.99758779, -0.66144816>, <-3.21200000, 1.84389268, -1.07797892>, <-3.36200000, 1.28560986, -1.80515812>, <-3.33700000, 0.88772233, -1.90386196>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.21400000, 0.88772233, -1.80386196>, <-4.06400000, 0.48983479, -2.00256580>, <-4.06400000, -0.88983479, -2.00256580>, <-4.13900000, -1.07245268, -1.98373014>,
            <-3.77600000, 0.88772233, -1.80386196>, <-3.47600000, 0.48983479, -2.00256580>, <-3.47600000, -0.88983479, -2.00256580>, <-3.72600000, -1.05650579, -1.96218507>,
            <-3.35000000, 0.88772233, -2.00386196>, <-3.30000000, 0.48983479, -2.00256580>, <-3.30000000, -0.88983479, -2.00256580>, <-3.55000000, -1.20125090, -1.98696158>,
            <-3.33700000, 0.88772233, -1.90386196>, <-3.31200000, 0.48983479, -2.00256580>, <-3.31200000, -0.88983479, -2.00256580>, <-3.41200000, -1.14448661, -1.99541177>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.13900000, -1.07245268, -1.98373014>, <-4.21400000, -1.25507058, -1.96489449>, <-4.36400000, -1.64389268, -1.47797892>, <-4.36400000, -1.89758779, -0.86144816>,
            <-3.72600000, -1.05650579, -1.96218507>, <-3.97600000, -1.22317680, -1.92180435>, <-4.07600000, -1.64389268, -1.47797892>, <-4.07600000, -1.89758779, -0.86144816>,
            <-3.55000000, -1.20125090, -1.98696158>, <-3.80000000, -1.51266701, -1.97135735>, <-3.50000000, -1.64389268, -1.47797892>, <-3.50000000, -1.89758779, -0.86144816>,
            <-3.41200000, -1.14448661, -1.99541177>, <-3.51200000, -1.39913843, -1.98825773>, <-3.21200000, -1.64389268, -1.47797892>, <-3.21200000, -1.89758779, -0.86144816>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.36400000, -1.89758779, -0.86144816>, <-4.36400000, -2.15128290, -0.24491740>, <-4.36400000, -2.05384870, 0.73475219>, <-4.31400000, -1.86013613, 1.06399650>,
            <-4.07600000, -1.89758779, -0.86144816>, <-4.07600000, -2.15128290, -0.24491740>, <-4.07600000, -2.05384870, 0.73475219>, <-4.02600000, -1.86013613, 1.06399650>,
            <-3.50000000, -1.89758779, -0.86144816>, <-3.50000000, -2.15128290, -0.24491740>, <-3.50000000, -2.05384870, 0.73475219>, <-3.45000000, -1.86013613, 1.06399650>,
            <-3.21200000, -1.89758779, -0.86144816>, <-3.21200000, -2.15128290, -0.24491740>, <-3.21200000, -2.05384870, 0.73475219>, <-3.16200000, -1.86013613, 1.06399650>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-4.31400000, -1.86013613, 1.06399650>, <-4.26400000, -1.66642356, 1.39324080>, <-4.26400000, -1.43397600, 1.47812359>, <-4.11400000, -1.17212177, 1.62054997>,
            <-4.02600000, -1.86013613, 1.06399650>, <-3.97600000, -1.66642356, 1.39324080>, <-3.97600000, -1.43397600, 1.47812359>, <-3.67600000, -1.19578796, 1.51056093>,
            <-3.45000000, -1.86013613, 1.06399650>, <-3.40000000, -1.66642356, 1.39324080>, <-3.40000000, -1.43397600, 1.47812359>, <-3.00000000, -1.39438395, 1.74741458>,
            <-3.16200000, -1.86013613, 1.06399650>, <-3.11200000, -1.66642356, 1.39324080>, <-3.11200000, -1.43397600, 1.47812359>, <-2.91200000, -1.27141977, 1.73897679>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-2.91200000, -1.27141977, 1.73897679>, <-3.11200000, -0.85455399, 1.76193520>, <-3.21200000, 1.66642356, 1.39324080>, <-3.21200000, 1.86013613, 1.06399650>,
            <-2.82400000, -1.14845559, 1.73053901>, <-2.82400000, -0.85455399, 1.76193520>, <-2.92400000, 1.66642356, 1.39324080>, <-2.92400000, 1.86013613, 1.06399650>,
            <-2.21259260, 0.00000000, 2.03863669>, <-2.24719501, 0.83936373, 1.84207663>, <-2.24510267, 1.46088760, 1.30912196>, <-2.22830400, 1.88101945, 0.78723418>,
            <-1.95216763, 0.00000000, 2.02474736>, <-1.98708409, 0.82657801, 1.82818730>, <-1.98499175, 1.44810189, 1.29523263>, <-1.96800824, 1.86822465, 0.78028952>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.21200000, 1.86013613, 1.06399650>, <-3.21200000, 2.05384870, 0.73475219>, <-3.21200000, 2.15128290, -0.24491740>, <-3.21200000, 1.99758779, -0.66144816>,
            <-2.92400000, 1.86013613, 1.06399650>, <-2.92400000, 2.05384870, 0.73475219>, <-2.92400000, 2.15128290, -0.24491740>, <-2.92400000, 1.99758779, -0.66144816>,
            <-2.22830400, 1.88101945, 0.78723418>, <-2.21150532, 2.30115129, 0.26534641>, <-2.20717360, 2.38927531, 0.07821786>, <-2.22220937, 2.05066951, -0.38165294>,
            <-1.96800824, 1.86822465, 0.78028952>, <-1.95102472, 2.28834740, 0.26534641>, <-1.94669300, 2.37647142, 0.07821786>, <-1.96192930, 2.03787548, -0.37441979>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.21200000, 1.99758779, -0.66144816>, <-3.21200000, 1.84389268, -1.07797892>, <-3.36200000, 1.28560986, -1.80515812>, <-3.33700000, 0.88772233, -1.90386196>,
            <-2.92400000, 1.99758779, -0.66144816>, <-2.92400000, 1.84389268, -1.07797892>, <-3.32400000, 1.28560986, -1.60515812>, <-3.32400000, 0.88772233, -1.80386196>,
            <-2.22220937, 2.05066951, -0.38165294>, <-2.23724514, 1.71206371, -0.84152375>, <-2.22511914, 1.21476823, -1.49899869>, <-2.21230725, 0.82916625, -1.67865563>,
            <-1.96192930, 2.03787548, -0.37441979>, <-1.97716559, 1.69927954, -0.82705745>, <-1.96503959, 1.20198406, -1.48453238>, <-1.95207070, 0.82277417, -1.66418932>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.33700000, 0.88772233, -1.90386196>, <-3.31200000, 0.48983479, -2.00256580>, <-3.31200000, -0.88983479, -2.00256580>, <-3.41200000, -1.14448661, -1.99541177>,
            <-3.32400000, 0.88772233, -1.80386196>, <-3.32400000, 0.48983479, -2.00256580>, <-3.32400000, -0.88983479, -2.00256580>, <-3.27400000, -1.08772233, -2.00386196>,
            <-2.21230725, 0.82916625, -1.67865563>, <-2.19949536, 0.44356427, -1.85831258>, <-2.19949536, -0.44356427, -1.85831258>, <-2.20947631, -0.84914368, -1.67865563>,
            <-1.95207070, 0.82277417, -1.66418932>, <-1.93910180, 0.44356427, -1.84384627>, <-1.93910180, -0.44356427, -1.84384627>, <-1.94908275, -0.84914368, -1.66418932>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.41200000, -1.14448661, -1.99541177>, <-3.51200000, -1.39913843, -1.98825773>, <-3.21200000, -1.64389268, -1.47797892>, <-3.21200000, -1.89758779, -0.86144816>,
            <-3.27400000, -1.08772233, -2.00386196>, <-3.22400000, -1.28560986, -2.00515812>, <-2.92400000, -1.64389268, -1.47797892>, <-2.92400000, -1.89758779, -0.86144816>,
            <-2.20947631, -0.84914368, -1.67865563>, <-2.21945725, -1.25472309, -1.49899869>, <-2.15220618, -1.70980713, -0.84152375>, <-2.13746029, -1.84844407, -0.53165294>,
            <-1.94908275, -0.84914368, -1.66418932>, <-1.95906369, -1.25472309, -1.48453238>, <-1.89210046, -1.69756686, -0.82705745>, <-1.87715403, -1.83619436, -0.52441979>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.21200000, -1.89758779, -0.86144816>, <-3.21200000, -2.15128290, -0.24491740>, <-3.21200000, -2.05384870, 0.73475219>, <-3.16200000, -1.86013613, 1.06399650>,
            <-2.92400000, -1.89758779, -0.86144816>, <-2.92400000, -2.15128290, -0.24491740>, <-2.92400000, -2.05384870, 0.73475219>, <-2.87400000, -1.86013613, 1.06399650>,
            <-2.13746029, -1.84844407, -0.53165294>, <-2.12271440, -1.98708101, -0.22178214>, <-2.12686183, -1.89894812, 0.66534641>, <-2.14320013, -1.67878163, 0.98723418>,
            <-1.87715403, -1.83619436, -0.52441979>, <-1.86220760, -1.97482186, -0.22178214>, <-1.86635503, -1.88668898, 0.66534641>, <-1.88287819, -1.66653119, 0.98028952>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-3.16200000, -1.86013613, 1.06399650>, <-3.11200000, -1.66642356, 1.39324080>, <-3.11200000, -1.43397600, 1.47812359>, <-2.91200000, -1.27141977, 1.73897679>,
            <-2.87400000, -1.86013613, 1.06399650>, <-2.82400000, -1.66642356, 1.39324080>, <-2.82400000, -1.43397600, 1.47812359>, <-2.82400000, -1.14845559, 1.73053901>,
            <-2.14320013, -1.67878163, 0.98723418>, <-2.15953843, -1.45861514, 1.30912196>, <-2.22307580, -0.87868746, 1.84207663>, <-2.21259260, 0.00000000, 2.03863669>,
            <-1.88287819, -1.66653119, 0.98028952>, <-1.89940134, -1.44637340, 1.29523263>, <-1.96265083, -0.87868746, 1.82818730>, <-1.95216763, 0.00000000, 2.02474736>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.95216763, 0.00000000, 2.02474736>, <-1.98708409, 0.82657801, 1.82818730>, <-1.98499175, 1.44810189, 1.29523263>, <-1.96800824, 1.86822465, 0.78028952>,
            <-1.69174265, 0.00000000, 2.01085802>, <-1.72697317, 0.81379230, 1.81429797>, <-1.72488083, 1.43531618, 1.28134329>, <-1.70771248, 1.85542985, 0.77334485>,
            <-1.17089271, 0.00000000, 1.98307936>, <-1.20675132, 0.78822087, 1.78651931>, <-1.20465898, 1.40974475, 0.95356463>, <-0.63712096, 2.47984025, 0.60945552>,
            <-0.91046774, 0.00000000, 1.96919003>, <-0.94664040, 0.77543516, 1.77262997>, <-0.94454806, 1.39695904, 0.93967530>, <-0.22682520, 2.59204545, 0.60251085>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.96800824, 1.86822465, 0.78028952>, <-1.95102472, 2.28834740, 0.26534641>, <-1.94669300, 2.37647142, 0.07821786>, <-1.96192930, 2.03787548, -0.37441979>,
            <-1.70771248, 1.85542985, 0.77334485>, <-1.69054413, 2.27554352, 0.26534641>, <-1.68621241, 2.36366754, 0.07821786>, <-1.70164923, 2.02508145, -0.36718664>,
            <-0.63712096, 2.47984025, 0.60945552>, <-0.06958294, 3.54993575, 0.26534641>, <-0.06525122, 3.63805977, 0.07821786>, <-0.63108908, 2.64949340, -0.20272033>,
            <-0.22682520, 2.59204545, 0.60251085>, <0.49089766, 3.78713187, 0.26534641>, <0.49522938, 3.87525589, 0.07821786>, <-0.22080901, 2.76169937, -0.19548717>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.96192930, 2.03787548, -0.37441979>, <-1.97716559, 1.69927954, -0.82705745>, <-1.96503959, 1.20198406, -1.48453238>, <-1.95207070, 0.82277417, -1.66418932>,
            <-1.70164923, 2.02508145, -0.36718664>, <-1.71708605, 1.68649537, -0.81259114>, <-1.70496004, 1.18919989, -1.47006607>, <-1.69183414, 0.81638208, -1.64972302>,
            <-0.63108908, 2.64949340, -0.20272033>, <-1.19692695, 1.66092703, -0.48365852>, <-1.18480095, 1.16363155, -1.44113345>, <-1.17136104, 0.80359791, -1.62079040>,
            <-0.22080901, 2.76169937, -0.19548717>, <-0.93684741, 1.64814285, -0.46919221>, <-0.92472140, 1.15084738, -1.42666714>, <-0.91112448, 0.79720583, -1.60632409>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.95207070, 0.82277417, -1.66418932>, <-1.93910180, 0.44356427, -1.84384627>, <-1.93910180, -0.44356427, -1.84384627>, <-1.94908275, -0.84914368, -1.66418932>,
            <-1.69183414, 0.81638208, -1.64972302>, <-1.67870824, 0.44356427, -1.82937996>, <-1.67870824, -0.44356427, -1.82937996>, <-1.68868919, -0.84914368, -1.64972302>,
            <-1.17136104, 0.80359791, -1.62079040>, <-1.15792113, 0.44356427, -1.80044735>, <-1.15792113, -0.44356427, -1.80044735>, <-1.16790207, -0.84914368, -1.62079040>,
            <-0.91112448, 0.79720583, -1.60632409>, <-0.89752757, 0.44356427, -1.78598104>, <-0.89752757, -0.44356427, -1.78598104>, <-0.90750851, -0.84914368, -1.60632409>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.94908275, -0.84914368, -1.66418932>, <-1.95906369, -1.25472309, -1.48453238>, <-1.89210046, -1.69756686, -0.82705745>, <-1.87715403, -1.83619436, -0.52441979>,
            <-1.68868919, -0.84914368, -1.64972302>, <-1.69867013, -1.25472309, -1.47006607>, <-1.63199475, -1.68532659, -0.81259114>, <-1.61684777, -1.82394465, -0.51718664>,
            <-1.16790207, -0.84914368, -1.62079040>, <-1.17788301, -1.25472309, -1.44113345>, <-1.11178333, -1.66084605, -0.78365852>, <-1.09623526, -1.79944524, -0.50272033>,
            <-0.90750851, -0.84914368, -1.60632409>, <-0.91748945, -1.25472309, -1.42666714>, <-0.85167761, -1.64860578, -0.76919221>, <-0.83592900, -1.78719554, -0.49548717>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.87715403, -1.83619436, -0.52441979>, <-1.86220760, -1.97482186, -0.22178214>, <-1.86635503, -1.88668898, 0.66534641>, <-1.88287819, -1.66653119, 0.98028952>,
            <-1.61684777, -1.82394465, -0.51718664>, <-1.60170080, -1.96256272, -0.22178214>, <-1.60584823, -1.87442983, 0.66534641>, <-1.62255624, -1.65428074, 0.97334485>,
            <-1.09623526, -1.79944524, -0.50272033>, <-1.08068719, -1.93804443, -0.22178214>, <-1.08483462, -1.84991155, 0.66534641>, <-1.10191235, -1.62977985, 0.95945552>,
            <-0.83592900, -1.78719554, -0.49548717>, <-0.82018039, -1.92578529, -0.22178214>, <-0.82432782, -1.83765240, 0.66534641>, <-0.84159040, -1.61752941, 0.95251085>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.88287819, -1.66653119, 0.98028952>, <-1.89940134, -1.44637340, 1.29523263>, <-1.96265083, -0.87868746, 1.82818730>, <-1.95216763, 0.00000000, 2.02474736>,
            <-1.62255624, -1.65428074, 0.97334485>, <-1.63926425, -1.43413165, 1.28134329>, <-1.70222586, -0.87868746, 1.81429797>, <-1.69174265, 0.00000000, 2.01085802>,
            <-1.10191235, -1.62977985, 0.95945552>, <-1.11899007, -1.40964816, 1.25356463>, <-1.18137591, -0.87868746, 1.78651931>, <-1.17089271, 0.00000000, 1.98307936>,
            <-0.84159040, -1.61752941, 0.95251085>, <-0.85885298, -1.39740642, 1.23967530>, <-0.92095094, -0.87868746, 1.77262997>, <-0.91046774, 0.00000000, 1.96919003>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.91046774, 0.00000000, 1.96919003>, <-0.94664040, 0.77543516, 1.77262997>, <-0.94454806, 1.39695904, 0.93967530>, <-0.22682520, 2.59204545, 0.60251085>,
            <-0.65004276, 0.00000000, 1.95530070>, <-0.68652948, 0.76264945, 1.75874064>, <-0.68443714, 1.38417333, 0.92578597>, <0.18347056, 2.70425066, 0.59556619>,
            <-0.12919282, 0.00000000, 1.92752203>, <-0.16630763, 0.73707802, 1.73096198>, <-0.16421529, 1.35860190, 0.89800730>, <-0.14593792, 1.57866106, 0.78167685>,
            <0.21596092, 0.00000000, 1.90245817>, <0.17832997, 0.71744703, 1.70649922>, <0.18040090, 1.33676476, 1.02517439>, <0.19900770, 1.55613200, 0.84424304>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.22682520, 2.59204545, 0.60251085>, <0.49089766, 3.78713187, 0.26534641>, <0.49522938, 3.87525589, 0.07821786>, <-0.22080901, 2.76169937, -0.19548717>,
            <0.18347056, 2.70425066, 0.59556619>, <1.05137825, 4.02432798, 0.26534641>, <1.05570997, 4.11245200, 0.07821786>, <0.18947106, 2.87390534, -0.18825402>,
            <-0.14593792, 1.57866106, 0.78167685>, <-0.12766056, 1.79872022, 0.66534641>, <-0.12332883, 1.88684424, -0.22178214>, <-0.13996880, 1.74831729, -0.32378771>,
            <0.19900770, 1.55613200, 0.84424304>, <0.21761451, 1.77549925, 0.66331169>, <0.22193298, 1.86335378, -0.22110390>, <0.20495751, 1.72526946, -0.38722376>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.22080901, 2.76169937, -0.19548717>, <-0.93684741, 1.64814285, -0.46919221>, <-0.92472140, 1.15084738, -1.42666714>, <-0.91112448, 0.79720583, -1.60632409>,
            <0.18947106, 2.87390534, -0.18825402>, <-0.67676786, 1.63535868, -0.45472590>, <-0.66464185, 1.13806321, -1.41220083>, <-0.65088793, 0.79081374, -1.59185778>,
            <-0.13996880, 1.74831729, -0.32378771>, <-0.15660876, 1.60979034, -0.42579328>, <-0.14448276, 1.11249487, -1.38326821>, <-0.13041482, 0.77802957, -1.56292516>,
            <0.20495751, 1.72526946, -0.38722376>, <0.18798204, 1.58718514, -0.55334362>, <0.20008598, 1.09171590, -1.35880791>, <0.21442571, 0.76696185, -1.53791544>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.91112448, 0.79720583, -1.60632409>, <-0.89752757, 0.44356427, -1.78598104>, <-0.89752757, -0.44356427, -1.78598104>, <-0.90750851, -0.84914368, -1.60632409>,
            <-0.65088793, 0.79081374, -1.59185778>, <-0.63713401, 0.44356427, -1.77151473>, <-0.63713401, -0.44356427, -1.77151473>, <-0.64711495, -0.84914368, -1.59185778>,
            <-0.13041482, 0.77802957, -1.56292516>, <-0.11634689, 0.44356427, -1.74258211>, <-0.11634689, -0.44356427, -1.74258211>, <-0.12632783, -0.84914368, -1.56292516>,
            <0.21442571, 0.76696185, -1.53791544>, <0.22876544, 0.44220779, -1.71702297>, <0.22876544, -0.44220779, -1.71702297>, <0.21881502, -0.84654689, -1.53791544>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.90750851, -0.84914368, -1.60632409>, <-0.91748945, -1.25472309, -1.42666714>, <-0.85167761, -1.64860578, -0.76919221>, <-0.83592900, -1.78719554, -0.49548717>,
            <-0.64711495, -0.84914368, -1.59185778>, <-0.65709589, -1.25472309, -1.41220083>, <-0.59157190, -1.63636551, -0.75472590>, <-0.57562275, -1.77494583, -0.48825402>,
            <-0.12632783, -0.84914368, -1.56292516>, <-0.13630877, -1.25472309, -1.38326821>, <-0.07136048, -1.61188498, -0.72579328>, <-0.05501023, -1.75044642, -0.47378771>,
            <0.21881502, -0.84654689, -1.53791544>, <0.20886460, -1.25088598, -1.35880791>, <0.27327685, -1.59000042, -0.70334362>, <0.28996352, -1.72811994, -0.46222376>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.83592900, -1.78719554, -0.49548717>, <-0.82018039, -1.92578529, -0.22178214>, <-0.82432782, -1.83765240, 0.66534641>, <-0.84159040, -1.61752941, 0.95251085>,
            <-0.57562275, -1.77494583, -0.48825402>, <-0.55967359, -1.91352615, -0.22178214>, <-0.56382102, -1.82539326, 0.66534641>, <-0.58126845, -1.60527896, 0.94556619>,
            <-0.05501023, -1.75044642, -0.47378771>, <-0.03865999, -1.88900786, -0.22178214>, <-0.04280742, -1.80087497, 0.66534641>, <-0.06062456, -1.58077808, 0.93167685>,
            <0.28996352, -1.72811994, -0.46222376>, <0.30665020, -1.86623946, -0.22110390>, <0.30251545, -1.77837609, 0.66331169>, <0.28436742, -1.55897041, 0.91924304>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.84159040, -1.61752941, 0.95251085>, <-0.85885298, -1.39740642, 1.23967530>, <-0.92095094, -0.87868746, 1.77262997>, <-0.91046774, 0.00000000, 1.96919003>,
            <-0.58126845, -1.60527896, 0.94556619>, <-0.59871589, -1.38516467, 1.22578597>, <-0.66052597, -0.87868746, 1.75874064>, <-0.65004276, 0.00000000, 1.95530070>,
            <-0.06062456, -1.58077808, 0.93167685>, <-0.07844171, -1.36068118, 1.19800730>, <-0.13967602, -0.87868746, 1.73096198>, <-0.12919282, 0.00000000, 1.92752203>,
            <0.28436742, -1.55897041, 0.91924304>, <0.26621940, -1.33956474, 1.17517439>, <0.20550978, -0.87600032, 1.70649922>, <0.21596092, 0.00000000, 1.90245817>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.21596092, 0.00000000, 1.90245817>, <0.17832997, 0.71744703, 1.70649922>, <0.18040090, 1.33676476, 1.02517439>, <0.19900770, 1.55613200, 0.84424304>,
            <0.56111466, 0.00000000, 1.87739431>, <0.52296758, 0.69781603, 1.68203647>, <0.52501709, 1.31492762, 1.15234149>, <0.54395333, 1.53360295, 0.90680923>,
            <1.16640000, 0.00000000, 1.82000000>, <1.16640000, 0.77627838, 1.64610179>, <1.16640000, 1.41313884, 1.27459264>, <1.21640000, 1.55810890, 0.93119720>,
            <1.39680000, 0.00000000, 1.82000000>, <1.39680000, 0.77627838, 1.64610179>, <1.39680000, 1.41313884, 1.27459264>, <1.44680000, 1.55810890, 0.93119720>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.19900770, 1.55613200, 0.84424304>, <0.21761451, 1.77549925, 0.66331169>, <0.22193298, 1.86335378, -0.22110390>, <0.20495751, 1.72526946, -0.38722376>,
            <0.54395333, 1.53360295, 0.90680923>, <0.56288957, 1.75227829, 0.66127697>, <0.56719480, 1.83986332, -0.22042566>, <0.54988382, 1.70222162, -0.45065981>,
            <1.21640000, 1.55810890, 0.93119720>, <1.26640000, 1.70307896, 0.58780175>, <1.26640000, 1.78102632, -0.19593392>, <1.26640000, 1.65807023, -0.56915853>,
            <1.44680000, 1.55810890, 0.93119720>, <1.49680000, 1.70307896, 0.58780175>, <1.49680000, 1.78102632, -0.19593392>, <1.49680000, 1.65807023, -0.56915853>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.20495751, 1.72526946, -0.38722376>, <0.18798204, 1.58718514, -0.55334362>, <0.20008598, 1.09171590, -1.35880791>, <0.21442571, 0.76696185, -1.53791544>,
            <0.54988382, 1.70222162, -0.45065981>, <0.53257285, 1.56457993, -0.68089396>, <0.54465471, 1.07093694, -1.33434760>, <0.55926624, 0.75589413, -1.51290572>,
            <1.26640000, 1.65807023, -0.56915853>, <1.26640000, 1.53511414, -0.94238313>, <1.16640000, 1.10848789, -1.32412649>, <1.16640000, 0.75017786, -1.48308957>,
            <1.49680000, 1.65807023, -0.56915853>, <1.49680000, 1.53511414, -0.94238313>, <1.39680000, 1.10848789, -1.32412649>, <1.39680000, 0.75017786, -1.48308957>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.21442571, 0.76696185, -1.53791544>, <0.22876544, 0.44220779, -1.71702297>, <0.22876544, -0.44220779, -1.71702297>, <0.21881502, -0.84654689, -1.53791544>,
            <0.55926624, 0.75589413, -1.51290572>, <0.57387776, 0.44085131, -1.69146384>, <0.57387776, -0.44085131, -1.69146384>, <0.56395787, -0.84395009, -1.51290572>,
            <1.16640000, 0.75017786, -1.48308957>, <1.16640000, 0.39186783, -1.64205264>, <1.16640000, -0.39186783, -1.64205264>, <1.16640000, -0.70017786, -1.48308957>,
            <1.39680000, 0.75017786, -1.48308957>, <1.39680000, 0.39186783, -1.64205264>, <1.39680000, -0.39186783, -1.64205264>, <1.39680000, -0.70017786, -1.48308957>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.21881502, -0.84654689, -1.53791544>, <0.20886460, -1.25088598, -1.35880791>, <0.27327685, -1.59000042, -0.70334362>, <0.28996352, -1.72811994, -0.46222376>,
            <0.56395787, -0.84395009, -1.51290572>, <0.55403797, -1.24704887, -1.33434760>, <0.61791417, -1.56811587, -0.68089396>, <0.63493728, -1.70579346, -0.45065981>,
            <1.16640000, -0.70017786, -1.48308957>, <1.16640000, -1.00848789, -1.32412649>, <1.26640000, -1.43511414, -0.94238313>, <1.26640000, -1.55807023, -0.56915853>,
            <1.39680000, -0.70017786, -1.48308957>, <1.39680000, -1.00848789, -1.32412649>, <1.49680000, -1.43511414, -0.94238313>, <1.49680000, -1.55807023, -0.56915853>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.28996352, -1.72811994, -0.46222376>, <0.30665020, -1.86623946, -0.22110390>, <0.30251545, -1.77837609, 0.66331169>, <0.28436742, -1.55897041, 0.91924304>,
            <0.63493728, -1.70579346, -0.45065981>, <0.65196038, -1.84347105, -0.22042566>, <0.64783832, -1.75587721, 0.66127697>, <0.62935941, -1.53716275, 0.90680923>,
            <1.26640000, -1.55807023, -0.56915853>, <1.26640000, -1.68102632, -0.19593392>, <1.26640000, -1.60307896, 0.58780175>, <1.26640000, -1.40810890, 0.93119720>,
            <1.49680000, -1.55807023, -0.56915853>, <1.49680000, -1.68102632, -0.19593392>, <1.49680000, -1.60307896, 0.58780175>, <1.49680000, -1.40810890, 0.93119720>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.28436742, -1.55897041, 0.91924304>, <0.26621940, -1.33956474, 1.17517439>, <0.20550978, -0.87600032, 1.70649922>, <0.21596092, 0.00000000, 1.90245817>,
            <0.62935941, -1.53716275, 0.90680923>, <0.61088050, -1.31844830, 1.15234149>, <0.55069557, -0.87331318, 1.68203647>, <0.56111466, 0.00000000, 1.87739431>,
            <1.26640000, -1.40810890, 0.93119720>, <1.26640000, -1.21313884, 1.27459264>, <1.16640000, -0.67627838, 1.64610179>, <1.16640000, 0.00000000, 1.82000000>,
            <1.49680000, -1.40810890, 0.93119720>, <1.49680000, -1.21313884, 1.27459264>, <1.39680000, -0.67627838, 1.64610179>, <1.39680000, 0.00000000, 1.82000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.39680000, 0.00000000, 1.82000000>, <1.39680000, 0.77627838, 1.64610179>, <1.39680000, 1.41313884, 1.27459264>, <1.44680000, 1.55810890, 0.93119720>,
            <1.62720000, 0.00000000, 1.82000000>, <1.62720000, 0.77627838, 1.64610179>, <1.62720000, 1.41313884, 1.27459264>, <1.67720000, 1.55810890, 0.93119720>,
            <3.97171573, 0.00000000, 1.59705627>, <3.97171573, 0.68613963, 1.44335052>, <3.97171573, 1.24905007, 1.12659138>, <3.97171573, 1.42138089, 0.82306982>,
            <5.04065786, 0.00000000, 1.51852814>, <5.04065786, 0.63417421, 1.37646343>, <5.04065786, 1.15445210, 1.04126793>, <5.04065786, 1.31373128, 0.76073386>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.44680000, 1.55810890, 0.93119720>, <1.49680000, 1.70307896, 0.58780175>, <1.49680000, 1.78102632, -0.19593392>, <1.49680000, 1.65807023, -0.56915853>,
            <1.67720000, 1.55810890, 0.93119720>, <1.72720000, 1.70307896, 0.58780175>, <1.72720000, 1.78102632, -0.19593392>, <1.72720000, 1.65807023, -0.56915853>,
            <3.97171573, 1.42138089, 0.82306982>, <3.97171573, 1.59371170, 0.51954826>, <3.97171573, 1.66260808, -0.17318275>, <3.97171573, 1.55392923, -0.50306982>,
            <5.04065786, 1.31373128, 0.76073386>, <5.04065786, 1.47301046, 0.48019979>, <5.04065786, 1.53668891, -0.16006660>, <5.04065786, 1.43624095, -0.46496936>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.49680000, 1.65807023, -0.56915853>, <1.49680000, 1.53511414, -0.94238313>, <1.39680000, 1.10848789, -1.32412649>, <1.39680000, 0.75017786, -1.48308957>,
            <1.72720000, 1.65807023, -0.56915853>, <1.72720000, 1.53511414, -0.94238313>, <1.62720000, 1.10848789, -1.32412649>, <1.62720000, 0.75017786, -1.48308957>,
            <3.97171573, 1.55392923, -0.50306982>, <3.97171573, 1.44525037, -0.83295688>, <3.97171573, 0.97977413, -1.14715022>, <3.97171573, 0.66306982, -1.28765506>,
            <5.04065786, 1.43624095, -0.46496936>, <5.04065786, 1.33579299, -0.76987212>, <5.04065786, 0.90557002, -1.14512255>, <5.04065786, 0.61285161, -1.27498612>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.39680000, 0.75017786, -1.48308957>, <1.39680000, 0.39186783, -1.64205264>, <1.39680000, -0.39186783, -1.64205264>, <1.39680000, -0.70017786, -1.48308957>,
            <1.62720000, 0.75017786, -1.48308957>, <1.62720000, 0.39186783, -1.64205264>, <1.62720000, -0.39186783, -1.64205264>, <1.62720000, -0.70017786, -1.48308957>,
            <3.97171573, 0.66306982, -1.28765506>, <3.97171573, 0.34636550, -1.42815989>, <3.97171573, -0.34636550, -1.42815989>, <3.97171573, -0.66306982, -1.28765506>,
            <5.04065786, 0.61285161, -1.27498612>, <5.04065786, 0.32013319, -1.40484969>, <5.04065786, -0.32013319, -1.40484969>, <5.04065786, -0.61285161, -1.27498612>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.39680000, -0.70017786, -1.48308957>, <1.39680000, -1.00848789, -1.32412649>, <1.49680000, -1.43511414, -0.94238313>, <1.49680000, -1.55807023, -0.56915853>,
            <1.62720000, -0.70017786, -1.48308957>, <1.62720000, -1.00848789, -1.32412649>, <1.72720000, -1.43511414, -0.94238313>, <1.72720000, -1.55807023, -0.56915853>,
            <3.97171573, -0.66306982, -1.28765506>, <3.97171573, -0.97977413, -1.14715022>, <3.97171573, -1.44525037, -0.83295688>, <3.97171573, -1.55392923, -0.50306982>,
            <5.04065786, -0.61285161, -1.27498612>, <5.04065786, -0.90557002, -1.14512255>, <5.04065786, -1.33579299, -0.76987212>, <5.04065786, -1.43624095, -0.46496936>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.49680000, -1.55807023, -0.56915853>, <1.49680000, -1.68102632, -0.19593392>, <1.49680000, -1.60307896, 0.58780175>, <1.49680000, -1.40810890, 0.93119720>,
            <1.72720000, -1.55807023, -0.56915853>, <1.72720000, -1.68102632, -0.19593392>, <1.72720000, -1.60307896, 0.58780175>, <1.72720000, -1.40810890, 0.93119720>,
            <3.97171573, -1.55392923, -0.50306982>, <3.97171573, -1.66260808, -0.17318275>, <3.97171573, -1.59371170, 0.51954826>, <3.97171573, -1.42138089, 0.82306982>,
            <5.04065786, -1.43624095, -0.46496936>, <5.04065786, -1.53668891, -0.16006660>, <5.04065786, -1.47301046, 0.48019979>, <5.04065786, -1.31373128, 0.76073386>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.49680000, -1.40810890, 0.93119720>, <1.49680000, -1.21313884, 1.27459264>, <1.39680000, -0.67627838, 1.64610179>, <1.39680000, 0.00000000, 1.82000000>,
            <1.72720000, -1.40810890, 0.93119720>, <1.72720000, -1.21313884, 1.27459264>, <1.62720000, -0.67627838, 1.64610179>, <1.62720000, 0.00000000, 1.82000000>,
            <3.97171573, -1.42138089, 0.82306982>, <3.97171573, -1.24905007, 1.12659138>, <3.97171573, -0.68613963, 1.44335052>, <3.97171573, 0.00000000, 1.59705627>,
            <5.04065786, -1.31373128, 0.76073386>, <5.04065786, -1.15445210, 1.04126793>, <5.04065786, -0.63417421, 1.37646343>, <5.04065786, 0.00000000, 1.51852814>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, 0.00000000, 1.51852814>, <5.04065786, 0.63417421, 1.37646343>, <5.04065786, 1.15445210, 1.04126793>, <5.04065786, 1.31373128, 0.76073386>,
            <6.10960000, 0.00000000, 1.44000000>, <6.10960000, 0.58220878, 1.30957634>, <6.10960000, 1.05985413, 0.95594448>, <6.10960000, 1.20608168, 0.69839790>,
            <8.51632960, 0.00000000, 1.12472000>, <7.61632960, 0.49516857, 1.11379468>, <7.61632960, 0.90140594, 0.81303078>, <7.61632960, 1.02577247, 0.59398741>,
            <8.64640026, -0.01416922, 1.09047006>, <8.15112333, 0.44693612, 1.03717542>, <8.15112333, 0.82522794, 0.75710143>, <8.15112333, 0.94103914, 0.55312631>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, 1.31373128, 0.76073386>, <5.04065786, 1.47301046, 0.48019979>, <5.04065786, 1.53668891, -0.16006660>, <5.04065786, 1.43624095, -0.46496936>,
            <6.10960000, 1.20608168, 0.69839790>, <6.10960000, 1.35230922, 0.44085131>, <6.10960000, 1.41076974, -0.14695044>, <6.10960000, 1.31855267, -0.42686889>,
            <7.61632960, 1.02577247, 0.59398741>, <7.61632960, 1.15013899, 0.37494404>, <7.61632960, 1.19985966, -0.12498135>, <7.61632960, 1.12142905, -0.36305199>,
            <8.15112333, 0.94103914, 0.55312631>, <8.15112333, 1.05685035, 0.34915120>, <8.15112333, 1.10315067, -0.11638373>, <8.15112333, 1.03011539, -0.33807722>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, 1.43624095, -0.46496936>, <5.04065786, 1.33579299, -0.76987212>, <5.04065786, 0.90557002, -1.14512255>, <5.04065786, 0.61285161, -1.27498612>,
            <6.10960000, 1.31855267, -0.42686889>, <6.10960000, 1.22633561, -0.70678735>, <6.10960000, 0.83136592, -1.14309487>, <6.10960000, 0.56263340, -1.26231718>,
            <7.61632960, 1.12142905, -0.36305199>, <7.61632960, 1.04299843, -0.60112264>, <7.61632960, 0.70707671, -0.97220219>, <8.06632960, 0.47851970, -1.07360076>,
            <8.15112333, 1.03011539, -0.33807722>, <8.15112333, 0.95708011, -0.55977070>, <8.15112333, 0.64426684, -0.90532325>, <8.39876180, 0.43143254, -0.99974649>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, 0.61285161, -1.27498612>, <5.04065786, 0.32013319, -1.40484969>, <5.04065786, -0.32013319, -1.40484969>, <5.04065786, -0.61285161, -1.27498612>,
            <6.10960000, 0.56263340, -1.26231718>, <6.10960000, 0.29390088, -1.38153948>, <6.10960000, -0.29390088, -1.38153948>, <6.10960000, -0.56263340, -1.26231718>,
            <8.06632960, 0.47851970, -1.07360076>, <8.51632960, 0.24996270, -1.17499933>, <7.61632960, -0.24996270, -1.17499933>, <7.61632960, -0.47851970, -1.07360076>,
            <8.39876180, 0.43143254, -0.99974649>, <8.64640026, 0.21859824, -1.09416973>, <8.15112333, -0.24693669, -1.09416973>, <8.15112333, -0.45977099, -0.99974649>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, -0.61285161, -1.27498612>, <5.04065786, -0.90557002, -1.14512255>, <5.04065786, -1.33579299, -0.76987212>, <5.04065786, -1.43624095, -0.46496936>,
            <6.10960000, -0.56263340, -1.26231718>, <6.10960000, -0.83136592, -1.14309487>, <6.10960000, -1.22633561, -0.70678735>, <6.10960000, -1.31855267, -0.42686889>,
            <7.61632960, -0.47851970, -1.07360076>, <7.61632960, -0.70707671, -0.97220219>, <7.61632960, -1.04299843, -0.60112264>, <7.61632960, -1.12142905, -0.36305199>,
            <8.15112333, -0.45977099, -0.99974649>, <8.15112333, -0.67260529, -0.90532325>, <8.15112333, -0.98541856, -0.55977070>, <8.15112333, -1.05845384, -0.33807722>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, -1.43624095, -0.46496936>, <5.04065786, -1.53668891, -0.16006660>, <5.04065786, -1.47301046, 0.48019979>, <5.04065786, -1.31373128, 0.76073386>,
            <6.10960000, -1.31855267, -0.42686889>, <6.10960000, -1.41076974, -0.14695044>, <6.10960000, -1.35230922, 0.44085131>, <6.10960000, -1.20608168, 0.69839790>,
            <7.61632960, -1.12142905, -0.36305199>, <7.61632960, -1.19985966, -0.12498135>, <7.61632960, -1.15013899, 0.37494404>, <7.61632960, -1.02577247, 0.59398741>,
            <8.15112333, -1.05845384, -0.33807722>, <8.15112333, -1.13148912, -0.11638373>, <8.15112333, -1.08518879, 0.34915120>, <8.15112333, -0.96937759, 0.55312631>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.04065786, -1.31373128, 0.76073386>, <5.04065786, -1.15445210, 1.04126793>, <5.04065786, -0.63417421, 1.37646343>, <5.04065786, 0.00000000, 1.51852814>,
            <6.10960000, -1.20608168, 0.69839790>, <6.10960000, -1.05985413, 0.95594448>, <6.10960000, -0.58220878, 1.30957634>, <6.10960000, 0.00000000, 1.44000000>,
            <7.61632960, -1.02577247, 0.59398741>, <7.61632960, -0.90140594, 0.81303078>, <7.61632960, -0.49516857, 1.11379468>, <7.61632960, 0.00000000, 1.22472000>,
            <8.15112333, -0.96937759, 0.55312631>, <8.15112333, -0.85356638, 0.75710143>, <8.15112333, -0.47527456, 1.03717542>, <8.15112333, -0.01416922, 1.14047006>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.64640026, -0.01416922, 1.09047006>, <8.15112333, 0.44693612, 1.03717542>, <8.15112333, 0.82522794, 0.75710143>, <8.15112333, 0.94103914, 0.55312631>,
            <8.77647092, -0.02833845, 1.05622012>, <8.68591707, 0.39870366, 0.96055617>, <8.68591707, 0.74904993, 0.70117208>, <8.68591707, 0.85630582, 0.51226522>,
            <10.12898258, 0.00000000, 0.44600000>, <10.12898258, 0.22075416, 0.49654770>, <10.12898258, 0.40186136, 0.36246228>, <10.12898258, 0.45730597, 0.26480920>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.15112333, 0.94103914, 0.55312631>, <8.15112333, 1.05685035, 0.34915120>, <8.15112333, 1.10315067, -0.11638373>, <8.15112333, 1.03011539, -0.33807722>,
            <8.68591707, 0.85630582, 0.51226522>, <8.68591707, 0.96356170, 0.32335835>, <8.68591707, 1.00644168, -0.10778612>, <8.68591707, 0.93880174, -0.31310244>,
            <10.12898258, 0.45730597, 0.26480920>, <10.12898258, 0.51275058, 0.16715612>, <10.12898258, 0.53491686, -0.05571871>, <10.12898258, 0.49995122, -0.16185446>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.15112333, 1.03011539, -0.33807722>, <8.15112333, 0.95708011, -0.55977070>, <8.15112333, 0.64426684, -0.90532325>, <8.39876180, 0.43143254, -0.99974649>,
            <8.68591707, 0.93880174, -0.31310244>, <8.68591707, 0.87116179, -0.51841876>, <8.68591707, 0.58145698, -0.83844431>, <8.73119399, 0.38434538, -0.92589222>,
            <10.12898258, 0.49995122, -0.16185446>, <10.12898258, 0.46498558, -0.26799020>, <10.12898258, 0.31522624, -0.43342347>, <10.17898258, 0.21333183, -0.42862860>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.39876180, 0.43143254, -0.99974649>, <8.64640026, 0.21859824, -1.09416973>, <8.15112333, -0.24693669, -1.09416973>, <8.15112333, -0.45977099, -0.99974649>,
            <8.73119399, 0.38434538, -0.92589222>, <8.77647092, 0.18723379, -1.01334014>, <8.68591707, -0.24391068, -1.01334014>, <8.68591707, -0.44102228, -0.92589222>,
            <10.17898258, 0.21333183, -0.42862860>, <10.22898258, 0.11143742, -0.42383372>, <10.22898258, -0.11143742, -0.42383372>, <10.17898258, -0.21333183, -0.42862860>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.15112333, -0.45977099, -0.99974649>, <8.15112333, -0.67260529, -0.90532325>, <8.15112333, -0.98541856, -0.55977070>, <8.15112333, -1.05845384, -0.33807722>,
            <8.68591707, -0.44102228, -0.92589222>, <8.68591707, -0.63813387, -0.83844431>, <8.68591707, -0.92783868, -0.51841876>, <8.68591707, -0.99547863, -0.31310244>,
            <10.17898258, -0.21333183, -0.42862860>, <10.12898258, -0.31522624, -0.43342347>, <10.12898258, -0.46498558, -0.26799020>, <10.12898258, -0.49995122, -0.16185446>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.15112333, -1.05845384, -0.33807722>, <8.15112333, -1.13148912, -0.11638373>, <8.15112333, -1.08518879, 0.34915120>, <8.15112333, -0.96937759, 0.55312631>,
            <8.68591707, -0.99547863, -0.31310244>, <8.68591707, -1.06311858, -0.10778612>, <8.68591707, -1.02023859, 0.32335835>, <8.68591707, -0.91298271, 0.51226522>,
            <10.12898258, -0.49995122, -0.16185446>, <10.12898258, -0.53491686, -0.05571871>, <10.12898258, -0.51275058, 0.16715612>, <10.12898258, -0.45730597, 0.26480920>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.15112333, -0.96937759, 0.55312631>, <8.15112333, -0.85356638, 0.75710143>, <8.15112333, -0.47527456, 1.03717542>, <8.15112333, -0.01416922, 1.14047006>,
            <8.68591707, -0.91298271, 0.51226522>, <8.68591707, -0.80572682, 0.70117208>, <8.68591707, -0.45538055, 0.96055617>, <8.68591707, -0.02833845, 1.05622012>,
            <10.12898258, -0.45730597, 0.26480920>, <10.12898258, -0.40186136, 0.36246228>, <10.12898258, -0.22075416, 0.49654770>, <10.12898258, 0.00000000, 0.54600000>,
            <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>, <10.70000000, 0.00000000, 0.00000000>
        }
    }
    
    texture { Dolphin_Skin }
}

union {  // Layer name: dolphin2
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <19.24683854, 13.12114891, 14.64439406>, <17.73066049, 13.21954208, 14.13560151>, <16.93696571, 13.31858303, 12.15852873>, <16.49126281, 13.35359398, 11.78989819>,
            <19.24905711, 13.16107193, 14.64550334>, <17.73287907, 13.25946509, 14.13671080>, <16.93918428, 13.35850605, 12.15963802>, <16.49348139, 13.39351700, 11.79100748>,
            <19.20836075, 13.12358323, 14.63373882>, <17.88501835, 13.33011547, 13.45329133>, <17.29727864, 13.39708278, 12.21863182>, <16.85434896, 13.48199750, 11.85138790>,
            <19.24683854, 13.12114891, 14.64439406>, <18.37238978, 13.25640967, 13.32824514>, <17.82030140, 13.37270459, 12.04995197>, <17.62235073, 13.41787035, 11.72182715>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.49126281, 13.35359398, 11.78989819>, <16.04555992, 13.38860492, 11.42126765>, <16.31625967, 13.41978448, 9.75772260>, <16.88923392, 13.39079806, 9.65498908>,
            <16.49348139, 13.39351700, 11.79100748>, <16.04777850, 13.42852794, 11.42237694>, <16.31847825, 13.45970750, 9.75883189>, <16.89145250, 13.43072108, 9.65609837>,
            <16.85434896, 13.48199750, 11.85138790>, <16.41141929, 13.56691222, 11.48414397>, <16.68211904, 13.59809178, 9.82059892>, <17.25232007, 13.51920159, 9.71647879>,
            <17.62235073, 13.41787035, 11.72182715>, <17.42440007, 13.46303610, 11.39370233>, <17.60677829, 13.48404267, 10.27292410>, <17.91539298, 13.44730597, 10.07636118>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.88923392, 13.39079806, 9.65498908>, <17.46220817, 13.36181164, 9.55225556>, <18.54316491, 13.36229039, 7.37311212>, <20.44893535, 13.25747553, 7.33383507>,
            <16.89145250, 13.43072108, 9.65609837>, <17.46442674, 13.40173466, 9.55336485>, <18.54538349, 13.40221341, 7.37422141>, <20.45115392, 13.29739855, 7.33494435>,
            <17.25232007, 13.51920159, 9.71647879>, <17.82252110, 13.44031139, 9.61235866>, <18.75277968, 13.43081805, 8.09350480>, <20.40911958, 13.25977344, 7.33076522>,
            <17.91539298, 13.44730597, 10.07636118>, <18.22400767, 13.41056926, 9.87979826>, <19.16452243, 13.34863290, 8.42488601>, <20.44893535, 13.25747553, 7.33383507>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <19.24683854, 13.12114891, 14.64439406>, <18.37238978, 13.25640967, 13.32824514>, <17.82030140, 13.37270459, 12.04995197>, <17.62235073, 13.41787035, 11.72182715>,
            <19.28531632, 13.11871458, 14.65504929>, <18.85976120, 13.18270387, 13.20319895>, <18.34332416, 13.34832641, 11.88127211>, <18.39035251, 13.35374320, 11.59226640>,
            <19.24905711, 13.16107193, 14.64550334>, <19.20827984, 13.20071797, 13.30020537>, <18.80717201, 13.28008153, 11.24614392>, <18.67426406, 13.29067730, 11.13062052>,
            <19.24683854, 13.12114891, 14.64439406>, <19.20606127, 13.16079495, 13.29909609>, <18.80495343, 13.24015851, 11.24503463>, <18.67204549, 13.25075428, 11.12951123>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <17.62235073, 13.41787035, 11.72182715>, <17.42440007, 13.46303610, 11.39370233>, <17.60677829, 13.48404267, 10.27292410>, <17.91539298, 13.44730597, 10.07636118>,
            <18.39035251, 13.35374320, 11.59226640>, <18.43738085, 13.35915998, 11.30326069>, <18.53143754, 13.36999356, 10.72524928>, <18.57846589, 13.37541035, 10.43624357>,
            <18.67426406, 13.29067730, 11.13062052>, <18.54135612, 13.30127306, 11.01509711>, <18.55512051, 13.30285846, 10.93051008>, <18.71785131, 13.29569773, 10.86276157>,
            <18.67204549, 13.25075428, 11.12951123>, <18.53913754, 13.26135004, 11.01398783>, <18.55290194, 13.26293544, 10.92940079>, <18.71563273, 13.25577471, 10.86165228>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <17.91539298, 13.44730597, 10.07636118>, <18.22400767, 13.41056926, 9.87979826>, <19.16452243, 13.34863290, 8.42488601>, <20.44893535, 13.25747553, 7.33383507>,
            <18.57846589, 13.37541035, 10.43624357>, <18.62549424, 13.38082713, 10.14723786>, <19.57626518, 13.26644775, 8.75626721>, <20.48875112, 13.25517762, 7.33690492>,
            <18.71785131, 13.29569773, 10.86276157>, <18.88058211, 13.28853700, 10.79501306>, <19.93682570, 13.28568955, 8.78500515>, <20.45115392, 13.29739855, 7.33494435>,
            <18.71563273, 13.25577471, 10.86165228>, <18.87836353, 13.24861399, 10.79390377>, <19.93460712, 13.24576653, 8.78389586>, <20.44893535, 13.25747553, 7.33383507>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <19.24683854, 13.12114891, 14.64439406>, <19.20606127, 13.16079495, 13.29909609>, <18.80495343, 13.24015851, 11.24503463>, <18.67204549, 13.25075428, 11.12951123>,
            <19.24461996, 13.08122589, 14.64328477>, <19.20384269, 13.12087194, 13.29798680>, <18.80273485, 13.20023549, 11.24392535>, <18.66982691, 13.21083126, 11.12840194>,
            <19.28531632, 13.11871458, 14.65504929>, <18.85976120, 13.18270387, 13.20319895>, <18.23368504, 13.15463015, 11.85980070>, <18.28071338, 13.16004693, 11.57079500>,
            <19.24683854, 13.12114891, 14.64439406>, <18.36684334, 13.15660213, 13.32547192>, <17.75716218, 13.12614515, 12.03505644>, <17.55782491, 13.14635901, 11.70623831>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <18.67204549, 13.25075428, 11.12951123>, <18.53913754, 13.26135004, 11.01398783>, <18.55290194, 13.26293544, 10.92940079>, <18.71563273, 13.25577471, 10.86165228>,
            <18.66982691, 13.21083126, 11.12840194>, <18.53691897, 13.22142702, 11.01287854>, <18.55068336, 13.22301243, 10.92829150>, <18.71341416, 13.21585170, 10.86054299>,
            <18.28071338, 13.16004693, 11.57079500>, <18.32774173, 13.16546372, 11.28178929>, <18.42179842, 13.17629730, 10.70377787>, <18.46882677, 13.18171409, 10.41477216>,
            <17.55782491, 13.14635901, 11.70623831>, <17.35848763, 13.16657288, 11.37742019>, <17.54086585, 13.18757945, 10.25664196>, <17.85086715, 13.17579463, 10.06077234>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <18.71563273, 13.25577471, 10.86165228>, <18.87836353, 13.24861399, 10.79390377>, <19.93460712, 13.24576653, 8.78389586>, <20.44893535, 13.25747553, 7.33383507>,
            <18.71341416, 13.21585170, 10.86054299>, <18.87614496, 13.20869097, 10.79279449>, <19.93238855, 13.20584351, 8.78278657>, <20.44671677, 13.21755251, 7.33272578>,
            <18.46882677, 13.18171409, 10.41477216>, <18.51585511, 13.18713087, 10.12576646>, <19.57626518, 13.26644775, 8.75626721>, <20.48875112, 13.25517762, 7.33690492>,
            <17.85086715, 13.17579463, 10.06077234>, <18.16086845, 13.16400981, 9.86490273>, <19.15897599, 13.24882535, 8.42211279>, <20.44893535, 13.25747553, 7.33383507>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <19.24683854, 13.12114891, 14.64439406>, <19.24461996, 13.08122589, 14.64328477>, <19.20836075, 13.12358323, 14.63373882>, <19.24683854, 13.12114891, 14.64439406>,
            <17.73066049, 13.21954208, 14.13560151>, <17.72844192, 13.17961906, 14.13449222>, <17.87392548, 13.13050038, 13.44774490>, <18.36684334, 13.15660213, 13.32547192>,
            <16.93696571, 13.31858303, 12.15852873>, <16.93474713, 13.27866001, 12.15741944>, <17.28063932, 13.09766014, 12.21031217>, <17.75716218, 13.12614515, 12.03505644>,
            <16.49126281, 13.35359398, 11.78989819>, <16.48904424, 13.31367096, 11.78878890>, <16.83493643, 13.13267109, 11.84168163>, <17.55782491, 13.14635901, 11.70623831>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.49126281, 13.35359398, 11.78989819>, <16.48904424, 13.31367096, 11.78878890>, <16.83493643, 13.13267109, 11.84168163>, <17.55782491, 13.14635901, 11.70623831>,
            <16.04555992, 13.38860492, 11.42126765>, <16.04334135, 13.34868190, 11.42015837>, <16.38923354, 13.16768204, 11.47305109>, <17.35848763, 13.16657288, 11.37742019>,
            <16.31625967, 13.41978448, 9.75772260>, <16.31404110, 13.37986146, 9.75661332>, <16.65993329, 13.19886160, 9.80950604>, <17.54086585, 13.18757945, 10.25664196>,
            <16.88923392, 13.39079806, 9.65498908>, <16.88701535, 13.35087504, 9.65387980>, <17.23290754, 13.16987518, 9.70677252>, <17.85086715, 13.17579463, 10.06077234>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.88923392, 13.39079806, 9.65498908>, <16.88701535, 13.35087504, 9.65387980>, <17.23290754, 13.16987518, 9.70677252>, <17.85086715, 13.17579463, 10.06077234>,
            <17.46220817, 13.36181164, 9.55225556>, <17.45998959, 13.32188862, 9.55114628>, <17.80588178, 13.14088875, 9.60403900>, <18.16086845, 13.16400981, 9.86490273>,
            <18.54316491, 13.36229039, 7.37311212>, <18.54094634, 13.32236737, 7.37200283>, <18.74168680, 13.23120296, 8.08795836>, <19.15897599, 13.24882535, 8.42211279>,
            <20.44893535, 13.25747553, 7.33383507>, <20.44671677, 13.21755251, 7.33272578>, <20.40911958, 13.25977344, 7.33076522>, <20.44893535, 13.25747553, 7.33383507>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.49081493, 12.25063901, 6.55799660>, <5.80365563, 11.77825486, 5.16462510>, <5.61041315, 11.54325461, 4.60343669>, <5.60922842, 11.49583489, 4.61924704>,
            <5.49081493, 12.25063901, 6.55799660>, <6.74383702, 11.28698062, 3.76160585>, <6.50001603, 11.15261104, 3.49844728>, <6.49883130, 11.10519133, 3.51425763>,
            <5.49081493, 12.25063901, 6.55799660>, <7.07743212, 11.24605960, 3.66386965>, <7.10655257, 11.07820919, 3.32074510>, <7.10536785, 11.03078947, 3.33655545>,
            <5.49081493, 12.25063901, 6.55799660>, <7.23577621, 11.25068252, 3.68960042>, <8.33421807, 11.09183543, 3.45360763>, <8.33303334, 11.04441572, 3.46941798>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.60922842, 11.49583489, 4.61924704>, <5.60804369, 11.44841518, 4.63505738>, <5.79891672, 11.58857600, 5.22786650>, <5.48607601, 12.06096015, 6.62123800>,
            <6.49883130, 11.10519133, 3.51425763>, <6.49764657, 11.05777161, 3.53006798>, <6.73909810, 11.09730177, 3.82484725>, <5.48607601, 12.06096015, 6.62123800>,
            <7.10536785, 11.03078947, 3.33655545>, <7.10418312, 10.98336976, 3.35236580>, <7.07269320, 11.05638075, 3.72711104>, <5.48607601, 12.06096015, 6.62123800>,
            <8.33303334, 11.04441572, 3.46941798>, <8.33184861, 10.99699600, 3.48522833>, <7.23103730, 11.06100367, 3.75284181>, <5.48607601, 12.06096015, 6.62123800>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.49081493, 12.25063901, 6.55799660>, <7.23577621, 11.25068252, 3.68960042>, <8.33421807, 11.09183543, 3.45360763>, <8.33303334, 11.04441572, 3.46941798>,
            <5.49081493, 12.25063901, 6.55799660>, <7.39412031, 11.25530545, 3.71533118>, <9.56188356, 11.10546168, 3.58647016>, <9.56069883, 11.05804196, 3.60228051>,
            <5.49081493, 12.25063901, 6.55799660>, <7.27623353, 11.36243303, 4.02780345>, <7.43002309, 11.32004959, 4.07033181>, <7.42883836, 11.27262988, 4.08614216>,
            <5.49081493, 12.25063901, 6.55799660>, <6.44443738, 11.92252200, 5.64533927>, <6.89028973, 11.86718572, 5.67090376>, <6.88910500, 11.81976601, 5.68671411>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.33303334, 11.04441572, 3.46941798>, <8.33184861, 10.99699600, 3.48522833>, <7.23103730, 11.06100367, 3.75284181>, <5.48607601, 12.06096015, 6.62123800>,
            <9.56069883, 11.05804196, 3.60228051>, <9.55951411, 11.01062225, 3.61809086>, <7.38938140, 11.06562659, 3.77857258>, <5.48607601, 12.06096015, 6.62123800>,
            <7.42883836, 11.27262988, 4.08614216>, <7.42765363, 11.22521016, 4.10195251>, <7.27149462, 11.17275417, 4.09104484>, <5.48607601, 12.06096015, 6.62123800>,
            <6.88910500, 11.81976601, 5.68671411>, <6.88792027, 11.77234629, 5.70252446>, <6.43969846, 11.73284314, 5.70858066>, <5.48607601, 12.06096015, 6.62123800>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.49081493, 12.25063901, 6.55799660>, <6.44443738, 11.92252200, 5.64533927>, <6.89028973, 11.86718572, 5.67090376>, <6.88910500, 11.81976601, 5.68671411>,
            <5.49081493, 12.25063901, 6.55799660>, <5.61264122, 12.48261096, 7.26287509>, <6.35055637, 12.41432185, 7.27147572>, <6.34937164, 12.36690214, 7.28728607>,
            <5.49081493, 12.25063901, 6.55799660>, <5.50593833, 12.44877990, 7.15341051>, <5.35014408, 12.75204921, 7.26070541>, <5.34066625, 12.37269149, 7.38718820>,
            <5.49081493, 12.25063901, 6.55799660>, <5.23752199, 12.41073917, 7.01920215>, <4.77338170, 12.67030882, 6.97232389>, <4.76390387, 12.29095111, 7.09880668>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.88910500, 11.81976601, 5.68671411>, <6.88792027, 11.77234629, 5.70252446>, <6.43969846, 11.73284314, 5.70858066>, <5.48607601, 12.06096015, 6.62123800>,
            <6.34937164, 12.36690214, 7.28728607>, <6.34818691, 12.31948242, 7.30309642>, <5.60790231, 12.29293211, 7.32611649>, <5.48607601, 12.06096015, 6.62123800>,
            <5.34066625, 12.37269149, 7.38718820>, <5.33118842, 11.99333378, 7.51367099>, <5.50119941, 12.25910104, 7.21665190>, <5.48607601, 12.06096015, 6.62123800>,
            <4.76390387, 12.29095111, 7.09880668>, <4.75442604, 11.91159340, 7.22528947>, <5.23278307, 12.22106032, 7.08244355>, <5.48607601, 12.06096015, 6.62123800>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.49081493, 12.25063901, 6.55799660>, <5.49081493, 12.25063901, 6.55799660>, <5.49081493, 12.25063901, 6.55799660>, <5.49081493, 12.25063901, 6.55799660>,
            <5.80365563, 11.77825486, 5.16462510>, <4.86347424, 12.26952910, 6.56764435>, <4.96910565, 12.37269845, 6.88499380>, <5.23752199, 12.41073917, 7.01920215>,
            <5.61041315, 11.54325461, 4.60343669>, <4.72081026, 11.93389817, 5.70842609>, <4.19661932, 12.58856844, 6.68394237>, <4.77338170, 12.67030882, 6.97232389>,
            <5.60922842, 11.49583489, 4.61924704>, <4.71962554, 11.88647846, 5.72423644>, <4.18714149, 12.20921073, 6.81042516>, <4.76390387, 12.29095111, 7.09880668>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.60922842, 11.49583489, 4.61924704>, <4.71962554, 11.88647846, 5.72423644>, <4.18714149, 12.20921073, 6.81042516>, <4.76390387, 12.29095111, 7.09880668>,
            <5.60804369, 11.44841518, 4.63505738>, <4.71844081, 11.83905874, 5.74004679>, <4.17766366, 11.82985301, 6.93690795>, <4.75442604, 11.91159340, 7.22528947>,
            <5.79891672, 11.58857600, 5.22786650>, <4.85873533, 12.07985024, 6.63088574>, <4.96436673, 12.18301959, 6.94823520>, <5.23278307, 12.22106032, 7.08244355>,
            <5.48607601, 12.06096015, 6.62123800>, <5.48607601, 12.06096015, 6.62123800>, <5.48607601, 12.06096015, 6.62123800>, <5.48607601, 12.06096015, 6.62123800>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.78382541, 12.23806358, 9.75014396>, <2.85683263, 11.76567943, 10.83643942>, <2.29193641, 11.53067918, 11.01855849>, <2.30387385, 11.48325946, 11.00812449>,
            <3.78382541, 12.23806358, 9.75014396>, <2.29852606, 11.27440520, 12.43039608>, <1.94170662, 11.14003561, 12.39323443>, <1.95364406, 11.09261590, 12.38280044>,
            <3.78382541, 12.23806358, 9.75014396>, <2.42049416, 11.23348418, 12.75591388>, <2.16346679, 11.06563376, 12.98508498>, <2.17540424, 11.01821404, 12.97465099>,
            <3.78382541, 12.23806358, 9.75014396>, <2.53608523, 11.23810710, 12.86715070>, <3.00635612, 11.07926000, 13.88749986>, <3.01829356, 11.03184029, 13.87706586>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.30387385, 11.48325946, 11.00812449>, <2.31581129, 11.43583975, 10.99769050>, <2.90458240, 11.57600058, 10.79470345>, <3.83157518, 12.04838472, 9.70840799>,
            <1.95364406, 11.09261590, 12.38280044>, <1.96558150, 11.04519619, 12.37236645>, <2.34627583, 11.08472634, 12.38866011>, <3.83157518, 12.04838472, 9.70840799>,
            <2.17540424, 11.01821404, 12.97465099>, <2.18734168, 10.97079433, 12.96421700>, <2.46824393, 11.04380532, 12.71417791>, <3.83157518, 12.04838472, 9.70840799>,
            <3.01829356, 11.03184029, 13.87706586>, <3.03023100, 10.98442058, 13.86663187>, <2.58383500, 11.04842824, 12.82541473>, <3.83157518, 12.04838472, 9.70840799>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.78382541, 12.23806358, 9.75014396>, <2.53608523, 11.23810710, 12.86715070>, <3.00635612, 11.07926000, 13.88749986>, <3.01829356, 11.03184029, 13.87706586>,
            <3.78382541, 12.23806358, 9.75014396>, <2.65167631, 11.24273002, 12.97838752>, <3.84924544, 11.09288625, 14.78991473>, <3.86118288, 11.04546654, 14.77948074>,
            <3.78382541, 12.23806358, 9.75014396>, <2.83092205, 11.34985760, 12.69659474>, <2.95721847, 11.30747416, 12.79410936>, <2.96915591, 11.26005445, 12.78367537>,
            <3.78382541, 12.23806358, 9.75014396>, <3.62587301, 11.90994657, 11.06063632>, <3.91383602, 11.85461029, 11.40197950>, <3.92577346, 11.80719058, 11.39154551>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.01829356, 11.03184029, 13.87706586>, <3.03023100, 10.98442058, 13.86663187>, <2.58383500, 11.04842824, 12.82541473>, <3.83157518, 12.04838472, 9.70840799>,
            <3.86118288, 11.04546654, 14.77948074>, <3.87312032, 10.99804682, 14.76904675>, <2.69942608, 11.05305116, 12.93665155>, <3.83157518, 12.04838472, 9.70840799>,
            <2.96915591, 11.26005445, 12.78367537>, <2.98109335, 11.21263474, 12.77324138>, <2.87867182, 11.16017875, 12.65485877>, <3.83157518, 12.04838472, 9.70840799>,
            <3.92577346, 11.80719058, 11.39154551>, <3.93771090, 11.75977087, 11.38111152>, <3.67362278, 11.72026771, 11.01890035>, <3.83157518, 12.04838472, 9.70840799>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.78382541, 12.23806358, 9.75014396>, <3.62587301, 11.90994657, 11.06063632>, <3.91383602, 11.85461029, 11.40197950>, <3.92577346, 11.80719058, 11.39154551>,
            <3.78382541, 12.23806358, 9.75014396>, <4.42082398, 12.47003554, 9.42467790>, <4.87045357, 12.40174643, 10.00984964>, <4.88239101, 12.35432671, 9.99941565>,
            <3.78382541, 12.23806358, 9.75014396>, <4.26923057, 12.43620447, 9.40499434>, <4.26158995, 12.73947378, 9.21598200>, <4.35708948, 12.36011607, 9.13251006>,
            <3.78382541, 12.23806358, 9.75014396>, <4.00081409, 12.39816375, 9.27078628>, <3.68482730, 12.65773340, 8.92760101>, <3.78032684, 12.27837568, 8.84412907>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.92577346, 11.80719058, 11.39154551>, <3.93771090, 11.75977087, 11.38111152>, <3.67362278, 11.72026771, 11.01890035>, <3.83157518, 12.04838472, 9.70840799>,
            <4.88239101, 12.35432671, 9.99941565>, <4.89432845, 12.30690700, 9.98898166>, <4.46857375, 12.28035668, 9.38294193>, <3.83157518, 12.04838472, 9.70840799>,
            <4.35708948, 12.36011607, 9.13251006>, <4.45258902, 11.98075836, 9.04903812>, <4.31698034, 12.24652562, 9.36325837>, <3.83157518, 12.04838472, 9.70840799>,
            <3.78032684, 12.27837568, 8.84412907>, <3.87582638, 11.89901797, 8.76065713>, <4.04856386, 12.20848489, 9.22905031>, <3.83157518, 12.04838472, 9.70840799>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.78382541, 12.23806358, 9.75014396>, <3.78382541, 12.23806358, 9.75014396>, <3.78382541, 12.23806358, 9.75014396>, <3.78382541, 12.23806358, 9.75014396>,
            <2.85683263, 11.76567943, 10.83643942>, <3.41513920, 12.25695367, 9.24248276>, <3.73239760, 12.36012302, 9.13657822>, <4.00081409, 12.39816375, 9.27078628>,
            <2.29193641, 11.53067918, 11.01855849>, <2.64216620, 11.92132274, 9.64388254>, <3.10806466, 12.57599301, 8.63922001>, <3.68482730, 12.65773340, 8.92760101>,
            <2.30387385, 11.48325946, 11.00812449>, <2.65410364, 11.87390303, 9.63344855>, <3.20356420, 12.19663530, 8.55574808>, <3.78032684, 12.27837568, 8.84412907>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.30387385, 11.48325946, 11.00812449>, <2.65410364, 11.87390303, 9.63344855>, <3.20356420, 12.19663530, 8.55574808>, <3.78032684, 12.27837568, 8.84412907>,
            <2.31581129, 11.43583975, 10.99769050>, <2.66604109, 11.82648332, 9.62301455>, <3.29906373, 11.81727759, 8.47227614>, <3.87582638, 11.89901797, 8.76065713>,
            <2.90458240, 11.57600058, 10.79470345>, <3.46288896, 12.06727481, 9.20074679>, <3.78014737, 12.17044416, 9.09484225>, <4.04856386, 12.20848489, 9.22905031>,
            <3.83157518, 12.04838472, 9.70840799>, <3.83157518, 12.04838472, 9.70840799>, <3.83157518, 12.04838472, 9.70840799>, <3.83157518, 12.04838472, 9.70840799>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.75770198, 12.87460114, 7.75722300>, <-1.74952082, 12.25325900, 5.28386243>, <-1.77558328, 12.33958402, 5.06372192>, <-1.69746524, 12.32860502, 4.99872700>,
            <1.72757640, 12.87013890, 7.73875974>, <-1.40005170, 12.46950186, 5.50011403>, <-1.43736196, 12.65503302, 5.27434962>, <-1.81593355, 12.87902503, 4.93326919>,
            <1.69745083, 12.86567665, 7.72029648>, <0.48262233, 12.92484299, 6.65618189>, <0.50805500, 13.20854223, 6.46998977>, <0.49033599, 13.28423989, 6.34752818>,
            <1.72468266, 12.86971027, 7.73698624>, <0.67593482, 12.97429007, 6.77492054>, <0.58132861, 13.45294339, 6.51783696>, <0.55798570, 13.57824412, 6.39256342>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.69746524, 12.32860502, 4.99872700>, <-1.61934720, 12.31762602, 4.93373207>, <-1.38432438, 12.29319305, 4.50295863>, <-1.31165173, 12.33316902, 4.45864524>,
            <-1.81593355, 12.87902503, 4.93326919>, <-2.19450515, 13.10301704, 4.59218876>, <-2.05531937, 13.16526073, 4.10394866>, <-1.96577502, 13.05642749, 4.06807112>,
            <0.49033599, 13.28423989, 6.34752818>, <0.47261698, 13.35993755, 6.22506659>, <0.68514420, 13.53391686, 5.78304535>, <0.77468855, 13.42508362, 5.74716781>,
            <0.55798570, 13.57824412, 6.39256342>, <0.53464279, 13.70354485, 6.26728988>, <0.75279391, 13.82792110, 5.82808059>, <0.84233826, 13.71908785, 5.79220305>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.31165173, 12.33316902, 4.45864524>, <-1.23897908, 12.37314499, 4.41433185>, <-1.15375686, 12.37647790, 4.24814358>, <0.77906210, 12.62744667, 5.12733368>,
            <-1.96577502, 13.05642749, 4.06807112>, <-1.87623066, 12.94759424, 4.03219358>, <-0.79303994, 12.49351463, 4.47001908>, <0.94435778, 12.68373391, 5.22903980>,
            <0.77468855, 13.42508362, 5.74716781>, <0.86423291, 13.31625037, 5.71129027>, <1.06778778, 13.03449435, 5.61381647>, <1.85970885, 12.95199265, 5.79170687>,
            <0.84233826, 13.71908785, 5.79220305>, <0.93188262, 13.61025461, 5.75632551>, <1.18897992, 13.23555718, 5.69039699>, <1.93673279, 13.02973934, 5.83974798>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.77906210, 12.62744667, 5.12733368>, <2.71188107, 12.87841544, 6.00652378>, <2.71073771, 12.88849988, 6.00595210>, <0.84681675, 12.48268706, 5.16691060>,
            <0.94435778, 12.68373391, 5.22903980>, <2.68175549, 12.87395320, 5.98806052>, <2.68061214, 12.88403763, 5.98748885>, <0.94949032, 12.38889573, 5.22846491>,
            <1.85970885, 12.95199265, 5.79170687>, <2.65162992, 12.86949096, 5.96959727>, <2.73507581, 12.89210487, 6.02086835>, <1.92495944, 12.46633732, 5.82546314>,
            <1.93673279, 13.02973934, 5.83974798>, <2.68448565, 12.82392150, 5.98909897>, <2.72001302, 12.88987375, 6.01163672>, <2.04753811, 12.43375075, 5.89995006>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.84681675, 12.48268706, 5.16691060>, <-1.01710421, 12.07687423, 4.32786910>, <-1.14031997, 12.05701988, 4.47063490>, <-1.20397178, 12.03250188, 4.52065470>,
            <0.94949032, 12.38889573, 5.22846491>, <-0.78163149, 11.89375384, 4.46944098>, <-0.88235165, 11.67548720, 4.62345459>, <-0.93475565, 11.55176305, 4.67909829>,
            <1.92495944, 12.46633732, 5.82546314>, <1.11484307, 12.04056977, 5.63005794>, <1.04490596, 11.74295648, 5.80188168>, <0.93895953, 11.71217373, 5.82598009>,
            <2.04753811, 12.43375075, 5.89995006>, <1.37506319, 11.97762776, 5.78826339>, <1.21182020, 11.65827029, 5.90280242>, <1.14064096, 11.60424419, 5.94785147>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.20397178, 12.03250188, 4.52065470>, <-1.26762359, 12.00798387, 4.57067450>, <-1.51494354, 12.08063922, 4.99454119>, <-1.56466877, 12.06982197, 5.07661013>,
            <-0.93475565, 11.55176305, 4.67909829>, <-0.98715966, 11.42803890, 4.73474199>, <-1.24572741, 11.59990039, 5.15298478>, <-1.26440582, 11.69455403, 5.25535120>,
            <0.93895953, 11.71217373, 5.82598009>, <0.83301310, 11.68139099, 5.85007851>, <0.59694096, 11.65484019, 6.27956910>, <0.62055717, 11.75575857, 6.40785690>,
            <1.14064096, 11.60424419, 5.94785147>, <1.06946172, 11.55021808, 5.99290051>, <0.85502856, 11.48316365, 6.43510299>, <0.82396345, 11.62923246, 6.53054812>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.56466877, 12.06982197, 5.07661013>, <-1.61439400, 12.05900473, 5.15867907>, <-1.74156624, 12.07343146, 5.28645940>, <1.75770198, 12.87460114, 7.75722300>,
            <-1.26440582, 11.69455403, 5.25535120>, <-1.28308423, 11.78920767, 5.35771762>, <-1.34816283, 12.01457617, 5.52609290>, <1.72757640, 12.87013890, 7.73875974>,
            <0.62055717, 11.75575857, 6.40785690>, <0.64417338, 11.85667696, 6.53614470>, <0.58352166, 12.18030235, 6.70846156>, <1.69745083, 12.86567665, 7.72029648>,
            <0.82396345, 11.62923246, 6.53054812>, <0.79289834, 11.77530126, 6.62599325>, <0.78015874, 12.20732381, 6.82894932>, <1.72468266, 12.86971027, 7.73698624>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.72468266, 12.86971027, 7.73698624>, <0.67593482, 12.97429007, 6.77492054>, <0.58132861, 13.45294339, 6.51783696>, <0.55798570, 13.57824412, 6.39256342>,
            <1.75191450, 12.87374389, 7.75367599>, <0.86924731, 13.02373715, 6.89365919>, <0.65460223, 13.69734455, 6.56568414>, <0.62563541, 13.87224835, 6.43759866>,
            <1.68933553, 12.85782612, 7.59804295>, <1.25587229, 13.12263132, 7.13113648>, <1.00407135, 13.91358742, 6.78193575>, <0.97510454, 14.08849122, 6.65385026>,
            <1.69049944, 12.86132276, 7.65739621>, <1.42311686, 13.17154143, 7.29253864>, <1.02239837, 14.01848698, 7.14604260>, <1.05860136, 14.19473323, 6.91129834>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.55798570, 13.57824412, 6.39256342>, <0.53464279, 13.70354485, 6.26728988>, <0.75279391, 13.82792110, 5.82808059>, <0.84233826, 13.71908785, 5.79220305>,
            <0.62563541, 13.87224835, 6.43759866>, <0.59666860, 14.04715215, 6.30951317>, <0.82044362, 14.12192533, 5.87311582>, <0.90998798, 14.01309208, 5.83723829>,
            <0.97510454, 14.08849122, 6.65385026>, <0.94613772, 14.26339502, 6.52576477>, <1.16991274, 14.33816820, 6.08936743>, <1.25945710, 14.22933495, 6.05348989>,
            <1.05860136, 14.19473323, 6.91129834>, <1.09480436, 14.37097947, 6.67655408>, <1.39678315, 14.44736358, 6.11216621>, <1.56453128, 14.34014127, 5.94829815>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.84233826, 13.71908785, 5.79220305>, <0.93188262, 13.61025461, 5.75632551>, <1.18897992, 13.23555718, 5.69039699>, <1.93673279, 13.02973934, 5.83974798>,
            <0.90998798, 14.01309208, 5.83723829>, <0.99953233, 13.90425884, 5.80136075>, <1.31017205, 13.43662001, 5.76697750>, <2.01375672, 13.10748603, 5.88778909>,
            <1.25945710, 14.22933495, 6.05348989>, <1.34900146, 14.12050170, 6.01761235>, <1.65964118, 13.65286288, 5.98322911>, <2.21009922, 13.26924416, 6.00979269>,
            <1.56453128, 14.34014127, 5.94829815>, <1.73227941, 14.23291896, 5.78443008>, <1.88651159, 13.76205827, 6.00602789>, <2.27614168, 13.41134075, 5.99333583>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.93673279, 13.02973934, 5.83974798>, <2.68448565, 12.82392150, 5.98909897>, <2.72001302, 12.88987375, 6.01163672>, <2.04753811, 12.43375075, 5.89995006>,
            <2.01375672, 13.10748603, 5.88778909>, <2.71734139, 12.77835205, 6.00860067>, <2.70495023, 12.88764263, 6.00240509>, <2.17011677, 12.40116419, 5.97443697>,
            <2.21009922, 13.26924416, 6.00979269>, <2.76055726, 12.88562543, 6.03635627>, <2.75941390, 12.89570987, 6.03578460>, <2.39398569, 12.43221927, 6.11161448>,
            <2.27614168, 13.41134075, 5.99333583>, <2.66577177, 13.06062323, 5.98064377>, <2.72095520, 12.65154059, 6.00921266>, <2.49914280, 12.32418235, 6.11590888>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.04753811, 12.43375075, 5.89995006>, <1.37506319, 11.97762776, 5.78826339>, <1.21182020, 11.65827029, 5.90280242>, <1.14064096, 11.60424419, 5.94785147>,
            <2.17011677, 12.40116419, 5.97443697>, <1.63528331, 11.91468575, 5.94646885>, <1.37873444, 11.57358411, 6.00372317>, <1.34232239, 11.49631464, 6.06972284>,
            <2.39398569, 12.43221927, 6.11161448>, <2.02855747, 11.96872868, 6.18744436>, <1.86996171, 11.49983572, 6.30294080>, <1.85276021, 11.37777682, 6.38011461>,
            <2.49914280, 12.32418235, 6.11590888>, <2.27733040, 11.99682410, 6.22260510>, <2.27773489, 11.50241950, 6.08334300>, <2.18232962, 11.37874967, 6.28850735>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.14064096, 11.60424419, 5.94785147>, <1.06946172, 11.55021808, 5.99290051>, <0.85502856, 11.48316365, 6.43510299>, <0.82396345, 11.62923246, 6.53054812>,
            <1.34232239, 11.49631464, 6.06972284>, <1.30591033, 11.41904517, 6.13572251>, <1.11311616, 11.31148712, 6.59063688>, <1.02736973, 11.50270634, 6.65323933>,
            <1.85276021, 11.37777682, 6.38011461>, <1.83555871, 11.25571792, 6.45728843>, <1.56592233, 11.32731759, 6.86750622>, <1.48579980, 11.46893375, 6.93292062>,
            <2.18232962, 11.37874967, 6.28850735>, <2.08692435, 11.25507983, 6.49367169>, <1.73908419, 11.32506857, 7.03188001>, <1.59097990, 11.49014382, 7.20254721>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.82396345, 11.62923246, 6.53054812>, <0.79289834, 11.77530126, 6.62599325>, <0.78015874, 12.20732381, 6.82894932>, <1.72468266, 12.86971027, 7.73698624>,
            <1.02736973, 11.50270634, 6.65323933>, <0.94162331, 11.69392557, 6.71584179>, <0.97679582, 12.23434528, 6.94943707>, <1.75191450, 12.87374389, 7.75367599>,
            <1.48579980, 11.46893375, 6.93292062>, <1.40567728, 11.61054990, 6.99833503>, <1.37006998, 12.28838821, 7.19041258>, <1.68933553, 12.85782612, 7.59804295>,
            <1.59097990, 11.49014382, 7.20254721>, <1.44287561, 11.65521906, 7.37321441>, <1.54063913, 12.31487269, 7.35356385>, <1.69049944, 12.86132276, 7.65739621>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.69049944, 12.86132276, 7.65739621>, <1.42311686, 13.17154143, 7.29253864>, <1.02239837, 14.01848698, 7.14604260>, <1.05860136, 14.19473323, 6.91129834>,
            <1.69166335, 12.86481940, 7.71674947>, <1.59036143, 13.22045153, 7.45394080>, <1.04072538, 14.12338655, 7.51014946>, <1.14209819, 14.30097524, 7.16874642>,
            <1.84348721, 12.90725323, 8.16163831>, <1.84686231, 13.68524439, 7.96810453>, <1.84632040, 14.33422885, 8.00503157>, <2.00464528, 14.53287299, 7.69869196>,
            <2.04628300, 12.94726437, 8.46184687>, <2.04965811, 13.72525553, 8.26831309>, <2.04273072, 14.36332144, 8.12540684>, <2.20105561, 14.56196558, 7.81906723>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.05860136, 14.19473323, 6.91129834>, <1.09480436, 14.37097947, 6.67655408>, <1.39678315, 14.44736358, 6.11216621>, <1.56453128, 14.34014127, 5.94829815>,
            <1.14209819, 14.30097524, 7.16874642>, <1.24347100, 14.47856393, 6.82734339>, <1.62365356, 14.55655897, 6.13496499>, <1.86960546, 14.45094759, 5.84310640>,
            <2.00464528, 14.53287299, 7.69869196>, <2.16297017, 14.73151713, 7.39235235>, <2.56592168, 14.81792997, 6.71399201>, <2.77595727, 14.69904016, 6.40002099>,
            <2.20105561, 14.56196558, 7.81906723>, <2.35938049, 14.76060972, 7.51272762>, <2.76233200, 14.84702256, 6.83436728>, <2.97236760, 14.72813275, 6.52039626>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.56453128, 14.34014127, 5.94829815>, <1.73227941, 14.23291896, 5.78443008>, <1.88651159, 13.76205827, 6.00602789>, <2.27614168, 13.41134075, 5.99333583>,
            <1.86960546, 14.45094759, 5.84310640>, <2.11555736, 14.34533621, 5.55124781>, <2.11338199, 13.87125365, 6.02882668>, <2.34218414, 13.55343734, 5.97687897>,
            <2.77595727, 14.69904016, 6.40002099>, <2.98599287, 14.58015035, 6.08604997>, <2.98639395, 14.05241757, 6.21293929>, <3.11053130, 13.69590619, 6.09655310>,
            <2.97236760, 14.72813275, 6.52039626>, <3.18240319, 14.60924294, 6.20642524>, <3.36527974, 14.08526901, 6.03467000>, <3.48941710, 13.72875762, 5.91828381>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.27614168, 13.41134075, 5.99333583>, <2.66577177, 13.06062323, 5.98064377>, <2.72095520, 12.65154059, 6.00921266>, <2.49914280, 12.32418235, 6.11590888>,
            <2.34218414, 13.55343734, 5.97687897>, <2.57098629, 13.23562102, 5.92493127>, <2.68249650, 12.40737132, 5.98264072>, <2.60429991, 12.21614542, 6.12020328>,
            <3.11053130, 13.69590619, 6.09655310>, <3.23466866, 13.33939480, 5.98016690>, <3.32350773, 12.55583009, 6.02458644>, <3.28060167, 12.19587775, 6.18158828>,
            <3.48941710, 13.72875762, 5.91828381>, <3.61355445, 13.37224623, 5.80189761>, <3.70239353, 12.58868153, 5.84631715>, <3.65948746, 12.22872918, 6.00331899>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.49914280, 12.32418235, 6.11590888>, <2.27733040, 11.99682410, 6.22260510>, <2.27773489, 11.50241950, 6.08334300>, <2.18232962, 11.37874967, 6.28850735>,
            <2.60429991, 12.21614542, 6.12020328>, <2.52610333, 12.02491952, 6.25776583>, <2.68550806, 11.50500328, 5.86374521>, <2.51189902, 11.37972252, 6.19690008>,
            <3.28060167, 12.19587775, 6.18158828>, <3.23769560, 11.83592541, 6.33859012>, <3.35668424, 11.31063543, 6.27139566>, <3.17452362, 11.18366671, 6.59930416>,
            <3.65948746, 12.22872918, 6.00331899>, <3.61658140, 11.86877684, 6.16032083>, <3.55309456, 11.33972802, 6.39177093>, <3.37093394, 11.21275929, 6.71967943>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.18232962, 11.37874967, 6.28850735>, <2.08692435, 11.25507983, 6.49367169>, <1.73908419, 11.32506857, 7.03188001>, <1.59097990, 11.49014382, 7.20254721>,
            <2.51189902, 11.37972252, 6.19690008>, <2.33828998, 11.25444175, 6.53005495>, <1.91224604, 11.32281955, 7.19625379>, <1.69616000, 11.51135389, 7.47217379>,
            <3.17452362, 11.18366671, 6.59930416>, <2.99236300, 11.05669798, 6.92721267>, <2.57174029, 11.12614586, 7.59673741>, <2.36921438, 11.31735677, 7.88097651>,
            <3.37093394, 11.21275929, 6.71967943>, <3.18877332, 11.08579057, 7.04758794>, <2.76815062, 11.15523844, 7.71711268>, <2.56562471, 11.34644936, 8.00135178>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.59097990, 11.49014382, 7.20254721>, <1.44287561, 11.65521906, 7.37321441>, <1.54063913, 12.31487269, 7.35356385>, <1.69049944, 12.86132276, 7.65739621>,
            <1.69616000, 11.51135389, 7.47217379>, <1.48007395, 11.69988822, 7.74809379>, <1.71120829, 12.34135718, 7.51671511>, <1.69166335, 12.86481940, 7.71674947>,
            <2.36921438, 11.31735677, 7.88097651>, <2.16668848, 11.50856768, 8.16521561>, <2.02284984, 12.13302631, 8.05609829>, <1.84348721, 12.90725323, 8.16163831>,
            <2.56562471, 11.34644936, 8.00135178>, <2.36309880, 11.53766027, 8.28559088>, <2.22564564, 12.17303745, 8.35630685>, <2.04628300, 12.94726437, 8.46184687>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.04628300, 12.94726437, 8.46184687>, <2.04965811, 13.72525553, 8.26831309>, <2.04273072, 14.36332144, 8.12540684>, <2.20105561, 14.56196558, 7.81906723>,
            <2.24907880, 12.98727550, 8.76205543>, <2.25245390, 13.76526667, 8.56852165>, <2.23914105, 14.39241402, 8.24578211>, <2.39746593, 14.59105817, 7.93944250>,
            <3.15823667, 11.96317636, 9.29951233>, <3.10881053, 12.25440762, 9.30977302>, <2.93288864, 14.74680232, 8.80155703>, <3.08275454, 14.94251303, 8.50972848>,
            <3.58874321, 11.99575843, 9.43406422>, <3.35242755, 12.29049253, 9.45908017>, <3.17650566, 14.78288723, 8.95086418>, <3.32637156, 14.97859794, 8.65903563>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.20105561, 14.56196558, 7.81906723>, <2.35938049, 14.76060972, 7.51272762>, <2.76233200, 14.84702256, 6.83436728>, <2.97236760, 14.72813275, 6.52039626>,
            <2.39746593, 14.59105817, 7.93944250>, <2.55579081, 14.78970231, 7.63310289>, <2.95874233, 14.87611514, 6.95474255>, <3.16877792, 14.75722534, 6.64077153>,
            <3.08275454, 14.94251303, 8.50972848>, <3.23262044, 15.13822374, 8.21789993>, <3.73242028, 15.24540566, 7.37649748>, <3.96686945, 15.09740403, 7.02972787>,
            <3.32637156, 14.97859794, 8.65903563>, <3.47623746, 15.17430865, 8.36720708>, <3.97603730, 15.28149058, 7.52580463>, <4.21048647, 15.13348894, 7.17903502>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.97236760, 14.72813275, 6.52039626>, <3.18240319, 14.60924294, 6.20642524>, <3.36527974, 14.08526901, 6.03467000>, <3.48941710, 13.72875762, 5.91828381>,
            <3.16877792, 14.75722534, 6.64077153>, <3.37881352, 14.63833553, 6.32680051>, <3.74416553, 14.11812044, 5.85640071>, <3.86830289, 13.76160905, 5.74001452>,
            <3.96686945, 15.09740403, 7.02972787>, <4.20131862, 14.94940239, 6.68295825>, <4.53896252, 14.40121322, 6.26452924>, <4.68731206, 14.00861834, 6.11735798>,
            <4.21048647, 15.13348894, 7.17903502>, <4.44493564, 14.98548731, 6.83226540>, <4.78257954, 14.43729813, 6.41383639>, <5.02530307, 14.05792399, 6.31113222>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.48941710, 13.72875762, 5.91828381>, <3.61355445, 13.37224623, 5.80189761>, <3.70239353, 12.58868153, 5.84631715>, <3.65948746, 12.22872918, 6.00331899>,
            <3.86830289, 13.76160905, 5.74001452>, <3.99244025, 13.40509767, 5.62362832>, <4.08127932, 12.62153296, 5.66804786>, <4.03837325, 12.26158062, 5.82504970>,
            <4.68731206, 14.00861834, 6.11735798>, <4.83566160, 13.61602346, 5.97018672>, <4.99084412, 12.24730649, 6.04777798>, <5.09918012, 12.06287661, 6.10847597>,
            <5.02530307, 14.05792399, 6.31113222>, <5.26802660, 13.67854985, 6.20842804>, <5.42320912, 12.30983288, 6.28601930>, <5.40299744, 12.12463880, 6.30677644>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.65948746, 12.22872918, 6.00331899>, <3.61658140, 11.86877684, 6.16032083>, <3.55309456, 11.33972802, 6.39177093>, <3.37093394, 11.21275929, 6.71967943>,
            <4.03837325, 12.26158062, 5.82504970>, <3.99546719, 11.90162827, 5.98205154>, <3.74950489, 11.36882061, 6.51214620>, <3.56734427, 11.24185188, 6.84005471>,
            <5.09918012, 12.06287661, 6.10847597>, <5.20751611, 11.87844673, 6.16917396>, <4.80216125, 11.49360092, 6.53779980>, <4.50926284, 11.23529852, 7.07813468>,
            <5.40299744, 12.12463880, 6.30677644>, <5.38278576, 11.93944472, 6.32753359>, <5.04577827, 11.52968583, 6.68710695>, <4.75287986, 11.27138343, 7.22744183>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.37093394, 11.21275929, 6.71967943>, <3.18877332, 11.08579057, 7.04758794>, <2.76815062, 11.15523844, 7.71711268>, <2.56562471, 11.34644936, 8.00135178>,
            <3.56734427, 11.24185188, 6.84005471>, <3.38518364, 11.11488315, 7.16796321>, <2.96456094, 11.18433103, 7.83748796>, <2.76203503, 11.37554194, 8.12172705>,
            <4.50926284, 11.23529852, 7.07813468>, <4.21636442, 10.97699612, 7.61846955>, <3.69464617, 11.06313561, 8.44891279>, <3.54349807, 11.25803918, 8.74487431>,
            <4.75287986, 11.27138343, 7.22744183>, <4.45998145, 11.01308103, 7.76777670>, <3.93826319, 11.09922052, 8.59821994>, <3.78711509, 11.29412410, 8.89418146>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.56562471, 11.34644936, 8.00135178>, <2.36309880, 11.53766027, 8.28559088>, <2.22564564, 12.17303745, 8.35630685>, <2.04628300, 12.94726437, 8.46184687>,
            <2.76203503, 11.37554194, 8.12172705>, <2.55950913, 11.56675286, 8.40596615>, <2.42844143, 12.21304859, 8.65651541>, <2.24907880, 12.98727550, 8.76205543>,
            <3.54349807, 11.25803918, 8.74487431>, <3.39234997, 11.45294276, 9.04083584>, <3.32195036, 11.68263341, 9.10019117>, <3.15823667, 11.96317636, 9.29951233>,
            <3.78711509, 11.29412410, 8.89418146>, <3.63596699, 11.48902767, 9.19014299>, <3.56556739, 11.71871832, 9.24949832>, <3.58874321, 11.99575843, 9.43406422>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.58874321, 11.99575843, 9.43406422>, <3.35242755, 12.29049253, 9.45908017>, <3.17650566, 14.78288723, 8.95086418>, <3.32637156, 14.97859794, 8.65903563>,
            <4.01924974, 12.02834049, 9.56861610>, <3.59604458, 12.32657745, 9.60838732>, <3.42012268, 14.81897215, 9.10017133>, <3.56998859, 15.01468286, 8.80834278>,
            <4.65765012, 11.93167455, 10.11790415>, <4.23550661, 12.41691732, 9.92306694>, <4.02810448, 14.90530646, 9.40715301>, <4.15355860, 15.09748123, 9.10177375>,
            <4.72567759, 12.06472895, 10.14248415>, <4.49105670, 12.45313455, 10.05084198>, <4.28365458, 14.94152369, 9.53492806>, <4.40910870, 15.13369846, 9.22954879>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.32637156, 14.97859794, 8.65903563>, <3.47623746, 15.17430865, 8.36720708>, <3.97603730, 15.28149058, 7.52580463>, <4.21048647, 15.13348894, 7.17903502>,
            <3.56998859, 15.01468286, 8.80834278>, <3.71985449, 15.21039356, 8.51651423>, <4.21965433, 15.31757549, 7.67511178>, <4.45410350, 15.16957386, 7.32834217>,
            <4.15355860, 15.09748123, 9.10177375>, <4.27901272, 15.28965601, 8.79639448>, <4.70617508, 15.38631671, 7.91467176>, <4.90974062, 15.23384172, 7.55075898>,
            <4.40910870, 15.13369846, 9.22954879>, <4.53456282, 15.32587323, 8.92416953>, <4.96172517, 15.42253394, 8.04244681>, <5.16529071, 15.27005895, 7.67853403>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.21048647, 15.13348894, 7.17903502>, <4.44493564, 14.98548731, 6.83226540>, <4.78257954, 14.43729813, 6.41383639>, <5.02530307, 14.05792399, 6.31113222>,
            <4.45410350, 15.16957386, 7.32834217>, <4.68855267, 15.02157222, 6.98157255>, <5.02619657, 14.47338305, 6.56314354>, <5.36329408, 14.10722965, 6.50490645>,
            <4.90974062, 15.23384172, 7.55075898>, <5.11330616, 15.08136673, 7.18684621>, <5.67948053, 14.54009131, 6.43331553>, <5.76802081, 14.15165015, 6.47903482>,
            <5.16529071, 15.27005895, 7.67853403>, <5.36885625, 15.11758396, 7.31462126>, <5.62375623, 14.54486998, 6.62906018>, <5.73483470, 14.15328496, 6.57424517>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.02530307, 14.05792399, 6.31113222>, <5.26802660, 13.67854985, 6.20842804>, <5.42320912, 12.30983288, 6.28601930>, <5.40299744, 12.12463880, 6.30677644>,
            <5.36329408, 14.10722965, 6.50490645>, <5.70039160, 13.74107625, 6.44666936>, <5.85557412, 12.37235927, 6.52426062>, <5.70681476, 12.18640099, 6.50507692>,
            <5.76802081, 14.15165015, 6.47903482>, <5.85656110, 13.76320900, 6.52475411>, <6.01174362, 12.39449202, 6.60234538>, <5.88853613, 12.06516337, 6.57674019>,
            <5.73483470, 14.15328496, 6.57424517>, <5.84591318, 13.76169994, 6.51943015>, <6.00109570, 12.39298297, 6.59702141>, <5.97309395, 12.13330421, 6.60029525>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.40299744, 12.12463880, 6.30677644>, <5.38278576, 11.93944472, 6.32753359>, <5.04577827, 11.52968583, 6.68710695>, <4.75287986, 11.27138343, 7.22744183>,
            <5.70681476, 12.18640099, 6.50507692>, <5.55805540, 12.00044272, 6.48589321>, <5.28939530, 11.56577075, 6.83641410>, <4.99649688, 11.30746835, 7.37674898>,
            <5.88853613, 12.06516337, 6.57674019>, <5.76532864, 11.73583472, 6.55113501>, <5.68449084, 11.62126943, 7.02522495>, <5.43730503, 11.36958830, 7.59093439>,
            <5.97309395, 12.13330421, 6.60029525>, <5.94509220, 11.87362544, 6.60356908>, <5.94004093, 11.65748666, 7.15300000>, <5.69285512, 11.40580553, 7.71870944>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.75287986, 11.27138343, 7.22744183>, <4.45998145, 11.01308103, 7.76777670>, <3.93826319, 11.09922052, 8.59821994>, <3.78711509, 11.29412410, 8.89418146>,
            <4.99649688, 11.30746835, 7.37674898>, <4.70359847, 11.04916595, 7.91708385>, <4.18188022, 11.13530544, 8.74752709>, <4.03073212, 11.33020901, 9.04348861>,
            <5.43730503, 11.36958830, 7.59093439>, <5.19011922, 11.11790717, 8.15664383>, <4.74103845, 11.21456788, 9.02740734>, <4.61637385, 11.41303036, 9.33318137>,
            <5.69285512, 11.40580553, 7.71870944>, <5.44566931, 11.15412440, 8.28441888>, <4.99658854, 11.25078511, 9.15518239>, <4.87192394, 11.44924759, 9.46095641>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.78711509, 11.29412410, 8.89418146>, <3.63596699, 11.48902767, 9.19014299>, <3.56556739, 11.71871832, 9.24949832>, <3.58874321, 11.99575843, 9.43406422>,
            <4.03073212, 11.33020901, 9.04348861>, <3.87958402, 11.52511259, 9.33945014>, <3.80918441, 11.75480324, 9.39880547>, <4.01924974, 12.02834049, 9.56861610>,
            <4.61637385, 11.41303036, 9.33318137>, <4.49170924, 11.61149285, 9.63895539>, <4.42760326, 11.84209510, 9.70180424>, <4.65765012, 11.93167455, 10.11790415>,
            <4.87192394, 11.44924759, 9.46095641>, <4.74725934, 11.64771007, 9.76673044>, <4.68315335, 11.87831233, 9.82957929>, <4.72567759, 12.06472895, 10.14248415>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.72567759, 12.06472895, 10.14248415>, <4.49105670, 12.45313455, 10.05084198>, <4.28365458, 14.94152369, 9.53492806>, <4.40910870, 15.13369846, 9.22954879>,
            <4.79370507, 12.19778334, 10.16706416>, <4.74660679, 12.48935178, 10.17861703>, <4.53920467, 14.97774092, 9.66270310>, <4.66465879, 15.16991569, 9.35732384>,
            <5.16940817, 13.42667233, 10.67239701>, <5.12165135, 14.25366621, 10.43122269>, <5.26557985, 14.86682668, 9.90810146>, <5.44115155, 15.28211712, 9.41225044>,
            <5.46453240, 13.46657437, 10.78602425>, <5.41150534, 14.28004412, 10.54416942>, <5.53920472, 14.89099844, 10.01458966>, <5.69689918, 15.30424279, 9.51856145>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.40910870, 15.13369846, 9.22954879>, <4.53456282, 15.32587323, 8.92416953>, <4.96172517, 15.42253394, 8.04244681>, <5.16529071, 15.27005895, 7.67853403>,
            <4.66465879, 15.16991569, 9.35732384>, <4.79011291, 15.36209046, 9.05194457>, <5.21727526, 15.45875117, 8.17022185>, <5.42084080, 15.30627618, 7.80630908>,
            <5.44115155, 15.28211712, 9.41225044>, <5.61672326, 15.69740757, 8.91639942>, <5.68516798, 15.78407956, 8.74145662>, <5.89243083, 15.44308805, 8.33264367>,
            <5.69689918, 15.30424279, 9.51856145>, <5.85459363, 15.71748714, 9.02253323>, <5.91738371, 15.80338320, 8.84521223>, <6.12479764, 15.46277686, 8.44271631>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.16529071, 15.27005895, 7.67853403>, <5.36885625, 15.11758396, 7.31462126>, <5.62375623, 14.54486998, 6.62906018>, <5.73483470, 14.15328496, 6.57424517>,
            <5.42084080, 15.30627618, 7.80630908>, <5.62440635, 15.15380119, 7.44239630>, <5.56803192, 14.54964864, 6.82480483>, <5.70164859, 14.15491977, 6.66945551>,
            <5.89243083, 15.44308805, 8.33264367>, <6.09969369, 15.10209654, 7.92383073>, <6.42811743, 14.60571673, 7.35333267>, <6.55459699, 14.22353998, 7.21522579>,
            <6.12479764, 15.46277686, 8.44271631>, <6.33221156, 15.12217052, 8.04022038>, <6.66063530, 14.62579071, 7.46972232>, <6.78653887, 14.24997502, 7.33131778>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.73483470, 14.15328496, 6.57424517>, <5.84591318, 13.76169994, 6.51943015>, <6.00109570, 12.39298297, 6.59702141>, <5.97309395, 12.13330421, 6.60029525>,
            <5.70164859, 14.15491977, 6.66945551>, <5.83526526, 13.76019089, 6.51410619>, <5.99044778, 12.39147392, 6.59169745>, <6.05765177, 12.20144505, 6.62385030>,
            <6.55459699, 14.22353998, 7.21522579>, <6.68107654, 13.84136324, 7.07711892>, <6.78085902, 12.96127723, 7.12701015>, <6.74594789, 12.55890890, 7.31072688>,
            <6.78653887, 14.24997502, 7.33131778>, <6.91244243, 13.87415933, 7.19291323>, <7.01222490, 12.99407333, 7.24280447>, <6.97731378, 12.59170500, 7.42652120>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.97309395, 12.13330421, 6.60029525>, <5.94509220, 11.87362544, 6.60356908>, <5.94004093, 11.65748666, 7.15300000>, <5.69285512, 11.40580553, 7.71870944>,
            <6.05765177, 12.20144505, 6.62385030>, <6.12485577, 12.01141617, 6.65600315>, <6.19559102, 11.69370389, 7.28077504>, <5.94840521, 11.44202276, 7.84648448>,
            <6.74594789, 12.55890890, 7.31072688>, <6.71103676, 12.15654057, 7.49444361>, <6.56201680, 11.71806827, 8.14975465>, <6.46781723, 11.58453012, 8.44766666>,
            <6.97731378, 12.59170500, 7.42652120>, <6.94240265, 12.18933667, 7.61023793>, <6.75881097, 11.75856436, 8.25287382>, <6.67686255, 11.62622751, 8.54730660>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.69285512, 11.40580553, 7.71870944>, <5.44566931, 11.15412440, 8.28441888>, <4.99658854, 11.25078511, 9.15518239>, <4.87192394, 11.44924759, 9.46095641>,
            <5.94840521, 11.44202276, 7.84648448>, <5.70121940, 11.19034162, 8.41219392>, <5.25213864, 11.28700233, 9.28295744>, <5.12747403, 11.48546482, 9.58873146>,
            <6.46781723, 11.58453012, 8.44766666>, <6.37361766, 11.45099198, 8.74557867>, <6.00715872, 11.54405015, 9.55293837>, <5.83951732, 11.76264726, 9.82945894>,
            <6.67686255, 11.62622751, 8.54730660>, <6.59491413, 11.49389065, 8.84173938>, <6.25546126, 11.59062131, 9.65987003>, <6.09960490, 11.81041909, 9.93415510>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.87192394, 11.44924759, 9.46095641>, <4.74725934, 11.64771007, 9.76673044>, <4.68315335, 11.87831233, 9.82957929>, <4.72567759, 12.06472895, 10.14248415>,
            <5.12747403, 11.48546482, 9.58873146>, <5.00280943, 11.68392730, 9.89450548>, <4.93870345, 11.91452956, 9.95735434>, <4.79370507, 12.19778334, 10.16706416>,
            <5.83951732, 11.76264726, 9.82945894>, <5.67187591, 11.98124436, 10.10597951>, <5.33685770, 12.55228239, 10.53734034>, <5.16940817, 13.42667233, 10.67239701>,
            <6.09960490, 11.81041909, 9.93415510>, <5.94374855, 12.03021687, 10.20844017>, <5.62585987, 12.59137490, 10.64893137>, <5.46453240, 13.46657437, 10.78602425>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.46453240, 13.46657437, 10.78602425>, <5.41150534, 14.28004412, 10.54416942>, <5.53920472, 14.89099844, 10.01458966>, <5.69689918, 15.30424279, 9.51856145>,
            <5.75965664, 13.50647642, 10.89965149>, <5.70135933, 14.30642203, 10.65711615>, <5.81282960, 14.91517019, 10.12107787>, <5.95264680, 15.32636845, 9.62487246>,
            <6.25594384, 13.57107272, 11.04656186>, <6.19993554, 14.34557150, 10.80525594>, <6.41240237, 14.94975856, 9.98676608>, <6.94787138, 16.07699543, 9.77275487>,
            <6.56999964, 13.61215982, 11.14323042>, <6.50733044, 14.37299832, 10.90162357>, <6.68857793, 14.97309032, 10.07333539>, <7.34147148, 16.24097525, 9.88302500>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.69689918, 15.30424279, 9.51856145>, <5.85459363, 15.71748714, 9.02253323>, <5.91738371, 15.80338320, 8.84521223>, <6.12479764, 15.46277686, 8.44271631>,
            <5.95264680, 15.32636845, 9.62487246>, <6.09246400, 15.73756671, 9.12866704>, <6.14959945, 15.82268684, 8.94896784>, <6.35716445, 15.48246567, 8.55278894>,
            <6.94787138, 16.07699543, 9.77275487>, <7.48334040, 17.20423231, 9.55874367>, <7.52654014, 17.28750633, 9.37435029>, <7.20088361, 16.23278360, 8.99820306>,
            <7.34147148, 16.24097525, 9.88302500>, <7.99436503, 17.50886018, 9.69271461>, <8.03427853, 17.59171075, 9.50742400>, <7.56220674, 16.39337088, 9.11316877>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.12479764, 15.46277686, 8.44271631>, <6.33221156, 15.12217052, 8.04022038>, <6.66063530, 14.62579071, 7.46972232>, <6.78653887, 14.24997502, 7.33131778>,
            <6.35716445, 15.48246567, 8.55278894>, <6.56472944, 15.14224451, 8.15661003>, <6.89315318, 14.64586469, 7.58611197>, <7.01848075, 14.27641006, 7.44740976>,
            <7.20088361, 16.23278360, 8.99820306>, <6.87522708, 15.17806087, 8.62205584>, <7.26483723, 14.67166976, 7.75258471>, <7.37838033, 14.31344055, 7.60815040>,
            <7.56220674, 16.39337088, 9.11316877>, <7.09013495, 15.19503102, 8.71891354>, <7.50454975, 14.69167322, 7.85334108>, <7.61752067, 14.33980495, 7.70859945>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.78653887, 14.24997502, 7.33131778>, <6.91244243, 13.87415933, 7.19291323>, <7.01222490, 12.99407333, 7.24280447>, <6.97731378, 12.59170500, 7.42652120>,
            <7.01848075, 14.27641006, 7.44740976>, <7.14380831, 13.90695542, 7.30870755>, <7.24359079, 13.02686942, 7.35859879>, <7.20867966, 12.62450109, 7.54231552>,
            <7.37838033, 14.31344055, 7.60815040>, <7.49192344, 13.95521134, 7.46371609>, <7.59170591, 13.07512534, 7.51360733>, <7.56751120, 12.67425116, 7.70224828>,
            <7.61752067, 14.33980495, 7.70859945>, <7.73049159, 13.98793668, 7.56385783>, <7.83027407, 13.10785068, 7.61374907>, <7.80607936, 12.70697650, 7.80239002>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.97731378, 12.59170500, 7.42652120>, <6.94240265, 12.18933667, 7.61023793>, <6.75881097, 11.75856436, 8.25287382>, <6.67686255, 11.62622751, 8.54730660>,
            <7.20867966, 12.62450109, 7.54231552>, <7.17376853, 12.22213276, 7.72603225>, <6.95560515, 11.79906045, 8.35599298>, <6.88590788, 11.66792489, 8.64694654>,
            <7.56751120, 12.67425116, 7.70224828>, <7.54331649, 12.27337699, 7.89088924>, <7.42944973, 11.88872547, 8.55470840>, <7.36499546, 11.75743876, 8.83217406>,
            <7.80607936, 12.70697650, 7.80239002>, <7.78188464, 12.30610233, 7.99103097>, <7.63132412, 11.92898247, 8.64344949>, <7.57967575, 11.79891699, 8.91667820>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.67686255, 11.62622751, 8.54730660>, <6.59491413, 11.49389065, 8.84173938>, <6.25546126, 11.59062131, 9.65987003>, <6.09960490, 11.81041909, 9.93415510>,
            <6.88590788, 11.66792489, 8.64694654>, <6.81621060, 11.53678932, 8.93790009>, <6.50376379, 11.63719248, 9.76680169>, <6.35969249, 11.85819092, 10.03885126>,
            <7.36499546, 11.75743876, 8.83217406>, <7.30054120, 11.62615204, 9.10963972>, <6.98809439, 11.72655520, 9.93854132>, <6.84835532, 11.94727906, 10.19739214>,
            <7.57967575, 11.79891699, 8.91667820>, <7.52802738, 11.66885151, 9.18990691>, <7.24880761, 11.77361757, 10.02931656>, <7.12153892, 11.99559513, 10.28549664>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.09960490, 11.81041909, 9.93415510>, <5.94374855, 12.03021687, 10.20844017>, <5.62585987, 12.59137490, 10.64893137>, <5.46453240, 13.46657437, 10.78602425>,
            <6.35969249, 11.85819092, 10.03885126>, <6.21562120, 12.07918937, 10.31090083>, <5.91486204, 12.63046740, 10.76052240>, <5.75965664, 13.50647642, 10.89965149>,
            <6.84835532, 11.94727906, 10.19739214>, <6.70861626, 12.16800293, 10.45624297>, <6.41114924, 12.69506371, 10.90743278>, <6.25594384, 13.57107272, 11.04656186>,
            <7.12153892, 11.99559513, 10.28549664>, <6.99427023, 12.21757270, 10.54167673>, <6.71770782, 12.73519321, 11.00220368>, <6.56999964, 13.61215982, 11.14323042>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.56999964, 13.61215982, 11.14323042>, <6.50733044, 14.37299832, 10.90162357>, <6.68857793, 14.97309032, 10.07333539>, <7.34147148, 16.24097525, 9.88302500>,
            <6.88405544, 13.65324691, 11.23989898>, <6.81472533, 14.40042513, 10.99799120>, <6.96475349, 14.99642209, 10.15990471>, <7.73507158, 16.40495507, 9.99329513>,
            <7.39060512, 13.71673988, 11.34682132>, <7.32354914, 14.43847226, 11.10619039>, <7.47357730, 15.03446922, 10.26810389>, <7.49678213, 15.25212186, 10.14818004>,
            <7.72802379, 13.75864841, 11.41125431>, <7.66252385, 14.46085708, 11.17217487>, <7.77310792, 15.05845841, 10.48050582>, <7.81360823, 15.27384812, 10.29837578>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.34147148, 16.24097525, 9.88302500>, <7.99436503, 17.50886018, 9.69271461>, <8.03427853, 17.59171075, 9.50742400>, <7.56220674, 16.39337088, 9.11316877>,
            <7.73507158, 16.40495507, 9.99329513>, <8.50538966, 17.81348805, 9.82668554>, <8.54201693, 17.89591517, 9.64049770>, <7.92352987, 16.55395816, 9.22813448>,
            <7.49678213, 15.25212186, 10.14818004>, <7.51998695, 15.46977450, 10.02825618>, <7.74633132, 15.53552592, 9.16847328>, <7.77264989, 15.39349458, 9.07357243>,
            <7.81360823, 15.27384812, 10.29837578>, <7.85410855, 15.48923784, 10.11624574>, <8.07976072, 15.55478818, 9.25909217>, <8.12248245, 15.41154967, 9.10222012>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.56220674, 16.39337088, 9.11316877>, <7.09013495, 15.19503102, 8.71891354>, <7.50454975, 14.69167322, 7.85334108>, <7.61752067, 14.33980495, 7.70859945>,
            <7.92352987, 16.55395816, 9.22813448>, <7.30504282, 15.21200116, 8.81577125>, <7.74426228, 14.71167668, 7.95409744>, <7.85666102, 14.36616935, 7.80904850>,
            <7.77264989, 15.39349458, 9.07357243>, <7.79896846, 15.25146324, 8.97867159>, <8.11703627, 14.73564218, 8.08594006>, <8.21514624, 14.40106853, 7.93502130>,
            <8.12248245, 15.41154967, 9.10222012>, <8.16520418, 15.26831117, 8.94534807>, <8.44327409, 14.75810431, 8.19917445>, <8.54040854, 14.43321206, 8.04830942>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.61752067, 14.33980495, 7.70859945>, <7.73049159, 13.98793668, 7.56385783>, <7.83027407, 13.10785068, 7.61374907>, <7.80607936, 12.70697650, 7.80239002>,
            <7.85666102, 14.36616935, 7.80904850>, <7.96905975, 14.02066202, 7.66399956>, <8.06884222, 13.14057602, 7.71389080>, <8.04464751, 12.73970185, 7.90253175>,
            <8.21514624, 14.40106853, 7.93502130>, <8.31325621, 14.06649488, 7.78410254>, <8.41303868, 13.18640888, 7.83399377>, <8.40208524, 12.78731639, 8.02758123>,
            <8.54040854, 14.43321206, 8.04830942>, <8.63754300, 14.10831981, 7.89744439>, <8.73702033, 13.23092523, 7.94718305>, <8.72610039, 12.83305322, 8.14017849>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.80607936, 12.70697650, 7.80239002>, <7.78188464, 12.30610233, 7.99103097>, <7.63132412, 11.92898247, 8.64344949>, <7.57967575, 11.79891699, 8.91667820>,
            <8.04464751, 12.73970185, 7.90253175>, <8.02045280, 12.33882767, 8.09117271>, <7.83319851, 11.96923947, 8.73219058>, <7.79435604, 11.84039522, 9.00118234>,
            <8.40208524, 12.78731639, 8.02758123>, <8.39113180, 12.38822390, 8.22116868>, <8.32154492, 12.05835955, 8.89228965>, <8.28686970, 11.92922133, 9.14742562>,
            <8.72610039, 12.83305322, 8.14017849>, <8.71518045, 12.43518120, 8.33317393>, <8.64357583, 12.12310463, 9.00120234>, <8.61202149, 11.99417380, 9.24589684>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.57967575, 11.79891699, 8.91667820>, <7.52802738, 11.66885151, 9.18990691>, <7.24880761, 11.77361757, 10.02931656>, <7.12153892, 11.99559513, 10.28549664>,
            <7.79435604, 11.84039522, 9.00118234>, <7.75551357, 11.71155097, 9.27017410>, <7.50952084, 11.82067994, 10.12009180>, <7.39472252, 12.04391120, 10.37360115>,
            <8.28686970, 11.92922133, 9.14742562>, <8.25219448, 11.80008311, 9.40256159>, <8.00620175, 11.90921208, 10.25247929>, <7.89468493, 12.13203284, 10.49249369>,
            <8.61202149, 11.99417380, 9.24589684>, <8.58046715, 11.86524296, 9.49059134>, <8.33522669, 11.97403820, 10.33790988>, <8.22619121, 12.19587214, 10.56784471>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.12153892, 11.99559513, 10.28549664>, <6.99427023, 12.21757270, 10.54167673>, <6.71770782, 12.73519321, 11.00220368>, <6.56999964, 13.61215982, 11.14323042>,
            <7.39472252, 12.04391120, 10.37360115>, <7.27992420, 12.26714247, 10.62711050>, <7.02426640, 12.77532271, 11.09697459>, <6.88405544, 13.65324691, 11.23989898>,
            <7.89468493, 12.13203284, 10.49249369>, <7.78316811, 12.35485360, 10.73250808>, <7.53081608, 12.83881567, 11.20389692>, <7.39060512, 13.71673988, 11.34682132>,
            <8.22619121, 12.19587214, 10.56784471>, <8.11715572, 12.41770607, 10.79777954>, <7.86780597, 12.88340901, 11.26876699>, <7.72802379, 13.75864841, 11.41125431>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.72802379, 13.75864841, 11.41125431>, <7.66252385, 14.46085708, 11.17217487>, <7.77310792, 15.05845841, 10.48050582>, <7.81360823, 15.27384812, 10.29837578>,
            <8.06544247, 13.80055694, 11.47568730>, <8.00149855, 14.48324189, 11.23815935>, <8.07263854, 15.08244759, 10.69290774>, <8.13043434, 15.29557438, 10.44857151>,
            <8.71121136, 13.87318422, 11.59083334>, <8.71025950, 14.64395678, 11.39396419>, <8.76111368, 15.27106698, 11.00957252>, <8.87973234, 15.41081940, 10.68118917>,
            <8.93531902, 13.88537230, 11.64242786>, <8.93795974, 14.65658692, 11.44735501>, <8.99173821, 15.28433851, 11.06442549>, <9.11100885, 15.42429943, 10.73636813>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.81360823, 15.27384812, 10.29837578>, <7.85410855, 15.48923784, 10.11624574>, <8.07976072, 15.55478818, 9.25909217>, <8.12248245, 15.41154967, 9.10222012>,
            <8.13043434, 15.29557438, 10.44857151>, <8.18823014, 15.50870117, 10.20423529>, <8.41319013, 15.57405043, 9.34971105>, <8.47231501, 15.42960477, 9.13086780>,
            <8.87973234, 15.41081940, 10.68118917>, <8.99835099, 15.55057182, 10.35280582>, <9.17115429, 15.61044280, 9.58673019>, <9.26173280, 15.47919382, 9.22758670>,
            <9.11100885, 15.42429943, 10.73636813>, <9.23027949, 15.56426035, 10.40831077>, <9.39529550, 15.62390206, 9.63834149>, <9.48587401, 15.49265307, 9.27919800>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.12248245, 15.41154967, 9.10222012>, <8.16520418, 15.26831117, 8.94534807>, <8.44327409, 14.75810431, 8.19917445>, <8.54040854, 14.43321206, 8.04830942>,
            <8.47231501, 15.42960477, 9.13086780>, <8.53143989, 15.28515910, 8.91202455>, <8.76951190, 14.78056644, 8.31240884>, <8.86567085, 14.46535559, 8.16159754>,
            <9.26173280, 15.47919382, 9.22758670>, <9.35231131, 15.34794483, 8.86844321>, <9.33624594, 14.89256483, 8.47585863>, <9.39989730, 14.53104748, 8.33834848>,
            <9.48587401, 15.49265307, 9.27919800>, <9.57645252, 15.36140409, 8.92005451>, <9.57388921, 14.91353533, 8.53422096>, <9.63292399, 14.55215690, 8.39440252>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.54040854, 14.43321206, 8.04830942>, <8.63754300, 14.10831981, 7.89744439>, <8.73702033, 13.23092523, 7.94718305>, <8.72610039, 12.83305322, 8.14017849>,
            <8.86567085, 14.46535559, 8.16159754>, <8.96182980, 14.15014474, 8.01078623>, <9.06100198, 13.27544158, 8.06037232>, <9.05011553, 12.87879004, 8.25277575>,
            <9.39989730, 14.53104748, 8.33834848>, <9.46354866, 14.16953013, 8.20083832>, <9.52408729, 13.38904837, 8.23858619>, <9.51192813, 13.08671334, 8.40820346>,
            <9.63292399, 14.55215690, 8.39440252>, <9.69195877, 14.19077847, 8.25458407>, <9.74251588, 13.40944161, 8.28734118>, <9.72648334, 13.10624034, 8.45502176>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.72610039, 12.83305322, 8.14017849>, <8.71518045, 12.43518120, 8.33317393>, <8.64357583, 12.12310463, 9.00120234>, <8.61202149, 11.99417380, 9.24589684>,
            <9.05011553, 12.87879004, 8.25277575>, <9.03922909, 12.48213851, 8.44517917>, <8.96560673, 12.18784972, 9.11011503>, <8.93717327, 12.05912626, 9.34436806>,
            <9.51192813, 13.08671334, 8.40820346>, <9.49976896, 12.78437832, 8.57782072>, <9.54343152, 12.37940856, 8.99234579>, <9.44691167, 12.26730895, 9.35086515>,
            <9.72648334, 13.10624034, 8.45502176>, <9.71045080, 12.80303908, 8.62270234>, <9.74890001, 12.39494703, 9.03462074>, <9.66171652, 12.28180781, 9.39780828>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.61202149, 11.99417380, 9.24589684>, <8.58046715, 11.86524296, 9.49059134>, <8.33522669, 11.97403820, 10.33790988>, <8.22619121, 12.19587214, 10.56784471>,
            <8.93717327, 12.05912626, 9.34436806>, <8.90873981, 11.93040281, 9.57862109>, <8.66425164, 12.03886432, 10.42334047>, <8.55769748, 12.25971143, 10.64319574>,
            <9.44691167, 12.26730895, 9.35086515>, <9.35039182, 12.15520934, 9.70938451>, <9.16951753, 12.25092601, 10.46993708>, <9.08194124, 12.45336497, 10.79747733>,
            <9.66171652, 12.28180781, 9.39780828>, <9.57453304, 12.16866859, 9.76099582>, <9.38607057, 12.26363390, 10.51775429>, <9.29943563, 12.46571244, 10.84576522>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.22619121, 12.19587214, 10.56784471>, <8.11715572, 12.41770607, 10.79777954>, <7.86780597, 12.88340901, 11.26876699>, <7.72802379, 13.75864841, 11.41125431>,
            <8.55769748, 12.25971143, 10.64319574>, <8.45114333, 12.48055854, 10.86305100>, <8.20479587, 12.92800235, 11.33363707>, <8.06544247, 13.80055694, 11.47568730>,
            <9.08194124, 12.45336497, 10.79747733>, <8.99436495, 12.65580393, 11.12501758>, <8.78546133, 13.19426111, 11.44542568>, <8.71121136, 13.87318422, 11.59083334>,
            <9.29943563, 12.46571244, 10.84576522>, <9.21280069, 12.66779098, 11.17377614>, <9.00640638, 13.20646041, 11.49543890>, <8.93531902, 13.88537230, 11.64242786>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.93531902, 13.88537230, 11.64242786>, <8.93795974, 14.65658692, 11.44735501>, <8.99173821, 15.28433851, 11.06442549>, <9.11100885, 15.42429943, 10.73636813>,
            <9.15942668, 13.89756039, 11.69402239>, <9.16565999, 14.66921706, 11.50074583>, <9.22236274, 15.29761004, 11.11927845>, <9.34228537, 15.43777946, 10.79154708>,
            <11.59546506, 13.99329142, 12.02241468>, <11.62973128, 14.67626115, 11.85873439>, <11.68658384, 15.23287533, 11.53600701>, <11.73512455, 15.39927493, 11.23305781>,
            <12.70409559, 13.96663148, 12.11185704>, <12.76072595, 14.59696968, 11.96678663>, <12.83192891, 15.11177612, 11.63067067>, <12.87557377, 15.26708996, 11.35131965>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.11100885, 15.42429943, 10.73636813>, <9.23027949, 15.56426035, 10.40831077>, <9.39529550, 15.62390206, 9.63834149>, <9.48587401, 15.49265307, 9.27919800>,
            <9.34228537, 15.43777946, 10.79154708>, <9.46220800, 15.57794888, 10.46381572>, <9.61943671, 15.63736131, 9.68995279>, <9.71001522, 15.50611233, 9.33080930>,
            <11.73512455, 15.39927493, 11.23305781>, <11.78366525, 15.56567454, 10.93010861>, <11.88920390, 15.62112414, 10.24424427>, <11.93717460, 15.50608105, 9.92005225>,
            <12.87557377, 15.26708996, 11.35131965>, <12.91921863, 15.42240381, 11.07196864>, <13.00012540, 15.47802235, 10.43635514>, <13.03049660, 15.37416803, 10.13451981>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.48587401, 15.49265307, 9.27919800>, <9.57645252, 15.36140409, 8.92005451>, <9.57388921, 14.91353533, 8.53422096>, <9.63292399, 14.55215690, 8.39440252>,
            <9.71001522, 15.50611233, 9.33080930>, <9.80059373, 15.37486334, 8.97166581>, <9.81153248, 14.93450583, 8.59258330>, <9.86595068, 14.57326631, 8.45045656>,
            <11.93717460, 15.50608105, 9.92005225>, <11.98514529, 15.39103795, 9.59586022>, <12.02498019, 14.91960075, 9.29329496>, <12.04103866, 14.60026089, 9.15985057>,
            <13.03049660, 15.37416803, 10.13451981>, <13.06086780, 15.27031370, 9.83268448>, <13.07606230, 14.83762334, 9.46283574>, <13.07340692, 14.54427949, 9.33590638>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.63292399, 14.55215690, 8.39440252>, <9.69195877, 14.19077847, 8.25458407>, <9.74251588, 13.40944161, 8.28734118>, <9.72648334, 13.10624034, 8.45502176>,
            <9.86595068, 14.57326631, 8.45045656>, <9.92036887, 14.21202680, 8.30832982>, <9.96094447, 13.42983485, 8.33609617>, <9.94103855, 13.12576734, 8.50184006>,
            <12.04103866, 14.60026089, 9.15985057>, <12.05709712, 14.28092102, 9.02640617>, <12.04589440, 13.58838238, 9.03827929>, <12.01959258, 13.27448951, 9.18258005>,
            <13.07340692, 14.54427949, 9.33590638>, <13.07075155, 14.25093563, 9.20897701>, <13.03081168, 13.61278368, 9.21314681>, <12.99694745, 13.32262406, 9.34388889>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.72648334, 13.10624034, 8.45502176>, <9.71045080, 12.80303908, 8.62270234>, <9.74890001, 12.39494703, 9.03462074>, <9.66171652, 12.28180781, 9.39780828>,
            <9.94103855, 13.12576734, 8.50184006>, <9.92113264, 12.82169984, 8.66758396>, <9.95436851, 12.41048549, 9.07689568>, <9.87652138, 12.29630667, 9.44475140>,
            <12.01959258, 13.27448951, 9.18258005>, <11.99329075, 12.96059663, 9.32688081>, <11.93840065, 12.50133986, 9.64540221>, <11.88691489, 12.39908560, 9.97331965>,
            <12.99694745, 13.32262406, 9.34388889>, <12.96308323, 13.03246444, 9.47463098>, <12.89421405, 12.60755041, 9.85008346>, <12.85131094, 12.51117226, 10.15322715>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.66171652, 12.28180781, 9.39780828>, <9.57453304, 12.16866859, 9.76099582>, <9.38607057, 12.26363390, 10.51775429>, <9.29943563, 12.46571244, 10.84576522>,
            <9.87652138, 12.29630667, 9.44475140>, <9.79867425, 12.18212784, 9.81260712>, <9.60262361, 12.27634178, 10.56557150>, <9.51693002, 12.47805991, 10.89405311>,
            <11.88691489, 12.39908560, 9.97331965>, <11.83542913, 12.29683133, 10.30123710>, <11.73211884, 12.37913624, 10.98473973>, <11.68915194, 12.55730255, 11.28178157>,
            <12.85131094, 12.51117226, 10.15322715>, <12.80840783, 12.41479410, 10.45637083>, <12.73544560, 12.48611187, 11.09115490>, <12.71167244, 12.64830437, 11.36843127>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.29943563, 12.46571244, 10.84576522>, <9.21280069, 12.66779098, 11.17377614>, <9.00640638, 13.20646041, 11.49543890>, <8.93531902, 13.88537230, 11.64242786>,
            <9.51693002, 12.47805991, 10.89405311>, <9.43123643, 12.67977803, 11.22253471>, <9.22735143, 13.21865971, 11.54545212>, <9.15942668, 13.89756039, 11.69402239>,
            <11.68915194, 12.55730255, 11.28178157>, <11.64618503, 12.73546887, 11.57882342>, <11.60753904, 13.30436294, 11.88225469>, <11.59546506, 13.99329142, 12.02241468>,
            <12.71167244, 12.64830437, 11.36843127>, <12.68789927, 12.81049687, 11.64570764>, <12.68160627, 13.33280988, 11.97504688>, <12.70409559, 13.96663148, 12.11185704>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.70409559, 13.96663148, 12.11185704>, <12.76072595, 14.59696968, 11.96678663>, <12.83192891, 15.11177612, 11.63067067>, <12.87557377, 15.26708996, 11.35131965>,
            <13.81272613, 13.93997154, 12.20129941>, <13.89172062, 14.51767821, 12.07483887>, <13.97727399, 14.99067690, 11.72533432>, <14.01602300, 15.13490499, 11.46958149>,
            <16.27309640, 13.58029617, 12.03106431>, <15.46220660, 14.21068046, 12.01145182>, <15.53244114, 14.61621012, 11.71802291>, <15.55673611, 14.74220466, 11.50126922>,
            <16.40006487, 13.54638838, 11.99910385>, <15.98440305, 14.08023353, 11.94440202>, <16.04980608, 14.45786632, 11.67115843>, <16.07242977, 14.57519355, 11.46931549>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.87557377, 15.26708996, 11.35131965>, <12.91921863, 15.42240381, 11.07196864>, <13.00012540, 15.47802235, 10.43635514>, <13.03049660, 15.37416803, 10.13451981>,
            <14.01602300, 15.13490499, 11.46958149>, <14.05477202, 15.27913308, 11.21382866>, <14.11104689, 15.33492057, 10.62846601>, <14.12381861, 15.24225501, 10.34898738>,
            <15.55673611, 14.74220466, 11.50126922>, <15.58103108, 14.86819920, 11.28451553>, <15.59981553, 14.92456175, 10.78564887>, <15.59277048, 14.85057029, 10.54626502>,
            <16.07242977, 14.57519355, 11.46931549>, <16.09505346, 14.69252078, 11.26747254>, <16.11254570, 14.74500608, 10.80292351>, <16.10598529, 14.67610458, 10.58000716>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <13.03049660, 15.37416803, 10.13451981>, <13.06086780, 15.27031370, 9.83268448>, <13.07606230, 14.83762334, 9.46283574>, <13.07340692, 14.54427949, 9.33590638>,
            <14.12381861, 15.24225501, 10.34898738>, <14.13659032, 15.14958945, 10.06950874>, <14.12714440, 14.75564593, 9.63237652>, <14.10577519, 14.48829808, 9.51196218>,
            <15.59277048, 14.85057029, 10.54626502>, <15.58572542, 14.77657884, 10.30688117>, <15.54128265, 14.45024706, 9.92995169>, <15.95205816, 14.15539694, 9.83327250>,
            <16.10598529, 14.67610458, 10.58000716>, <16.09942487, 14.60720309, 10.35709081>, <16.05803937, 14.30332006, 10.00609075>, <16.27130850, 14.05565340, 9.91272854>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <13.07340692, 14.54427949, 9.33590638>, <13.07075155, 14.25093563, 9.20897701>, <13.03081168, 13.61278368, 9.21314681>, <12.99694745, 13.32262406, 9.34388889>,
            <14.10577519, 14.48829808, 9.51196218>, <14.08440597, 14.22095024, 9.39154785>, <14.01572895, 13.63718498, 9.38801433>, <13.97430233, 13.37075861, 9.50519774>,
            <15.95205816, 14.15539694, 9.83327250>, <16.36283367, 13.86054682, 9.73659331>, <15.39586898, 13.50811582, 9.71019111>, <15.35784560, 13.28094229, 9.80748645>,
            <16.27130850, 14.05565340, 9.91272854>, <16.48457763, 13.80798674, 9.81936633>, <15.92262888, 13.42599915, 9.80144776>, <15.88722117, 13.21445315, 9.89205004>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.99694745, 13.32262406, 9.34388889>, <12.96308323, 13.03246444, 9.47463098>, <12.89421405, 12.60755041, 9.85008346>, <12.85131094, 12.51117226, 10.15322715>,
            <13.97430233, 13.37075861, 9.50519774>, <13.93287571, 13.10433224, 9.62238114>, <13.85002744, 12.71376097, 10.05476472>, <13.81570698, 12.62325892, 10.33313464>,
            <15.35784560, 13.28094229, 9.80748645>, <15.31982221, 13.05376875, 9.90478179>, <15.25905240, 12.71665428, 10.26975343>, <15.24153254, 12.63574507, 10.50634537>,
            <15.88722117, 13.21445315, 9.89205004>, <15.85181346, 13.00290715, 9.98265232>, <15.79522407, 12.68898318, 10.32251712>, <15.77890942, 12.61363981, 10.54283363>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.85131094, 12.51117226, 10.15322715>, <12.80840783, 12.41479410, 10.45637083>, <12.73544560, 12.48611187, 11.09115490>, <12.71167244, 12.64830437, 11.36843127>,
            <13.81570698, 12.62325892, 10.33313464>, <13.78138652, 12.53275687, 10.61150456>, <13.73877236, 12.59308751, 11.19757007>, <13.73419294, 12.73930619, 11.45508097>,
            <15.24153254, 12.63574507, 10.50634537>, <15.22401267, 12.55483586, 10.74293732>, <15.22080102, 12.59667177, 11.24357389>, <15.23545836, 12.71630143, 11.46475467>,
            <15.77890942, 12.61363981, 10.54283363>, <15.76259477, 12.53829644, 10.76315013>, <15.75960405, 12.57725440, 11.22934733>, <15.77325309, 12.68865460, 11.43531282>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.71167244, 12.64830437, 11.36843127>, <12.68789927, 12.81049687, 11.64570764>, <12.68160627, 13.33280988, 11.97504688>, <12.70409559, 13.96663148, 12.11185704>,
            <13.73419294, 12.73930619, 11.45508097>, <13.72961351, 12.88552488, 11.71259187>, <13.75567350, 13.36125681, 12.06783907>, <13.81272613, 13.93997154, 12.20129941>,
            <15.23545836, 12.71630143, 11.46475467>, <15.25011569, 12.83593110, 11.68593545>, <15.30711699, 13.23272128, 11.99382525>, <15.38222151, 13.72008926, 12.11352530>,
            <15.77325309, 12.68865460, 11.43531282>, <15.78690213, 12.80005480, 11.64127831>, <15.83998225, 13.16954931, 11.92798800>, <15.90992023, 13.62339068, 12.03945374>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.40006487, 13.54638838, 11.99910385>, <15.98440305, 14.08023353, 11.94440202>, <16.04980608, 14.45786632, 11.67115843>, <16.07242977, 14.57519355, 11.46931549>,
            <16.52703333, 13.51248058, 11.96714339>, <16.50659951, 13.94978660, 11.87735222>, <16.56717102, 14.29952253, 11.62429395>, <16.58812343, 14.40818244, 11.43736175>,
            <17.88038817, 13.33706747, 11.38394497>, <17.91384688, 13.55432809, 11.43840421>, <17.94515858, 13.73511978, 11.30758885>, <17.95598967, 13.79129018, 11.21095654>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.07242977, 14.57519355, 11.46931549>, <16.09505346, 14.69252078, 11.26747254>, <16.11254570, 14.74500608, 10.80292351>, <16.10598529, 14.67610458, 10.58000716>,
            <16.58812343, 14.40818244, 11.43736175>, <16.60907584, 14.51684235, 11.25042955>, <16.62527588, 14.56545041, 10.82019814>, <16.61920010, 14.50163887, 10.61374929>,
            <17.95598967, 13.79129018, 11.21095654>, <17.96682076, 13.84746059, 11.11432424>, <17.97519517, 13.87258792, 10.89192141>, <17.97205437, 13.83960133, 10.78520021>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.10598529, 14.67610458, 10.58000716>, <16.09942487, 14.60720309, 10.35709081>, <16.05803937, 14.30332006, 10.00609075>, <16.27130850, 14.05565340, 9.91272854>,
            <16.61920010, 14.50163887, 10.61374929>, <16.61312432, 14.43782734, 10.40730044>, <16.57479609, 14.15639305, 10.08222981>, <16.59055885, 13.95590986, 9.99218458>,
            <17.97205437, 13.83960133, 10.78520021>, <17.96891357, 13.80661475, 10.67847902>, <17.94910027, 13.66113075, 10.51043775>, <17.98240866, 13.55259323, 10.51438985>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.27130850, 14.05565340, 9.91272854>, <16.48457763, 13.80798674, 9.81936633>, <15.92262888, 13.42599915, 9.80144776>, <15.88722117, 13.21445315, 9.89205004>,
            <16.59055885, 13.95590986, 9.99218458>, <16.60632160, 13.75542666, 9.90213936>, <16.44938878, 13.34388247, 9.89270441>, <16.41659674, 13.14796400, 9.97661363>,
            <17.98240866, 13.55259323, 10.51438985>, <18.01571705, 13.44405570, 10.51834194>, <17.98081422, 13.22396653, 10.51437509>, <17.91559192, 13.13126232, 10.50679585>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <15.88722117, 13.21445315, 9.89205004>, <15.85181346, 13.00290715, 9.98265232>, <15.79522407, 12.68898318, 10.32251712>, <15.77890942, 12.61363981, 10.54283363>,
            <16.41659674, 13.14796400, 9.97661363>, <16.38380471, 12.95204554, 10.06052284>, <16.33139575, 12.66131208, 10.37528082>, <16.31628631, 12.59153455, 10.57932188>,
            <17.91559192, 13.13126232, 10.50679585>, <17.85036962, 13.03855812, 10.49921661>, <17.82327745, 12.88826704, 10.66192687>, <17.81546681, 12.85219640, 10.76740339>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <15.77890942, 12.61363981, 10.54283363>, <15.76259477, 12.53829644, 10.76315013>, <15.75960405, 12.57725440, 11.22934733>, <15.77325309, 12.68865460, 11.43531282>,
            <16.31628631, 12.59153455, 10.57932188>, <16.30117687, 12.52175701, 10.78336295>, <16.29840709, 12.55783704, 11.21512076>, <16.31104783, 12.66100777, 11.40587096>,
            <17.81546681, 12.85219640, 10.76740339>, <17.80765617, 12.81612576, 10.87287991>, <17.80622437, 12.83477689, 11.09607180>, <17.81275884, 12.88810973, 11.19467777>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <15.77325309, 12.68865460, 11.43531282>, <15.78690213, 12.80005480, 11.64127831>, <15.83998225, 13.16954931, 11.92798800>, <15.90992023, 13.62339068, 12.03945374>,
            <16.31104783, 12.66100777, 11.40587096>, <16.32368857, 12.76417851, 11.59662116>, <16.37284750, 13.10637735, 11.86215075>, <16.43761896, 13.52669209, 11.96538219>,
            <17.81275884, 12.88810973, 11.19467777>, <17.81929332, 12.94144257, 11.29328374>, <17.84470542, 13.11833805, 11.43054599>, <17.87818823, 13.33561459, 11.48391021>,
            <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>, <18.45403199, 13.25393186, 10.94920581>
        }
    }
    
    texture { Dolphin_Skin }
}

union {  // Layer name: dolphin3
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.28229795, 4.66299942, -14.84418894>, <14.81476371, 4.28241960, -14.32568225>, <12.94825804, 4.24420066, -15.35683364>, <12.37621754, 4.15294119, -15.37121010>,
            <16.27595261, 4.70118743, -14.83411853>, <14.80841837, 4.32060760, -14.31561185>, <12.94191269, 4.28238866, -15.34676324>, <12.36987220, 4.19112919, -15.36113969>,
            <16.24650362, 4.65312860, -14.82931170>, <14.47105930, 4.48442106, -14.91105623>, <13.23615460, 4.43453054, -15.49997730>, <12.65618242, 4.39100607, -15.50176574>,
            <16.28229795, 4.66299942, -14.84418894>, <14.76842627, 4.58683742, -15.31066075>, <13.52142732, 4.59821029, -15.94091768>, <13.15636537, 4.59669323, -16.06588879>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.37621754, 4.15294119, -15.37121010>, <11.80417704, 4.06168172, -15.38558655>, <10.93988911, 4.29474813, -16.81398394>, <11.30508638, 4.46633731, -17.23455734>,
            <12.36987220, 4.19112919, -15.36113969>, <11.79783170, 4.09986972, -15.37551614>, <10.93354377, 4.33293613, -16.80391353>, <11.29874103, 4.50452531, -17.22448693>,
            <12.65618242, 4.39100607, -15.50176574>, <12.07621024, 4.34748160, -15.50355419>, <11.21192232, 4.58054801, -16.93195157>, <11.58505126, 4.70440218, -17.36511299>,
            <13.15636537, 4.59669323, -16.06588879>, <12.79130342, 4.59517618, -16.19085990>, <12.20900774, 4.75219973, -17.15321238>, <12.32049636, 4.83437199, -17.49386998>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.30508638, 4.46633731, -17.23455734>, <11.67028364, 4.63792649, -17.65513075>, <11.08468712, 5.14849480, -19.96024042>, <12.49352496, 5.69075449, -21.12883795>,
            <11.29874103, 4.50452531, -17.22448693>, <11.66393830, 4.67611449, -17.64506034>, <11.07834178, 5.18668280, -19.95017001>, <12.48717961, 5.72894249, -21.11876754>,
            <11.58505126, 4.70440218, -17.36511299>, <11.95818020, 4.82825636, -17.79827440>, <11.68308756, 5.23409355, -19.51058524>, <12.46159358, 5.67979164, -21.10738560>,
            <12.32049636, 4.83437199, -17.49386998>, <12.43198497, 4.91654426, -17.83452758>, <12.21656861, 5.27218001, -19.51746929>, <12.49352496, 5.69075449, -21.12883795>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.28229795, 4.66299942, -14.84418894>, <14.76842627, 4.58683742, -15.31066075>, <13.52142732, 4.59821029, -15.94091768>, <13.15636537, 4.59669323, -16.06588879>,
            <16.31809229, 4.67287025, -14.85906618>, <15.06579324, 4.68925378, -15.71026527>, <13.80670003, 4.76189005, -16.38185805>, <13.65654831, 4.80238040, -16.63001184>,
            <16.27595261, 4.70118743, -14.83411853>, <15.38159691, 4.81627924, -15.83409002>, <13.76107874, 4.89624973, -17.15843141>, <13.58690303, 4.86956319, -17.16698112>,
            <16.28229795, 4.66299942, -14.84418894>, <15.38794226, 4.77809124, -15.84416043>, <13.76742409, 4.85806173, -17.16850182>, <13.59324837, 4.83137519, -17.17705152>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <13.15636537, 4.59669323, -16.06588879>, <12.79130342, 4.59517618, -16.19085990>, <12.20900774, 4.75219973, -17.15321238>, <12.32049636, 4.83437199, -17.49386998>,
            <13.65654831, 4.80238040, -16.63001184>, <13.50639660, 4.84287075, -16.87816562>, <13.20609316, 4.92385145, -17.37447318>, <13.05594145, 4.96434180, -17.62262697>,
            <13.58690303, 4.86956319, -17.16698112>, <13.41272731, 4.84287665, -17.17553082>, <13.36878047, 4.85472748, -17.24816120>, <13.44773802, 4.90709083, -17.39697730>,
            <13.59324837, 4.83137519, -17.17705152>, <13.41907266, 4.80468865, -17.18560123>, <13.37512581, 4.81653948, -17.25823161>, <13.45408337, 4.86890283, -17.40704771>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.32049636, 4.83437199, -17.49386998>, <12.43198497, 4.91654426, -17.83452758>, <12.21656861, 5.27218001, -19.51746929>, <12.49352496, 5.69075449, -21.12883795>,
            <13.05594145, 4.96434180, -17.62262697>, <12.90578973, 5.00483215, -17.87078075>, <12.75004966, 5.31026647, -19.52435333>, <12.52545633, 5.70171734, -21.15029029>,
            <13.44773802, 4.90709083, -17.39697730>, <13.52669558, 4.95945418, -17.54579341>, <13.03108672, 5.44712014, -19.70735400>, <12.48717961, 5.72894249, -21.11876754>,
            <13.45408337, 4.86890283, -17.40704771>, <13.53304092, 4.92126618, -17.55586382>, <13.03743206, 5.40893214, -19.71742441>, <12.49352496, 5.69075449, -21.12883795>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.28229795, 4.66299942, -14.84418894>, <15.38794226, 4.77809124, -15.84416043>, <13.76742409, 4.85806173, -17.16850182>, <13.59324837, 4.83137519, -17.17705152>,
            <16.28864330, 4.62481142, -14.85425935>, <15.39428760, 4.73990324, -15.85423084>, <13.77376943, 4.81987373, -17.17857222>, <13.59959372, 4.79318719, -17.18712193>,
            <16.31809229, 4.67287025, -14.85906618>, <15.06579324, 4.68925378, -15.71026527>, <13.75404899, 4.54460008, -16.38545463>, <13.60389728, 4.58509043, -16.63360841>,
            <16.28229795, 4.66299942, -14.84418894>, <14.78428963, 4.49136741, -15.33583677>, <13.51889684, 4.34636030, -15.98047999>, <13.15780073, 4.32097574, -16.11174511>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <13.59324837, 4.83137519, -17.17705152>, <13.41907266, 4.80468865, -17.18560123>, <13.37512581, 4.81653948, -17.25823161>, <13.45408337, 4.86890283, -17.40704771>,
            <13.59959372, 4.79318719, -17.18712193>, <13.42541800, 4.76650064, -17.19567164>, <13.38147116, 4.77835148, -17.26830202>, <13.46042871, 4.83071483, -17.41711812>,
            <13.60389728, 4.58509043, -16.63360841>, <13.45374556, 4.62558078, -16.88176219>, <13.15344213, 4.70656148, -17.37806976>, <13.00329041, 4.74705183, -17.62622354>,
            <13.15780073, 4.32097574, -16.11174511>, <12.79670462, 4.29559118, -16.24301023>, <12.21440894, 4.45261473, -17.20536270>, <12.32193172, 4.55865450, -17.53972630>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <13.45408337, 4.86890283, -17.40704771>, <13.53304092, 4.92126618, -17.55586382>, <13.03743206, 5.40893214, -19.71742441>, <12.49352496, 5.69075449, -21.12883795>,
            <13.46042871, 4.83071483, -17.41711812>, <13.53938627, 4.88307818, -17.56593423>, <13.04377740, 5.37074413, -19.72749482>, <12.49987030, 5.65256649, -21.13890835>,
            <13.00329041, 4.74705183, -17.62622354>, <12.85313870, 4.78754218, -17.87437732>, <12.75004966, 5.31026647, -19.52435333>, <12.52545633, 5.70171734, -21.15029029>,
            <12.32193172, 4.55865450, -17.53972630>, <12.42945449, 4.66469426, -17.87408989>, <12.23243197, 5.17671001, -19.54264531>, <12.49352496, 5.69075449, -21.12883795>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <16.28229795, 4.66299942, -14.84418894>, <16.28864330, 4.62481142, -14.85425935>, <16.24650362, 4.65312860, -14.82931170>, <16.28229795, 4.66299942, -14.84418894>,
            <14.81476371, 4.28241960, -14.32568225>, <14.82110906, 4.24423160, -14.33575266>, <14.50278602, 4.29348105, -14.96140827>, <14.78428963, 4.49136741, -15.33583677>,
            <12.94825804, 4.24420066, -15.35683364>, <12.95460338, 4.20601266, -15.36690405>, <13.28374468, 4.14812052, -15.57550536>, <13.51889684, 4.34636030, -15.98047999>,
            <12.37621754, 4.15294119, -15.37121010>, <12.38256288, 4.11475319, -15.38128051>, <12.71170418, 4.05686105, -15.58988181>, <13.15780073, 4.32097574, -16.11174511>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.37621754, 4.15294119, -15.37121010>, <12.38256288, 4.11475319, -15.38128051>, <12.71170418, 4.05686105, -15.58988181>, <13.15780073, 4.32097574, -16.11174511>,
            <11.80417704, 4.06168172, -15.38558655>, <11.81052238, 4.02349372, -15.39565696>, <12.13966368, 3.96560158, -15.60425827>, <12.79670462, 4.29559118, -16.24301023>,
            <10.93988911, 4.29474813, -16.81398394>, <10.94623446, 4.25656012, -16.82405434>, <11.27537576, 4.19866799, -17.03265565>, <12.21440894, 4.45261473, -17.20536270>,
            <11.30508638, 4.46633731, -17.23455734>, <11.31143172, 4.42814930, -17.24462775>, <11.64057302, 4.37025717, -17.45322906>, <12.32193172, 4.55865450, -17.53972630>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.30508638, 4.46633731, -17.23455734>, <11.31143172, 4.42814930, -17.24462775>, <11.64057302, 4.37025717, -17.45322906>, <12.32193172, 4.55865450, -17.53972630>,
            <11.67028364, 4.63792649, -17.65513075>, <11.67662898, 4.59973848, -17.66520115>, <12.00577028, 4.54184635, -17.87380246>, <12.42945449, 4.66469426, -17.87408989>,
            <11.08468712, 5.14849480, -19.96024042>, <11.09103247, 5.11030679, -19.97031082>, <11.71481428, 5.04315354, -19.56093728>, <12.23243197, 5.17671001, -19.54264531>,
            <12.49352496, 5.69075449, -21.12883795>, <12.49987030, 5.65256649, -21.13890835>, <12.46159358, 5.67979164, -21.10738560>, <12.49352496, 5.69075449, -21.12883795>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.99675084, 4.67336768, -9.19137022>, <-0.32359531, 4.58875826, -9.90693119>, <-0.96160600, 4.57454360, -9.89142248>, <-0.96418111, 4.52573140, -9.88089925>,
            <0.99675084, 4.67336768, -9.19137022>, <-1.48070342, 4.36819940, -11.21315056>, <-1.83179957, 4.36854500, -11.05989370>, <-1.83437468, 4.31973280, -11.04937047>,
            <0.99675084, 4.67336768, -9.19137022>, <-1.48738536, 4.29478545, -11.55531766>, <-1.84394854, 4.23506508, -11.68201571>, <-1.84652365, 4.18625289, -11.67149248>,
            <0.99675084, 4.67336768, -9.19137022>, <-1.41774977, 4.26081216, -11.69586303>, <-1.37131831, 3.97085826, -12.79188782>, <-1.37389342, 3.92204607, -12.78136459>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.96418111, 4.52573140, -9.88089925>, <-0.96675622, 4.47691921, -9.87037602>, <-0.33389576, 4.39350948, -9.86483827>, <0.98645039, 4.47811890, -9.14927730>,
            <-1.83437468, 4.31973280, -11.04937047>, <-1.83694979, 4.27092061, -11.03884724>, <-1.49100387, 4.17295062, -11.17105764>, <0.98645039, 4.47811890, -9.14927730>,
            <-1.84652365, 4.18625289, -11.67149248>, <-1.84909876, 4.13744069, -11.66096925>, <-1.49768581, 4.09953667, -11.51322475>, <0.98645039, 4.47811890, -9.14927730>,
            <-1.37389342, 3.92204607, -12.78136459>, <-1.37646853, 3.87323387, -12.77084136>, <-1.42805023, 4.06556338, -11.65377011>, <0.98645039, 4.47811890, -9.14927730>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.99675084, 4.67336768, -9.19137022>, <-1.41774977, 4.26081216, -11.69586303>, <-1.37131831, 3.97085826, -12.79188782>, <-1.37389342, 3.92204607, -12.78136459>,
            <0.99675084, 4.67336768, -9.19137022>, <-1.34811419, 4.22683888, -11.83640839>, <-0.89868808, 3.70665144, -13.90175994>, <-0.90126319, 3.65783925, -13.89123671>,
            <0.99675084, 4.67336768, -9.19137022>, <-1.06517905, 4.25614770, -11.63122255>, <-0.99805113, 4.17410381, -11.75778829>, <-1.00062624, 4.12529161, -11.74726506>,
            <0.99675084, 4.67336768, -9.19137022>, <0.33836836, 4.45583649, -10.36150382>, <0.46890213, 4.31034938, -10.76683627>, <0.46632702, 4.26153718, -10.75631304>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.37389342, 3.92204607, -12.78136459>, <-1.37646853, 3.87323387, -12.77084136>, <-1.42805023, 4.06556338, -11.65377011>, <0.98645039, 4.47811890, -9.14927730>,
            <-0.90126319, 3.65783925, -13.89123671>, <-0.90383830, 3.60902705, -13.88071348>, <-1.35841464, 4.03159010, -11.79431547>, <0.98645039, 4.47811890, -9.14927730>,
            <-1.00062624, 4.12529161, -11.74726506>, <-1.00320136, 4.07647942, -11.73674183>, <-1.07547951, 4.06089892, -11.58912964>, <0.98645039, 4.47811890, -9.14927730>,
            <0.46632702, 4.26153718, -10.75631304>, <0.46375190, 4.21272499, -10.74578981>, <0.32806791, 4.26058771, -10.31941090>, <0.98645039, 4.47811890, -9.14927730>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.99675084, 4.67336768, -9.19137022>, <0.33836836, 4.45583649, -10.36150382>, <0.46890213, 4.31034938, -10.76683627>, <0.46632702, 4.26153718, -10.75631304>,
            <0.99675084, 4.67336768, -9.19137022>, <1.74191577, 4.65552529, -9.09178508>, <1.93585539, 4.44659494, -9.77588425>, <1.93328028, 4.39778275, -9.76536102>,
            <0.99675084, 4.67336768, -9.19137022>, <1.60199014, 4.67730319, -9.02500870>, <1.75839165, 4.95863606, -8.86961661>, <1.73779075, 4.56813850, -8.78543078>,
            <0.99675084, 4.67336768, -9.19137022>, <1.39249627, 4.73379587, -8.81423108>, <1.30823959, 5.08002529, -8.41670600>, <1.28763869, 4.68952772, -8.33252017>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.46632702, 4.26153718, -10.75631304>, <0.46375190, 4.21272499, -10.74578981>, <0.32806791, 4.26058771, -10.31941090>, <0.98645039, 4.47811890, -9.14927730>,
            <1.93328028, 4.39778275, -9.76536102>, <1.93070516, 4.34897055, -9.75483779>, <1.73161532, 4.46027651, -9.04969216>, <0.98645039, 4.47811890, -9.14927730>,
            <1.73779075, 4.56813850, -8.78543078>, <1.71718984, 4.17764093, -8.70124494>, <1.59168969, 4.48205441, -8.98291578>, <0.98645039, 4.47811890, -9.14927730>,
            <1.28763869, 4.68952772, -8.33252017>, <1.26703779, 4.29903016, -8.24833433>, <1.38219582, 4.53854709, -8.77213816>, <0.98645039, 4.47811890, -9.14927730>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.99675084, 4.67336768, -9.19137022>, <0.99675084, 4.67336768, -9.19137022>, <0.99675084, 4.67336768, -9.19137022>, <0.99675084, 4.67336768, -9.19137022>,
            <-0.32359531, 4.58875826, -9.90693119>, <0.83351280, 4.80931711, -8.60071182>, <1.18300240, 4.79028855, -8.60345346>, <1.39249627, 4.73379587, -8.81423108>,
            <-0.96160600, 4.57454360, -9.89142248>, <-0.09141242, 4.78054220, -8.72295126>, <0.85808754, 5.20141451, -7.96379540>, <1.30823959, 5.08002529, -8.41670600>,
            <-0.96418111, 4.52573140, -9.88089925>, <-0.09398754, 4.73173000, -8.71242803>, <0.83748664, 4.81091695, -7.87960956>, <1.28763869, 4.68952772, -8.33252017>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.96418111, 4.52573140, -9.88089925>, <-0.09398754, 4.73173000, -8.71242803>, <0.83748664, 4.81091695, -7.87960956>, <1.28763869, 4.68952772, -8.33252017>,
            <-0.96675622, 4.47691921, -9.87037602>, <-0.09656265, 4.68291781, -8.70190480>, <0.81688574, 4.42041938, -7.79542373>, <1.26703779, 4.29903016, -8.24833433>,
            <-0.33389576, 4.39350948, -9.86483827>, <0.82321235, 4.61406833, -8.55861890>, <1.17270195, 4.59503977, -8.56136054>, <1.38219582, 4.53854709, -8.77213816>,
            <0.98645039, 4.47811890, -9.14927730>, <0.98645039, 4.47811890, -9.14927730>, <0.98645039, 4.47811890, -9.14927730>, <0.98645039, 4.47811890, -9.14927730>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.43113365, 4.01690490, -6.59587160>, <3.97589891, 3.42934409, -5.32288168>, <3.89697591, 3.26436421, -4.71128295>, <3.87466080, 3.22087516, -4.72180618>,
            <3.43113365, 4.01690490, -6.59587160>, <5.07300237, 2.60090795, -4.22569802>, <4.89189253, 2.55541454, -3.89120457>, <4.86957742, 2.51192549, -3.90172780>,
            <3.43113365, 4.01690490, -6.59587160>, <5.38467604, 2.44164530, -4.22843965>, <5.45857193, 2.26584608, -3.89618937>, <5.43625682, 2.22235703, -3.90671260>,
            <3.43113365, 4.01690490, -6.59587160>, <5.51862603, 2.39032880, -4.30041406>, <6.51003024, 1.84555079, -4.38892457>, <6.48771513, 1.80206174, -4.39944780>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.87466080, 3.22087516, -4.72180618>, <3.85234569, 3.17738611, -4.73232941>, <3.88663847, 3.25538789, -5.36497460>, <3.34187321, 3.84294870, -6.63796451>,
            <4.86957742, 2.51192549, -3.90172780>, <4.84726231, 2.46843644, -3.91225103>, <4.98374193, 2.42695175, -4.26779093>, <3.34187321, 3.84294870, -6.63796451>,
            <5.43625682, 2.22235703, -3.90671260>, <5.41394171, 2.17886798, -3.91723582>, <5.29541560, 2.26768910, -4.27053257>, <3.34187321, 3.84294870, -6.63796451>,
            <6.48771513, 1.80206174, -4.39944780>, <6.46540002, 1.75857269, -4.40997103>, <5.42936559, 2.21637260, -4.34250698>, <3.34187321, 3.84294870, -6.63796451>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.43113365, 4.01690490, -6.59587160>, <5.51862603, 2.39032880, -4.30041406>, <6.51003024, 1.84555079, -4.38892457>, <6.48771513, 1.80206174, -4.39944780>,
            <3.43113365, 4.01690490, -6.59587160>, <5.65257602, 2.33901231, -4.37238847>, <7.56148855, 1.42525550, -4.88165978>, <7.53917344, 1.38176645, -4.89218301>,
            <3.43113365, 4.01690490, -6.59587160>, <5.48852753, 2.48885603, -4.64376916>, <5.59701404, 2.39565927, -4.72623907>, <5.57469893, 2.35217022, -4.73676230>,
            <3.43113365, 4.01690490, -6.59587160>, <4.44492002, 3.34845178, -5.98316647>, <4.81297054, 3.13891520, -6.13526250>, <4.79065543, 3.09542615, -6.14578573>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.48771513, 1.80206174, -4.39944780>, <6.46540002, 1.75857269, -4.40997103>, <5.42936559, 2.21637260, -4.34250698>, <3.34187321, 3.84294870, -6.63796451>,
            <7.53917344, 1.38176645, -4.89218301>, <7.51685833, 1.33827740, -4.90270624>, <5.56331557, 2.16505611, -4.41448139>, <3.34187321, 3.84294870, -6.63796451>,
            <5.57469893, 2.35217022, -4.73676230>, <5.55238382, 2.30868117, -4.74728553>, <5.39926709, 2.31489983, -4.68586208>, <3.34187321, 3.84294870, -6.63796451>,
            <4.79065543, 3.09542615, -6.14578573>, <4.76834032, 3.05193710, -6.15630896>, <4.35565958, 3.17449558, -6.02525939>, <3.34187321, 3.84294870, -6.63796451>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.43113365, 4.01690490, -6.59587160>, <4.44492002, 3.34845178, -5.98316647>, <4.81297054, 3.13891520, -6.13526250>, <4.79065543, 3.09542615, -6.14578573>,
            <3.43113365, 4.01690490, -6.59587160>, <3.40131250, 4.20804752, -7.32256377>, <4.02892703, 3.88217113, -7.54428593>, <4.00661192, 3.83868208, -7.55480916>,
            <3.43113365, 4.01690490, -6.59587160>, <3.32891675, 4.21161512, -7.18378816>, <3.26244719, 4.55304805, -7.26601751>, <3.08392630, 4.20513565, -7.35020335>,
            <3.43113365, 4.01690490, -6.59587160>, <3.11942310, 4.26810774, -6.97301031>, <2.81229553, 4.67443717, -6.81310648>, <2.63377465, 4.32652477, -6.89729231>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.79065543, 3.09542615, -6.14578573>, <4.76834032, 3.05193710, -6.15630896>, <4.35565958, 3.17449558, -6.02525939>, <3.34187321, 3.84294870, -6.63796451>,
            <4.00661192, 3.83868208, -7.55480916>, <3.98429681, 3.79519303, -7.56533239>, <3.31205206, 4.03409132, -7.36465669>, <3.34187321, 3.84294870, -6.63796451>,
            <3.08392630, 4.20513565, -7.35020335>, <2.90540542, 3.85722325, -7.43438918>, <3.23965631, 4.03765892, -7.22588108>, <3.34187321, 3.84294870, -6.63796451>,
            <2.63377465, 4.32652477, -6.89729231>, <2.45525376, 3.97861237, -6.98147815>, <3.03016265, 4.09415154, -7.01510322>, <3.34187321, 3.84294870, -6.63796451>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.43113365, 4.01690490, -6.59587160>, <3.43113365, 4.01690490, -6.59587160>, <3.43113365, 4.01690490, -6.59587160>, <3.43113365, 4.01690490, -6.59587160>,
            <3.97589891, 3.42934409, -5.32288168>, <2.87879545, 4.25778022, -6.42006534>, <2.90992945, 4.32460036, -6.76223245>, <3.11942310, 4.26810774, -6.97301031>,
            <3.89697591, 3.26436421, -4.71128295>, <2.90205928, 3.97331387, -5.53136132>, <2.36214388, 4.79582629, -6.36019545>, <2.81229553, 4.67443717, -6.81310648>,
            <3.87466080, 3.22087516, -4.72180618>, <2.87974417, 3.92982482, -5.54188455>, <2.18362299, 4.44791389, -6.44438128>, <2.63377465, 4.32652477, -6.89729231>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.87466080, 3.22087516, -4.72180618>, <2.87974417, 3.92982482, -5.54188455>, <2.18362299, 4.44791389, -6.44438128>, <2.63377465, 4.32652477, -6.89729231>,
            <3.85234569, 3.17738611, -4.73232941>, <2.85742906, 3.88633577, -5.55240778>, <2.00510211, 4.10000148, -6.52856712>, <2.45525376, 3.97861237, -6.98147815>,
            <3.88663847, 3.25538789, -5.36497460>, <2.78953500, 4.08382402, -6.46215826>, <2.82066900, 4.15064416, -6.80432537>, <3.03016265, 4.09415154, -7.01510322>,
            <3.34187321, 3.84294870, -6.63796451>, <3.34187321, 3.84294870, -6.63796451>, <3.34187321, 3.84294870, -6.63796451>, <3.34187321, 3.84294870, -6.63796451>
        }
    }
    union {
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.49491993, 5.58309713, -5.32383546>, <-1.66613580, 6.51778647, -2.50634140>, <-1.84063180, 6.67419291, -2.54734474>, <-1.88868966, 6.66936454, -2.63742490>,
            <1.47062074, 5.59103246, -5.29903761>, <-1.32280469, 6.57708335, -2.81336262>, <-1.46868663, 6.82927295, -2.85697798>, <-1.77204943, 7.22320164, -2.60674622>,
            <1.44632154, 5.59896779, -5.27423976>, <0.26168711, 6.24356121, -4.38385255>, <0.19961751, 6.56100417, -4.48957349>, <0.11194428, 6.67424048, -4.51263607>,
            <1.46828666, 5.59179469, -5.29665563>, <0.42538836, 6.21179307, -4.54542695>, <0.34597473, 6.75660887, -4.57737253>, <0.27260853, 6.91773676, -4.60174112>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.88868966, 6.66936454, -2.63742490>, <-1.93674752, 6.66453618, -2.72750507>, <-2.29267286, 6.73421383, -3.05895737>, <-2.30448118, 6.77087446, -3.14474566>,
            <-1.77204943, 7.22320164, -2.60674622>, <-2.07541222, 7.61713033, -2.35651447>, <-2.47095293, 7.80487265, -2.62094920>, <-2.52568233, 7.69785855, -2.70281946>,
            <0.11194428, 6.67424048, -4.51263607>, <0.02427106, 6.78747679, -4.53569866>, <-0.27442617, 7.04872075, -4.87237500>, <-0.32915557, 6.94170665, -4.95424526>,
            <0.27260853, 6.91773676, -4.60174112>, <0.19924233, 7.07886465, -4.62610972>, <-0.11376193, 7.29221703, -4.96148005>, <-0.16849133, 7.18520293, -5.04335031>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-2.30448118, 6.77087446, -3.14474566>, <-2.31628949, 6.80753509, -3.23053395>, <-2.45003964, 6.84730695, -3.35471758>, <-1.18223945, 6.40453908, -5.01856523>,
            <-2.52568233, 7.69785855, -2.70281946>, <-2.58041173, 7.59084445, -2.78468973>, <-2.13532258, 6.81082068, -3.65912679>, <-1.03703052, 6.39026360, -5.15837091>,
            <-0.32915557, 6.94170665, -4.95424526>, <-0.38388497, 6.83469255, -5.03611553>, <-0.53524786, 6.56483342, -5.22209270>, <-0.24914276, 6.27123764, -5.92745494>,
            <-0.16849133, 7.18520293, -5.04335031>, <-0.22322073, 7.07818882, -5.12522058>, <-0.36908296, 6.70140577, -5.34340053>, <-0.16223127, 6.31199148, -5.99866379>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.18223945, 6.40453908, -5.01856523>, <0.08556073, 5.96177120, -6.68241289>, <0.08846938, 5.97150768, -6.68267840>, <-1.18542138, 6.24425244, -5.05612110>,
            <-1.03703052, 6.39026360, -5.15837091>, <0.06126154, 5.96970653, -6.65761504>, <0.06417019, 5.97944301, -6.65788055>, <-1.14332810, 6.11690841, -5.12780973>,
            <-0.24914276, 6.27123764, -5.92745494>, <0.03696234, 5.97764186, -6.63281718>, <0.10810042, 5.96509682, -6.70271229>, <-0.38156671, 5.79826706, -5.92287663>,
            <-0.16223127, 6.31199148, -5.99866379>, <0.04462043, 5.92257719, -6.65392705>, <0.09595082, 5.96906449, -6.69031337>, <-0.30165309, 5.71928612, -6.01780574>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.18542138, 6.24425244, -5.05612110>, <-2.45931214, 6.51699720, -3.42956379>, <-2.36027746, 6.47720895, -3.27282381>, <-2.33591697, 6.45116670, -3.19612288>,
            <-1.14332810, 6.11690841, -5.12780973>, <-2.35082640, 6.25437380, -3.59773892>, <-2.30901983, 6.02301923, -3.43577491>, <-2.31327339, 5.90119383, -3.35646195>,
            <-0.38156671, 5.79826706, -5.92287663>, <-0.87123384, 5.63143730, -5.14304096>, <-0.83594569, 5.31476549, -4.99654190>, <-0.84569991, 5.29986401, -4.88502617>,
            <-0.30165309, 5.71928612, -6.01780574>, <-0.69925700, 5.46950775, -5.34529812>, <-0.74218938, 5.17012239, -5.12106193>, <-0.73450835, 5.11993619, -5.03482349>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-2.33591697, 6.45116670, -3.19612288>, <-2.31155648, 6.42512446, -3.11942194>, <-1.94685325, 6.40473524, -2.78373642>, <-1.88560829, 6.37815839, -2.71396789>,
            <-2.31327339, 5.90119383, -3.35646195>, <-2.31752696, 5.77936843, -3.27714900>, <-1.92420968, 5.85476237, -2.94407550>, <-1.80023595, 5.91282791, -2.91173378>,
            <-0.84569991, 5.29986401, -4.88502617>, <-0.85545413, 5.28496252, -4.77351044>, <-0.51936496, 5.16879015, -4.43521290>, <-0.36127653, 5.21571493, -4.43768598>,
            <-0.73450835, 5.11993619, -5.03482349>, <-0.72682732, 5.06975000, -4.94858504>, <-0.38961412, 4.90765782, -4.62295597>, <-0.25573696, 5.01798552, -4.58668460>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-1.88560829, 6.37815839, -2.71396789>, <-1.82436333, 6.35158153, -2.64419936>, <-1.72734459, 6.34913357, -2.49158844>, <1.49491993, 5.58309713, -5.32383546>,
            <-1.80023595, 5.91282791, -2.91173378>, <-1.67626223, 5.97089346, -2.87939206>, <-1.45378595, 6.13773029, -2.80163477>, <1.47062074, 5.59103246, -5.29903761>,
            <-0.36127653, 5.21571493, -4.43768598>, <-0.20318809, 5.26263972, -4.44015906>, <0.05932333, 5.51812096, -4.37753146>, <1.44632154, 5.59896779, -5.27423976>,
            <-0.25573696, 5.01798552, -4.58668460>, <-0.12185979, 5.12831323, -4.55041323>, <0.21714385, 5.46438840, -4.53914549>, <1.46828666, 5.59179469, -5.29665563>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.46828666, 5.59179469, -5.29665563>, <0.42538836, 6.21179307, -4.54542695>, <0.34597473, 6.75660887, -4.57737253>, <0.27260853, 6.91773676, -4.60174112>,
            <1.49025177, 5.58462160, -5.31907150>, <0.58908961, 6.18002493, -4.70700134>, <0.49233194, 6.95221356, -4.66517157>, <0.43327277, 7.16123303, -4.69084617>,
            <1.33044774, 5.63298013, -5.29637200>, <0.91649212, 6.11648865, -5.03015013>, <0.83566305, 7.01151045, -4.97219279>, <0.77660388, 7.22052992, -4.99786739>,
            <1.38605056, 5.61673619, -5.28292390>, <1.11383108, 6.07564967, -5.15586056>, <1.20915487, 6.98673383, -4.91051959>, <1.06600142, 7.21843041, -5.02585411>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.27260853, 6.91773676, -4.60174112>, <0.19924233, 7.07886465, -4.62610972>, <-0.11376193, 7.29221703, -4.96148005>, <-0.16849133, 7.18520293, -5.04335031>,
            <0.43327277, 7.16123303, -4.69084617>, <0.37421360, 7.37025250, -4.71652077>, <0.04690232, 7.53571330, -5.05058510>, <-0.00782708, 7.42869920, -5.13245536>,
            <0.77660388, 7.22052992, -4.99786739>, <0.71754471, 7.42954938, -5.02354199>, <0.39023343, 7.59501019, -5.35760632>, <0.33550403, 7.48799609, -5.43947658>,
            <1.06600142, 7.21843041, -5.02585411>, <0.92284797, 7.45012698, -5.14118863>, <0.49462356, 7.64280032, -5.58284486>, <0.33898103, 7.56299874, -5.77230704>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.16849133, 7.18520293, -5.04335031>, <-0.22322073, 7.07818882, -5.12522058>, <-0.36908296, 6.70140577, -5.34340053>, <-0.16223127, 6.31199148, -5.99866379>,
            <-0.00782708, 7.42869920, -5.13245536>, <-0.06255648, 7.32168510, -5.21432563>, <-0.20291806, 6.83797813, -5.46470836>, <-0.07531977, 6.35274532, -6.06987264>,
            <0.33550403, 7.48799609, -5.43947658>, <0.28077463, 7.38098198, -5.52134684>, <0.14041305, 6.89727502, -5.77172958>, <0.13261792, 6.42311225, -6.24710512>,
            <0.33898103, 7.56299874, -5.77230704>, <0.18333850, 7.48319717, -5.96176921>, <0.24480318, 6.94506515, -5.99696813>, <0.18189898, 6.54646509, -6.33183606>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.16223127, 6.31199148, -5.99866379>, <0.04462043, 5.92257719, -6.65392705>, <0.09595082, 5.96906449, -6.69031337>, <-0.30165309, 5.71928612, -6.01780574>,
            <-0.07531977, 6.35274532, -6.06987264>, <0.05227851, 5.86751252, -6.67503691>, <0.08380122, 5.97303215, -6.67791444>, <-0.22173947, 5.64030517, -6.11273486>,
            <0.13261792, 6.42311225, -6.24710512>, <0.12482279, 5.94894948, -6.72248067>, <0.12773145, 5.95868597, -6.72274618>, <-0.04195384, 5.57939951, -6.29676476>,
            <0.18189898, 6.54646509, -6.33183606>, <0.11899477, 6.14786503, -6.66670399>, <0.00761584, 5.74937890, -6.66302545>, <-0.05673909, 5.45695054, -6.38357538>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.30165309, 5.71928612, -6.01780574>, <-0.69925700, 5.46950775, -5.34529812>, <-0.74218938, 5.17012239, -5.12106193>, <-0.73450835, 5.11993619, -5.03482349>,
            <-0.22173947, 5.64030517, -6.11273486>, <-0.52728017, 5.30757819, -5.54755528>, <-0.64843307, 5.02547929, -5.24558195>, <-0.62331679, 4.94000838, -5.18462080>,
            <-0.04195384, 5.57939951, -6.29676476>, <-0.21163912, 5.20011306, -5.87078334>, <-0.30694766, 4.76127086, -5.63269417>, <-0.28413292, 4.62690711, -5.58194050>,
            <-0.05673909, 5.45695054, -6.38357538>, <-0.12109402, 5.16452218, -6.10412531>, <-0.42701605, 4.75262877, -6.07992758>, <-0.30328818, 4.59105249, -5.92158200>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.73450835, 5.11993619, -5.03482349>, <-0.72682732, 5.06975000, -4.94858504>, <-0.38961412, 4.90765782, -4.62295597>, <-0.25573696, 5.01798552, -4.58668460>,
            <-0.62331679, 4.94000838, -5.18462080>, <-0.59820051, 4.85453747, -5.12365965>, <-0.25986327, 4.64652549, -4.81069904>, <-0.15019738, 4.82025612, -4.73568322>,
            <-0.28413292, 4.62690711, -5.58194050>, <-0.26131818, 4.49254336, -5.53118682>, <0.08622523, 4.48010276, -5.17739630>, <0.18158409, 4.60594180, -5.10107447>,
            <-0.30328818, 4.59105249, -5.92158200>, <-0.17956032, 4.42947621, -5.76323642>, <0.26889623, 4.38982308, -5.30185399>, <0.45550287, 4.51693080, -5.13652524>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.25573696, 5.01798552, -4.58668460>, <-0.12185979, 5.12831323, -4.55041323>, <0.21714385, 5.46438840, -4.53914549>, <1.46828666, 5.59179469, -5.29665563>,
            <-0.15019738, 4.82025612, -4.73568322>, <-0.04053150, 4.99398674, -4.66066740>, <0.37496437, 5.41065583, -4.70075952>, <1.49025177, 5.58462160, -5.31907150>,
            <0.18158409, 4.60594180, -5.10107447>, <0.27694295, 4.73178084, -5.02475264>, <0.69060541, 5.30319070, -5.02398758>, <1.33044774, 5.63298013, -5.29637200>,
            <0.45550287, 4.51693080, -5.13652524>, <0.64210952, 4.64403853, -4.97119649>, <0.88206364, 5.24038729, -5.14973764>, <1.38605056, 5.61673619, -5.28292390>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.38605056, 5.61673619, -5.28292390>, <1.11383108, 6.07564967, -5.15586056>, <1.20915487, 6.98673383, -4.91051959>, <1.06600142, 7.21843041, -5.02585411>,
            <1.44165338, 5.60049226, -5.26947580>, <1.31117005, 6.03481068, -5.28157098>, <1.58264668, 6.96195722, -4.84884638>, <1.35539896, 7.21633090, -5.05384083>,
            <1.89209813, 5.46487646, -5.30801251>, <1.99805027, 6.24600040, -5.45415113>, <2.26662821, 6.83396811, -5.52274116>, <2.09003263, 7.08495244, -5.77610075>,
            <2.21966463, 5.36364629, -5.43172525>, <2.32561678, 6.14477023, -5.57786387>, <2.42505216, 6.78223198, -5.68441621>, <2.24845658, 7.03321632, -5.93777581>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.06600142, 7.21843041, -5.02585411>, <0.92284797, 7.45012698, -5.14118863>, <0.49462356, 7.64280032, -5.58284486>, <0.33898103, 7.56299874, -5.77230704>,
            <1.35539896, 7.21633090, -5.05384083>, <1.12815124, 7.47070458, -5.25883527>, <0.59901369, 7.69059045, -5.80808341>, <0.34245804, 7.63800140, -6.10513749>,
            <2.09003263, 7.08495244, -5.77610075>, <1.91343705, 7.33593678, -6.02946035>, <1.40454980, 7.55446761, -6.59804446>, <1.11605083, 7.50401603, -6.86459750>,
            <2.24845658, 7.03321632, -5.93777581>, <2.07186100, 7.28420065, -6.19113541>, <1.56297375, 7.50273148, -6.75971952>, <1.27447478, 7.45227990, -7.02627256>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.33898103, 7.56299874, -5.77230704>, <0.18333850, 7.48319717, -5.96176921>, <0.24480318, 6.94506515, -5.99696813>, <0.18189898, 6.54646509, -6.33183606>,
            <0.34245804, 7.63800140, -6.10513749>, <0.08590238, 7.58541236, -6.40219157>, <0.34919332, 6.99285528, -6.22220668>, <0.23118003, 6.66981793, -6.41656699>,
            <1.11605083, 7.50401603, -6.86459750>, <0.82755186, 7.45356445, -7.13115054>, <0.75220196, 6.92458726, -7.03571218>, <0.54110171, 6.60777876, -7.14118850>,
            <1.27447478, 7.45227990, -7.02627256>, <0.98597581, 7.40182832, -7.29282559>, <0.67516194, 6.93634704, -7.44843502>, <0.46406169, 6.61953853, -7.55391134>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.18189898, 6.54646509, -6.33183606>, <0.11899477, 6.14786503, -6.66670399>, <0.00761584, 5.74937890, -6.66302545>, <-0.05673909, 5.45695054, -6.38357538>,
            <0.23118003, 6.66981793, -6.41656699>, <0.11316674, 6.34678058, -6.61092731>, <-0.11249978, 5.54007184, -6.60330471>, <-0.07152435, 5.33450157, -6.47038600>,
            <0.54110171, 6.60777876, -7.14118850>, <0.33000147, 6.29097025, -7.24666481>, <0.10399768, 5.53444147, -7.22603420>, <0.10844810, 5.15950694, -7.10169397>,
            <0.46406169, 6.61953853, -7.55391134>, <0.25296145, 6.30273002, -7.65938766>, <0.02695766, 5.54620124, -7.63875704>, <0.03140808, 5.17126671, -7.51441681>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.05673909, 5.45695054, -6.38357538>, <-0.12109402, 5.16452218, -6.10412531>, <-0.42701605, 4.75262877, -6.07992758>, <-0.30328818, 4.59105249, -5.92158200>,
            <-0.07152435, 5.33450157, -6.47038600>, <-0.03054892, 5.12893130, -6.33746728>, <-0.54708444, 4.74398668, -6.52716099>, <-0.32244345, 4.55519787, -6.26122351>,
            <0.10844810, 5.15950694, -7.10169397>, <0.11289851, 4.78457241, -6.97735375>, <-0.11547523, 4.29686009, -7.04506688>, <0.10211069, 4.10993617, -6.77204059>,
            <0.03140808, 5.17126671, -7.51441681>, <0.03585849, 4.79633218, -7.39007659>, <0.04294872, 4.24512396, -7.20674194>, <0.26053464, 4.05820005, -6.93371564>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <-0.30328818, 4.59105249, -5.92158200>, <-0.17956032, 4.42947621, -5.76323642>, <0.26889623, 4.38982308, -5.30185399>, <0.45550287, 4.51693080, -5.13652524>,
            <-0.32244345, 4.55519787, -6.26122351>, <-0.09780245, 4.36640906, -5.99528602>, <0.45156722, 4.29954340, -5.42631168>, <0.72942166, 4.42791981, -5.17197602>,
            <0.10211069, 4.10993617, -6.77204059>, <0.31969661, 3.92301226, -6.49901429>, <0.87353881, 3.85496436, -5.93453387>, <1.16258040, 3.98038362, -5.69143884>,
            <0.26053464, 4.05820005, -6.93371564>, <0.47812057, 3.87127613, -6.66068935>, <1.03196277, 3.80322824, -6.09620893>, <1.32100435, 3.92864749, -5.85311389>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.45550287, 4.51693080, -5.13652524>, <0.64210952, 4.64403853, -4.97119649>, <0.88206364, 5.24038729, -5.14973764>, <1.38605056, 5.61673619, -5.28292390>,
            <0.72942166, 4.42791981, -5.17197602>, <1.00727609, 4.55629621, -4.91764035>, <1.07352187, 5.17758388, -5.27548770>, <1.44165338, 5.60049226, -5.26947580>,
            <1.16258040, 3.98038362, -5.69143884>, <1.45162198, 4.10580288, -5.44834380>, <1.55034358, 4.74733968, -5.41328249>, <1.89209813, 5.46487646, -5.30801251>,
            <1.32100435, 3.92864749, -5.85311389>, <1.61004593, 4.05406675, -5.61001886>, <1.87791009, 4.64610951, -5.53699524>, <2.21966463, 5.36364629, -5.43172525>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.21966463, 5.36364629, -5.43172525>, <2.32561678, 6.14477023, -5.57786387>, <2.42505216, 6.78223198, -5.68441621>, <2.24845658, 7.03321632, -5.93777581>,
            <2.54723113, 5.26241611, -5.55543800>, <2.65318328, 6.04354006, -5.70157662>, <2.58347611, 6.73049585, -5.84609127>, <2.40688053, 6.98148019, -6.09945087>,
            <2.88054948, 3.98205759, -6.19803669>, <2.97819235, 4.26012700, -6.17551685>, <3.31726556, 6.77972104, -6.37029517>, <3.14620056, 7.02648312, -6.60645532>,
            <3.10372510, 3.89736383, -6.58212169>, <3.17764419, 4.20634224, -6.37619113>, <3.51671739, 6.72593627, -6.57096945>, <3.34565239, 6.97269835, -6.80712960>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.24845658, 7.03321632, -5.93777581>, <2.07186100, 7.28420065, -6.19113541>, <1.56297375, 7.50273148, -6.75971952>, <1.27447478, 7.45227990, -7.02627256>,
            <2.40688053, 6.98148019, -6.09945087>, <2.23028495, 7.23246452, -6.35281047>, <1.72139770, 7.45099535, -6.92139458>, <1.43289873, 7.40054377, -7.18794761>,
            <3.14620056, 7.02648312, -6.60645532>, <2.97513556, 7.27324519, -6.84261548>, <2.34142694, 7.54504756, -7.54531227>, <2.02118768, 7.47221895, -7.84408120>,
            <3.34565239, 6.97269835, -6.80712960>, <3.17458739, 7.21946043, -7.04328975>, <2.54087877, 7.49126280, -7.74598655>, <2.22063951, 7.41843419, -8.04475547>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.27447478, 7.45227990, -7.02627256>, <0.98597581, 7.40182832, -7.29282559>, <0.67516194, 6.93634704, -7.44843502>, <0.46406169, 6.61953853, -7.55391134>,
            <1.43289873, 7.40054377, -7.18794761>, <1.14439976, 7.35009219, -7.45450065>, <0.59812192, 6.94810681, -7.86115786>, <0.38702168, 6.63129830, -7.96663418>,
            <2.02118768, 7.47221895, -7.84408120>, <1.70094842, 7.39939034, -8.14285012>, <1.20093049, 6.95600138, -8.52098489>, <0.96365665, 6.60788484, -8.66351106>,
            <2.22063951, 7.41843419, -8.04475547>, <1.90040025, 7.34560558, -8.34352440>, <1.40038232, 6.90221661, -8.72165917>, <1.26698965, 6.52608718, -8.96870319>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.46406169, 6.61953853, -7.55391134>, <0.25296145, 6.30273002, -7.65938766>, <0.02695766, 5.54620124, -7.63875704>, <0.03140808, 5.17126671, -7.51441681>,
            <0.38702168, 6.63129830, -7.96663418>, <0.17592143, 6.31448980, -8.07211050>, <-0.05008235, 5.55796102, -8.05147988>, <-0.04563194, 5.18302649, -7.92713965>,
            <0.96365665, 6.60788484, -8.66351106>, <0.72638282, 6.25976830, -8.80603723>, <0.36716859, 4.92768223, -8.80603723>, <0.38290111, 4.71778203, -8.87765920>,
            <1.26698965, 6.52608718, -8.96870319>, <1.13359697, 6.14995774, -9.21574721>, <0.77438275, 4.81787167, -9.21574721>, <0.68756709, 4.65214144, -9.14997786>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.03140808, 5.17126671, -7.51441681>, <0.03585849, 4.79633218, -7.39007659>, <0.04294872, 4.24512396, -7.20674194>, <0.26053464, 4.05820005, -6.93371564>,
            <-0.04563194, 5.18302649, -7.92713965>, <-0.04118152, 4.80809196, -7.80279943>, <0.20137267, 4.19338783, -7.36841699>, <0.41895860, 4.00646392, -7.09539070>,
            <0.38290111, 4.71778203, -8.87765920>, <0.39863363, 4.50788183, -8.94928118>, <0.52375823, 4.10446219, -8.42976187>, <0.87247919, 3.74766770, -7.98753707>,
            <0.68756709, 4.65214144, -9.14997786>, <0.60075142, 4.48641121, -9.08420850>, <0.72321006, 4.05067742, -8.63043615>, <1.07193102, 3.69388294, -8.18821135>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.26053464, 4.05820005, -6.93371564>, <0.47812057, 3.87127613, -6.66068935>, <1.03196277, 3.80322824, -6.09620893>, <1.32100435, 3.92864749, -5.85311389>,
            <0.41895860, 4.00646392, -7.09539070>, <0.63654452, 3.81954001, -6.82236441>, <1.19038672, 3.75149211, -6.25788398>, <1.47942830, 3.87691136, -6.01478895>,
            <0.87247919, 3.74766770, -7.98753707>, <1.22120015, 3.39087322, -7.54531227>, <1.90564519, 3.30721842, -6.84261548>, <2.21220823, 3.42518193, -6.64129461>,
            <1.07193102, 3.69388294, -8.18821135>, <1.42065199, 3.33708846, -7.74598655>, <2.10509703, 3.25343366, -7.04328975>, <2.41166006, 3.37139717, -6.84196888>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.32100435, 3.92864749, -5.85311389>, <1.61004593, 4.05406675, -5.61001886>, <1.87791009, 4.64610951, -5.53699524>, <2.21966463, 5.36364629, -5.43172525>,
            <1.47942830, 3.87691136, -6.01478895>, <1.76846988, 4.00233062, -5.77169392>, <2.20547659, 4.54487933, -5.66070798>, <2.54723113, 5.26241611, -5.55543800>,
            <2.21220823, 3.42518193, -6.64129461>, <2.51877126, 3.54314544, -6.43997374>, <2.63639714, 3.75217693, -6.37908906>, <2.88054948, 3.98205759, -6.19803669>,
            <2.41166006, 3.37139717, -6.84196888>, <2.71822309, 3.48936067, -6.64064802>, <2.83584897, 3.69839216, -6.57976334>, <3.10372510, 3.89736383, -6.58212169>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.10372510, 3.89736383, -6.58212169>, <3.17764419, 4.20634224, -6.37619113>, <3.51671739, 6.72593627, -6.57096945>, <3.34565239, 6.97269835, -6.80712960>,
            <3.32690072, 3.81267008, -6.96620669>, <3.37709602, 4.15255748, -6.57686541>, <3.71616922, 6.67215151, -6.77164373>, <3.54510422, 6.91891359, -7.00780388>,
            <3.90269583, 3.45170944, -7.26734357>, <3.77599969, 4.04498795, -6.97821396>, <4.11507289, 6.56458198, -7.17299228>, <3.94400789, 6.81134406, -7.40915243>,
            <3.98997816, 3.55552922, -7.33471296>, <3.97545152, 3.99120318, -7.17888824>, <4.31452472, 6.51079722, -7.37366656>, <4.14345972, 6.75755930, -7.60982671>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.34565239, 6.97269835, -6.80712960>, <3.17458739, 7.21946043, -7.04328975>, <2.54087877, 7.49126280, -7.74598655>, <2.22063951, 7.41843419, -8.04475547>,
            <3.54510422, 6.91891359, -7.00780388>, <3.37403922, 7.16567567, -7.24396403>, <2.74033061, 7.43747803, -7.94666082>, <2.42009135, 7.36464942, -8.24542975>,
            <3.94400789, 6.81134406, -7.40915243>, <3.77294289, 7.05810614, -7.64531258>, <3.13923427, 7.32990850, -8.34800938>, <2.81899501, 7.25707990, -8.64677830>,
            <4.14345972, 6.75755930, -7.60982671>, <3.97239472, 7.00432137, -7.84598686>, <3.33868611, 7.27612374, -8.54868366>, <3.01844685, 7.20329513, -8.84745258>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.22063951, 7.41843419, -8.04475547>, <1.90040025, 7.34560558, -8.34352440>, <1.40038232, 6.90221661, -8.72165917>, <1.26698965, 6.52608718, -8.96870319>,
            <2.42009135, 7.36464942, -8.24542975>, <2.09985209, 7.29182082, -8.54419868>, <1.59983416, 6.84843185, -8.92233345>, <1.57032264, 6.44428951, -9.27389532>,
            <2.81899501, 7.25707990, -8.64677830>, <2.49875575, 7.18425129, -8.94554723>, <1.79889025, 6.79475380, -9.68027232>, <1.73079431, 6.40101626, -9.71418190>,
            <3.01844685, 7.20329513, -8.84745258>, <2.69820758, 7.13046652, -9.14622151>, <1.95975765, 6.75137383, -9.56329430>, <1.80707276, 6.38044679, -9.65151217>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.26698965, 6.52608718, -8.96870319>, <1.13359697, 6.14995774, -9.21574721>, <0.77438275, 4.81787167, -9.21574721>, <0.68756709, 4.65214144, -9.14997786>,
            <1.57032264, 6.44428951, -9.27389532>, <1.54081113, 6.04014718, -9.62545719>, <1.18159691, 4.70806111, -9.62545719>, <0.99223306, 4.58650085, -9.42229651>,
            <1.73079431, 6.40101626, -9.71418190>, <1.66269836, 6.00727871, -9.74809148>, <1.30348414, 4.67519264, -9.74809148>, <1.05976560, 4.41837428, -9.56270247>,
            <1.80707276, 6.38044679, -9.65151217>, <1.65438787, 6.00951975, -9.73973005>, <1.29517365, 4.67743367, -9.73973005>, <1.16443066, 4.44894196, -9.66492004>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <0.68756709, 4.65214144, -9.14997786>, <0.60075142, 4.48641121, -9.08420850>, <0.72321006, 4.05067742, -8.63043615>, <1.07193102, 3.69388294, -8.18821135>,
            <0.99223306, 4.58650085, -9.42229651>, <0.80286922, 4.46494059, -9.21913583>, <0.92266189, 3.99689266, -8.83111043>, <1.27138286, 3.64009818, -8.38888563>,
            <1.05976560, 4.41837428, -9.56270247>, <0.81604706, 4.16155591, -9.37731346>, <1.32156556, 3.88932313, -9.23245898>, <1.67028652, 3.53252865, -8.79023418>,
            <1.16443066, 4.44894196, -9.66492004>, <1.03368768, 4.22045024, -9.59011003>, <1.52101739, 3.83553837, -9.43313326>, <1.86973836, 3.47874388, -8.99090846>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.07193102, 3.69388294, -8.18821135>, <1.42065199, 3.33708846, -7.74598655>, <2.10509703, 3.25343366, -7.04328975>, <2.41166006, 3.37139717, -6.84196888>,
            <1.27138286, 3.64009818, -8.38888563>, <1.62010382, 3.28330370, -7.94666082>, <2.30454886, 3.19964890, -7.24396403>, <2.61111189, 3.31761240, -7.04264316>,
            <1.67028652, 3.53252865, -8.79023418>, <2.01900749, 3.17573417, -8.34800938>, <2.70345253, 3.09207937, -7.64531258>, <3.01001556, 3.21004288, -7.44399172>,
            <1.86973836, 3.47874388, -8.99090846>, <2.21845932, 3.12194940, -8.54868366>, <2.90290436, 3.03829460, -7.84598686>, <3.20946739, 3.15625811, -7.64466599>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.41166006, 3.37139717, -6.84196888>, <2.71822309, 3.48936067, -6.64064802>, <2.83584897, 3.69839216, -6.57976334>, <3.10372510, 3.89736383, -6.58212169>,
            <2.61111189, 3.31761240, -7.04264316>, <2.91767493, 3.43557591, -6.84132229>, <3.03530081, 3.64460740, -6.78043762>, <3.32690072, 3.81267008, -6.96620669>,
            <3.01001556, 3.21004288, -7.44399172>, <3.31657859, 3.32800638, -7.24267085>, <3.43420447, 3.53703787, -7.18178617>, <3.90269583, 3.45170944, -7.26734357>,
            <3.20946739, 3.15625811, -7.64466599>, <3.51603043, 3.27422162, -7.44334512>, <3.63365631, 3.48325311, -7.38246045>, <3.98997816, 3.55552922, -7.33471296>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.98997816, 3.55552922, -7.33471296>, <3.97545152, 3.99120318, -7.17888824>, <4.31452472, 6.51079722, -7.37366656>, <4.14345972, 6.75755930, -7.60982671>,
            <4.07726048, 3.65934901, -7.40208235>, <4.17490335, 3.93741842, -7.37956251>, <4.51397656, 6.45701245, -7.57434083>, <4.34291156, 6.70377453, -7.81050099>,
            <5.00697400, 4.59811937, -7.60711017>, <5.06931264, 5.45065563, -7.72398817>, <4.87403569, 6.14703995, -8.10772349>, <4.64395385, 6.64422388, -8.49376790>,
            <5.17798489, 4.55200408, -7.79853309>, <5.23677712, 5.39225424, -7.91519227>, <5.04150017, 6.08863855, -8.29892759>, <4.81621602, 6.58451932, -8.68011953>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.14345972, 6.75755930, -7.60982671>, <3.97239472, 7.00432137, -7.84598686>, <3.33868611, 7.27612374, -8.54868366>, <3.01844685, 7.20329513, -8.84745258>,
            <4.34291156, 6.70377453, -7.81050099>, <4.17184656, 6.95053661, -8.04666114>, <3.53813794, 7.22233898, -8.74935793>, <3.21789868, 7.14951037, -9.04812686>,
            <4.64395385, 6.64422388, -8.49376790>, <4.41387200, 7.14140781, -8.87981232>, <4.31392458, 7.25963183, -9.01705405>, <3.90597142, 7.01894052, -9.33643319>,
            <4.81621602, 6.58451932, -8.68011953>, <4.59093187, 7.08040008, -9.06131147>, <4.49098444, 7.19862410, -9.19855320>, <4.08776111, 6.95666753, -9.51260442>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.01844685, 7.20329513, -8.84745258>, <2.69820758, 7.13046652, -9.14622151>, <1.95975765, 6.75137383, -9.56329430>, <1.80707276, 6.38044679, -9.65151217>,
            <3.21789868, 7.14951037, -9.04812686>, <2.89765942, 7.07668176, -9.34689578>, <2.12062505, 6.70799385, -9.44631628>, <1.88335122, 6.35987732, -9.58884245>,
            <3.90597142, 7.01894052, -9.33643319>, <3.49801826, 6.77824920, -9.65581233>, <2.93461990, 6.41511746, -10.13585476>, <2.72223140, 6.07301468, -10.27364613>,
            <4.08776111, 6.95666753, -9.51260442>, <3.68453778, 6.71471097, -9.82665565>, <3.12113942, 6.35157923, -10.30669808>, <2.91052391, 6.01561875, -10.44459885>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.80707276, 6.38044679, -9.65151217>, <1.65438787, 6.00951975, -9.73973005>, <1.29517365, 4.67743367, -9.73973005>, <1.16443066, 4.44894196, -9.66492004>,
            <1.88335122, 6.35987732, -9.58884245>, <1.64607738, 6.01176078, -9.73136862>, <1.28686316, 4.67967470, -9.73136862>, <1.26909572, 4.47950964, -9.76713761>,
            <2.72223140, 6.07301468, -10.27364613>, <2.50984289, 5.73091189, -10.41143749>, <2.27886789, 4.87437958, -10.41143749>, <2.28722297, 4.45205939, -10.27561869>,
            <2.91052391, 6.01561875, -10.44459885>, <2.69990840, 5.67965827, -10.58249961>, <2.46893340, 4.82312596, -10.58249961>, <2.47728848, 4.40080577, -10.44668081>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.16443066, 4.44894196, -9.66492004>, <1.03368768, 4.22045024, -9.59011003>, <1.52101739, 3.83553837, -9.43313326>, <1.86973836, 3.47874388, -8.99090846>,
            <1.26909572, 4.47950964, -9.76713761>, <1.25132829, 4.27934457, -9.80290660>, <1.72046922, 3.78175360, -9.63380754>, <2.06919019, 3.42495912, -9.19158273>,
            <2.28722297, 4.45205939, -10.27561869>, <2.29557806, 4.02973920, -10.13979989>, <2.66598439, 3.45851424, -9.71506626>, <2.84856755, 3.26568913, -9.50307704>,
            <2.47728848, 4.40080577, -10.44668081>, <2.48564357, 3.97848558, -10.31086201>, <2.85903746, 3.41913249, -9.88592781>, <3.03689583, 3.22759126, -9.67926652>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <1.86973836, 3.47874388, -8.99090846>, <2.21845932, 3.12194940, -8.54868366>, <2.90290436, 3.03829460, -7.84598686>, <3.20946739, 3.15625811, -7.64466599>,
            <2.06919019, 3.42495912, -9.19158273>, <2.41791115, 3.06816464, -8.74935793>, <3.10235619, 2.98450984, -8.04666114>, <3.40891923, 3.10247335, -7.84534027>,
            <2.84856755, 3.26568913, -9.50307704>, <3.03115071, 3.07286403, -9.29108782>, <3.64804440, 2.99779176, -8.65187894>, <3.91060390, 3.15502026, -8.40961118>,
            <3.03689583, 3.22759126, -9.67926652>, <3.21475420, 3.03605003, -9.47260523>, <3.83164788, 2.96097776, -8.83339635>, <4.08940505, 3.11949227, -8.59598105>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.20946739, 3.15625811, -7.64466599>, <3.51603043, 3.27422162, -7.44334512>, <3.63365631, 3.48325311, -7.38246045>, <3.98997816, 3.55552922, -7.33471296>,
            <3.40891923, 3.10247335, -7.84534027>, <3.71548226, 3.22043685, -7.64401940>, <3.83310814, 3.42946834, -7.58313473>, <4.07726048, 3.65934901, -7.40208235>,
            <3.91060390, 3.15502026, -8.40961118>, <4.17316341, 3.31224877, -8.16734342>, <4.63870008, 3.78735409, -7.74079409>, <5.00697400, 4.59811937, -7.60711017>,
            <4.08940505, 3.11949227, -8.59598105>, <4.34716222, 3.27800677, -8.35856575>, <4.80971097, 3.74123880, -7.93221702>, <5.17798489, 4.55200408, -7.79853309>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.17798489, 4.55200408, -7.79853309>, <5.23677712, 5.39225424, -7.91519227>, <5.04150017, 6.08863855, -8.29892759>, <4.81621602, 6.58451932, -8.68011953>,
            <5.34899577, 4.50588878, -7.98995601>, <5.40424159, 5.33385285, -8.10639637>, <5.20896464, 6.03023716, -8.49013168>, <4.98847818, 6.52481476, -8.86647115>,
            <5.69101755, 4.41365819, -8.37280186>, <5.73917054, 5.21705006, -8.48880457>, <5.34206733, 5.96785944, -9.08772369>, <5.78222262, 6.95748631, -9.72999843>,
            <5.86202844, 4.36754289, -8.56422479>, <5.90663501, 5.15864867, -8.68000867>, <5.50953180, 5.90945805, -9.27892779>, <6.09091126, 6.99045772, -10.02086791>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.81621602, 6.58451932, -8.68011953>, <4.59093187, 7.08040008, -9.06131147>, <4.49098444, 7.19862410, -9.19855320>, <4.08776111, 6.95666753, -9.51260442>,
            <4.98847818, 6.52481476, -8.86647115>, <4.76799173, 7.01939235, -9.24281062>, <4.66804430, 7.13761637, -9.38005235>, <4.26955080, 6.89439455, -9.68877566>,
            <5.78222262, 6.95748631, -9.72999843>, <6.22237790, 7.94711318, -10.37227317>, <6.12243048, 8.06533720, -10.50951490>, <5.28417654, 7.26750420, -10.31675835>,
            <6.09091126, 6.99045772, -10.02086791>, <6.67229072, 8.07145739, -10.76280803>, <6.57234329, 8.18968141, -10.90004976>, <5.60239271, 7.29790719, -10.59744743>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.08776111, 6.95666753, -9.51260442>, <3.68453778, 6.71471097, -9.82665565>, <3.12113942, 6.35157923, -10.30669808>, <2.91052391, 6.01561875, -10.44459885>,
            <4.26955080, 6.89439455, -9.68877566>, <3.87105730, 6.65117274, -9.99749897>, <3.30765895, 6.28804099, -10.47754140>, <3.09881643, 5.95822282, -10.61555157>,
            <5.28417654, 7.26750420, -10.31675835>, <4.44592261, 6.46967121, -10.12400179>, <3.68069799, 6.16096453, -10.81922804>, <3.47540146, 5.84343097, -10.95745701>,
            <5.60239271, 7.29790719, -10.59744743>, <4.63244214, 6.40613297, -10.29484511>, <3.86721752, 6.09742629, -10.99007136>, <3.66369398, 5.78603504, -11.12840973>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.91052391, 6.01561875, -10.44459885>, <2.69990840, 5.67965827, -10.58249961>, <2.46893340, 4.82312596, -10.58249961>, <2.47728848, 4.40080577, -10.44668081>,
            <3.09881643, 5.95822282, -10.61555157>, <2.88997391, 5.62840465, -10.75356173>, <2.65899891, 4.77187234, -10.75356173>, <2.66735399, 4.34955215, -10.61774293>,
            <3.47540146, 5.84343097, -10.95745701>, <3.27010493, 5.52589741, -11.09568597>, <3.03912992, 4.66936510, -11.09568597>, <3.04748501, 4.24704491, -10.95986717>,
            <3.66369398, 5.78603504, -11.12840973>, <3.46017044, 5.47464379, -11.26674809>, <3.22919543, 4.61811148, -11.26674809>, <3.23755052, 4.19579129, -11.13092929>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <2.47728848, 4.40080577, -10.44668081>, <2.48564357, 3.97848558, -10.31086201>, <2.85903746, 3.41913249, -9.88592781>, <3.03689583, 3.22759126, -9.67926652>,
            <2.66735399, 4.34955215, -10.61774293>, <2.67570907, 3.92723196, -10.48192413>, <3.05209053, 3.37975073, -10.05678936>, <3.22522411, 3.18949338, -9.85545600>,
            <3.04748501, 4.24704491, -10.95986717>, <3.05584009, 3.82472472, -10.82404837>, <3.43819667, 3.30098723, -10.39851247>, <3.60188066, 3.11329763, -10.20783496>,
            <3.23755052, 4.19579129, -11.13092929>, <3.24590560, 3.77347110, -10.99511049>, <3.63124974, 3.26160548, -10.56937402>, <3.79020894, 3.07519976, -10.38402444>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.03689583, 3.22759126, -9.67926652>, <3.21475420, 3.03605003, -9.47260523>, <3.83164788, 2.96097776, -8.83339635>, <4.08940505, 3.11949227, -8.59598105>,
            <3.22522411, 3.18949338, -9.85545600>, <3.39835768, 2.99923603, -9.65412264>, <4.01525137, 2.92416376, -9.01491376>, <4.26820620, 3.08396427, -8.78235092>,
            <3.60188066, 3.11329763, -10.20783496>, <3.76556465, 2.92560803, -10.01715746>, <4.38245834, 2.85053576, -9.37794858>, <4.62580849, 3.01290828, -9.15509067>,
            <3.79020894, 3.07519976, -10.38402444>, <3.94916814, 2.88879403, -10.19867487>, <4.56606182, 2.81372176, -9.55946599>, <4.80460964, 2.97738028, -9.34146054>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.08940505, 3.11949227, -8.59598105>, <4.34716222, 3.27800677, -8.35856575>, <4.80971097, 3.74123880, -7.93221702>, <5.17798489, 4.55200408, -7.79853309>,
            <4.26820620, 3.08396427, -8.78235092>, <4.52116102, 3.24376478, -8.54978809>, <4.98072186, 3.69512350, -8.12363994>, <5.34899577, 4.50588878, -7.98995601>,
            <4.62580849, 3.01290828, -9.15509067>, <4.86915864, 3.17528079, -8.93223275>, <5.32274363, 3.60289291, -8.50648579>, <5.69101755, 4.41365819, -8.37280186>,
            <4.80460964, 2.97738028, -9.34146054>, <5.04315745, 3.14103880, -9.12345508>, <5.49375452, 3.55677761, -8.69790872>, <5.86202844, 4.36754289, -8.56422479>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.86202844, 4.36754289, -8.56422479>, <5.90663501, 5.15864867, -8.68000867>, <5.50953180, 5.90945805, -9.27892779>, <6.09091126, 6.99045772, -10.02086791>,
            <6.03303932, 4.32142760, -8.75564771>, <6.07409949, 5.10024728, -8.87121276>, <5.67699628, 5.85105666, -9.47013189>, <6.39959990, 7.02342913, -10.31173739>,
            <6.37506110, 4.22919701, -9.13849356>, <6.40902844, 4.98344450, -9.25362096>, <6.01192523, 5.73425387, -9.85254009>, <6.00361641, 5.96441436, -9.94871693>,
            <6.59743787, 4.17007767, -9.39696190>, <6.61971018, 4.90648812, -9.50479362>, <6.31828373, 5.62912590, -9.98917982>, <6.26458832, 5.87103081, -10.12988080>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.09091126, 6.99045772, -10.02086791>, <6.67229072, 8.07145739, -10.76280803>, <6.57234329, 8.18968141, -10.90004976>, <5.60239271, 7.29790719, -10.59744743>,
            <6.39959990, 7.02342913, -10.31173739>, <7.12220353, 8.19580160, -11.15334288>, <7.02225611, 8.31402561, -11.29058461>, <5.92060888, 7.32831018, -10.87813652>,
            <6.00361641, 5.96441436, -9.94871693>, <5.99530759, 6.19457484, -10.04489377>, <5.42443223, 6.43979066, -10.68423106>, <5.30821647, 6.32765446, -10.74580307>,
            <6.26458832, 5.87103081, -10.12988080>, <6.21089291, 6.11293572, -10.27058178>, <5.64096167, 6.35766125, -10.90714631>, <5.48272006, 6.25710183, -11.01575857>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.60239271, 7.29790719, -10.59744743>, <4.63244214, 6.40613297, -10.29484511>, <3.86721752, 6.09742629, -10.99007136>, <3.66369398, 5.78603504, -11.12840973>,
            <5.92060888, 7.32831018, -10.87813652>, <4.81896166, 6.34259474, -10.46568843>, <4.05373704, 6.03388806, -11.16091468>, <3.85198649, 5.72863911, -11.29936245>,
            <5.30821647, 6.32765446, -10.74580307>, <5.19200071, 6.21551827, -10.80737507>, <4.42677609, 5.90681159, -11.50260132>, <4.22857153, 5.61384726, -11.64126789>,
            <5.48272006, 6.25710183, -11.01575857>, <5.32447845, 6.15654241, -11.12437082>, <4.66662044, 5.82103360, -11.71515109>, <4.47448700, 5.53675135, -11.85655003>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.66369398, 5.78603504, -11.12840973>, <3.46017044, 5.47464379, -11.26674809>, <3.22919543, 4.61811148, -11.26674809>, <3.23755052, 4.19579129, -11.13092929>,
            <3.85198649, 5.72863911, -11.29936245>, <3.65023595, 5.42339017, -11.43781021>, <3.41926094, 4.56685786, -11.43781021>, <3.42761603, 4.14453767, -11.30199141>,
            <4.22857153, 5.61384726, -11.64126789>, <4.03036696, 5.32088293, -11.77993445>, <3.79939196, 4.46435062, -11.77993445>, <3.80774704, 4.04203043, -11.64411565>,
            <4.47448700, 5.53675135, -11.85655003>, <4.28235356, 5.25246911, -11.99794898>, <4.06030101, 4.39650432, -12.00617403>, <4.07235346, 3.97440901, -11.87453217>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.23755052, 4.19579129, -11.13092929>, <3.24590560, 3.77347110, -10.99511049>, <3.63124974, 3.26160548, -10.56937402>, <3.79020894, 3.07519976, -10.38402444>,
            <3.42761603, 4.14453767, -11.30199141>, <3.43597111, 3.72221748, -11.16617260>, <3.82430281, 3.22222373, -10.74023557>, <3.97853721, 3.03710188, -10.56021393>,
            <3.80774704, 4.04203043, -11.64411565>, <3.81610213, 3.61971024, -11.50829684>, <4.21040895, 3.14346023, -11.08195867>, <4.35519377, 2.96090613, -10.91259289>,
            <4.07235346, 3.97440901, -11.87453217>, <4.08440590, 3.55231369, -11.74289031>, <4.48489427, 3.09403420, -11.32060795>, <4.62404390, 2.91371903, -11.16056690>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <3.79020894, 3.07519976, -10.38402444>, <3.94916814, 2.88879403, -10.19867487>, <4.56606182, 2.81372176, -9.55946599>, <4.80460964, 2.97738028, -9.34146054>,
            <3.97853721, 3.03710188, -10.56021393>, <4.13277162, 2.85198003, -10.38019228>, <4.74966530, 2.77690776, -9.74098340>, <4.98341078, 2.94185228, -9.52783041>,
            <4.35519377, 2.96090613, -10.91259289>, <4.49997859, 2.77835203, -10.74322710>, <5.11687227, 2.70327977, -10.10401822>, <5.34101308, 2.87079629, -9.90057015>,
            <4.62404390, 2.91371903, -11.16056690>, <4.76319354, 2.73340385, -11.00052584>, <5.37737058, 2.65871159, -10.36245513>, <5.59200603, 2.82777860, -10.16419757>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.80460964, 2.97738028, -9.34146054>, <5.04315745, 3.14103880, -9.12345508>, <5.49375452, 3.55677761, -8.69790872>, <5.86202844, 4.36754289, -8.56422479>,
            <4.98341078, 2.94185228, -9.52783041>, <5.21715626, 3.10679680, -9.31467742>, <5.66476541, 3.51066232, -8.88933164>, <6.03303932, 4.32142760, -8.75564771>,
            <5.34101308, 2.87079629, -9.90057015>, <5.56515388, 3.03831282, -9.69712208>, <6.00678718, 3.41843173, -9.27217749>, <6.37506110, 4.22919701, -9.13849356>,
            <5.59200603, 2.82777860, -10.16419757>, <5.80664148, 2.99684561, -9.96594001>, <6.23839309, 3.35962445, -9.53838510>, <6.59743787, 4.17007767, -9.39696190>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.59743787, 4.17007767, -9.39696190>, <6.61971018, 4.90648812, -9.50479362>, <6.31828373, 5.62912590, -9.98917982>, <6.26458832, 5.87103081, -10.12988080>,
            <6.81981464, 4.11095834, -9.65543024>, <6.83039193, 4.82953173, -9.75596628>, <6.62464222, 5.52399793, -10.12581955>, <6.52556023, 5.77764726, -10.31104467>,
            <7.20466791, 4.02843900, -10.11728147>, <7.23914674, 4.81969554, -10.19193398>, <7.11347837, 5.51036005, -10.41732320>, <6.94642825, 5.70970564, -10.68897066>,
            <7.36304685, 4.00704793, -10.27180324>, <7.39814911, 4.79821974, -10.34705585>, <7.27381260, 5.48870322, -10.57372709>, <7.10816084, 5.68783624, -10.84637938>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.26458832, 5.87103081, -10.12988080>, <6.21089291, 6.11293572, -10.27058178>, <5.64096167, 6.35766125, -10.90714631>, <5.48272006, 6.25710183, -11.01575857>,
            <6.52556023, 5.77764726, -10.31104467>, <6.42647823, 6.03129660, -10.49626980>, <5.85749112, 6.27553185, -11.13006157>, <5.65722366, 6.18654920, -11.28571407>,
            <6.94642825, 5.70970564, -10.68897066>, <6.77937812, 5.90905123, -10.96061811>, <6.26732596, 6.12751765, -11.51774682>, <5.99224601, 6.07489533, -11.79338557>,
            <7.10816084, 5.68783624, -10.84637938>, <6.94250907, 5.88696927, -11.11903166>, <6.43326661, 6.10505378, -11.67886494>, <6.15952466, 6.05224960, -11.95579163>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.48272006, 6.25710183, -11.01575857>, <5.32447845, 6.15654241, -11.12437082>, <4.66662044, 5.82103360, -11.71515109>, <4.47448700, 5.53675135, -11.85655003>,
            <5.65722366, 6.18654920, -11.28571407>, <5.45695620, 6.09756654, -11.44136657>, <4.90646479, 5.73525560, -11.92770085>, <4.72040248, 5.45965545, -12.07183218>,
            <5.99224601, 6.07489533, -11.79338557>, <5.71716605, 6.02227301, -12.06902432>, <5.30573483, 5.68366344, -12.30098521>, <5.12887731, 5.36184023, -12.43812228>,
            <6.15952466, 6.05224960, -11.95579163>, <5.88578272, 5.99944541, -12.23271832>, <5.47538547, 5.66074028, -12.46635691>, <5.29909784, 5.33883961, -12.60404254>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.47448700, 5.53675135, -11.85655003>, <4.28235356, 5.25246911, -11.99794898>, <4.06030101, 4.39650432, -12.00617403>, <4.07235346, 3.97440901, -11.87453217>,
            <4.72040248, 5.45965545, -12.07183218>, <4.53434016, 5.18405529, -12.21596351>, <4.32121007, 4.32865802, -12.23241362>, <4.33695987, 3.90678758, -12.10494870>,
            <5.12887731, 5.36184023, -12.43812228>, <4.95201979, 5.04001702, -12.57525935>, <4.79909513, 4.27301043, -12.62582154>, <4.84587990, 3.94244279, -12.53169102>,
            <5.29909784, 5.33883961, -12.60404254>, <5.12281021, 5.01693894, -12.74172817>, <4.96988554, 4.24993235, -12.79229036>, <5.01610043, 3.91944218, -12.69761129>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.07235346, 3.97440901, -11.87453217>, <4.08440590, 3.55231369, -11.74289031>, <4.48489427, 3.09403420, -11.32060795>, <4.62404390, 2.91371903, -11.16056690>,
            <4.33695987, 3.90678758, -12.10494870>, <4.35270968, 3.48491714, -11.97748378>, <4.75937959, 3.04460818, -11.55925723>, <4.89289404, 2.86653192, -11.40854090>,
            <4.84587990, 3.94244279, -12.53169102>, <4.89266467, 3.61187516, -12.43756051>, <5.13760691, 3.11544517, -12.26064664>, <5.36470380, 2.92740437, -12.00087276>,
            <5.01610043, 3.91944218, -12.69761129>, <5.06231532, 3.58895200, -12.60293221>, <5.30622358, 3.09261756, -12.42434064>, <5.53198246, 2.90475864, -12.16327881>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <4.62404390, 2.91371903, -11.16056690>, <4.76319354, 2.73340385, -11.00052584>, <5.37737058, 2.65871159, -10.36245513>, <5.59200603, 2.82777860, -10.16419757>,
            <4.89289404, 2.86653192, -11.40854090>, <5.02640848, 2.68845567, -11.25782458>, <5.63786889, 2.61414341, -10.62089204>, <5.84299899, 2.78476091, -10.42782499>,
            <5.36470380, 2.92740437, -12.00087276>, <5.59180069, 2.73936358, -11.74109887>, <6.13427145, 2.67346427, -11.17391271>, <6.40333528, 2.80197490, -10.91502387>,
            <5.53198246, 2.90475864, -12.16327881>, <5.75774134, 2.71689972, -11.90221698>, <6.29740241, 2.65138230, -11.33232626>, <6.56523516, 2.78006027, -11.07225242>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.59200603, 2.82777860, -10.16419757>, <5.80664148, 2.99684561, -9.96594001>, <6.23839309, 3.35962445, -9.53838510>, <6.59743787, 4.17007767, -9.39696190>,
            <5.84299899, 2.78476091, -10.42782499>, <6.04812909, 2.95537840, -10.23475794>, <6.46999899, 3.30081716, -9.80459271>, <6.81981464, 4.11095834, -9.65543024>,
            <6.40333528, 2.80197490, -10.91502387>, <6.67239910, 2.93048554, -10.65613504>, <6.95571986, 3.39814406, -10.28564473>, <7.20466791, 4.02843900, -10.11728147>,
            <6.56523516, 2.78006027, -11.07225242>, <6.83306791, 2.90873825, -10.81217857>, <7.11472222, 3.37666825, -10.44076659>, <7.36304685, 4.00704793, -10.27180324>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.36304685, 4.00704793, -10.27180324>, <7.39814911, 4.79821974, -10.34705585>, <7.27381260, 5.48870322, -10.57372709>, <7.10816084, 5.68783624, -10.84637938>,
            <7.52142579, 3.98565687, -10.42632500>, <7.55715147, 4.77674394, -10.50217771>, <7.43414683, 5.46704638, -10.73013098>, <7.26989343, 5.66596684, -11.00378810>,
            <9.01971774, 3.80039013, -12.15496634>, <9.01074038, 4.50292251, -12.18290767>, <8.88184522, 5.11376292, -12.34863197>, <8.71072648, 5.33812215, -12.55406946>,
            <9.75348687, 3.79432505, -12.88675598>, <9.72965329, 4.44326754, -12.89773646>, <9.57605461, 5.01612318, -13.07456944>, <9.41884607, 5.22423176, -13.26442150>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.10816084, 5.68783624, -10.84637938>, <6.94250907, 5.88696927, -11.11903166>, <6.43326661, 6.10505378, -11.67886494>, <6.15952466, 6.05224960, -11.95579163>,
            <7.26989343, 5.66596684, -11.00378810>, <7.10564002, 5.86488731, -11.27744522>, <6.59920725, 6.08258991, -11.83998305>, <6.32680332, 6.02960386, -12.11819769>,
            <8.71072648, 5.33812215, -12.55406946>, <8.53960775, 5.56248137, -12.75950695>, <8.10698177, 5.75551553, -13.26960061>, <7.88260771, 5.70830454, -13.53049134>,
            <9.41884607, 5.22423176, -13.26442150>, <9.26163753, 5.43234034, -13.45427355>, <8.87262275, 5.61285784, -13.93370878>, <8.67419106, 5.57040305, -14.18214204>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.15952466, 6.05224960, -11.95579163>, <5.88578272, 5.99944541, -12.23271832>, <5.47538547, 5.66074028, -12.46635691>, <5.29909784, 5.33883961, -12.60404254>,
            <6.32680332, 6.02960386, -12.11819769>, <6.05439939, 5.97661781, -12.39641233>, <5.64503612, 5.63781712, -12.63172862>, <5.46931837, 5.31583899, -12.76996280>,
            <7.88260771, 5.70830454, -13.53049134>, <7.65823366, 5.66109354, -13.79138207>, <7.39758347, 5.26017784, -14.08585392>, <7.26694325, 4.97414885, -14.23133170>,
            <8.67419106, 5.57040305, -14.18214204>, <8.47575936, 5.52794826, -14.43057531>, <8.20263064, 5.17495743, -14.78501196>, <8.09292876, 4.91143641, -14.92927859>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.29909784, 5.33883961, -12.60404254>, <5.12281021, 5.01693894, -12.74172817>, <4.96988554, 4.24993235, -12.79229036>, <5.01610043, 3.91944218, -12.69761129>,
            <5.46931837, 5.31583899, -12.76996280>, <5.29360062, 4.99386086, -12.90819699>, <5.14067595, 4.22685427, -12.95875918>, <5.18632095, 3.89644156, -12.86353155>,
            <7.26694325, 4.97414885, -14.23133170>, <7.13630304, 4.68811987, -14.37680947>, <7.04644992, 4.00690394, -14.46482955>, <7.09493163, 3.67005330, -14.39983422>,
            <8.09292876, 4.91143641, -14.92927859>, <7.98322688, 4.64791540, -15.07354522>, <7.91870668, 4.01916926, -15.17205484>, <7.96941358, 3.70778714, -15.11786190>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.01610043, 3.91944218, -12.69761129>, <5.06231532, 3.58895200, -12.60293221>, <5.30622358, 3.09261756, -12.42434064>, <5.53198246, 2.90475864, -12.16327881>,
            <5.18632095, 3.89644156, -12.86353155>, <5.23196596, 3.56602884, -12.76830391>, <5.47484025, 3.06978996, -12.58803465>, <5.69926111, 2.88211291, -12.32568487>,
            <7.09493163, 3.67005330, -14.39983422>, <7.14341334, 3.33320265, -14.33483888>, <7.28331105, 2.81864084, -14.15865611>, <7.47949196, 2.65210720, -13.92538338>,
            <7.96941358, 3.70778714, -15.11786190>, <8.02012048, 3.39640502, -15.06366896>, <8.20654131, 2.90443182, -14.84161814>, <8.38472855, 2.74960538, -14.62409417>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <5.53198246, 2.90475864, -12.16327881>, <5.75774134, 2.71689972, -11.90221698>, <6.29740241, 2.65138230, -11.33232626>, <6.56523516, 2.78006027, -11.07225242>,
            <5.69926111, 2.88211291, -12.32568487>, <5.92368198, 2.69443585, -12.06333510>, <6.46053336, 2.62930034, -11.49073982>, <6.72713503, 2.75814564, -11.22948096>,
            <7.47949196, 2.65210720, -13.92538338>, <7.67567286, 2.48557356, -13.69211065>, <8.12617174, 2.42804168, -13.16450870>, <8.34199603, 2.54261486, -12.91527767>,
            <8.38472855, 2.74960538, -14.62409417>, <8.56291578, 2.59477895, -14.40657019>, <8.96476443, 2.53932684, -13.90754018>, <9.15407437, 2.64404483, -13.66867562>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <6.56523516, 2.78006027, -11.07225242>, <6.83306791, 2.90873825, -10.81217857>, <7.11472222, 3.37666825, -10.44076659>, <7.36304685, 4.00704793, -10.27180324>,
            <6.72713503, 2.75814564, -11.22948096>, <6.99373671, 2.88699095, -10.96822210>, <7.27372459, 3.35519245, -10.59588845>, <7.52142579, 3.98565687, -10.42632500>,
            <8.34199603, 2.54261486, -12.91527767>, <8.55782032, 2.65718804, -12.66604664>, <8.83274405, 3.15345428, -12.35727280>, <9.01971774, 3.80039013, -12.15496634>,
            <9.15407437, 2.64404483, -13.66867562>, <9.34338432, 2.74876282, -13.42981106>, <9.60184071, 3.19774038, -13.09288104>, <9.75348687, 3.79432505, -12.88675598>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.75348687, 3.79432505, -12.88675598>, <9.72965329, 4.44326754, -12.89773646>, <9.57605461, 5.01612318, -13.07456944>, <9.41884607, 5.22423176, -13.26442150>,
            <10.48725600, 3.78825997, -13.61854563>, <10.44856619, 4.38361258, -13.61256525>, <10.27026401, 4.91848344, -13.80050691>, <10.12696566, 5.11034137, -13.97477353>,
            <12.20373061, 4.07870553, -15.17907543>, <11.42215216, 4.39645338, -14.59300145>, <11.24580020, 4.85113583, -14.72586068>, <11.12350471, 5.01758349, -14.87003426>,
            <12.29535623, 4.09559193, -15.27711520>, <11.83305746, 4.46173145, -14.94099113>, <11.66883697, 4.88513576, -15.06471082>, <11.55495433, 5.04013328, -15.19896653>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.41884607, 5.22423176, -13.26442150>, <9.26163753, 5.43234034, -13.45427355>, <8.87262275, 5.61285784, -13.93370878>, <8.67419106, 5.57040305, -14.18214204>,
            <10.12696566, 5.11034137, -13.97477353>, <9.98366731, 5.30219931, -14.14904015>, <9.63826373, 5.47020015, -14.59781695>, <9.46577440, 5.43250156, -14.83379275>,
            <11.12350471, 5.01758349, -14.87003426>, <11.00120922, 5.18403114, -15.01420785>, <10.73047496, 5.33907621, -15.40798637>, <10.60520372, 5.31485061, -15.62373908>,
            <11.55495433, 5.04013328, -15.19896653>, <11.44107169, 5.19513080, -15.33322225>, <11.18896156, 5.33951014, -15.69991228>, <11.07230787, 5.31695104, -15.90082310>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.67419106, 5.57040305, -14.18214204>, <8.47575936, 5.52794826, -14.43057531>, <8.20263064, 5.17495743, -14.78501196>, <8.09292876, 4.91143641, -14.92927859>,
            <9.46577440, 5.43250156, -14.83379275>, <9.29328507, 5.39480297, -15.06976854>, <9.00767782, 5.08973701, -15.48417000>, <8.91891427, 4.84872397, -15.62722549>,
            <10.60520372, 5.31485061, -15.62373908>, <10.47993247, 5.29062500, -15.83949178>, <10.29232287, 5.04766370, -16.23485981>, <10.62494075, 4.92999761, -16.60974648>,
            <11.07230787, 5.31695104, -15.90082310>, <10.95565419, 5.29439194, -16.10173392>, <10.78095047, 5.06814424, -16.46990411>, <10.94633091, 4.92807495, -16.73176075>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.09292876, 4.91143641, -14.92927859>, <7.98322688, 4.64791540, -15.07354522>, <7.91870668, 4.01916926, -15.17205484>, <7.96941358, 3.70778714, -15.11786190>,
            <8.91891427, 4.84872397, -15.62722549>, <8.83015073, 4.60771093, -15.77028098>, <8.79096345, 4.03143457, -15.87928012>, <8.84389553, 3.74552098, -15.83588958>,
            <10.62494075, 4.92999761, -16.60974648>, <10.95755862, 4.81233151, -16.98463314>, <10.21748501, 4.17209249, -16.66477312>, <10.28021925, 3.93083445, -16.64530647>,
            <10.94633091, 4.92807495, -16.73176075>, <11.11171136, 4.78800565, -16.99361739>, <10.71126079, 4.25280461, -16.87024318>, <10.76967947, 4.02814300, -16.85211566>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <7.96941358, 3.70778714, -15.11786190>, <8.02012048, 3.39640502, -15.06366896>, <8.20654131, 2.90443182, -14.84161814>, <8.38472855, 2.74960538, -14.62409417>,
            <8.84389553, 3.74552098, -15.83588958>, <8.89682762, 3.45960739, -15.79249904>, <9.12977157, 2.99022280, -15.52458016>, <9.28996514, 2.84710357, -15.32280495>,
            <10.28021925, 3.93083445, -16.64530647>, <10.34295350, 3.68957642, -16.62583982>, <10.55461697, 3.28733047, -16.41622064>, <10.68550428, 3.16091383, -16.24383636>,
            <10.76967947, 4.02814300, -16.85211566>, <10.82809816, 3.80348139, -16.83398815>, <11.02520105, 3.42890642, -16.63878892>, <11.14708447, 3.31118613, -16.47826316>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <8.38472855, 2.74960538, -14.62409417>, <8.56291578, 2.59477895, -14.40657019>, <8.96476443, 2.53932684, -13.90754018>, <9.15407437, 2.64404483, -13.66867562>,
            <9.28996514, 2.84710357, -15.32280495>, <9.45015871, 2.70398433, -15.12102974>, <9.80335712, 2.65061199, -14.65057166>, <9.96615272, 2.74547480, -14.42207357>,
            <10.68550428, 3.16091383, -16.24383636>, <10.81639159, 3.03449720, -16.07145208>, <11.08356558, 2.97495097, -15.65018037>, <11.19695573, 3.04737499, -15.43723798>,
            <11.14708447, 3.31118613, -16.47826316>, <11.26896789, 3.19346584, -16.31773739>, <11.51776266, 3.13801587, -15.92544547>, <11.62335257, 3.20545776, -15.72715163>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <9.15407437, 2.64404483, -13.66867562>, <9.34338432, 2.74876282, -13.42981106>, <9.60184071, 3.19774038, -13.09288104>, <9.75348687, 3.79432505, -12.88675598>,
            <9.96615272, 2.74547480, -14.42207357>, <10.12894832, 2.84033760, -14.19357548>, <10.37093737, 3.24202647, -13.82848928>, <10.48725600, 3.78825997, -13.61854563>,
            <11.19695573, 3.04737499, -15.43723798>, <11.31034589, 3.11979901, -15.22429558>, <11.45760899, 3.44537957, -14.86680627>, <11.49955712, 3.89710931, -14.63948066>,
            <11.62335257, 3.20545776, -15.72715163>, <11.72894248, 3.27289965, -15.52885779>, <11.86607517, 3.57608313, -15.19596060>, <11.90513765, 3.99673785, -14.98427298>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <12.29535623, 4.09559193, -15.27711520>, <11.83305746, 4.46173145, -14.94099113>, <11.66883697, 4.88513576, -15.06471082>, <11.55495433, 5.04013328, -15.19896653>,
            <12.38698186, 4.11247832, -15.37515496>, <12.24396277, 4.52700952, -15.28898082>, <12.09187373, 4.91913568, -15.40356096>, <11.98640395, 5.06268307, -15.52789880>,
            <13.19674964, 4.51130845, -16.55314907>, <13.21604011, 4.71246178, -16.45091070>, <13.13741955, 4.91516658, -16.51014150>, <13.08289824, 4.98937164, -16.57441642>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.55495433, 5.04013328, -15.19896653>, <11.44107169, 5.19513080, -15.33322225>, <11.18896156, 5.33951014, -15.69991228>, <11.07230787, 5.31695104, -15.90082310>,
            <11.98640395, 5.06268307, -15.52789880>, <11.88093416, 5.20623046, -15.65223664>, <11.64744816, 5.33994407, -15.99183818>, <11.53941203, 5.31905148, -16.17790712>,
            <13.08289824, 4.98937164, -16.57441642>, <13.02837694, 5.06357670, -16.63869133>, <12.90767922, 5.13269830, -16.81424417>, <12.85183127, 5.12189813, -16.91043022>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.07230787, 5.31695104, -15.90082310>, <10.95565419, 5.29439194, -16.10173392>, <10.78095047, 5.06814424, -16.46990411>, <10.94633091, 4.92807495, -16.73176075>,
            <11.53941203, 5.31905148, -16.17790712>, <11.43137590, 5.29815889, -16.36397606>, <11.26957807, 5.08862478, -16.70494842>, <11.26772108, 4.92615229, -16.85377502>,
            <12.85183127, 5.12189813, -16.91043022>, <12.79598332, 5.11109796, -17.00661627>, <12.71234392, 5.00278188, -17.18287773>, <12.76068119, 4.91279446, -17.23258924>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <10.94633091, 4.92807495, -16.73176075>, <11.11171136, 4.78800565, -16.99361739>, <10.71126079, 4.25280461, -16.87024318>, <10.76967947, 4.02814300, -16.85211566>,
            <11.26772108, 4.92615229, -16.85377502>, <11.26586409, 4.76367980, -17.00260163>, <11.20503658, 4.33351673, -17.07571324>, <11.25913970, 4.12545155, -17.05892486>,
            <12.76068119, 4.91279446, -17.23258924>, <12.80901846, 4.82280703, -17.28230075>, <12.81699800, 4.60876839, -17.34392037>, <12.77595694, 4.50304649, -17.35055166>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <10.76967947, 4.02814300, -16.85211566>, <10.82809816, 3.80348139, -16.83398815>, <11.02520105, 3.42890642, -16.63878892>, <11.14708447, 3.31118613, -16.47826316>,
            <11.25913970, 4.12545155, -17.05892486>, <11.31324282, 3.91738636, -17.04213647>, <11.49578513, 3.57048236, -16.86135719>, <11.60866465, 3.46145843, -16.71268995>,
            <12.77595694, 4.50304649, -17.35055166>, <12.73491588, 4.39732459, -17.35718295>, <12.82927888, 4.21799684, -17.26373133>, <12.88763056, 4.16163825, -17.18687963>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.14708447, 3.31118613, -16.47826316>, <11.26896789, 3.19346584, -16.31773739>, <11.51776266, 3.13801587, -15.92544547>, <11.62335257, 3.20545776, -15.72715163>,
            <11.60866465, 3.46145843, -16.71268995>, <11.72154418, 3.35243449, -16.56402271>, <11.95195974, 3.30108078, -16.20071056>, <12.04974940, 3.36354053, -16.01706528>,
            <12.88763056, 4.16163825, -17.18687963>, <12.94598225, 4.10527967, -17.11002792>, <13.06509273, 4.07873300, -16.92221818>, <13.11564390, 4.11102080, -16.82728501>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
        bicubic_patch { type 1  flatness 0.02  u_steps 8  v_steps 8
            <11.62335257, 3.20545776, -15.72715163>, <11.72894248, 3.27289965, -15.52885779>, <11.86607517, 3.57608313, -15.19596060>, <11.90513765, 3.99673785, -14.98427298>,
            <12.04974940, 3.36354053, -16.01706528>, <12.14753907, 3.42600028, -15.83342000>, <12.27454136, 3.70678670, -15.52511493>, <12.31071817, 4.09636639, -15.32906531>,
            <13.11564390, 4.11102080, -16.82728501>, <13.16619506, 4.14330860, -16.73235184>, <13.23184734, 4.28845768, -16.57297733>, <13.25054850, 4.48984612, -16.47163189>,
            <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>, <13.43771277, 4.70862961, -17.20734937>
        }
    }
    
    texture { Dolphin_Skin }
}
