static define s_1 <0.57143, 0.63492, 0.95238>
static define s_2 <0.50794, 0.50794, 0.93651>
static define s_3 <0.31746, 0.34921, 0.85714>
static define s_4 <0.73016, 0.55556, 0.92063>

define sub_map color_map([0.0,0.2,s_1,s_2]
                        [0.2,0.4,s_2,s_3]
                        [0.4,0.6,s_3,s_4]
                        [0.6,1,s_4,s_1])

define sub_fn noise(P,3)*cos(noise(P,2))

define sub_tex texture {
   special surface {
       color sub_map[sub_fn]
       ambient 0.3
       diffuse 0.7
       specular white,0.3
       microfacet Gaussian 10
       reflection  0.45
 }
}
define fin object {
   bezier 2,0.05,3,3,
     <0.5,3.5,-1.3>,<0,3,0>,<0,3,0>,<0.5,3.5,1.3>,
     <-1,2.3,-1.1>,<-0.6,2.1,0>,<0.6,2.1,0>,<1,2.3,1.1>,
     <-1,-2.3,-1>,<-0.6,0.1,0>,<0.6,0.1,0>,<1,-2.3,1>,
     <-0.8,0,-0.9>,<-0.2,0,0>,<0.2,0,0>,<0.8,0,0.9>
  uv_steps 8,8
   rotate <0,90,0> translate <-3,-3,0>
  metallic_silver
  rotate <0,45,0>
  translate <2,3,0>
  scale <1,0.7,1> }


define fins object {
   fin+
   fin {rotate<0,0,45>}+
   fin {rotate<0,0,90>}+
   fin {rotate<0,0,135>}+
   fin {rotate<0,0,180>}+
   fin {rotate<0,0,225>}+
   fin {rotate<0,0,270>}+
   fin {rotate<0,0,315>}

}

define turbine object {
 fins {translate <0,0,-1>}+
 object { cylinder <0,0,3>,<0,0,-1.2>,2.7}+
 object { cylinder <0,0,3>,<0,0,-1.2>,2.4}+
 object { disc <0,0,-1.2>,<0,0,1>,2.4,2.7}+
 object {parabola <0,0,-3>,<0,0,-1>,0.7 }+

 //center
 object {cylinder <0,0,-1>,<0,0,3>,0.8 }+
 object {disc <0,0,-1>,<0,0,1>,0.8 }

}

define right_arm object{
  turbine+
 object { cylinder <2.68,1.4,0>,<7,2.2,0>,0.4
            scale <1,1,6>}
}

define left_arm object {
  turbine+
 object { cylinder <-2.68,1.4,0>,<-7,2.2,0>,0.4
            scale <1,1,6>}
}
define body object {
   sphere <0,0,0>,2
   scale <2,0.4,0.9>
   rotate <0,90,0>
}


define tail object {
  object {
    torus 1,0.3,<0,0,3>,<0,0,1>
    scale <0.5,1,1>
   }+
  object {
    cone <-3,3.1,3>,0,<0,2.8,3>,1
    scale <1,0.3,1>
  }+
  object {
    cone <3,3.1,3>,0,<0,2.8,3>,1
    scale <1,0.3,1>
  }
}


define lamp_map color_map([0.0,1,<0.301585,0.373015,0.83335>,0.7,<0.3,0.3,0.8>,1])

define lamp object {
   object {
      cone <0,0,-14>,2,<0,0,-3>,0}+
   object {
     light <0.3,0.3,0.75>,<0,0,-5.5> }
   texture {
     special surface {
        color lamp_map[noise(P,1)] //adjust 
        transmission white,1
        ambient 0.5
        diffuse 0.9 } scale <0.5,0.5,0.5>}
}

define submarine object {
  body+
  right_arm {scale <0.25,0.25,0.25> translate <-2.8,-0.5,0>}+
  left_arm {scale <0.25,0.25,0.25> translate <2.8,-0.5,0>}+
  tail {translate <0,1,0>}+
  lamp {rotate <-30,0,0> translate <0,1,0>  }+
  lamp {rotate <-20,10,30> translate <0,1,0> }
  sub_tex
 // shiny_cyan
}


