// -============------------------------------------------------------------
//  Adam Parrish
//  Entry for Internet RayTracing Competition -- July and August '96
// -============------------------------------------------------------------
//  Image Title: Summer Bubbles
// -============------------------------------------------------------------
// This is a fairly simple scene.  A few marbles, a bottle of bubbles, the
// bottle's cap, the Magic Bubble Wand and some bubbles floating in the
// air.  Mostly spheres, cylinders, and toruses.  Enjoy!
// -============------------------------------------------------------------
// Please send any comments to myth@alinc.com or visit my homepage at
// http://www.alinc.com/~myth.
// -============------------------------------------------------------------

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

// Pretty simple camera object.  Right is 4/3 to maintain aspect ratio
camera {
   location  <-4, 32, 16>
   right     <4/3, 0, 0>
   look_at   <10, 0, 0> 
}

// Yellowish-White ambient light so it looks like a bright summer day
global_settings { ambient_light rgb<1, 1, .95> }

// Plain and simple light source.  The objects are close to the ground,
// so their shadows should be crisp, thus soft lighting wouldn't do much
// for realism.
light_source { <-6000,6000,-4000> color White }

// The asphalt ground.  Not very convincing, but close enough...
plane { y, 0
  pigment { color rgb<.35, .35, .35> }
  normal { bumps .5 scale .15 }
  finish { crand .05 }
}

// The sky.  This new skies.inc file has some useful stuff in it!
// S_Cloud1 looks exactly like the skies during the summers at my home.
sky_sphere { S_Cloud1 }
                 
// The glass casing that encloses all the marble objects.  I don't know
// if this is how marbles really work, but it sure makes them look more
// realistic here...
#declare MarbleGlassCasing = 
difference {
  
  object { sphere { <0, 0, 0>, 1 } }
  object { sphere { <0, 0, 0>, .975 } }
  
  pigment { color rgbf<1, 1, 1, 1> }
  finish { reflection .15 phong 1 phong_size 200 
           refraction 1 ior 1.33 caustics 1 }
}

// Following are a couple of definitions of the marble objects.  The
// transparent objects use pov-ray 3.0's caustics feature, making the
// shadows look a lot better
#declare LittleRedMarble =
union {
  object { MarbleGlassCasing }
  object {
    sphere { <0, 0, 0>, .974
      pigment { color red 1 }
    }
  }
}
object { LittleRedMarble translate <6, .5, 2> }
object { LittleRedMarble translate <1, .5, 1> }

#declare BlueTransparentMarble = 
union {
  object { MarbleGlassCasing }
  sphere { <0, 0, 0>, .974
    pigment { color rgbf<.3, .3, .7, .8> }
    finish { refraction 1 ior 1.33 caustics 1 }
  }
}
object { BlueTransparentMarble translate <4.5, .5, 2.5> }
object { BlueTransparentMarble translate <5, .5, 7> }

#declare GreenTransparentMarble = 
union {
  object { MarbleGlassCasing }
  sphere { <0, 0, 0>, .974
    pigment { color rgbf<.3, .8, .4, .8> }
    finish { refraction 1 ior 1.33 caustics 1 }
  }
}
object { GreenTransparentMarble translate <1.5, .5, -1> }
object { GreenTransparentMarble translate <6.5, .5, 4.5> }

#declare GlassyMarble =
union {
  object { MarbleGlassCasing }
  sphere { <0, 0, 0>, .974
    pigment { color rgbf<.9, .95, .9, .99> }
    finish { refraction 1 ior 1.33 caustics 1 }
  }
}
object { GlassyMarble translate <9, .5, 2> }
object { GlassyMarble translate <8, .5, -2> }
object { GlassyMarble translate <2.5, .5, 5> }

#declare GreatMasher =
object { GlassyMarble scale <1.5, 1.5, 1.5> }

object { GreatMasher translate <6, 1, 0> }

// The bubble objects use pov-ray 3.0's new iridescence features.  Thanks to
// whomever put this in!  It's quite useful for the soapy look.
#declare NeatoIridescentBubble =
sphere { <0, 0, 0> 1
    pigment { color rgbt<.00, .01, .00, .99> }
    finish {  
      irid { // I fiddled with these settings for awhile, these seem to work
        .25  // well for a bubble
        thickness .9
        turbulence .6
      }
      reflection .042
      phong .1
      phong_size 24
    }
    hollow
}

// Bubble the scene . . .
object { NeatoIridescentBubble translate <3.42, 4, 3.62> 
         scale <3,3,3> }
object { NeatoIridescentBubble translate <-1.5, 6, 3.9>
         scale <2.5,2.5,2.5> }
object { NeatoIridescentBubble translate <.14, 4.5, -1.3> 
         scale <3.7,3.7,3.7> }

// The BottleOfBubbles is a very simple CSG involving a few superellipsoids
// and some cylinders.  Nothing new or remarkable.  It should be
// reminiscent of a real bottle of bubbles.
#declare BottleOfBubbles =
union {
  superellipsoid { <1, .2>
    rotate <90, 0, 0>
    scale <5, 2, 5>
    translate <0, 2, 0>
    hollow
  }
  cylinder {
    <0, 2.5, 0>
    <0, 10, 0>
    4.65
    open
  }
  difference {
    superellipsoid { <1, .2>
      rotate <90, 0, 0>
      scale <5, 2, 5>
      translate <0, 12, 0>
      hollow
    }
    cylinder {
      <0, 10, 0>
      <0, 15, 0>
      3
    }
  }
  cylinder {
      <0, 14, 0>
      <0, 16, 0>
      3
      open
  }
  cylinder {
      <0, 14, 0>        
      <0, 16, 0>
      3.5
      open
  }
  torus { 3.25 .25
    translate <0, 16, 0>
  }
  torus { 3.5 .15
    translate <0, 15.5, 0>
    pigment { color rgb<1, .2, .05> }
    finish { reflection .05 phong .1 ambient .25 }
  }
  torus { 3.5 .15
    translate <0, 14.5, 0>
    pigment { color rgb<1, .2, .05> }
    finish { reflection .05 phong .1 ambient .25 }
  }
  cylinder {
    <0, 4.2, 0>
    <0, 9.8, 0>
    4.7
    open
    pigment { image_map { gif "bblwrpr.gif" map_type 2 } 
      scale <.42, 7.42, .42>
      translate <0, 2.9, 0>
      rotate <0, 20, 0>
    }
  }
  
  pigment { color rgbf<1, .2, .05, .1> }
  finish { reflection .05 phong .4 phong_size 5 ambient .25 }
}

object { BottleOfBubbles translate <18, 0, 4> }

// This is the BottleOfBubblesCap.  It also is a simple CSG of a few
// cylinders and a torus.
#declare BottleOfBubblesCap =
union {
  cylinder {
    <0, 0, 0>
    <0, .5, 0>
    4
  }
  cylinder {
    <0, .5, 0>
    <0, 2.5, 0>
    4
    open
  }
  cylinder {
    <0, .5, 0>
    <0, 2.5, 0>
    3.6
    open
  }
  disc { <0, .52, 0>, y, 3.6 // You can't see this in the rendered picture,
    pigment { color rgbf<.99, .99, .99, .99> } // but what the hey...
    finish { 
      irid { .2 thickness .2 turbulence .5 } 
      reflection .1
      phong .1
      phong_size 25
    }
  }
  torus { 3.8 .2
    translate <0, 2.5, 0>
  }
  pigment { color rgb<.95, .95, .95> }
  finish { reflection .1 phong .2 phong_size 50 }
}

object { BottleOfBubblesCap translate <24, 0, -6> }

// The following declares the bubble wand.  It's nothing special either:
// just a box, a torus, and a disc (I know this is the wimpy way out, but
// it's fast and easy)
#declare MagicBubbleWand =
union {
  torus { 1 .1 } // the big bubble blower
  box {
    <-.25, 0, -5>
    <.25, .1, -1>
  }
  disc {
    <0, .25, -6>
    y
    1.2
    .9
  }
  translate <0, .1, 0>
  pigment { color rgbf<1, .2, .05, .1> }
  finish { reflection .05 phong .4 phong_size 5 }
}   
object { MagicBubbleWand rotate <0, -90, 0> translate <2.2, 0, 4.8> 
         scale <2.5, 2.5, 2.5> }

// This is the four-hole "Bubble-Pipe" that came with a bubble kit that
// my little sister Claire got for her birthday.  It doesn't seem to work,
// but it looks really cool here. :)
#declare BubblePipe =
union {
  // Rather complex (but not overly so) "bubble-blowing" part of the
  // pipe.
  difference {
    cylinder {
      <0, .2, 0>
      <0, 3.5, 0>
      1.4
    }
    union {
      sphere { <1, 3.5, 1> 1 }
      sphere { <-1, 3.5, 1> 1 }
      sphere { <-1, 3.5, -1> 1 }
      sphere { <1, 3.5, -1> 1 }
    }
  }
  intersection {
    plane { y, 3.5 }
    difference {
      union {
        sphere { <1, 3.5, 1> 1 hollow }
        sphere { <-1, 3.5, 1> 1 hollow }
        sphere { <-1, 3.5, -1> 1 hollow }
        sphere { <1, 3.5, -1> 1 hollow }
      }
      union {
        sphere { <1, 3.5, 1> .9 hollow }
        sphere { <-1, 3.5, 1> .9 hollow }
        sphere { <-1, 3.5, -1> .9 hollow }
        sphere { <1, 3.5, -1> .9 hollow }
      }
    }
  }
  // This cylinder is the pipe that you blow in to bubble the bubbles.
  cylinder {
    <0, 1, 0>
    <0, .5, -14>
    .5
    pigment { color rgbf<.9, .9, .9, .1> }
    finish { reflection .001 phong .2 phong_size 50 ambient .2 }
  }
  // This is a little yellow cylinder that sits on the bottom of the big
  // red one.
  cylinder {
    <0, 0, 0>
    <0, .2, 0>
    1.25
    pigment { color rgbf<.9, .9, 0, .1> }
    finish { reflection .001 phong .2 phong_size 50 ambient .2 }
  }
  pigment { color rgbf<1, .2, .05, .1> }
  finish { reflection .05 phong .3 phong_size 4 ambient .25 }
}
object { BubblePipe translate <5, 0, -7> scale <1.5, 1.5, 1.5> }

