/****************************************************
  Asteroid Homeworld
  Persistance of Vision 3.0
  Kiet To
 ****************************************************/

//#include "colors.inc"
//#include "textures.inc"

// **** Test Camera ****
/*
camera {
  location  <-7.1,    7.3,  -8.4>
  direction < 0.0,    0.0,   2.6>
  sky       < 0.0,    1.0,   0.0>    // Use right handed-system!
  up        < 0.0,    1.0,   0.0>    // Where Z is up
  right     < 1.3333, 0.0,   0.0>
  look_at   < 0.0,    0.0,   0.0>
}
*/

// **** Textures ****
#declare Astro_Tex= texture {
    pigment {
      bozo
      color_map{
        [ 0.1 color rgb<0.31,0.05,0.00> ]
        [ 0.5 color rgb<0.26,0.03,0.08> ]
        [ 0.9 color rgb<0.35,0.05,0.05> ]
      }
      scale 0.3
    } 
    normal { dents 0.95 scale 0.1 }
    finish { 
      diffuse 0.9
      ambient 0.30
      specular 0.01
    }
  }

#declare Far_Water = texture {
  pigment { color rgb< 0.08, 0.14, 0.80 > }
  normal { bumps  bump_size 1.00 }
  finish { reflection 0.20 }
  scale 0.01
}

// **** Test Light ****
// light_source { <-47.700, 100.00, -100.000> color White }

// **** Objects ****
#declare Asteroid_obj = blob {
  threshold 0.6
  sphere { < 0.00, 0.00, 0.00 >, 2.1,  1.0 }
  sphere { < 0.00,-1.00, 0.00 >, 0.6,  0.1 }
  sphere { < 0.00,-1.00, 0.00 >, 0.6,  0.1 rotate < 60,-25,  5 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.5,  0.1 rotate <  4, 40,-15 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.4,  0.1 rotate <-11, -7, 65 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.6,  0.1 rotate < 10,-14, -5 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.7,  0.1 rotate <-35,-14, 12 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.6, -0.1 rotate <-10, 54, -5 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.5,  0.1 rotate <-34, 14,-60 > }
// craters
  sphere { < 0.00,-1.00, 0.00 >, 0.3, -1.0 rotate < 23,-37, 25 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.4, -0.9 rotate < -4, 46,-45 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.3, -0.6 rotate <-41, -7,  5 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.2, -0.7 rotate < 60,-21, -5 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.2, -0.4 rotate < 35,-14, 52 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.3, -0.8 rotate <-63, 52, -5 > }
  sphere { < 0.00,-1.00, 0.00 >, 0.5, -0.8 rotate <-28,  4,-60 > }
}

#declare Land_Shape = height_field {
  gif "disclake.gif"
  smooth
  water_level 2/256
  texture {
    pigment {      
      image_map {
        gif "disclake.gif"
        map_type 0
      }
    }
    rotate x*90
  }
  translate < -0.5, 0, -0.5 >
  scale < 5, 0.75 ,5 >
}

#declare Glass_Dome = union {
  difference {
    sphere { < 0,0,0 >,0.99 }
    union {
      sphere { < 0,0,0 >,0.95 }
      box { < 1,0,1 >, < -1,-1,-1> }
    }
    texture { Glass 
      finish { ambient 0.05 }
    }
  }
  union { 
    torus { 0.97 0.03 }
    cylinder { < 0.0, 0.0, 0.0 >, < 0.0, 0.01, 0.0 >, 0.99 }
    texture { pigment { color White } finish { Shiny } } 
  }
}

#declare Glass_Dome2 = union {
  difference {
    sphere { < 0,0,0 >,0.99 }
    union {
      sphere { < 0,0,0 >,0.95 }
      box { < 1,0,1 >, < -1,-1,-1> }
    }
    texture { Glass }
  }
  union { 
    torus { 0.97 0.03 }
    cylinder { < 0.0, 0.0, 0.0 >, < 0.0, 0.01, 0.0 >, 0.99 }
    texture { pigment { color White } finish { Shiny } } 
  }
}

#declare Yellow_Lights = sphere { 0, 1
  hollow
  texture {
    pigment { colour Clear }
    halo {
      emitting
      spherical_mapping
      linear
      colour_map {
        [ 0.0 colour rgbt < 1.0, 1.0, 0.0, 1> ]
        [ 0.5 colour rgbt < 1.0, 1.0, 1.0, 0> ]
        [ 1.0 colour rgbt < 1.0, 1.0, 1.0,-1> ]
      }
      samples 10
      scale 0.6
    }
//  translate < 0, 0, 100 >
  }
}

#declare Many_Lights = union {
  #declare Lcount = 1
  #while (Lcount <= 100)
    object { Yellow_Lights
      scale 0.05
      translate < 2.65*sin(2*pi/100*Lcount),0,2.65*cos(2*pi/100*Lcount) >
    }
    #declare Lcount = Lcount + 1
  #end

  bounded_by { cylinder { < 0.0,-0.1, 0.0 >, < 0.0, 0.1, 0.0 >, 2.9 } }
}

#declare Many_Lights2 = union {
  #declare R1 = seed(0)
  #declare Lcount = 1
  #while (Lcount <= 30)
    object { Yellow_Lights
      scale 0.04
      #declare rad1 = 1.5*rand(R1)
      #declare ang1 = 2*pi*rand(R1)
      #declare height = 0.35+0.20*rand(R1)
      translate < rad1*sin(ang1),height,rad1*cos(ang1) >
    }
    #declare Lcount = Lcount + 1
  #end
  bounded_by { cylinder { < 0.0, 0.35, 0.0 >, < 0.0, 0.55, 0.0 >, 1.5 } }
}

#declare Astro_World = union {
  difference {
    object{ Asteroid_obj } 
    box { < 1.1, 0.0, 1.1 >, <-1.1, 1.2,-1.1> } 
    texture { Astro_Tex } 
    bounded_by { box { < 1.1, 0.0, 1.1 >, <-1.1,-1.2,-1.1 > } }
    scale 2.6
  }
  disc { <0,0,0>,y,1 texture { Far_Water } scale 2 translate <0,0.75*55/256,0> }
  object { Land_Shape }
  object { Glass_Dome scale < 2.6, 2, 2.6 > }

  object { Many_Lights }
  object { Many_Lights2 }
}
