/****************************************************
  Beach side balcony
  Persistance of Vision 3.0
  Kiet To
 ****************************************************/

//#include "colors.inc"
//#include "textures.inc"

// **** Test Cameras ****
/*
#declare cam1 = camera {
  location  <-21.0,  21.0, -24.0>
  direction < 0.0,    0.0,   2.6>
  sky       < 0.0,    1.0,   0.0>    // Use left handed-system!
  up        < 0.0,    1.0,   0.0>    // Where Y is up
  right     < 1.3333, 0.0,   0.0>
  look_at   < 0.0,    0.0,   0.0>
}
#declare cam2 = camera {
  location  < -21.0,  21.0, -24.0>
  direction < 0.0,    0.0,   2.6>
  sky       < 0.0,    1.0,   0.0>    // Use left handed-system!
  up        < 0.0,    1.0,   0.0>    // Where Y is up
  right     < 1.3333, 0.0,   0.0>
  look_at   < -9.0,    0.0,   0.0>
}

camera { cam2 }
*/
// **** Test Lighting ****
// light_source { < 5, 50, -20 > colour White } 

// The Pine Plank
#declare Plank = union {
  box { < -0.50, -0.25, -10 >, < 0.50, 0.20, 5 > }
  box { < -0.49,  0.20, -10 >, < 0.49, 0.21, 5 > }
  cylinder { < -0.49, 0.25, -10 >, < -0.49, 0.25, 5 >, 0.01 }
  cylinder { <  0.49, 0.25, -10 >, <  0.49, 0.25, 5 >, 0.01 }
}

#declare Plank_Floor = union {
  // Plank count
  #declare RndSd=seed(0)
  #declare Pcount = 0
  #while (Pcount < 20)
    object { Plank
      translate < -11 + 1.1*Pcount, 0, 0 >
      texture { Yellow_Pine  translate < Pcount, 0, -Pcount > 
        finish { ambient (0.15+0.1*rand(RndSd)) }
      }
    }
    #declare Pcount = Pcount + 1
  #end
}

// Hand Rail Posts
#declare Rail_Post = union {
  cylinder { < 0.0,-4.0, 0.0 >, < 0.0, 2.5, 0.0 >, 0.4 
    texture { Yellow_Pine } }
  sphere   { < 0.0, 0.0, 0.0 >, 0.35 
    scale < 1.0, 0.5, 1.0 > 
    translate < 0.0, 2.5, 0.0 >
    texture { Chrome_Texture } }
}

#declare Pine_Post = union {
  // Post count 
  #declare Pcount = 0
  #while (Pcount < 5)
    object { Rail_Post  translate < -10 + Pcount*5, 0, 4 > }
    #declare Pcount = Pcount + 1
  #end
}

#declare Hand_Rail = union {
// Hand Rail (front)
  box { < -10.5, 2.4, 3.5 >, < 10.5, 2.0, 4.5 > texture { Yellow_Pine } }
  box { < -10.5, 2.4, 4.5 >, < -9.5, 2.0, 0.0 > texture { Yellow_Pine } }
  box { <  -9.5, 2.4, 1.0 >, <  -12, 2.0, 0.0 > texture { Yellow_Pine } }
  object { Rail_Post  translate < -10, 0, 0.5 > }
  box { <  -6.5, 0.0, 0.5 >, <  0.0,-0.4,-0.5 > rotate < 0, 0, 30 >
    translate < -12, 2.4, 0.5 >
    texture { Yellow_Pine }
  }
}

// Steps and Post
#declare Step_and_Post = union {
  box      { <-0.6,-0.1,-10> <0.6,0.1,1.0> }
  cylinder { < 0.0, 0.0, 0.5 >, < 0.0, 2.4, 0.5 >, 0.2 }
  texture { Yellow_Pine }
}

declare Pine_Stair = union {
  #declare Scount = 0
  #while (Scount < 4)
    object { Step_and_Post 
      translate < -12.6 - Scount*1.2, -(Scount+1)*1.2*tan(pi/6), 0 >
    }
    #declare Scount = Scount + 1 
  #end
}

#declare Beach_Balcony = union {
  object { Plank_Floor }
  object { Pine_Post }
  object { Hand_Rail }
  object { Pine_Stair }
}
