/****************************************************
  Deck Chair
  Persistance of Vision 3.0
  Kiet To
 ****************************************************/

//#version 3.0
//global_settings { max_trace_level 5  assumed_gamma 2.2 }
//#include "colors.inc"
//#include "textures.inc"

// **** Test Camera ****
/*
camera {
  location  <-7.1,    7.3,  -8.4>
  direction < 0.0,    0.0,   2.6>
  sky       < 0.0,    1.0,   0.0>    // Use right handed-system!
  up        < 0.0,    1.0,   0.0>    // Where Z is up
  right     < 1.3333, 0.0,   0.0>
  look_at   < 0.0,    0.0,   0.0>
}
*/
// **** Test Lights ****
/*
light_source { <47.700, 100.000, -28.300> color White }
light_source { <47.700, -28.300, 100.000> color White }
*/
// **** Objects ****
#declare Chair_Part1 = prism {
  linear_sweep
  linear_spline
  0,0.1
  8,
  <0.0,0.0>, <1.0,0.0>, <0.9,1.9>, <0.8,2.0>,
  <-0.8,2.0>, <-0.9,1.9>, <-1.0,0.0>, <0.0,0.0>
  pigment { Red }
  finish { Shiny }
}

#declare Chair_Part2 = prism {
  linear_sweep
  linear_spline
  0,0.1
  8,
  <0.0,0.0>, <1.0,0.0>, <0.8,2.0>, <0.7,2.1>,
  <-0.7,2.5>, <-0.8,2.4>, <-1.0,0.0>, <0.0,0.0>
  pigment { Red }
  finish { Shiny }
}

#declare Chair_Leg = box { < 0.15, 0.0, 0.1 >, <-0.15,-1.2,-0.1 > }

#declare Arm_Rest = union {
  box { < 0.15, 0.1, 1.2 >, <-0.15,-0.1,-1.2 > }
  cylinder { < 0.15, 0.0, 1.2 >, <-0.15, 0.0, 1.2 >, 0.1 }
  cylinder { < 0.15, 0.0,-1.2 >, <-0.15, 0.0,-1.2 >, 0.1 }
  object { Chair_Leg rotate < 30, 0, 0 > translate < 0, 0,-0.8 > }
  object { Chair_Leg rotate <-30, 0, 0 > translate < 0, 0, 0.8 > }
  pigment { Blue }
  finish { Shiny }
}

#declare Deck_Chair = union {
  object { Chair_Part1 rotate < -50, 0, 0 > translate <0,0.5,1.2 > }
  box { < 1.0, 0.0, 1.2 >, <-1.0, 0.1, -1.2 > 
    translate < 0, 0.5, 0 > pigment { White} 
    finish { Shiny }
  }
  object { Chair_Part2 rotate < 170, 0, 0 > translate <0,0.6,-1.2> } 
  object { Arm_Rest translate < -1.15, 0.9, 0.2 > }
  object { Arm_Rest translate <  1.15, 0.9, 0.2 > }
}

//object { Deck_Chair }

//plane { y, 0
//  pigment { Green }
//}
