/****************************************************
  Cup of OJ
  Persistance of Vision 3.0
  Kiet To
 ****************************************************/

//#include "colors.inc"
//#include "textures.inc"

// **** Test Camera ****
/*
camera {
  location  <-7.1,    7.3,  -8.4>
  direction < 0.0,    0.0,   2.6>
  sky       < 0.0,    1.0,   0.0>    // Use right handed-system!
  up        < 0.0,    1.0,   0.0>    // Where Z is up
  right     < 1.3333, 0.0,   0.0>
  look_at   < 0.0,    2.0,   0.0>
}
*/

// **** Textures ****
#declare BlueTint_Glass = texture {
  pigment {
    color rgbf < 0.93, 0.95, 1.00, 0.96 >
  }
  finish {
    diffuse    0.000
    ambient    0.050
    reflection 0.020
    refraction 1.000
    ior        1.500
    specular   1.000
    roughness  0.001
  }
}

#declare Soft_Drink = texture {
  pigment {
    color rgbf < 1.00, 0.75, 0.45, 0.750 >
  }
  finish {
    diffuse    0.350
    ambient    0.450
    phong      0.100
    reflection 0.20
    refraction 1.000
    ior        1.333
    specular   0.800
    roughness  0.001
  }
}
// **** Test Lights ****
/*
light_source { <47.700, 100.000, -28.300> color White }
light_source { <47.700, -28.300, 100.000> color White }
*/

// **** Objects ****

#declare Glass_Cup_Ext = merge {
  cylinder { < 0.0, 0.305,0.0>,      < 0.0, 0.0, 0.0 >, 0.9 } // Base
  cone     { < 0.0, 0.3, 0.0 >, 0.9, < 0.0, 2.305,0.0>, 1.0 } // Trunk
  cylinder { < 0.0, 2.3, 0.0 >,      < 0.0, 3.3, 0.0 >, 1.0 } // Neck
  torus    { 0.95, 0.05  translate  3.3*y }      // Rim
}

#declare Glass_Cup_Int = merge {
  cone     { < 0.0, 0.3, 0.0 >, 0.8, < 0.0, 2.305,0.0>, 0.9 } // Inner Trunk
  cylinder { < 0.0, 2.3, 0.0 >,      < 0.0, 3.4, 0.0 >, 0.9 } // Inner Neck
}

#declare Glass_Cup = difference {
  object { Glass_Cup_Ext }
  object { Glass_Cup_Int }
  texture { BlueTint_Glass
    finish { ambient 0.25 }
  }
}

#declare Drink_in_Cup = merge {
  cylinder { < 0.0, 2.3, 0.0 >,      < 0.0, 2.85, 0.0 >, 0.9 }
  cone     { < 0.0, 0.3, 0.0 >, 0.8, < 0.0, 2.305,0.0 >, 0.9 }
  texture { Soft_Drink }
  scale 0.999
} 

#declare Straw_Object = cylinder {
  < 0.73, 0.31, 0.00 >, <-1.30, 4.3, 0.00>, 0.07
  rotate < 0, 40, 0 >
  texture {
    pigment { color White }
    finish { Shiny  ambient 0.25 }
  }
}

#declare Cup_Of_OJ = union { 
  object { Glass_Cup }
  object { Drink_in_Cup }
  object { Straw_Object }
}
