/**********************************************
 Nebula and Space Background
 Persistence Of Vision - Version 3.0
 Kiet To
 **********************************************/

/*
#version 3.0
global_settings { assumed_gamma 2.2 }
*/ 

//#include "colors.inc"
//#include "textures.inc"
#include "shapes.inc"

// ***** Test Camera ****
/*
camera {
   location  <0.0,   0.0, -100.0>
   direction <0.0,   0.0,    1.0>
   up        <0.0,   1.0,    0.0>
   right     <1.667, 0.0,    0.0>
   look_at   <0.0,   0.0,    0.0>
}
*/

// ***** Test Lighting *****
// light_source{<-20,100,-100> colour White}

// ***** Textures *****
#declare Nebula_Gas =
texture {
   pigment { colour Clear }
   finish { refraction 1 ambient 2.5 }

   halo {
      linear
      cylindrical_mapping
      emitting
      turbulence <0.7,0,0.0>
      colour_map {
         [0 color rgbt <0,0,0,1> ]
         [1 color rgbt <1,0,0,0.8>]
      }
      translate <-1,0,0>
   }
   halo {
      linear
      cylindrical_mapping
      emitting
      turbulence <0.0,0,0.6>
      colour_map {
         [0 color rgbt <0,0,0,1> ]
         [1 color rgbt <0,0,1,0.9>]
      }
      translate <0,0,1>
   } 
   halo {
      linear
      cylindrical_mapping
      emitting
      turbulence <0.6,0,0.75>
      colour_map{
         [0 color rgbt <0,0,0,1> ]
         [1 color rgbt <1,0,1,0.9>]
      }
      rotate <20,-30,20>
      translate <0.5,-0.5,0>
   }
   scale 0.6
}

// ***** Objects *****
#declare Nebula = object{ Cube 
  hollow texture{ Nebula_Gas scale < 0.5, 0.5, 1.0 >} 
  scale < 3750, 4000, 500 > 
  translate < 0, 0, 9000 >
}

#declare Star_Background = plane { z, 10000
  hollow
  texture {
    pigment {
      image_map {
        gif "starmap.gif"
        map_type 0
      }
    }
    finish { ambient 1.0 }
  }
  scale < 4000, 4000, 1.0 >
}

#declare Red_Sun = sphere { 0, 1
  hollow
  texture {
    pigment { colour Clear }
    halo {
      emitting
      spherical_mapping
      linear
      colour_map {
        [ 0.0 colour rgbt < 1.0, 0.1, 0.0, 1> ]
        [ 0.5 colour rgbt < 1.0, 0.0, 0.0,-1> ]
        [ 1.0 colour rgbt < 1.0, 0.0, 0.0,-1> ]
      }
      samples 10
      scale 0.6
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.3
      colour_map {
        [ 0.0 colour rgbt < 1.0, 0.0, 0.0, 1.0> ]
        [ 1.0 colour rgbt < 1.0, 0.0, 0.0, 0.5> ]
      }
      samples 10
      scale 0.9
    }
  }
//  scale 50
//  translate < 0, 0, 100 >
}

#declare Yellow_Sun = sphere { 0, 1
  hollow
  texture {
    pigment { colour Clear }
    halo {
      emitting
      spherical_mapping
      linear
      colour_map {
        [ 0.0 colour rgbt < 1.0, 0.9, 0.0, 1> ]
        [ 0.5 colour rgbt < 1.0, 1.0, 0.0,-1> ]
        [ 1.0 colour rgbt < 1.0, 1.0, 0.0,-1> ]
      }
      samples 10
      scale 0.5
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.4
      colour_map {
        [ 0.0 colour rgbt < 1.0, 0.0, 0.0, 1.0> ]
        [ 1.0 colour rgbt < 1.0, 0.0, 0.0, 0.5> ]
      }
      samples 10
      scale 0.9
      rotate < 123, -87, 81 >
    }
  }
//  scale 50
//  translate < 0, 0, 100 >
}

#declare Lense_Flare= cylinder { 
  < 0,0,0 >, <0,1,0>, 1 
  hollow
  texture {
    pigment { colour Clear }
    halo {
      emitting
      cylindrical_mapping
      linear
      colour_map {
        [ 0.0 colour rgbt < 1,1,1,0.5 > ]
        [ 0.4 colour rgbt < 1,1,1,1.0 > ]
        [ 1.0 colour rgbt < 1,1,1,1.0 > ]
      }
      samples 10
      scale 1.1
    }
  }
  scale < 20, 1, 20 >
  rotate <90,0,0>
}
// -------------------------------------------------
#declare Land_Shape2 = height_field {
  gif "disclak2.gif"
  smooth
  water_level 2/256
  texture {
    pigment {
      bozo
      color_map {
        [ 0.3 color rgb< 0.0, 0.5, 0.1 > ]
        [ 0.8 color rgb< 0.1, 0.8, 0.1 > ]
        [ 0.9 color rgb< 0.3, 0.3, 0.1 > ]
        [ 1.0 color rgb< 0.9, 0.9, 0.1 > ]
      }
      scale 0.1
      translate < 0, 0, -0.1 >
    }
/*
      image_map {
        gif "disclak2.gif"
        map_type 0
      }
      translate < 0,0,-0.1>
    }
    rotate x*90
*/
  }
  translate < -0.5, 0, -0.5 >
  scale < 2.0, 0.15 ,2.0 >
  translate < 0, -55/256*0.15, 0 >
}

// -----------------------------------------------------
#declare Ocean_Disc = disc { <0,0,0>, y, 1
  texture {
    pigment {
      bozo 
      color_map {
        [0.3  color rgb< 0.1, 0.1, 0.8 > ]
        [0.7  color rgb< 0.1, 0.2, 0.5 > ]
      }
      scale 0.3
      translate < 0, 0, 0.2 >
    }
    normal { 
      average
      normal_map {
        [0.70 bumps 1.0 scale 0.002 ]
        [0.30 waves 1.2 scale 0.001 ]
        [0.60 ripples 1.0 scale 0.004 translate < -0.02, 0,-0.80 > ]
      }
    }
    finish { Shiny  reflection 0.3  brilliance 2 }
  }
}

#declare Water_Home = sphere { < 0, 0, 0 >, 1
  texture { 
    pigment {
      image_map {
        gif "tech.gif"
        map_type 0
      }
      rotate < 90, 0, 0 >
    }
  }
  texture {
    pigment {
      bozo
      color_map {
        [0.10 color rgbf< 0.1, 0.5, 0.2, 0.5 > ]
        [0.20 color rgbf< 1.0, 1.0, 1.0, 1.0 > ]
      }
      scale 0.1
    }
    finish { Metal }
  }
}
// object { Star_Background }
// object { Star_Background rotate < 180, 0, 0 > }
// object { Nebula }
// object { Red_Sun scale 500 translate < 500, 500,1000 > }
// object { Yellow_Sun scale 200 translate < -2800, 500, 5000 > }
// object { Ocean_Disc translate < 0.0, -0.01, -99 > }
