#include "colors.inc"
#include "textures.inc"
#include "nebula.inc"
#include "astro.inc"
#include "balcony.inc"
#include "table.inc"
#include "cup.inc"
#include "chair.inc"
#include "sail.inc"
#include "space.inc"

#declare FinalCam = camera {
  location   <   0.0,   0.0,-100.0 >
  direction  <   0.0,   0.0,   2.0 >
  right      <   5/3,   0.0,   0.0 >
  sky        <   0.0,   1.0,   0.0 >
  up         <   0.0,   1.0,   0.0 >
  look_at    <   0.0,   0.0,   0.0 >
}

#declare TestCam = camera {
  location   <   0.0,   5.0,-110.0 >
  direction  <   0.0,   0.0,   4.0 >
  right      <   5/3,   0.0,   0.0 >
  sky        <   0.0,   1.0,   0.0 >
  up         <   0.0,   1.0,   0.0 >
  look_at    <   0.0,   0.0,-100.0 >
}

#declare TestCam2 = camera {
  location   <  200.0,  200.0,-50.0 >
  direction  <   0.0,   0.0,   4.0 >
  right      <   5/3,   0.0,   0.0 >
  sky        <   0.0,   1.0,   0.0 >
  up         <   0.0,   1.0,   0.0 >
  look_at    <   0.0,   0.0, -50.0 >
}

camera{FinalCam} 

union {
  object { Star_Background }
  object { Star_Background rotate < 180, 0, 0 > }
}

object { Nebula translate < 1800, 0, 0 > }

object { Red_Sun scale 500 translate < 700, 400, 1500 > }
light_source { < 700, 400, 1500 >, color rgb < 1.0,0.5,0.5 > }
object { Yellow_Sun scale 200 translate < -2000, 1000, 5000 > }
light_source { <-2000,1000,5000>, color rgb < 1.0, 1.0, 0.5 > }

union {
  object { Ocean_Disc }
  object { Land_Shape2 rotate < 0,-20, 0 > }
  translate < 0.0, -0.02, -99 >
}
object { Water_Home  scale < 0.05, 0.02, 0.05 > translate < -0.02, -0.03, -99.80 > }
// object { Glass_Dome2 translate < 0.0, -0.035, -99 > }
// object { Astro_World scale 6.0 rotate < -20,-20, 0 > translate < -20, 15, 0 > }
object { Astro_World rotate < -20,-20, 0 > translate < -2.6, 2, -84 > }
light_source { < -200,300,-300 >, color White }


object { Beach_Balcony 
  scale 0.001 rotate < 0, -20, 0 > translate < 0.015, -0.01, -99.95 > 
}
object { Table 
  scale 0.0008 translate < 0.012, -0.0098, -99.953 >
}
object { Cup_Of_OJ 
  scale 0.0003 rotate < 0, 30, 0 > translate < 0.012, -0.0067, -99.953 >
}
object { Deck_Chair
  scale 0.002 rotate < 0, 160, 0 > translate < 0.017, -0.0098, -99.955 >
}
object { Sail_Ship 
  scale 0.004 rotate < 0, 20, 0 > translate < 0.1, -0.02,-99.0 >
}


object { Shuttle_Craft scale 0.1 rotate <  0,-120,-10 > translate < -2.3, 1.5, -87 > }
object { Shuttle_Craft scale 0.05 rotate < 0, 166, -5 > translate <  1.8, 2.2, -89 > }
object { Shuttle_Craft scale 0.05 rotate < 0, -45, 15 > translate <  1.0, 1.3, -88 > }
object { Shuttle_Craft scale 0.05 rotate < 0,  20,  3 > translate < -3.0, 3.1, -88 > }
