#declare ShapeTex1 =
        texture { pigment { gradient z
        color_map {
     [  0.0  color red 0.8 green 0.4 blue 0.2]
     [  0.5  color red 0.9 green 0.8 blue 0.8]
     [  1.0  color red 0.8 green 0.4 blue 0.2] }
scale 0.5
translate z*1 }
                  finish  { phong 0.4 phong_size 10 }
                  normal { bumps 0.5 scale <10,0.01,10> } }

#declare ShellTex1 =
        texture { pigment { colour rgbt 1 } }
#declare ShellTex2 =
        texture { pigment { colour rgbt 1 } }

// ShellA - flat coil shape
#declare Shape1 =
difference {
        sphere { <0,0,0> 1 }
        sphere { <-0.8,0,0> 1.1 }
        sphere { < 0.8,0,0> 1.1 }
scale <0.75,0.75,1>
rotate y*90
texture { ShapeTex1 } }

#declare NumIterations = 80
#declare Counter       = 0.0
#declare Increment     = 1.0/NumIterations
#declare NumTwists     = 360*2 // two full twists
// ----------------------------------------

#declare ShellA =
union {
    #while (Counter<=1.0)
    object
    { Shape1
      scale <(1-Counter)*2,(1-Counter)*2,(1-Counter)*2>
      translate <(1-Counter)*2, Counter*1.5, 0.0>
      rotate NumTwists*Counter*y
       }
    #declare Counter=Counter+Increment
    #end
}
// ----------------------------------------
