#declare ShapeTex1 =
        texture { pigment { gradient z
        color_map {
     [  0.00 color red 0.75 green 0.75 blue 0.73]
     [  0.25 color red 0.75 green 0.75 blue 0.73]
     [  0.25 color red 0.50 green 0.50 blue 0.00]
     [  0.75 color red 0.50 green 0.50 blue 0.00]
     [  0.75 color red 0.75 green 0.75 blue 0.73]
     [  1.00 color red 0.75 green 0.75 blue 0.73] }

                  scale <0.1,1,0.1> }
                  normal { bumps 0.4 scale <20,20,0.01> turbulence 0.4 }
                  finish  { phong 0.4 phong_size 10
                            ambient 0.25 } }
#declare ShellTex1 =
        texture { pigment { colour rgbt 1 } }
#declare ShellTex2 =
        texture { pigment { colour rgbt 1 }
        finish { ambient 0.25 }

                  }


// ----------------------------------------
// ShellC - rising coil shape
#declare Shape2 =
        sphere { <0,0,0> 1
        scale <1.15,1,1>
        rotate y*90
        texture { ShapeTex1 } }
#declare NumIterations = 80
#declare Counter       = 0.0
#declare Increment     = 1.0/(NumIterations/2)
#declare NumTwists     = 360*4 // number of twists
// ----------------------------------------
#declare ShellC =
union {
    #while (Counter<=1.0)
    object    {
      Shape2
      scale <(1-Counter)*2,(1-Counter)*1.50,(1-Counter)*2>
      translate <(1-Counter)*1.25, Counter*4, 0.0>
      rotate NumTwists*Counter*y
      texture { ShellTex1 }
      texture { ShellTex2 } }
    #declare Counter=Counter+Increment
    #end

union {
 sphere {  <0, 4.9, 0>   0.8 scale <1,0.6,1> }
 sphere {  <0, 5.6, 0>   0.5 scale <1,0.6,1> }
 sphere {  <0, 6.1, 0>   0.3 scale <1,0.6,1> }
  texture { ShapeTex1 } }
}

