// Persistence of Vision Ray Tracer Scene Description File
// File: creekrd.pov
// Vers: 3
// Desc: Tree covered, rocky, hillside with road, low-water bridge
//       and a couple of gals splashing around in the water.
// Date: 8/30/96
// Auth: Barrett L. Bowen
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "finish.inc" // Standard Finish definitions
#include "skies.inc" // Some sky textures
#include "d:\ray\pov\people\fhero.inc"
#include "d:\ray\pov\people\catchya.inc"


global_settings{
                assumed_gamma 2.2
                max_trace_level 100
                max_intersections 100
                ambient_light 0.4
                adc_bailout 1/255
                }

sky_sphere
{
  pigment
  { //color SkyBlue
    gradient y
    color_map { [0.0 color LightBlue] [1.0 color rgb<0.5, 0.5, 1.0>] }
  }
}

camera
{
  up y
  right 4/3*x
  location  <-40 , 10.0 ,-40.0>
  look_at   <-5 , 10 , 5>
  angle 45
}



plane { -y, -30000 texture {T_Cloud2 scale <3200, 1, 9400> translate x*5000 rotate -30*y }
      hollow}



#declare Nothing =
        texture{
           pigment{ color Clear}
           finish {phong 0
                   reflection 0
                   specular 0
                   ambient 0
                   diffuse 0
                  }
        }

#declare GrassTex = texture{	pigment { bozo
					pigment_map{
							[0.0 HuntersGreen]
							[1.0 MediumForestGreen]
							}
					//scale 0.5
					}
                normal {average
                       normal_map {
                                  [1.0 bozo 1.5 /*scale .5*/ ]
                                  [2.0 granite 3 scale 0.2 ]
                                  }
                        }
	        finish { ambient 0.4 }
      }

#declare LBarkTex = texture { pigment {color Gray55}
                              normal{ average
                                      normal_map{
                                                 [0.5 crackle 0.25  sine_wave turbulence 0.7 ]
                                                 //[ 0.5 granite 0.025 ]
                                                 [ 1.0 gradient y 0.25 scale 1/100 turbulence 0.4]
                                                 //[ 1.0 marble 0.05 scale 1/150 turbulence 0.6]
                                                 }
                                     }
                              finish { ambient 0.4 }
                             }

#declare LLeafTex = texture { pigment {color MediumForestGreen }
                              normal {crackle 0.02 scallop_wave scale 0.25 turbulence 0.4}
                              finish {Phong_Shiny ambient 0.3}
                             scale 1/50}

#declare RoadTex = texture { pigment { color VeryDarkBrown }
          normal {bump_map
                          { // uses image color or index as bumpiness
                           gif "pp9.gif" // the file to read (iff/gif/tga/png/sys)
                           map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                           interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                           bump_size 3 // 0...3
                           } // bump_map
                   rotate x*75
                   //scale 0.5
                   }
          finish { Dull  ambient 0.4 }
  }

#declare StoneWallTex = texture {

// texture pigment {} attribute
// create a texture that lays an image's colors onto a surface
// image maps into X-Y plane from <0,0,0> to <1,1,0>
pigment {
image_map
{
  gif "pp9.gif" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  } // image_map
}
normal{
bump_map
{ // uses image color or index as bumpiness
  gif "pp9.gif" // the file to read (iff/gif/tga/png/sys)
  map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance

  bump_size 3 // 0...3
} // bump_map
}
}


difference {
superellipsoid // GROUND N OF WATER
{
  <0.5,  // east-west exponent (0.0 ... 1.0)
  0.5>  // north-south exponent (0.0 ... 1.0)
  scale <1100,7,1150>
  translate y*-6
  //scale <1,3,1>
  rotate x*-15
  translate <0, 297.64, 1110.81>
  texture { bozo scale 5
            texture_map {
                        [ 0.0 StoneWallTex scale<50,50,1> rotate <90, 0, 0>]
                        [ 0.1 StoneWallTex scale<30,30,1> rotate <90, 20,0>]
                        [ 0.25 GrassTex ]
                        [ 1.0 GrassTex ]
                        }
          }


}

superellipsoid // ROAD CUT N. OF WATER
{
  <0.5, 0.5>
  scale <28,6.75,1150>
  rotate <-15, 0, 0>
  translate <0, 298, 1110.81>
  texture { bozo scale 5
            texture_map {
                        [ 0.0 StoneWallTex scale<50,50,1> rotate <90, 0, 0>]
                        [ 0.2 StoneWallTex scale<30,30,1> rotate <90, 20,0>]
                        [ 0.6 RoadTex]
                        [ 1.0 GrassTex ]
                        }
          }


}



}// end difference



superellipsoid // ROCK LEDGE N OF WATER
{
  <0.5,  // east-west exponent (0.0 ... 1.0)
  0.5>  // north-south exponent (0.0 ... 1.0)
  scale <500,6,2>
  texture { bozo scale 2
            texture_map {
                        [ 0.0 StoneWallTex scale<5,5,1> rotate <0, 0, 0>]
                        [ 0.5 StoneWallTex scale<5,5,1> rotate <0, 0, 0>]
                        [ 0.5 StoneWallTex scale<2,2,1> rotate <0, 20, 45>]
                        [ 1 StoneWallTex scale<2,2,1> rotate <0, 20,45>]

                        }
           }
  rotate <60, 0, 0>
  translate <-509, 0, 10>

}


superellipsoid // ROCK LEDGE N OF WATER
{
  <0.5,  // east-west exponent (0.0 ... 1.0)
  0.5>  // north-south exponent (0.0 ... 1.0)
  scale <500,6,2>
  texture { bozo scale 2
            texture_map {
                        [ 0.0 StoneWallTex scale<5,5,1> rotate <0, 0, 0>]
                        [ 0.5 StoneWallTex scale<5,5,1> rotate <0, 0, 0>]
                        [ 0.5 StoneWallTex scale<2,2,1> rotate <0, 20, 45>]
                        [ 1 StoneWallTex scale<2,2,1> rotate <0, 20,45>]

                        }
           }
  rotate <60, 0, 0>
  translate <509, 0, 10>

}


superellipsoid // ROAD N. OF WATER
{
  <0.5,  // east-west exponent (0.0 ... 1.0)
  0.5>  // north-south exponent (0.0 ... 1.0)
  scale <27,2.5,1150>
  texture { bozo scale 5
            texture_map {
                        [ 0.0 StoneWallTex scale<50,50,1> rotate <90, 0, 0>]
                        [ 0.2 StoneWallTex scale<30,30,1> rotate <90, 20,0>]
                        [ 0.6 RoadTex]
                        [ 1.0 RoadTex ]
                        }
          }
  rotate <-15, 0, 0>
  translate <0, 293, 1110.81>


}


#declare BridgeTex = texture { pigment { color Gray60 }
                       normal{ agate 1 scale 5 }
                       finish { Dull  ambient 0.4 }
                       }
#declare WetBridgeTex = texture { pigment { color Gray50 }
                       normal{ agate 1 scale 5 }
                       finish { Glossy ambient 0.4}
                       }

#declare TopRoad = intersection{
// create a box that extends between the 2 specified points
box
{
  <0, 0, 0>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
}
height_field{ gif "top.gif" }
}// end intersection

#declare BottomRoad = intersection{
// create a box that extends between the 2 specified points
box
{
  <0, 0, 0>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
}
height_field{ gif "bottom.gif" }
}// end intersection

object {TopRoad
                  //translate 0.5
                  scale <25, 25, 33.3333>
                  rotate <-7, 0, -0.3>
                  translate <-12.5, -24.5, 0>
                  texture { gradient y
                            texture_map {
                                         [ 0.25 WetBridgeTex]
                                         //[ 0.55 BridgeTex ]
                                         [ 1.0 bozo texture_map{
                                                                [ 0.0 BridgeTex ]
                                                                [ 0.2 BridgeTex ]
                                                                [ 1.0 RoadTex scale z*2]
                                                                }]
                                          }
                           scale 3.5
                           }// end texture

             }

object {BottomRoad
                  //translate 0.5
                  scale <25, 25, 33.3333>
                  rotate <-2, 0, 1>
                  translate <-12.5, -24.5, -29.75>
                  texture { gradient y
                            texture_map {
                                         [ 0.5 WetBridgeTex]
                                         [ 0.75 BridgeTex ]
                                         }
                            scale 3.5
                            }

             }

object {BottomRoad
                  //translate 0.5
                  scale <25, 25, 33.3333>
                  rotate <0, 180, -1>
                  translate <12.5, -24.5, -30>
                  texture { gradient y
                            texture_map {
                                         [ 0.5 WetBridgeTex]
                                         [ 0.75 BridgeTex ]
                                         }
                            scale 3.5
                            }

             }

#include "d:\ray\toolbox\lparser\bbtree3.inc"
/*#declare LTree = //union{
                        cylinder{  -1.15*y,  1*y,  0.1
                                   texture { LBarkTex }
                                }
                        sphere{ y*1.17, 1.14  texture { //LLeafTex
                                                      leopard
                                                      texture_map{
                                                      [0.0 Nothing]
                                                      [0.3 Nothing]
                                                      [0.3 LLeafTex]
                                                      [1.0 LLeafTex]
                                                      }
                                           scale 1/25}
                              }
                       //}*/

#declare SudsObject = object { LTree scale 1.26667 translate y*1.14  rotate x*-90 }
#include "d:\ray\toolbox\suds\treesuds.inc"
object {LTree translate y*1.14 scale 30 translate <23.0 , 3.9 ,23>}
object {LTree  translate y*0.9 scale 25 rotate <0, 15, 0> translate <-36, 1, -41> }

object {Suds  scale 10 rotate x*75  translate <0,287,1100> }

#include "bbleaf.inc"
#declare SudsObject = object { Leaf2 scale 0.5}
#include "d:\ray\toolbox\suds\treesuds.inc"
object {Suds scale 0.75 rotate x*90 rotate y*75 translate <0.3, 0.04, 0 >}
object {Suds scale 0.5 rotate <75, 0, 0 >  translate <15, 14.5, 55.5>}
object {Suds scale 0.3 rotate <90, 15, 0 >  translate <15, 0.04, 0>}

/*light_source
{
  0*x // light's position (translated below)
  color Gray75  // light's color
  translate <-20, 40000, -50>
 //rotate < -10, 30, 0>
}*/

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color Gray75  // light's color
  area_light
  <20, 0, 0> <0, 0, 20>
  3, 3
  adaptive 0
  jitter
  translate <0, 40000, -10>
  rotate x*-0.7
  translate z*-50
}

// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color Gray75  // light's color
  area_light
  <20, 0, 0> <0, 0, 20>
  3, 3
  adaptive 0
  jitter
  translate <-20, 40000, 0>
  rotate x*-0.7
  translate z*-50
}

/*light_source
{
  0*x // light's position (translated below)
  color Gray75  // light's color
  translate <20, 40000, -50>
  //rotate < -10, 30, 0 >
}*/

light_source
{
  0*x // light's position (translated below)
  color Gray85  // light's color
  translate <-40, 10, -40>
  shadowless

}

plane { y, 0 texture { Water scale 50} }


plane { y, -2.5 texture { bozo
                     texture_map {
                                 [ 0.0 StoneWallTex  scale <20,20,1> rotate <90, 30, 0>]
                                 [ 0.3 GrassTex pigment{color Tan}]
                                 [ 1.0 GrassTex pigment { color Gray60}]
                        }
                      }
      }

#declare BlondHairTex  = texture { pigment { gradient x
                               pigment_map {
                                                       [ 0.0 color Wheat ]
                                                       [ 0.2 color Gold ]
                                                       [ 0.3 color Wheat]
                                                       [ 0.35 color Bronze]
                                                       [ 0.5 color Wheat ]
                                                       [ 0.75 color Gold ]
                                                       [ 1.0 color Bronze ]
                                                      }
                                frequency 10
                               }
                normal{ average
                              normal_map{
                                                    [ 1.0 gradient x 0.3 sine_wave turbulence 0.1 rotate z*3 frequency 3 ]
                                                    [ 1.0 gradient x 0.2 triangle_wave turbulence 0.3 frequency 5]
                                                   }
                               frequency 100
                             }
                finish{ specular 0.5 diffuse 0.3 ambient 0.4 reflection 0.02 }
                }

// people
// The Splasher . . .
#declare HeroHair = #include "herohair.inc"
object {FHero rotate y*39.4 translate <-23, 0, -08> finish { ambient 0.4}}
object { HeroHair rotate y*39.4translate < -23, 0, -08>
       texture { BlondHairTex
                 rotate y* 20 translate y* 20 scale 0.5
               }
       }

//. . . and the Splashee!
#declare CatchHair = #include "catchair.inc"
object {Catchya rotate y*73.5  translate < -17.559, 0, -5.449> finish {ambient 0.4 }}

object { CatchHair rotate y*73.5 translate < -17.559, 0, -5.449>
       texture { BlondHairTex
                 rotate y* 10 translate y* 20 scale 0.5
               }
       }

disc
{
  <0, 0.01, 0>  // center position
  y,         // normal vector
  6.0       // outer radius
  texture { onion  scale 6.01
            texture_map {
                        [ 0.0 Water ]
                        [ 1.0 Water scale 50 translate <25, 0, 15>]
                        }
          }
  translate <-23, 0, -08>

}

disc
{
  <0, 0.01, 0>  // center position
  y,         // normal vector
  6.0       // outer radius
  texture { onion  scale 6.01
            texture_map {
                        [ 0.0 Water ]
                        [ 1.0 Water scale 50 translate <24, 0, 13>]
                        }
          }
  translate < -17.559, 0, -5.449>

}
