//Textures------------------------------------------------------------------------------------
declare Seide =
texture
{
	pigment{rgb<1,1,1>}
	finish
	{
		diffuse 1
		brilliance 0.5
		ambient 0.3
	}
}
//----------------------------------------------------------------------------------------------------
declare Seife =
texture
{
	pigment{rgbf<1,0.98,0.95,1>}
  finish
	{
 		specular 1
 		roughness 0.001
 		ambient 0.3
 		diffuse 0
 		reflection 0.004
 		irid {0.3 thickness 0.25 turbulence 0.3}
  }
}
//----------------------------------------------------------------------------------------------------
#declare Fensterbank =
texture
{
  pigment
	{
    bozo
    turbulence 0.25
    color_map
		{
       [0, 1 color rgb <0.35, 0.225, 0.225>
             color rgb <0.2, 0.2, 0.2> ]
    }
    scale 0.4
  }
  finish{ ambient 0.25 }
}
texture
{
  pigment
	{
    granite
    color_map
		{
       [0.0, 0.9 color rgbf <0.42, 0.29, 0.29, 1.0>
                 color rgbf <0.42, 0.29, 0.29, 0.5>]
       [0.9, 1.0 color rgbf <0.32, 0.07, 0.45, 0.0>
                 color rgbf <0.32, 0.07, 0.45, 0.0>]
    }
    scale 2
  }
  finish
	{
    specular 1
    roughness 0.01
    phong 0.25
    phong_size 75
    brilliance 5
		reflection 0.3
  }
}
//---------------------------------------------------------------------------------------------------
#declare Vorhang_ColorMap=
color_map
{
	[0,0.6 color rgbf<0.9,0.8,0.6,0.6> color rgbf<0.9,0.8,0.6,1>]
	[0.6,1 color rgbf<1,1,1,1> color rgbf<1,1,1,1>]
}
#declare Vorhang_Normal=
normal
{
 	gradient x
 	slope_map
	{
   	[0   <0,0>]
		[0.25 <1,0.5>]
   	[0.5 <0,1>]
		[0.75 <-1,0.5>]
   	[1   <0,0>]
 	}
	scale 2
}
#declare Vorhang_Normal2=
normal
{
 	gradient x
 	slope_map
	{
   	[0   <0,0>]
		[0.25 <1,0.25>]
   	[0.5 <0,0.5>]
		[0.75 <-1,0.25>]
   	[1   <0,0>]
 	}
	scale 2
}

#declare Vorhang_Finish=
finish
{
	ambient 0.3
	brilliance 2.5
	irid {0.2 thickness 0.3 turbulence 0.75}
}
#declare Vorhang=
texture
{
	pigment
	{
		gradient x
		color_map{Vorhang_ColorMap}
		scale 0.004
	}
	normal{Vorhang_Normal}
	finish{Vorhang_Finish}
}
texture
{
	pigment
	{
		gradient y
		color_map{Vorhang_ColorMap}
		scale 0.004
	}
	normal{Vorhang_Normal}
	finish{Vorhang_Finish}
}
texture
{
	pigment
	{
		gradient x
		color_map{Vorhang_ColorMap}
		scale 0.004
	}
	normal{Vorhang_Normal2}
	finish{Vorhang_Finish}
}
texture
{
	pigment
	{
		gradient y
		color_map{Vorhang_ColorMap}
		scale 0.004
	}
	normal{Vorhang_Normal2}
	finish{Vorhang_Finish}
}

//----------------------------------------------------------------------------------------------------
#declare Himmel1 =
pigment
{
	gradient y
 	color_map
	{
 		[(1-cos(radians( 30)))/2 color <0.6,0.6,0.9>]
   	[(1-cos(radians(120)))/2 color <0.2,0.2,0.8>]
 	}
 	scale 2
 	translate -1
}
#declare Himmel2 =
pigment
{
 	bozo
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2
  color_map
	{
   	[0.0 0.1 color rgb <0.85, 0.85, 0.85>
             color rgb <0.75, 0.75, 0.75>]
    [0.1 0.5 color rgb <0.75, 0.75, 0.75>
             color rgbt <1, 1, 1, 1>]
    [0.5 1.0 color rgbt <1, 1, 1, 1>
             color rgbt <1, 1, 1, 1>]
  }
  scale <0.2, 0.5, 0.2>
	rotate<0,0,90>
}
#declare Himmel3 =
pigment
{
	bozo
  turbulence 0.68
  octaves 6
  omega 0.65
  lambda 2
  color_map
	{
 	  [0.0 0.15 color rgb <1, 0.85, 0.8>
              color rgb <0.9, 0.75, 0.7>]
    [0.15 0.5 color rgb <0.9, 0.75, 0.7>
              color rgbt <1, 1, 1, 1>]
    [0.5 1.0 color rgbt <1, 1, 1, 1>
             color rgbt <1, 1, 1, 1>]
  }
  scale <0.2, 0.5, 0.2>
	rotate<0,60,90>
}
//Objects-------------------------------------------------------------------------------------------
#declare Blase =
difference
{
	sphere{<0,0,0>,1}
	sphere{<0,0,0>,0.98}
	texture{Seife}
}
//----------------------------------------------------------------------------------------------------
#declare Same =
union
{
 sphere{<0,0,0>  0.1 pigment{colour rgb<0.6,0.2,0.2>} scale <1.2,0.24,0.24>}
 cylinder{ <0,0,0>, <0.8,0,0>, 0.002 }
 #declare Whilei = 0
 #while (Whilei < 360 )
  cylinder{ <0.8,0,0>, <1,0.2,0>, 0.002  rotate<Whilei,0,0>}
  #declare Whilei = Whilei+20
 #end
 texture{Seide}
}
//----------------------------------------------------------------------------------------------------
#declare Blatt =
prism
{
  linear_sweep
	linear_spline
  -0.05,
   0.05,
  4,
  <-0.5,0>,
  < 0.5,0>,
	< 0,-10>,
	<-0.5,0>
	pigment{colour rgb<0.1,0.8,0>}
	rotate<-84,0,0>
}
//----------------------------------------------------------------------------------------------------
#declare Pusteblumenkopf =
union
{
 sphere{<0,0,0> 0.13 pigment{colour rgb<0.1,0.8,0> } }
 #declare Whilei = 0
 #while(Whilei<360)
	object{ Blatt	scale 0.04 translate<0.08,0.08,0> rotate<0,Whilei,0>}
 	#declare Whilei = Whilei+20
 #end
 #declare Whilei = -90
 #while(Whilei<90)
 	#declare Whilej = 0
	#if( cos(Whilei) = 0)
		#declare Increment = 360
	#else
		#declare Increment = abs(18/cos(Whilei))
	#end
	#while( Whilej<360 )
 		object{Same translate<0.07,0,0> rotate<0,0,Whilej> rotate<0,Whilei,0> }
		#declare Whilej = Whilej+Increment
	#end
  #declare Whilei = Whilei+18
 #end
}
//---------------------------------------------------------------------------------------------------
declare Pusteblume =
union
{
	object{Pusteblumenkopf}
	cylinder
	{<0,0,0>,<0,-5,0>,0.04
		texture
		{
			pigment
			{
				radial
				frequency 10
				color_map
				{
					[0.0,0.3 colour rgb<0.1,1,0> colour rgb<0.1,0.9,0.1>]
					[0.3,0.6 colour rgb<0.4,0.6,0> colour rgb<0.3,0.7,0>]
					[0.6,1.0 colour rgb<0,0.7,0.3> colour rgb<0,0.6,0.4>]
				}
			}
            finish
            {
            	brilliance 1.5
							reflection 0.1
            }
		}
	}
	translate<0,5,0>
}
//--------------------------------------------------------------------------------------------------
declare Vase_Texture =
texture
{
	pigment{ rgbf<1,0.98,0.98,1>}
	finish
	{
 		specular 1
 		roughness 0.001
 		ambient 0
 		diffuse 0
 		reflection 0.1
 		refraction 1
 		ior 1.5
	}
}
//--------------------------------------------------------------------------------------------------
#declare Wasser_Texture =
texture
{
	pigment{rgbf<0.7,0.7,1,1>}
	finish
	{
 		ambient 0
 		diffuse 0.2
 		reflection 0.4
 		refraction 1
 		ior 1
	}
}
//---------------------------------------------------------------------------------------------------
declare Vase =
union
{
	difference
	{
		cylinder{<0,0,0><0,3,0>,1}
		cylinder{<0,0.1,0><0,3.1,0>,0.95}
		texture{Vase_Texture}
	}
	cylinder
	{
		<0,0.1,0>,<0,1.5,0>,0.95
		texture{Wasser_Texture}
	}
}

