//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 19 textures and 195 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.0.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/31/1996    (31.08.1996)
//

#max_trace_level 5

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//



camera {  //  Camera TempCam
  location  <193.500, -490.000, 155.000>
  direction <0.0,     0.0,  1.6125>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-31.792, -29.857, 36.791>
}

// *******  L I G H T S *******
light_source {   // TempSun
  <25000.000, -25000.000, 150000.000>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "deck4.inc"



// ********  REFERENCED OBJECTS  *******

#declare StandTop = union {
  box { // StandTopPart7
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    rotate -90.0*z
    translate  <-9.0, 9.0, -2.0>
  }
  box { // StandTopPart6
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    rotate -90.0*z
    translate  <9.0, 9.0, -2.0>
  }
  box { // StandTopPart5
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    translate  18.0*y
  }
  box { // StandTopPart4
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    translate  13.5*y
  }
  box { // StandTopPart3
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    translate  9.0*y
  }
  box { // StandTopPart2
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
    translate  4.5*y
  }
  box { // StandTopPart1
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.0, 1.0>
  }
}
#declare StandSupport1 = object {
  box { // StandSupport1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 28.0>
    translate  <-9.0, 20.0, -27.0>
  }
}
#declare StandSupport5 = object {
  box { // StandSupport5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 39.0>
    translate  <-9.0, -2.0, -16.0>
  }
}




// ********  OBJECTS  *******

#declare PlantPotDiff1 = difference {
  cylinder { // PlantPot3
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 3.0>
    translate  <134.5, -54.5, 14.75>
  }
  cylinder { // PlantPotCut1
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 2.0>
    translate  <134.5, -54.5, 16.0>
  }
  texture {
    Pottery
  }
}
#declare PlantPotDiff2 = difference {
  cylinder { // PlantPot5
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 11.0>
    translate  <134.5, -54.5, 18.78>
  }
  cylinder { // PlantPotCut2
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 9.0>
    translate  <134.5, -54.5, 21.0>
  }
  texture {
    Pottery
  }
}
union { // PlantPotter
  cylinder { // PlantPot1
    <0,0,1>, <0,0,0>, 1 
    scale <8.5, 8.5, 1.0>
    translate  <134.5, -54.5, 12.0>
  }
  torus { // PlantPot2
    8.5, 2.0  rotate -x*90
    translate  <134.5, -54.5, 15.0>
  }
  object { PlantPotDiff1 }
  cylinder { // PlantPot4
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 5.0>
    translate  <134.5, -54.5, 16.0>
  }
  object { PlantPotDiff2 }
  torus { // PlantPot6
    10.25, 0.25  rotate -x*90
    translate  <134.5, -54.5, 29.75>
  }
  cylinder { // PlantDirt
    <0,0,1>, <0,0,0>, 1 
    texture {
      Dirt
    }
    scale <10.0, 10.0, 6.0>
    translate  <134.5, -54.5, 21.0>
  }
  texture {
    Pottery
  }
}


sphere { // Cloudsphere
  <0,0,0>,1
  texture {
    Clouds
  }
  scale 90000.0
  translate  -50000.0*z
}


sphere { // Sky
  <0,0,0>,1
  texture {
    BlueSky
  }
  no_shadow
  scale 100000.0
  translate  -50000.0*z
}




union { // Roof
  box { // RoofFront
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 10.0>
    rotate 22.0*z
    translate  <71.5, -140.0, 231.0>
  }
  box { // RoofSupport1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 10.0>
    rotate 22.0*z
    translate  <-14.5, -175.5, 210.0>
  }
  box { // RoofSupport2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 10.0>
    rotate 22.0*z
    translate  <-32.0, -182.5, 210.0>
  }
  box { // RoofSide1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 10.0>
    rotate -68.0*z
    translate  <-255.5, -6.5, 230.5>
  }
  box { // RoofSide2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 10.0>
    rotate -68.0*z
    translate  <-70.5, -464.0, 230.5>
  }
  box { // Lattice
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LatticeTexture
      scale 0.07
    }
    scale <246.0, 246.0, 1.0>
    rotate 22.0*z
    translate  <-159.0, -236.0, 234.0>
  }
  box { // RoofMiddle1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 6.0>
    rotate -68.0*z
    translate  <-209.25, -120.875, 227.0>
  }
  box { // RoofMiddle2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 6.0>
    rotate -68.0*z
    translate  <-163.0, -235.25, 227.0>
  }
  box { // RoofMiddle3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 250.0, 6.0>
    rotate -68.0*z
    translate  <-116.75, -349.625, 227.0>
  }
  texture {
    Yellow_Pine3
  }
}


#declare DeckBottomParts = union {
  box { // DeckPiece1
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-117.5, -44.0, -56.0>
  }
  box { // DeckPiece2
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-290.5, -260.5, -56.0>
  }
  box { // DeckPiece3
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-72.5, -50.0, -56.0>
  }
  box { // DeckPiece4
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-177.5, -200.5, -56.0>
  }
  box { // DeckPiece5
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <42.5, 12.0, -56.0>
  }
  box { // DeckPiece6
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-107.0, -182.5, -56.0>
  }
  box { // DeckPiece7
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <111.5, 29.0, -56.0>
  }
  box { // DeckPiece8
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-174.5, -296.5, -56.0>
  }
  box { // DeckPiece9
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <43.0, -85.5, -56.0>
  }
  box { // DeckPiece10
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <4.5, -171.0, -56.0>
  }
  box { // DeckPiece11
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <224.0, 41.5, -56.0>
  }
  box { // DeckPiece12
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <-60.5, -281.5, -56.0>
  }
  box { // DeckPiece13
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <159.0, -69.0, -56.0>
  }
  box { // DeckPiece14
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <29.0, -243.0, -56.0>
  }
  box { // DeckPiece15
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <248.5, -31.5, -56.0>
  }
  box { // DeckPiece16
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <137.0, -187.5, -56.0>
  }
  box { // DeckPiece17
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 15.0, 4.0>
    rotate 44.0*z
    translate  <357.0, 24.5, -56.0>
  }
}
#declare DeckPartsCut = difference {
  object { DeckBottomParts }
  box { // DeckBottomCut
    <-1, -1, -1>, <1, 1, 1>
    scale <320.0, 100.0, 6.0>
    translate  <163.5, 90.0, -56.0>
  }
  translate  9.0*x
}
#declare DeckBottom = union {
  box { // DeckBottomRail
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 3.0, 4.0>
    translate  <202.0, -6.0, -56.0>
  }
  box { // DeckBottomRail2
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 3.0, 4.0>
    rotate 44.0*z
    translate  <-180.5, -88.0, -56.0>
  }
  object { DeckPartsCut }
}
#declare FenceSect1 = union {
  box { // DeckFenceBack1
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 2.0, 5.0>
    translate  <0.0, 3.0, 35.0>
  }
  box { // DeckFenceBack2
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 2.0, 5.0>
    translate  <0.0, 3.0, -35.0>
  }
  box { // DeckFenceSlat1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-80.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-60.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat3
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-40.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat4
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-20.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat5
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <0.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat6
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <20.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat7
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <40.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat8
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <60.0, -1.0, -2.5>
  }
  box { // DeckFenceSlat9
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <80.0, -1.0, -2.5>
  }
}
#declare FenceSect2 = union {
  box { // DeckFenceBack3
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 2.0, 5.0>
    translate  <0.0, 3.0, 35.0>
  }
  box { // DeckFenceBack4
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 2.0, 5.0>
    translate  <0.0, 3.0, -35.0>
  }
  box { // DeckFenceSla10
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-80.0, -1.0, -2.5>
  }
  box { // DeckFenceSla11
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-60.0, -1.0, -2.5>
  }
  box { // DeckFenceSla12
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-40.0, -1.0, -2.5>
  }
  box { // DeckFenceSla13
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-20.0, -1.0, -2.5>
  }
  box { // DeckFenceSla14
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <0.0, -1.0, -2.5>
  }
  box { // DeckFenceSla15
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <20.0, -1.0, -2.5>
  }
  box { // DeckFenceSla16
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <40.0, -1.0, -2.5>
  }
  box { // DeckFenceSla17
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <60.0, -1.0, -2.5>
  }
  box { // DeckFenceSla18
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <80.0, -1.0, -2.5>
  }
  rotate 44.0*z
  translate  <-168.5, -68.0, 0.0>
}
#declare FenceSect3 = union {
  box { // DeckFenceBack5
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 2.0, 5.0>
    translate  <0.0, 3.0, 35.0>
  }
  box { // DeckFenceBack6
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 2.0, 5.0>
    translate  <0.0, 3.0, -35.0>
  }
  box { // DeckFenceSla19
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-80.0, -1.0, -2.5>
  }
  box { // DeckFenceSla20
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-60.0, -1.0, -2.5>
  }
  box { // DeckFenceSla21
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-40.0, -1.0, -2.5>
  }
  box { // DeckFenceSla22
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <-20.0, -1.0, -2.5>
  }
  box { // DeckFenceSla23
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <0.0, -1.0, -2.5>
  }
  box { // DeckFenceSla24
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <20.0, -1.0, -2.5>
  }
  box { // DeckFenceSla25
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <40.0, -1.0, -2.5>
  }
  box { // DeckFenceSla26
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <60.0, -1.0, -2.5>
  }
  box { // DeckFenceSla27
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 57.5>
    translate  <80.0, -1.0, -2.5>
  }
  translate  200.0*x
}
#declare DeckSill1 = difference {
  box { // DeckFenceSill1
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 12.0, 2.5>
    rotate 44.0*z
    translate  <-163.6, -68.1, 63.0>
  }
  box { // DeckCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 14.0, 4.0>
    rotate 22.0*z
    translate  <-90.6, 0.02, 63.0>
  }
  box { // DeckFencePost
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 120.0>
    rotate 22.0*z
    translate  <-96.0, 0.5, 60.0>
  }
}
#declare DeckSill2 = difference {
  box { // DeckFenceSill
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 12.0, 2.5>
    translate  <0.0, -2.0, 62.5>
  }
  box { // DeckCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 14.0, 4.0>
    rotate 22.0*z
    translate  <-99.8, -3.7, 63.0>
  }
  box { // DeckFencePost2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 120.0>
    rotate 22.0*z
    translate  <-96.0, 0.5, 60.0>
  }
}
#declare DeckFence = union {
  object { FenceSect1 }
  object { FenceSect2 }
  object { FenceSect3 }
  box { // DeckFencePost1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 60.0>
    translate  100.0*x
  }
  box { // DeckFencePost3
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 180.0>
    rotate 22.0*z
    translate  <-96.0, 0.5, 40.0>
  }
  object { DeckSill1 }
  object { DeckSill2 }
  box { // DeckFenceSill3
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 12.0, 2.5>
    translate  <202.0, -2.0, 62.5>
  }
}
union { // Deck
  object { DeckBottom }
  object { DeckFence }
  texture {
    Yellow_Pine3
  }
}


#declare BookSpine = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-0.978947, -2.000000, -0.515789>, <0.021053, -2.000000, -0.515789>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-0.978947, -1.000000, -0.515789>, <0.021053, -1.000000, -0.515789>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-0.978947, 0.000000, -0.515789>, <0.021053, 0.000000, -0.515789>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-0.978947, 1.000000, -0.515789>, <0.021053, 1.000000, -0.515789>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    BookSpineIMG
    scale <3.0, 3.0, 1.1>
    rotate <0.0, 0.0, -180.0>
  translate <1.000000, 1.000000, 0.000000>
  }
  scale <0.12, 1.34, 0.15>
  translate  <1.645, 0.67, 1.15>
}
// Include contains 'BookBack'
#include "deck4.in1"

#declare BookBack = object {
  BookBack_Raw
  texture {
    BookCover2
    scale <2.4, 1.0, 1.0>
    rotate <-90.0, 0.0, 21.616791>
  translate <-0.770000, -0.690000, 1.000000>
  }
  scale <1.0, 1.0, 4.0>
  rotate <90.0, 0.0, 180.0>
  translate  <3.17, -2.0, 1.0>
}
// Include contains 'BookbackPage'
#include "deck4.in2"

#declare BookbackPage = object {
  BookbackPage_Raw
  texture {
    BookPages
    scale <2.3, 1.0, 0.9>
    rotate <90.0, 0.0, -160.0>
  translate <1.300000, -0.500000, 0.000000>
  }
  scale <1.02, 1.0, 4.02>
  rotate <90.0, 0.0, -180.0>
  translate  <3.17, -2.01, 0.99>
}
// Include contains 'BookFrontPages'
#include "deck4.in3"

#declare BookFrontPages = object {
  BookFrontPages_Raw
  texture {
    BookPages
    scale <2.3, 1.0, 0.9>
    rotate <90.0, 0.0, -160.0>
  translate <1.300000, 0.100000, 0.000000>
  }
  scale <1.02, 1.0, 4.02>
  rotate 90.0*x
  translate  <0.0, 2.01, 0.99>
}
// Include contains 'BookFront'
#include "deck4.in4"

#declare BookFront = object {
  BookFront_Raw
  texture {
    BookCover1
    scale <2.4, 1.0, 0.9>
    rotate <90.0, 0.0, -158.530624>
  translate <1.380000, 0.150000, 0.000000>
  }
  scale <1.0, 1.0, 4.0>
  rotate 90.0*x
  translate  <0.0, 2.0, 1.0>
}
union { // Book
  object { BookSpine }
  object { BookBack }
  object { BookbackPage }
  object { BookFrontPages }
  object { BookFront }
  scale 5.0
  rotate 160.0*z
  translate  <39.0, -57.5, 60.5>
}


#declare StandSupports = union {
  object { StandSupport1 }
  object { // StandSupport2->StandSupport1
    StandSupport1
    translate  <18.0, 0.0, 0.0>
  }
  object { StandSupport5 }
  object { // StandSupport6->StandSupport5
    StandSupport5
    translate  18.0*x
  }
  object { // StandSupport7->StandSupport5
    StandSupport5
    translate  -22.0*y
  }
  object { // StandSupport8->StandSupport5
    StandSupport5
    translate  <18.0, -22.0, 0.0>
  }
  box { // StandSupport3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 16.0>
    translate  <9.0, -46.0, -39.0>
  }
  box { // StandSupport4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 16.0>
    translate  <-9.0, -46.0, -39.0>
  }
}
union { // Stand
  object { StandTop }
  object { // StandTop1->StandTop
    StandTop
    translate  <0.0, -22.0, 22.0>
  }
  object { // StandTop2->StandTop
    StandTop
    translate  -33.0*z
  }
  object { // StandTop3->StandTop
    StandTop
    translate  <0.0, -22.0, -11.0>
  }
  object { // StandTop4->StandTop
    StandTop
    translate  <0.0, -22.0, -44.0>
  }
  object { // StandTop5->StandTop
    StandTop
    translate  <0.0, -44.0, -24.0>
  }
  object { StandSupports }
  texture {
    Cherry_Wood2
  }
  scale 2.0
  rotate 90.0*z
  translate  <62.0, -55.5, 58.0>
}


plane { // Ground
  z,0
  texture {
    Grass
    scale 0.6
  }
  scale 100.0
  rotate <-5.0, 0.0, 0.0>
  translate  <-95.5, 0.0, -140.0>
}


#declare ChimeWoodTop = union {
  cylinder { // ChimeTop1
    <0,0,1>, <0,0,0>, 1 
    scale <1.2, 1.2, 0.3>
    translate  -0.15*z
  }
  torus { // ChimeTop2
    1.2, 0.15  rotate -x*90
  }
  translate  <0.0, 0.1, -0.1>
}
#declare ChimeWoodMiddle = union {
  torus { // ChimeMid2
    0.4, 0.1  rotate -x*90
    translate  -2.5*z
  }
  cylinder { // ChimeMid1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.2>
    translate  -2.6*z
  }
  translate  -0.5*z
}
#declare ChimeWoodBottom = union {
  cylinder { // ChimeBottom5
    <0,0,1>, <0,0,0>, 1 
    scale 0.1
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.05, 0.3, -7.0>
  }
  cylinder { // ChimeBottom4
    <0,0,1>, <0,0,0>, 1 
    scale 0.1
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.05, -0.3, -7.0>
  }
  box { // ChimeBottom3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 0.05>
    rotate <90.0, 0.0, -90.0>
    translate  -6.8*z
  }
  box { // ChimeBottom2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.4, 0.05>
    rotate <90.0, 0.0, -90.0>
    translate  -6.6*z
  }
  cylinder { // Chimebottom1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.1>
    rotate <90.0, 0.0, 90.0>
    translate  <-0.05, 0.0, -6.2>
  }
  translate  -1.0*z
}
#declare WoodChimePieces = union {
  object { ChimeWoodTop }
  object { ChimeWoodMiddle }
  object { ChimeWoodBottom }
  texture {
    Cherry_Wood1
    rotate -5.0*x
  }
}
#declare ChimeSet1 = union {
  cylinder { // Chime1
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Chrome
    }
    scale <0.15, 0.15, 5.0>
    translate  <-0.9, 0.0, -6.0>
  }
  cylinder { // Chime1String1
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, 0.0>
    translate  <-0.9, -0.15, -1.6>
  }
  cylinder { // Chime1String2
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, -180.0>
    translate  <-0.9, 0.15, -1.6>
  }
  translate  -0.1*x
}
#declare ChimeSet2 = union {
  cylinder { // Chime2
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Chrome
    }
    scale <0.15, 0.15, 4.7>
    translate  <-0.9, 0.0, -5.7>
  }
  cylinder { // Chime1String3
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, 0.0>
    translate  <-0.9, -0.15, -1.6>
  }
  cylinder { // Chime1String4
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, -180.0>
    translate  <-0.9, 0.15, -1.6>
  }
  rotate -60.0*z
  translate  <-0.05, 0.086603, 0.0>
}
#declare ChimeSet3 = union {
  cylinder { // Chime3
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Chrome
    }
    scale <0.15, 0.15, 4.4>
    translate  <-0.9, 0.0, -5.4>
  }
  cylinder { // Chime1String5
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, 0.0>
    translate  <-0.9, -0.15, -1.6>
  }
  cylinder { // Chime1String6
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, -180.0>
    translate  <-0.9, 0.15, -1.6>
  }
  rotate -120.0*z
  translate  <0.05, 0.086603, 0.0>
}
#declare ChimeSet4 = union {
  cylinder { // Chime4
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Chrome
    }
    scale <0.15, 0.15, 4.1>
    translate  <-0.9, 0.0, -5.1>
  }
  cylinder { // Chime1String7
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, 0.0>
    translate  <-0.9, -0.15, -1.6>
  }
  cylinder { // Chime1String8
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, -180.0>
    translate  <-0.9, 0.15, -1.6>
  }
  rotate -180.0*z
  translate  <0.1, 0.0, 0.0>
}
#declare ChimeSet5 = union {
  cylinder { // Chime5
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Chrome
    }
    scale <0.15, 0.15, 3.8>
    translate  <-0.9, 0.0, -4.8>
  }
  cylinder { // Chime1String9
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, 0.0>
    translate  <-0.9, -0.15, -1.6>
  }
  cylinder { // Chime1String10
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, -180.0>
    translate  <-0.9, 0.15, -1.6>
  }
  rotate -240.0*z
  translate  <0.05, -0.086603, 0.0>
}
#declare ChimeSet6 = union {
  cylinder { // Chime6
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Chrome
    }
    scale <0.15, 0.15, 3.5>
    translate  <-0.9, 0.0, -4.5>
  }
  cylinder { // Chime1String11
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, 0.0>
    translate  <-0.9, -0.15, -1.6>
  }
  cylinder { // Chime1String12
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 1.5>
    rotate <10.0, 0.0, -180.0>
    translate  <-0.9, 0.15, -1.6>
  }
  rotate -300.0*z
  translate  <-0.05, -0.086603, 0.0>
}
#declare Chimes = union {
  object { ChimeSet1 }
  object { ChimeSet2 }
  object { ChimeSet3 }
  object { ChimeSet4 }
  object { ChimeSet5 }
  object { ChimeSet6 }
}
union { // ChimeObject
  object { WoodChimePieces }
  cylinder { // CenterString
    <0,0,1>, <0,0,0>, 1 
    texture {
      String
    }
    scale <0.02, 0.02, 6.8>
    translate  -6.8*z
  }
  object { Chimes }
  scale 15.0
  rotate <0.0, 0.0, -60.0>
  translate  <-52.5, 73.5, 200.0>
}


#declare ChairLegDiff = difference {
  box { // ChairLegPart1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 45.0>
    rotate <30.0, 0.0, 0.0>
    translate  <-37.0, -12.0, -39.0>
  }
  box { // ChairLegCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 2.0>
    rotate -10.0*x
    translate  <-36.0, -31.0, 1.5>
  }
}
#declare ChairLegDiff1 = difference {
  box { // ChairLegPart3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 45.0>
    rotate <30.0, 0.0, 0.0>
    translate  <-37.0, -12.0, -39.0>
  }
  box { // ChairLegCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 2.0>
    rotate -10.0*x
    translate  <-38.0, -31.0, 1.5>
  }
  translate  74.0*x
}
#declare ChairLegs = union {
  box { // ChairArm1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 40.0, 2.0>
    rotate -10.0*x
    translate  <-36.0, -35.0, -1.0>
  }
  box { // ChairArm2
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 40.0, 2.0>
    rotate -10.0*x
    translate  <36.0, -35.0, -1.0>
  }
  object { ChairLegDiff }
  object { ChairLegDiff1 }
  box { // ChairLegPart2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 45.0>
    rotate -25.0*x
    translate  <-37.0, -64.5, -39.5>
  }
  box { // ChairLegPart4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 45.0>
    rotate -25.0*x
    translate  <37.0, -64.5, -39.5>
  }
}
#declare ChairLegsDiff = difference {
  object { ChairLegs }
  box { // ChairLegsCut
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 60.0, 6.0>
    translate  <0.0, -32.5, -78.5>
  }
  texture {
    Cherry_Wood2
  }
}
#declare ChairSideDiff = difference {
  cylinder { // ChairSeatSide11
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 13.0, 4.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-34.0, -67.5, -34.25>
  }
  cylinder { // ChairSeatSide12
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.5, 6.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-35.5, -67.5, -34.5>
  }
  box { // ChairSeatSide13
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 15.0, 6.0>
    rotate -15.0*x
    translate  <-32.5, -69.5, -41.5>
  }
  box { // ChairSeatSide14
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 8.0, 6.0>
    rotate -15.0*x
    translate  <-32.5, -60.5, -33.0>
  }
  translate  <0.0, -19.0, 4.0>
}
#declare ChairSeatSide1 = union {
  box { // ChairSeatSide10
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 40.0, 3.0>
    rotate -10.0*x
    translate  <-32.0, -47.5, -28.0>
  }
  object { ChairSideDiff }
  texture {
    Cherry_Wood2
  }
}
#declare ChairSideDiff1 = difference {
  cylinder { // ChairSeatSid12
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 13.0, 4.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-34.0, -67.5, -34.25>
  }
  cylinder { // ChairSeatSid13
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.5, 6.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-35.5, -67.5, -34.5>
  }
  box { // ChairSeatSid14
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 15.0, 6.0>
    rotate -15.0*x
    translate  <-32.5, -69.5, -41.5>
  }
  box { // ChairSeatSid15
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 8.0, 6.0>
    rotate -15.0*x
    translate  <-32.5, -60.5, -33.0>
  }
  translate  <0.0, -19.0, 4.0>
}
#declare ChairSeatSide2 = union {
  box { // ChairSeatSid11
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 40.0, 3.0>
    rotate -10.0*x
    translate  <-32.0, -47.5, -28.0>
  }
  object { ChairSideDiff1 }
  texture {
    Cherry_Wood2
  }
  translate  64.0*x
}
#declare ChairSeat = union {
  box { // ChairSeat1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -22.0, -28.35>
  }
  box { // ChairSeat2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -32.0, -26.6>
  }
  box { // ChairSeat3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -42.0, -24.85>
  }
  box { // ChairSeat4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -52.0, -23.1>
  }
  box { // ChairSeat5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -62.0, -21.35>
  }
  box { // ChairSeat6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -72.0, -19.6>
  }
  box { // ChairSeat7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate -10.0*x
    translate  <0.0, -82.0, -17.85>
  }
  box { // ChairSeat8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate 20.0*x
    translate  <0.0, -92.0, -18.5>
  }
  box { // ChairSeat9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cherry_Wood2
    }
    scale <34.0, 3.0, 1.0>
    rotate 55.0*x
    translate  <0.0, -99.0, -24.5>
  }
  texture {
    Cherry_Wood2
  }
}
#declare ChairBackParts = union {
  box { // ChairBackSide1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 40.0>
    rotate -20.0*x
    translate  -29.0*x
  }
  box { // ChairBack1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 40.0>
    rotate -20.0*x
    translate  -24.0*x
  }
  box { // ChairBack2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 45.0>
    rotate -20.0*x
    translate  <-16.0, 2.0, 5.0>
  }
  box { // ChairBack3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 48.0>
    rotate -20.0*x
    translate  <-8.0, 4.0, 8.0>
  }
  box { // ChairBack4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 50.0>
    rotate -20.0*x
    translate  <0.0, 5.0, 10.0>
  }
  box { // ChairBack5
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 48.0>
    rotate -20.0*x
    translate  <8.0, 4.0, 8.0>
  }
  box { // ChairBack6
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 45.0>
    rotate -20.0*x
    translate  <16.0, 2.0, 5.0>
  }
  box { // ChairBack7
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 40.0>
    rotate -20.0*x
    translate  24.0*x
  }
  box { // ChairBackSide2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 40.0>
    rotate -20.0*x
    translate  29.0*x
  }
  texture {
    Cherry_Wood2
  }
  rotate -10.0*x
}
#declare ChairBackCut = difference {
  box { // ChairBackCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <32.0, 20.0, 3.5>
    rotate <60.0, 0.0, 0.0>
    translate  <-0.5, 22.5, 37.5>
  }
  cylinder { // ChairBackCut1
    <0,0,1>, <0,0,0>, 1 
    scale <32.0, 35.0, 8.0>
    rotate 60.0*x
    translate  <0.0, 13.0, 13.0>
  }
  texture {
    Cherry_Wood2
  }
}
#declare ChairBack = difference {
  object { ChairBackParts }
  object { ChairBackCut }
  texture {
    Cherry_Wood2
  }
}
#declare ChairBolts = union {
  sphere { // ChairLegBolt1
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-40.0, -58.5, -26.0>
  }
  sphere { // ChairLegBolt2
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-30.0, -58.5, -26.0>
  }
  sphere { // ChairLegBolt3
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <40.0, -58.5, -26.0>
  }
  sphere { // ChairLegBolt4
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <30.0, -58.5, -26.0>
  }
  sphere { // ChairArmBolt1
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-41.0, -3.5, -6.5>
  }
  cylinder { // ChairArmCyl1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Brass_Texture1
    }
    scale <0.5, 0.5, 3.0>
    rotate 90.0*y
    translate  <-31.0, -3.5, -6.5>
  }
  sphere { // ChairArmBolt2
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-28.0, -3.5, -6.5>
  }
  sphere { // ChairArmBolt3
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <41.0, -3.5, -6.5>
  }
  cylinder { // ChairArmCyl2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Brass_Texture1
    }
    scale <0.5, 0.5, 3.0>
    rotate 90.0*y
    translate  <28.0, -3.5, -6.5>
  }
  sphere { // ChairArmBolt4
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <28.0, -3.5, -6.5>
  }
  cylinder { // ChairBackCyl1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Brass_Texture1
    }
    scale <0.5, 0.5, 60.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-30.0, 12.0, 19.5>
  }
  sphere { // ChairBackBolt1
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-30.0, 12.0, 19.5>
  }
  sphere { // ChairBackBolt2
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <30.0, 12.0, 19.5>
  }
  cylinder { // ChairBackCyl2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Brass_Texture1
    }
    scale <0.5, 0.5, 80.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-40.0, -18.0, -32.5>
  }
  cylinder { // ChairBackCyl3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Brass_Texture1
    }
    scale <0.5, 0.5, 80.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-40.0, -13.0, -34.5>
  }
  sphere { // ChairBackBolt3
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-40.0, -18.0, -32.5>
  }
  sphere { // ChairBackBolt4
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <-40.0, -13.0, -34.5>
  }
  sphere { // ChairBackBolt5
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <40.0, -18.0, -32.5>
  }
  sphere { // ChairBackBolt6
    <0,0,0>,1
    texture {
      Brass_Texture1
    }
    scale 0.7
    translate  <40.0, -13.0, -34.5>
  }
  texture {
    Brass_Texture1
  }
}
union { // Chair
  object { ChairLegsDiff }
  object { ChairSeatSide1 }
  object { ChairSeatSide2 }
  object { ChairSeat }
  object { ChairBack }
  object { ChairBolts }
  texture {
    Cherry_Wood2
  }
  rotate 65.0*z
  translate  <-133.0, -114.5, 20.5>
}



# include "potplant.inc"

object {
  Lsystem
  scale <0.03, 0.03, 0.03>
  rotate <90, 0, 210>
  translate <135,-53, 20>
}

fog {
  color red 0.85 green 0.85 blue 0.85
  distance 75000
}


box {
  <-1,-1,-1>,<1, 1, 1>
  scale <4, 600, 300>
  rotate <0, 0, 90>
  translate <310,-600, 30>
  pigment {
    brick red 0.9 green 0.9 blue 0.7, red 1.0 green 1.0 blue 1.0
  }
  finish {ambient 0.3  crand 0.03}
}
