/***************************************************************************/
//		fishing.pov
//		by Hero Ngauv
//		email:  mroreo123@aol.com
/***************************************************************************/

#include "colors.inc"
//#include "textures.inc"
//#include "herotxtr.inc"
//#include "shapes.inc"

#declare Direction = 1
#declare Vector = <-3,5,-7>
#declare Look_At = <0,3,10>
camera{
  location Vector
  direction <0,0,Direction>
  up <0,1,0>
  right <4/3,0,0>
  look_at Look_At
}
light_source{ (Vector + <0,0,0>) color (Gray35+Orange)/3 }
//light_source{ <0,5500,10000> color Orange }
light_source{
  <0,5500,10000> color Orange
  area_light <500,500,0>, <-500,-500,0>,  5,5
  adaptive 1
  jitter
}

/***************************************************************************/
//				The Sun
/*
sphere{ <0,11,200>, 7
  texture{
    pigment{ Orange*1.65 }
    finish{ ambient 0.65 diffuse 0 }
  }
  no_shadow
}
*/
sphere{ <0,0,0>, 5
  texture{
    pigment{ Clear }
    halo{
      emitting
      linear
      spherical_mapping
      samples 30
//      color_map{
//        [0.0 Orange*0.5 transmit 0.5]
//        [1.00 Orange*0.5 transmit 0]
//      }
      color_map{
        [0.00 color ((Orange*2.35)+Red*1.25)/5 /*Orange*0.5*/ transmit 1]
        [0.50 Orange*0.75 transmit -0.25]
        [1.00 Orange*0.5 transmit -2.5]
      }
    }
  }
  scale 14//12
  translate <0,11,180>
  hollow
  no_shadow
}

/***************************************************************************/
//				The Sky
plane{ <0,10,1>, 0
  translate <0,20,0>
  texture{			//the sky
    pigment{
      gradient y
      color_map{
        [0.00 color ((Orange*2.35)+Red*1.25)/2.5]
        [0.35 color ((Orange*2.35)+Red*1.25)/2.5]
        //[0.40 color ((Orange*1.5)+Red*1.)/2]
        [0.95 color (Navy+LightBlue+White*1.75)/6]
        [1.00 color (Navy+LightBlue+White*1.75)/6]
      }
    }
    finish{ ambient 0.5 diffuse 0 }
    scale 35
  }
  texture{			//cloud layer
    pigment{
      bozo
      color_map{
        [0.0 Clear]
        [0.5 Clear]
        [1.0 rgb 0.65 transmit 0.25]
      }
      turbulence 0.75
      lambda 3
      scale <100,50,50>
      scale 2/3
    }
    finish{ ambient 0.5 diffuse 0 }
  }
  hollow
  no_shadow
  translate <0,0,200>
}
plane{ <0,10,1>, 0		//cloud layer in front of sun
  texture{
    pigment{
      bozo
      color_map{
        [0.0 Clear]
        [0.5 Clear]
        [1.0 rgb 0.65 transmit 0.5]
      }
      turbulence 0.75
      lambda 3
      scale <100,50,50>
      scale 2/3
    }
    finish{ ambient 0.5 diffuse 0 }
  }
  translate <0,0,180>
  no_shadow
  hollow
}

plane{ <0,1,0>, 35
  texture{
    pigment{ color (Navy+LightBlue+White*1.75)/6 }
    finish{ ambient 0.5 diffuse 0 }
  }
  hollow
  no_shadow
}
/***************************************************************************/
//				The Water
//union{
  plane{ <0,1,0>, 0 //}			//the sea
/*  height_field{ gif "b-ripp7.gif"	//the waves at the shore
    translate <-0.5,-0.001,0>
    scale <80,0.5,52.5/1>
    translate <-5,0,-6>
    
    scale <1,1,0.5>
    translate <0,0,-10>
    //smooth
  }*/
/*  height_field{ tga "ripples3.tga"	//the waves around the boat
    translate <-0.5,0,-0.5>
    scale <90,1,30>
    translate <20,0,100>
  }*/
  texture{
    pigment{ LightBlue*0.55 }
    //pigment{ SeaGreen*0.5 }
    finish{
      ambient 0
      diffuse 0.85
      specular 0.5
      roughness 0.01
      reflection 0.5
    }
    normal{
      bumps 0.25
      frequency 5
      //turbulence 0.25
      omega 0.5
      lambda 1.75
      scale <1.25,0.25,0.25>
    }
  }
}
/***************************************************************************/
//				The Beach
/*
height_field{ gif "beach2.gif"
  water_level 0.1
  translate <-0.5,-0.1,-0.5>
  scale <80,3,25/1.5>
  texture{
    pigment{ color (Wheat+White)/2 }
    finish{ ambient 0.15 diffuse 0.25 }
  }
  rotate <0,20,0>
  translate <-5,0,-6>
  //smooth
}
*/
/***************************************************************************/
/*
height_field{ gif "b-ripp7.gif"
  translate <-0.5,-0.001,0>
  scale <80,0.5,52.5/1>
  translate <-5,0,-6>
//  smooth
  texture{
    pigment{ LightBlue*0.55 }
    finish{
      ambient 0.05
      diffuse 0.85
      specular 0.5
      roughness 0.01
    }
    normal{
      bumps 0.25
      frequency 5
      turbulence 0.5
      omega 0.75
      lambda 1.75
      scale <25,5,5>
      scale 0.05
    }
  }
}
*/
/***************************************************************************/
//				The Boat
#declare Boat =
union{
  intersection{
    sphere{ <1,0,0>, 2 }
    sphere{ <-1,0,0>, 2 }
    box{ <3,0,3>, <-3,-3,0> }
    scale <5,3,12>
    translate <0,0,-10>
  }
/*  intersection{
    cylinder{ <1,0,0>,<1,0,-2>, 2 }
    cylinder{ <-1,0,0>,<-1,0,-2>, 2 }
    box{ <1,0,0>, <-1,-3,-2> }
    scale <5,3,4>
  }*/
  union{				//fisherman 1
    sphere{ <0,3,0.5>, 1  }			//head
    sphere{ <0,0,0>, 1 scale <1,2.25,1> }	//body
    union{					//arm
      cylinder{ <0,0,0>,<0,0,1.75>, 0.4 }
      cylinder{ <0,0,0>,<0,0,1.5>, 0.4
        rotate <-60,0,0>
        translate <0,0,1.75>
      }
      rotate <40,0,0>
      translate <0,1.5,0>
    }
    union{				//the fishing pole
      cylinder{ <0,0,0>,<0,0,10>, 0.125 }
      cylinder{ <0,0,0>,<0,0,15>, 0.095
        pigment{ rgb 0.5 transmit 0.75 }
        rotate <25+90,0,0>
        translate <0,0,10>
      }
      rotate <-25,0,0>
      translate <0,1,2.5>
    }
    rotate <0,180,0>
    translate <0,0,-5>
  }
  union{				//fisherman 2
    sphere{ <0,3,0.5>, 1  }			//head
    sphere{ <0,0,0>, 1 scale <1,2.25,1> }	//body
    union{					//arm
      cylinder{ <0,0,0>,<0,0,1.75>, 0.4 }
      cylinder{ <0,0,0>,<0,0,1.5>, 0.4
        rotate <-60,0,0>
        translate <0,0,1.75>
      }
      rotate <40,0,0>
      translate <0,1.5,0>
    }
    union{				//the fishing pole
      cylinder{ <0,0,0>,<0,0,10>, 0.125 }
      cylinder{ <0,0,0>,<0,0,15>, 0.095
        pigment{ rgb 0.5 transmit 0.75 }
        rotate <25+90,0,0>
        translate <0,0,10>
      }
      rotate <-25,0,0>
      translate <0,1,2.5>
    }
    rotate <0,0,0>
    translate <0,0,1>
  }
}
object{
  Boat
  texture{
    pigment{ Black }
  }
  rotate <0,90,0>
  translate <10,2,115>
}

/***************************************************************************/
//				The Wood
#declare Wood_Texture =
  texture{
    pigment{
      wood
      ramp_wave
      color_map{
        [0.0 LightWood*0.85]
        [0.3 LightWood*0.85]
        [0.7 MediumWood*1.15]
        [0.9 DarkWood*1.15]
        [1.0 LightWood*0.85]
      }
      scale <0.1,0.1,1>
      turbulence 0.1
      octaves 4
      omega 0.35
      warp{
        black_hole
        <0,0.5,0>, 1
        strength 4
        repeat <3,3,3>
        turbulence 1
        inverse
      }
      warp{
        black_hole
        <0,0.5,0>, 1
        strength 4
        repeat <4,4,4>
        turbulence 1
        inverse
      }
    }
  }
/***************************************************************************/
//				The Planks
#declare Plank =
box{ <0,0.5,2>, <10,-3,1.05> }
union{
  object{ Plank translate <0,0,0> }
  object{ Plank translate <0,0,-1> }
  object{ Plank translate <0,0,-2> }
  object{ Plank translate <0,0,-3> }
  object{ Plank translate <0,0,-4> }
  object{ Plank translate <0,0,-5> }
  object{ Plank translate <0,0,-6> }
  object{ Plank translate <0,0,-7> }
  object{ Plank translate <0,0,-8> }
  object{ Plank translate <0,0,-9> }
  object{ Plank translate <0,0,-10> }
  object{ Plank translate <0,0,-11> }
  object{ Plank translate <0,0,-12> }
  texture{ Wood_Texture rotate <0,90,0> }
  translate <-6,0,0>
}
/***************************************************************************/
//			The Border and Posts
#declare Post =
box{ <0.25,3,0.25>, <-0.25,-3,-0.25> }

union{				//the border
  box{ <-6.05,0.5,2>, <-6.35,-3,-20> }
  box{ <4.05,0.5,2>, <4.35,-3,-20> }
  texture{ Wood_Texture }
}

union{				//the vertical posts
  object{ Post translate <-4,0,1.75> }	//center posts
  object{ Post translate <-1,0,1.75> }
  object{ Post translate <2,0,1.75> }

  object{ Post translate <-6.101,0,1.75> }	//left set of posts
  object{ Post translate <-6.101,0,-1.25> }
  object{ Post translate <-6.101,0,-4.25> }
  object{ Post translate <-6.101,0,-7.25> }
  object{ Post translate <-6.101,0,-10.25> }

  object{ Post translate <4.101,0,1.75> }	//right set of posts
  object{ Post translate <4.101,0,-1.25> }
  object{ Post translate <4.101,0,-4.25> }
  object{ Post translate <4.101,0,-7.25> }
  object{ Post translate <4.101,0,-10.25> }

  texture{ Wood_Texture rotate <90,0,0> scale <0.5,1,0.5> }
}

union{					//the two side rails
  box{ <-6.101,3.5,2>, <-5.601,3,-20> }
  box{ <4.101,3.5,2>, <3.601,3,-20> }
  texture{ Wood_Texture }
}
box{ <-5.601,3.5,2>, <3.601,3,1.5>	//the front rail
  texture{ Wood_Texture rotate <0,90,0> }
}
/***************************************************************************/
