
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "house-1.inc" - Create one entire house.
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// Note: this house is missing a few(!) pieces. Most of the back roof is
// not there (to help the interior lighting). I just concentrated on
// the visible parts of the house, on the front and right walls.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set the major colors.

        #declare Trim_Pigment = pigment { Sapphire_Agate scale 0.1 }
        #declare Siding_Pigment = pigment { color rgb < 0.4, 0.4, 1.0 > }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Front siding.

        #declare Front_Siding = difference{

                union {
                #declare A = 0
                #while ( A < 9*12 )
                        box { < 0, -5, -1 > < 36*12, 5, 1 >
                                rotate x*10
                                translate y * (A+12) }
                #declare A=A+8
                #end
                } // End of union.

                // Cutouts for left side windows.
                box { < 3*12, 2*12, -10 > <  7*12, 8*12, 10 > }
                box { < 9*12, 2*12, -10 > < 13*12, 8*12, 10 > }

                // Cutout for door.
                box { < 16*12, 1*12, -10 > < 21*12, 8*12, 10 > }

                // Cutout for right side window.
                box { < 24*12, 3*12, -10 > < 33*12, 8*12, 10 > }

                pigment { Siding_Pigment }
                normal { bumps 0.2 scale 1 }

                } // End of difference.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Right side siding. This starts out *too tall*, then everything
// outside the /\ part is differenced off.

        #declare Right_Side_Siding = difference {

                union {

                #declare A = 0
                #while ( A < 16*12 )

                        box { < 0, -5, -1 > < 24*12, 5, 1 >
                                rotate x*10
                                translate y * (A+12) }

                #declare A=A+8
                #end

                } // End of union.

                // Slicer thingies.
                box { < -50, 0, -5 > < 300, 100, 5 >
                        rotate z * -30
                        translate <12*12, 17*12,0 > }

                box { <-300, 0, -5 > < 50, 100, 5 >
                        rotate z * 30
                        translate <12*12, 17*12,0 > }

                // Now spin it all, and move it over.
                        rotate y * -90
                        translate x * 36*12

                pigment { Siding_Pigment }
                normal { bumps 0.2 scale 1 }

                } // End of difference.


//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Very simple back and left side walls. These are white, because
// all you see is the interior side. Sloppy!
//
// Note: Added the goofy wallpaper to avoid glaring white wall that
//       was visible through the windows!

        #declare Fake_Walls = union {

                box { < 0, 12, 3 > < 1, 9*12, 24*12 >
                        pigment { White } }

                box { < 0, 12, 24*12 > < 36*12, 9*12, (24*12)-1 >
                        pigment { White } }

                // Goofy wallpaper.
                box { < 5*12, 12, (24*12)-1 > < 30*12, 8*12, (24*12)-2 >
                texture { T_Stone16 scale 0.01 } }

                // Left side wallpaper.
                box { < 1, 12, 3 > < 2, 8*12, 20*12 >
                        texture { T_Stone30 scale 0.01 } }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Medium size windows - fill up 48x72 rough openings.

        #declare Medium_Window = union {

                difference{
                box { < 0, 0, -6 > < 48, 72, 6 > }
                box { < 6, 6, -7 > < 42, 66, 7 > }

                        } // End of difference.

                // Horizontal dividers.
                        #declare A = 16
                        #while ( A <= 56 )
                        box{ < 0, A-0.5, -1 > < 48, A+0.5, 1 > }
                        #declare A = A + 10
                        #end

                // Extra thick center one!
                        box{ < 0, (36)-1.5, -2 > < 48, (36)+1.5, 2 > }

                // Vertical dividers.
                        #declare A = 15
                        #while (A <= 33 )
                        box{ < A-0.5, 0, -1 > < A+0.5, 72, 1 > }
                        #declare A=A+9
                        #end

                pigment { Trim_Pigment }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Curtains for medium windows.

        #declare The_Curtains =

                mesh {

                // Top part.
                triangle{ <0,72,7><28,72,7><0,0,7> }
                triangle{ <20,72,7><48,72,7><48,0,7> }

                // Bottom part.
                triangle{ <0,0,7><0,24,7><24,0,7> }
                triangle{ <48,0,7><48,24,7><24,0,7> }

                pigment { color rgb < 1, 0.3, 0.3 > }

                } // End of mesh

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Large window - fill up 108x60 rough opening.

        #declare Large_Window = union {

                difference{
                box { < 0, 0, -6 > < 9*12, 5*12, 6 > }
                box { < 6, 6, -7 > < 8.5*12, 4.5*12, 7 > }

                        } // End of difference.

                // Vertical dividers.
                        #declare A = 2
                        #while ( A <= 6 )
                        box{ < (A*12)+5, 0, -1 > < (A*12)+7, 5*12, 1 > }
                        #declare A = A + 2
                        #end

                pigment { Trim_Pigment }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The front door - fill up 60x84 rough opening.

        #declare Front_Door = union {

                difference{

                        box { < 0, 0, -6 > < 60, 84, 6 > }
                        box { < 6, 1, -7 > < 54, 78, 7 > }

                        pigment { Trim_Pigment }

                        } // End of difference.

                // Wood door.
                        box { < 0, 0, 5 > < 60, 84, 6 >
                                pigment { brick GreenCopper, BakersChoc
                                        scale < 0.5, 200, 200 > }
                                normal { bumps 0.5 scale 0.2 } }

                // Door knob.
                        sphere{0,2 scale <1,1,0.5> translate < 9,36,4 >
                                texture { T_Gold_3C } }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Trim boards (at front corners of house).

        #declare Trim_Boards = union {

                box { < -2, 6, -2 > < 4, 9.5*12, 4 > }

                box { < (36*12)-4, 9, -2 > < (36*12)+2, 9.5*12, 4 > }

                pigment { Trim_Pigment }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Brick foundation

        #declare Brick_Foundation =

                box { < 1, 0, 1 > < (36*12)-1, 12, (24*12)-1 >
                        pigment { brick Gray30, Firebrick } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Front steps - from x=15' to x=22' (one foot past door).

        #declare Front_Steps = union {

                box { < 15*12, 0, 1 > < 22*12,  6, -4.5*12 > }
                box { < 15*12, 6, 1 > < 22*12, 12, -4.0*12 > }

                pigment { brick Gray30, Firebrick }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Hand rails for front steps.

        #declare Hand_Rails = union {

        cylinder { < 15.5*12, 4*12, -2*12 > < 15.5*12, 4*12, 1*12 >, 1.5 }
        cylinder { < 21.5*12, 4*12, -2*12 > < 21.5*12, 4*12, 1*12 >, 1.5 }

        #declare A = -3.5 #while ( A <= -0.5 )

        cylinder { < 15.5*12, 0, A*12 > < 15.5*12, 4*12, A*12 >, 1.5 }
        cylinder { < 21.5*12, 0, A*12 > < 21.5*12, 4*12, A*12 >, 1.5 }

        #declare A = A + 0.5 #end

        pigment { Gray40 }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Bright white floor.

        #declare White_Floor =
                box { < 3, 12, 3 > < (36*12)-3, 12.1, (24*12)-3 >
                pigment { White } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The roof. This is *-VERY-*-*-SLOPPY-*, sorry!

        #declare Roof = union {

                // Front part (all shingles).
                // Rotate this *after* pigment is applied.
                box { < -12, -24, 0 > < 37*12, 15*12, -6 >
                        pigment { brick Gray20, SteelBlue
                        brick_size < 36, 12, 12 >
                        mortar 0.5 }
                        normal { bumps 0.5 scale 0.1 }
                        rotate x * 90 }

                // Trim on front and right edge. This fits just a little
                // bit under the shingles.
                        box { < -12.1, 0, -24.1 > < 37.1*12, 5, 14.9*12 >
                        pigment { Trim_Pigment } }

                // Back part (just the right edge is visible). Paint it
                // with the trim color, because you're really looking
                // at the bottom, not the shingles!
                        box { < 34*12, 0, 0 > < 37*12, 6, 15*12 >
                        rotate x * 60 translate z * 12*15
                        pigment { Trim_Pigment } }

                // Adjust the entire roof.
                        rotate x * -30
                        translate y * 10*12

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Every house needs a giant tee-vee!

        #declare Giant_Tee_Vee = union {

                box { < 0,0,0 > < 56, 52, 24 > pigment { Gray10 } }

                box { < 0,0,0> < 1, 1, 0.1 >
                        pigment {
                                image_map { tga "notagain.tga"
                                        interpolate 2
                                } // end of image_map
                        } // end of pigment
                        scale < 48, 36, 1 >
                        translate < 4, 12, -0.1 >
                        } // End of box.

                translate < -28, 0, -12 >
                rotate y * -45

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Put everything together.

        #declare House_One = union {

                object { Giant_Tee_Vee translate < 20.2*12, 12.1, 14*12 > }
                object { Front_Siding }
                object { Right_Side_Siding }
                object { Fake_Walls }
                object { Brick_Foundation }
                object { Trim_Boards }
                object { Front_Steps }
                object { Hand_Rails }
                object { White_Floor }
                object { Roof }

                object { Medium_Window translate< 3*12, 2*12, 4> }
                object { Medium_Window translate< 9*12, 2*12, 4> }
                object { The_Curtains  translate< 3*12, 2*12, 4> }
                object { The_Curtains  translate< 9*12, 2*12, 4> }

                object { Large_Window translate< 24*12, 3*12, 4> }
                object { Front_Door translate < 16*12, 1*12, 4 > }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

