
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// p4def_08.inc - Girl watching spatula boy.
//
// "Paul's Primitive POV People", or "P4".
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Declare the *textures* for everything.

        #declare P4_Eye_Texture = texture { pigment { Sapphire_Agate } }
        #declare P4_Glasses_Texture = texture { pigment{SpicyPink} }

        #declare P4_Hair_Texture = texture {
                pigment { Red_Marble scale 0.1 } }

        #declare P4_Hat_Texture = texture {
                pigment { checker NeonBlue, White scale 50 } }

        #declare P4_Shirt_Texture = texture {
                pigment { spiral1 2
                        color_map {
                                [0.0, 0.5 color rgb <1.0, 1.0, 0.0>
                                          color rgb <0.9, 1.0, 1.0>]
                                [0.5, 1.0 color rgb <1.0, 0.0, 1.0>
                                          color rgb <1.0, 1.0, 0.0>] }
                        scale 12
                        translate x*12 }
                normal { bumps 0.5 scale 2 } }

        #declare P4_Shoe_Texture = texture { pigment{CornflowerBlue} }

        #declare P4_Shorts_Texture = texture {
                pigment {
                        image_map { gif "shorts-0.gif"
                                interpolate 2
                                } // end of image_map
                        } // end of pigment
                scale 3
                rotate < 33, 33, 33 >
                normal { bumps 0.2 scale 2 } }

        #declare P4_Skin_Texture = texture { pigment { Tan } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now choose *types* of things. You will have to read the directions
// to see what numbers are legal here!

        #declare P4_Eye_Type = 1
        #declare P4_Glasses_Type = 0
        #declare P4_Hair_Type = 3
        #declare P4_Hand_Type = 1
        #declare P4_Hat_Type = 2
        #declare P4_Mouth_Type = 2
        #declare P4_Nose_Type = 2
        #declare P4_Shirt_Type = 2
        #declare P4_Shoe_Type = 3
        #declare P4_Shorts_Type = 2

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set the sizes of various things.

        #declare P4_Leg_Length = 34
        #declare P4_Neck_Height = 3
        #declare P4_Shirt_Height = 22
        #declare P4_Shorts_Height = 12

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose the rotation values. Please read the directions!

        #declare P4_Hat_Rotate = < 10, -70, 0 >
        #declare P4_Neck_Rotate = < -10, 0, 0 >
        #declare P4_Waist_Rotate = < -10, 0, 0 >

        #declare P4_Left_Elbow_Rotate = < 120, -150, 0 >
        #declare P4_Right_Elbow_Rotate = < 120, 150, 0 >

        #declare P4_Left_Eyelid_Rotate = -40
        #declare P4_Right_Eyelid_Rotate = -40

        #declare P4_Left_Knee_Rotate = < -10, 0, 0 >
        #declare P4_Right_Knee_Rotate = < -10, 0, 0 >

        #declare P4_Left_Leg_Rotate = < 10, 0, -10 >
        #declare P4_Right_Leg_Rotate = < 10, 0, 10 >

        #declare P4_Left_Shoulder_Rotate = < 50, -50,  30 >
        #declare P4_Right_Shoulder_Rotate = < 30, 50, -30 >

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Create the optional "holding" object. This will go into the left
// hand, and move with the hand. This is optional - just comment it
// out if not needed, and set the flag to "false".
//
// The flag is necessary to prevent person #2 from carrying the object
// that you gave to person #1. Set it to true or false.

        #declare P4_Holding_Flag = false

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make another optional object - a "bracelet". This also has a flag
// to set on/off. This prevents duplicate bracelets! The bracelet
// should be at <0,0,0>, just like a standard torus.

        #declare P4_Bracelet_Flag = true

// Here, I got carried away and created a very complex bracelet!

        #declare P4_Bracelet_Object = union {
                #declare A = 0 #while ( A < 360 )
                        sphere { 0, 0.3
                                translate x * 0.5
                                rotate z * A * 13
                                translate x * 3
                                rotate y * A
                                } // End of sphere.
                #declare A = A + 2 #end
                pigment { MidnightBlue }
                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Despite my attempts at using "realistic inches" as units, the
// people always seem to end up 8 or 9 feet tall. This variable lets
// you scale the person down to a normal size. Use the P4_TEST.POV
// scene to see how tall your person actually is!

        #declare P4_Total_Scale = 80/100

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// This is the height to move the person up, so his/her feet are on
// the floor. Sorry, but because of bendable legs, this has to be
// adjusted manually (by YOU). 8-)

        #declare P4_Y_Adjust = 30

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now call "p4_main.inc" to create the object.

        #include "p4_main.inc"

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.


