
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "test-4.pov" - Test the big tree.
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->

        #include "colors.inc"
        #include "textures.inc"
        #include "skies.inc"
        #include "golds.inc"
        #include "stones.inc"
        #include "woods.inc"
        #default { finish { Shiny } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose a camera.

        #declare Which_Camera = 1

// Close-up view.

        #if ( Which_Camera = 1 )
                camera { location < 0, 120, -250 >
                look_at < 0, 120, 0> }
        #end

// Final camera position.

        #if ( Which_Camera = 2 )
                camera { location < 135*12, 8*12, -21*12>
                look_at < 121*12, 1*12, 0> }
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Miscellaneous stuff.

        light_source { < -1000, 1000, -1000 > color White }
        light_source { <     0, 1000, -1000 > color White }
        light_source { <  1000, 1000, -1000 > color White }

        background { White }
        #declare R=seed(0)

        cylinder { < 0, 0, 0 > < 0, -1, 0 >, 5000
            pigment { checker SteelBlue, Yellow scale 16 }
            rotate y*30 }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Include the tree include file (what else???).

        #include "ptd_tree.inc"

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Show the tree.

        #if ( Which_Camera = 1 )
                object { Complete_Tree scale 14 }
        #end

        #if ( Which_Camera = 2 )
                object { Complete_Tree
                        scale 14
                        translate < 70*12, 0, 38*12> }
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

