#declare Body_txt = texture {
	pigment {color rgb <0.75, 0.5, 0.45>}
	finish {ambient 0.12 phong 0.01}
}

#declare Hair_txt = texture {
	pigment {color rgb <0.3, 0.25, 0.2>}
	finish {ambient 0.12 diffuse 0.8 phong 0.5 phong_size 40}
	normal {bumps 1 scale <0.001, 0.05, 0.01>}
}

#declare Eye_txt = texture {
	pigment {
		gradient y
		color_map {
			[0 0.5 color rgb 1 color rgb 1]
			[0.5 1 color rgb 0 color rgb 0]
		}
	}
	finish {ambient 0.1 phong 0.2}
	translate y*0.5
}

#declare Main = blob {
	threshold 0.6

	// head
	sphere {0, 0.03 strength 1 translate <-0.25, -0.13, -0.003> scale 1.2 translate <0, 0.03, 0>}
	sphere {0, 0.03 strength 1 translate <-0.25, -0.13, 0.003> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.02 strength 1 translate <-0.257, -0.14, -0.0035> scale 1.2 translate <0, 0.03, 0>} // eyebrow
	sphere {0, 0.02 strength 1 translate <-0.257, -0.14, 0.0035> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.022 strength 1 translate <-0.262, -0.143, -0.007> scale 1.2 translate <0, 0.03, 0>} // eyes
	sphere {0, 0.022 strength 1 translate <-0.262, -0.143, 0.007> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.01 strength -1 scale <1, 0.6, 1> translate <-0.266, -0.153, -0.022> scale 1.2 translate <0, 0.03, 0>} // holes for eyes
	sphere {0, 0.01 strength -1 scale <1, 0.6, 1> translate <-0.266, -0.153, 0.022> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.04 strength 1 translate <-0.23, -0.15, -0.003> scale 1.2 translate <0, 0.03, 0>}
	sphere {0, 0.04 strength 1 translate <-0.23, -0.15, 0.003> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.045 strength 1 scale <3, 1, 1> rotate z*60 translate <-0.25, -0.17, 0> scale 1.2 translate <0, 0.03, 0>}
	sphere {0, 0.02 strength 1 scale <3, 1, 1> rotate z*62 translate <-0.27, -0.17, 0> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.015 strength 1 translate <-0.29, -0.21, -0.002> scale 1.2 translate <0, 0.03, 0>}
	sphere {0, 0.015 strength 1 translate <-0.29, -0.21, 0.002> scale 1.2 translate <0, 0.03, 0>}

	sphere {0, 0.008 strength -1 translate <-0.294, -0.21, -0.006> scale 1.2 translate <0, 0.03, 0>} // nostril
	sphere {0, 0.008 strength -1 translate <-0.294, -0.21, 0.006> scale 1.2 translate <0, 0.03, 0>}


	sphere {0, 0.018 strength 1 translate <-0.285, -0.218, 0> scale 1.2 translate <0, 0.03, 0>}
	sphere {0, 0.015 strength 1 translate <-0.27, -0.22, 0> scale 1.2 translate <0, 0.03, 0>}

	// neck
	sphere {0, 0.04 strength 1 translate -x*0.04 scale <5.2, 1.5, 1.3> rotate z*50 translate <-0.075, 0.137, 0>}
	sphere {0, 0.04 strength 1 translate -x*0.04 scale <4.8, 0.8, 0.6> rotate z*48 translate <-0.046, 0.11, 0>}

	// body
	cylinder {<-0.09, 0, 0>, <0.12, 0, 0>, 0.15 strength 1 translate y*0.02}
	sphere {0, 0.11 strength 1 translate <-0.04, 0, 0>}

	// left forehand
	cylinder {0, <0, -0.1, 0>, 0.05 strength 1 rotate -z*30 translate <-0.09, 0.055, -0.035>}
	cylinder {0, <0, -0.11, 0>, 0.042 strength 1 rotate z*10 translate <-0.12, -0.03, -0.04>}
	cylinder {0, <0, -0.115, 0>, 0.028 strength 1 rotate z*5 translate <-0.102, -0.145, -0.04>}
	cylinder {0, <0, -0.115, 0>, 0.012 strength 1 rotate z*5 translate <-0.094, -0.15, -0.04>}

	// right forehand
	cylinder {0, <0, -0.1, 0>, 0.05 strength 1 rotate -z*30 translate <-0.09, 0.055, 0.035>}
	cylinder {0, <0, -0.11, 0>, 0.042 strength 1 rotate z*5 translate <-0.12, -0.03, 0.04>}
	cylinder {0, <0, -0.115, 0>, 0.028 strength 1 translate <-0.11, -0.145, 0.04>}
	cylinder {0, <0, -0.115, 0>, 0.012 strength 1 translate <-0.1, -0.15, 0.04>}

	// left hind leg
	sphere {0, 0.09 strength 1 scale <1, 1.2, 0.6> rotate -y*20 translate <0.14, 0, -0.04>}
	cylinder {0, <0, -0.15, 0>, 0.044 strength 1 rotate z*30 translate <0.11, 0, -0.04>}
	cylinder {0, <0, -0.14, 0>, 0.025 strength 1 translate <0.185, -0.134, -0.04>}
	cylinder {0, <0, -0.12, 0>, 0.013 strength 1 translate <0.194, -0.15, -0.04>}

	// right hind leg
	sphere {0, 0.09 strength 1 scale <1, 1.2, 0.6> rotate y*20 translate <0.14, 0, 0.04>}
	cylinder {0, <0, -0.16, 0>, 0.044 strength 1 rotate z*0 translate <0.11, 0.02, 0.04>}
	cylinder {0, <0, -0.15, 0>, 0.025 strength 1 rotate -z*20 translate <0.11, -0.13, 0.04>}
	cylinder {0, <0, -0.13 0>, 0.012 strength 1 rotate -z*20 translate <0.112, -0.15, 0.04>}
}

#declare Horse = union {
	object {Main}

	//eyes
	union {
		sphere {0, 0.01
			texture {Eye_txt}
			scale <1, 0.6, 1>
			rotate x*15
			rotate -z*35
			translate <-0.262, -0.153, -0.012>
		}
		sphere {0, 0.01
			texture {Eye_txt}
			scale <1, 0.6, 1>
			rotate x*15
			translate <-0.262, -0.153, 0.012>
		}
		scale 1.2
		translate <0, 0.03, 0>
	}

	//ears
	union {
		difference {
			sphere {0, 0.01}
			plane {y, 0}
			sphere {0, 0.01 scale <1, 0.8, 1>}

			scale <3.1, 1.2, 0.9>
			rotate x*10
			rotate -y*10
			rotate -z*45
			translate <-0.255, -0.125, -0.016>
		}
		difference {
			sphere {0, 0.01}
			plane {y, 0}
			sphere {0, 0.01 scale <1, 0.8, 1>}

			scale <3.1, 1.2, 0.9>
			rotate -x*10
			rotate y*10
			rotate -z*45
			translate <-0.255, -0.125, 0.016>
		}
		scale 1.2
		translate <0, 0.03, 0>
	}

	// mane
	sphere {0, 0.04
		translate -x*0.04
		scale <3.8, 1, 0.04>
		rotate z*53
		translate <-0.13, 0.1, 0>

		texture {Hair_txt}
	}

	// tail
	blob {
		threshold 0.6
		sphere {
			0, 0.03
			strength 1
			scale <2, 1, 1>
			translate <0.22, 0.06, 0>
		}
		sphere {
			0, 0.035
			strength 1
			translate <0.25, 0.054, 0>
		}
		sphere {
			0, 0.03
			strength 1
			scale <1, 1.4, 0.8>
			translate <0.258, 0.035, 0>
		}
		sphere {
			0, 0.05
			strength 1
			scale <1, 2, 0.6>
			translate <0.26, 0.03, 0>
		}
		sphere {
			0, 0.05
			strength 1
			scale <1, 2, 0.6>
			translate <0.26, -0.05, 0>
		}

		scale <1, 1, 0.75>
		translate <-0.036, 0.01, 0>

		texture {Hair_txt}
	}
	texture {Body_txt}

	translate y*0.24
}








