#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "glass.inc"
#include "metals.inc"
#include "skies.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 10 }

// ----------------------------------------

light_source {   0*x color rgb 1.0
  looks_like { sphere {0,1 finish { ambient 1}   pigment { color Yellow}}}
  translate <-35, 30, -10>
}

sky_sphere { S_Cloud5 }


#include "sidewalk.inc"
#include "grass.inc"
#include "egg.inc"
#include "bacon.inc"
#include "marble.inc"
#include "jacks.inc"
#include "wheel.inc"
#include "weed.inc"

#declare closeup=0


#if (closeup)
declare back=0.4
camera {
   location <0, 2*back, -3*back>+<-1.3,0.1501,-0.762>
   direction <0.0, 0.0, 5.0>
   up <0.0, 1.0, 0.0>
   right <4/3, 0.0, 0.0>
   look_at <-1.3,0.1501,-0.762>
     }
#else
declare back=3.3
camera {
   location <0, 2*back, -3*back>
   direction <0.0, 0.0, 5.0>
   up <0.0, 1.0, 0.0>
   right <4/3, 0.0, 0.0>
   look_at <0,0,0.4>
    }
#end

