//bike wheel on a front fork

#declare SR1=0.1    //Spokes come into the hub this far off center
#declare SR2=0.2    //half the lenght of the hub
#declare SDia=0.015 //diameter of a spoke
#declare Wdia=1.8   //diameter of inside edge of wheel

#declare Nlen=0.1   //fraction of the spoke is the nipple
#declare N1=SR1*Nlen/Wdia
#declare N2=SR2*Nlen/Wdia
#declare N3=Wdia-Nlen

#declare Tlen=0.2   //fraction of spoke that is threaded (partly under nipple)
#declare T1=SR1*Tlen/Wdia
#declare T2=SR2*Tlen/Wdia
#declare T3=Wdia-Tlen

//one group of spokes 2 up and 2 down, 2 to left of hub and 2 to the right
#declare Spoke1=
union{
union{
cylinder{<SR1,SR2,0>,<0,0,Wdia> SDia}
cylinder{<SR1,-1*SR2,0>,<0,0,Wdia> SDia rotate <0,360/28,0>}
cylinder{<-1*SR1,SR2,0>,<0,0,Wdia> SDia  rotate <0,360*2/28,0>}
cylinder{<-1*SR1,-1*SR2,0>,<0,0,Wdia> SDia rotate <0,360*3/28,0>}
texture { T_Chrome_3D }
}
union{
cylinder{<N1,N2,N3>,<0,0,Wdia> SDia*1.5}
cylinder{<N1,-1*N2,N3>,<0,0,Wdia> SDia*1.5 rotate <0,360/28,0>}
cylinder{<-1*N1,N2,N3>,<0,0,Wdia> SDia*1.5 rotate <0,360*2/28,0>}
cylinder{<-1*N1,-1*N2,N3>,<0,0,Wdia> SDia*1.5 rotate <0,360*3/28,0>}
texture { T_Chrome_2B }
}
union{
cylinder{<T1,T2,T3>,<0,0,Wdia> SDia*1.05 texture { T_Chrome_3C normal {spiral1 1 rotate <90,0,0> scale 0.01} }}
cylinder{<T1,-1*T2,T3>,<0,0,Wdia> SDia*1.05 texture { T_Chrome_3C normal {spiral1 1 rotate <90,0,0> scale 0.01} } rotate <0,360/28,0>}
cylinder{<-1*T1,T2,T3>,<0,0,Wdia> SDia*1.05 texture { T_Chrome_3C normal {spiral1 1 rotate <90,0,0> scale 0.01} } rotate <0,360*2/28,0>}
cylinder{<-1*T1,-1*T2,T3>,<0,0,Wdia> SDia*1.05 texture { T_Chrome_3C normal {spiral1 1 rotate <90,0,0> scale 0.01} } rotate <0,360*3/28,0>}

}
}
#declare Spoke2=
union{
cylinder{<SR1,SR2,0>,<0,0,Wdia> SDia}
cylinder{<SR1,-1*SR2,0>,<0,0,Wdia> SDia rotate <0,360/28,0>}
cylinder{<-1*SR1,SR2,0>,<0,0,Wdia> SDia  rotate <0,360*2/28,0>}
cylinder{<-1*SR1,-1*SR2,0>,<0,0,Wdia> SDia rotate <0,360*3/28,0>}
texture {  pigment{color rgbt <0.50, 0.50, 0.50, 0.85>}}
}



//all the spokes
union
{#declare Count=0
  #while (Count < 8)
    object {Spoke1 rotate <0,Count*360/7,0> }
  /*object {Spoke2 rotate <0,Count*360/7-1,0> }
    object {Spoke2 rotate <0,Count*360/7-2,0> }
    object {Spoke2 rotate <0,Count*360/7-3,0> }
    object {Spoke2 rotate <0,Count*360/7-4,0> } */
    #declare Count=Count+1
  #end



//rim
lathe
{   cubic_spline
    7, // # of points
    <Wdia+0.35,0.11>
    <Wdia+0.25,0.1>
    <Wdia+0.05,0.07>
    <Wdia,0.0>
    <Wdia+0.05,-0.07>
    <Wdia+0.25,-0.1>
    <Wdia+0.35,-0.11>

   texture { T_Chrome_4E }
}


#declare TireColor = pigment{bozo scale 0.8 color_map{[0 color rgb 0.05]
                                                      [1 color rgb 0.15]}}

//body of tire
torus
{
  Wdia+0.35,
  0.15*1.1
  pigment{TireColor}
  finish {ambient 0.3}
  scale <1,1/1.1,1>
}

//tread
torus
{
  Wdia+0.35,
  0.15*1.1
  pigment{checker  pigment{TireColor}, pigment{color rgb 0.075 } scale 0.065  rotate <45,0,45> }//rgb 0.05 } scale 0.10
  finish {ambient 0.25}
  normal {checker scale 0.10 rotate <45,0,45>}
  scale <1.04,1/(1.1*1.2),1.04>
 }


//whitewall
torus
{
  Wdia+0.35,
  0.15*0.9
  pigment{color White}
  scale <1,1.01/0.9,1>
}

//hub and axel
disc { <0,SR2-SDia,0>, y, SR1+3*SDia texture { T_Chrome_2B } }
disc { <0,SDia-SR2,0>, y, SR1+3*SDia texture { T_Chrome_2B } }

cylinder { SR2*1.5*y, -SR2*1.5*y,  SR1/4 texture { T_Chrome_1A }}
cylinder { SR2*1.4*y, -SR2*1.4*y,  SR1/2 texture { T_Chrome_2B }}


//front fork
superellipsoid { <1, 0.5> scale <SR1,SR1/8,Wdia >
                       translate <0,SR2*1.2+SR1/8,SR1*1.5-Wdia >
     pigment {color rgb <0,0.0,0.5>} finish {F_MetalA }}
superellipsoid { <1, 0.5> scale <SR1,SR1/8,Wdia >
                       translate <0,-1*(SR2*1.2+SR1/8),SR1*1.5-Wdia >
     pigment {color rgb <0,0.0,0.5>} finish {F_MetalA }}


scale 0.4
rotate <0,120,0>
rotate <-5,0,-10>
translate <-1.45,0.23,2.53>
}



