#include "kegbody.inc"
#include "kegtop.inc"
#include "tap.inc"
#include "spout.inc"
#include "hose.inc"
#include "tub.inc"

#declare Keg =
union {
  object { KegBody }
  object { KegTop }
  pigment { 
    bozo color_map {
      [0 0.8 color rgb<0.68,0.68,0.68> color rgb<0.75,0.75,0.75>]
      [1 color rgb<0.75,0.75,0.75>]
    } 
    turbulence 1.5
    scale <50,200,50>
    rotate 20*y
  }
  finish { metallic reflection 0.1 specular 0.5 phong 0.3 }
  translate 98.05*z
  scale 1/250 
}

#declare TapAndHose =
union {
  object { Tap }
  object { Spout }
  object { SpoutHose }
  pigment { rgb<0,0,0> }
  finish { specular 0.6 phong 0.8 }
  translate 98.05*z
  scale 1/250
}

#declare TappedKeg =
union {
  object { Keg }
  object { TapAndHose }
}

#declare KegInTub =
union {
  object { 
    TappedKeg
    rotate 30*z
    rotate -6*y
    rotate -3*x
    scale <1,-1,1>
    translate <-0.0115,0,0.204>
  }
  object { Tub translate 120*z scale 1/250 }
}
