/******************************************************************
 *
 * Midsummers Dawn at Stone Henge
 * Matthew Corey Brown
 * talious@earthlink.net
 *
 ******************************************************************/

#include "colors.inc"

#declare fin=0
#include "stonehenge.inc"
#declare Stars=0.2
#include "space.inc"

global_settings{
	max_trace_level 12
}


camera{
	location <-1.3,1.2,-.8>
	look_at <1.5,0.8,0>
	angle 35

}


//Gorge


#declare Mnt=height_field{
	tga "gorge.tga"
#ifdef (fin)
	smooth
#end
	water_level 0.01
	scale 0.95
	pigment {
		gradient y
		color_map{
			[0 rgb<0.2,0.45,0.1>]
			[0.2 rgb <0.3,0.4,0.2>]
			[1 rgb <0.4,0.3,0.1>]
		}
		turbulence 0.12
	} 
	finish {diffuse 0.9 ambient 0.3}
	scale 1/0.95
	translate<-0.5,-0.01,-0.5>
	scale <65,5.5,8>
	rotate y*70
	translate<30,-3.5,2> 
}

//The River

#declare River=sphere{<0,-40003,0>, 40000
	pigment {rgb<0.3,0.5,0.9>}
	finish {
		diffuse 0.8 
		ambient rgb<0.2,0.2,0.3> 
		reflection 0.4 
		refraction 1 ior 1.4
		specular 0.5
		roughness 0.4
		metallic
	}
	normal{
            average
            normal_map {
                [ ripples 0.15 frequency 3 scale 0.008 translate <0, 0, 10> ]
                [ wrinkles 0.25 scale 0.01  ]
		}
	}
}


//MayHill
#declare Hill=height_field{
	pot "hill.pot"
	water_level 0.01
#ifdef (fin)
	smooth
#end
	translate <-0.5,-0.9875,-0.5>
	scale <4.55,2,4.55>
	pigment {
		bozo
		color_map{
			[0 rgb <0.2,0.9,0>]
			[1 rgb <0.4,0.8,0.1>]
		}
		turbulence 0.1
		scale 1/40
	}
	normal {bumps 0.2 scale 0.02}

}


#declare Monument=union{
	object{Stonehenge scale 1/40}
	object{Hill}
	scale 2
	translate <1.5,0.5,0>
}

//Moon
#declare MoonPos=<32000,2800,7500>

#declare MoonLight=light_source{ 
	MoonPos-<1100,600,1100> color rgb<0.15,0.15,0.25>*2 
	spotlight
	point_at<0,0,0>
	radius 40000
}

#declare Moon=
sphere{
	MoonPos,1000
	texture{ T_Moon1 finish {ambient 0 diffuse 0.8 crand 0.01} 
		scale 1200}
}


//Atmosphere
#declare Atmosphere=
sphere{<0,0.5,0>,0.5
	pigment{gradient y
		color_map{
		[0.25 rgbt<0,0,0,1>] 
                [0.5 rgbt<0.3,0.3,0.3,0.6>]
		[1.0 color red 0.8 green 0.8 blue 1.2 transmit 0.05]
		}
	}
	finish {diffuse 0 ambient 1}
	no_shadow
	translate -0.5*y
	rotate -45*z
	scale 82000
	translate -40003*y
	hollow
}


#declare PClouds=pigment{
	bozo
	turbulence 0.6
	color_map{
		[0.34 Clear]
		[0.63 Gray filter 0.2]
		[1 White]
	}
	scale 1/12
}


//Clouds
#declare Clouds=
sphere{<0,0.5,0>,0.5
	pigment{bozo
		turbulence 0.3 
		pigment_map{
                [0.2 color Clear]
		[0.7 PClouds ]
		}
		scale 1/25
	}
	finish {diffuse 0 ambient 0.8}
	no_shadow
	translate -0.5*y
	scale 81000
	translate -40003*y
	hollow
}



//Sun
light_source{ <-50000,1000,0> color White
	area_light <0,400,0>,<0,0,400>,15,15	adaptive 1 	jitter
}

//Fill light
light_source{ <0,20000,0> color rgb<0.1,0.11,0.12> shadowless}


object{Clouds} 
object{Atmosphere}
object{Mnt}
object{River}
object{Monument}
object{Moon}
//object{MoonLight}

