/*************************************************************************
 *
 * Stonehenge
 * Matthew Corey Brown
 * talious@earthlink.net
 * Go ahead use this file anywhere you want...
 *
 ************************************************************************/


#declare TStone =
texture {
	pigment{
		granite
  		turbulence 0.67
  		color_map{
			[0.000 rgb <0.161, 0.133, 0.118>]
			[0.104 rgb <0.190, 0.182, 0.271>]
			[0.252 rgb <0.161, 0.153, 0.221>]
    			[0.383 rgb <0.000, 0.000, 0.000>]
    			[0.643 rgb <0.161, 0.133, 0.118>]
    			[0.783 rgb <0.220, 0.149, 0.137>]
    			[0.922 rgb <0.000, 0.000, 0.000>]
    			[0.983 rgb <0.220, 0.149, 0.137>]
    			[1.001 rgb <0.161, 0.133, 0.118>]
   		} 
	}
	finish{
		diffuse 0.8 
		ambient rgb <0.5,0.2,0.4>
	} 
	scale 1/2
	rotate y*7
}

texture {
	pigment{
		granite
  		turbulence 0.15
  		color_map{
	[0.0 White   filter 0.0]
    	[0.2 DimGray filter 0.1]
    	[0.3 DimGray filter 0.2]
    	[1.0 DimGray filter 0.3]
   		}
		scale 1/3
 	}
 	finish {
		diffuse 0.8
		ambient rgb<0.1,0.1,0.4>
		specular 0.1
		roughness 0.2
  		crand 0.02
 	}
 	rotate <20,80,10>
	normal{
            average
            normal_map {
                [ dents 1.25 scale 0.08 translate <0, 0, 10> ]
                [ bumps 1.85 scale 0.08 translate <0, 40, 10> ]
                [ wrinkles 1.15 scale 0.01  ]
		}
	}
}             

  

#declare R1=seed(0)

#declare SE=superellipsoid{<0.17,0.15> scale 1/2}

#declare SLeg=
	object{SE scale <2,5,1>}

#declare STop= 
	object{SE scale <4,1,1>}

#declare BLeg=
	object{SE scale <3,6,1.5>}

#declare BTop= 
	object{SE scale <9,2,1.5>}




#declare c=0

#declare Stonehenge=union{

//Outer Ring
#while (c < 30)
	union{
	  object{STop rotate y*360/60 translate <2,4.5,0> 
	    texture{TStone rotate z*90
		translate <rand(R1)*200,rand(R1)*100,rand(R1)*100>}  
	    }
	  object{SLeg translate <0,1.5,0> 
	    texture{TStone translate <rand(R1)*200,rand(R1)*100,rand(R1)*100>}  
	    }
	  translate <0,0,124/6.28>
	  rotate y*360/30*c
	}
	#declare c=c+1
#end


//Inner horseshoe
#declare c=0
#while (c<5)
	#declare c=c+1
	union{
	  object{BLeg translate <-3,3,0>
	    texture{TStone translate <rand(R1)*200,rand(R1)*100,rand(R1)*100>}  
	  }
	  object{BLeg translate <3,3,0>
	    texture{TStone translate <rand(R1)*200,rand(R1)*100,rand(R1)*100>}  
	  }
	  object{BTop translate <0,7,0> 
	    texture{TStone rotate z*90 
		translate <rand(R1)*200,rand(R1)*100,rand(R1)*100>}  
	  }
	#switch (c)
	  #case (1)
		translate <0,0,12>
		rotate 90*y
	  	#break
	  #case (2)
		translate <0,0,12>
		rotate 40*y
	  	#break
	  #case (3)
		translate <0,0,12>
		rotate 140*y
	  	#break
	  #case (4)
		translate <-3,0,12>
	  	#break
	  #case (5)
		translate <-3,0,-12>
	  	#break
	#end
	}
#end	

//Altar Stone
	object{SE scale <4,3,9> translate x*6 texture {TStone}}

//FootStone
	object{SE scale <1,12,1> translate -x*28 texture {TStone}}

}


