#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"


global_settings
{
  assumed_gamma 1.2
}


// Choose 16 colors

#declare col_1  = colour red 0.5 green 0.5 blue 0.5
#declare col_2  = colour red 1.0
#declare col_3  = colour red 1.0 green 1.0
#declare col_4  = colour red 0.2 green 0.7 blue 0.1
#declare col_5  = colour blue 1.0 green 1.0
#declare col_6  = colour blue 1.0
#declare col_7  = colour red 1.0 blue 1.0
#declare col_8  = colour red 0.439216 green 0.858824 blue 0.576471
#declare col_9  = colour red 1.0 green 0.498039 blue 0.0
#declare col_10 = colour red 0.258824 green 0.258824 blue 0.435294
#declare col_11 = colour red 0.6 green 0.196078 blue 0.8
#declare col_12 = colour red 0.439216 green 0.576471 blue 0.858824
#declare col_13 = colour red 0.556863 green 0.137255 blue 0.137255
#declare col_14 = colour red 0.858824 green 0.858824 blue 0.439216
#declare col_15 = colour red 0.623529 green 0.623529 blue 0.372549




#declare Jade_Map =
color_map {
[0.0, 0.8 color rgb <0.1, 0.6, 0.1>
              color rgb <0.0, 0.3, 0.0>]
    [0.8, 1.0 color rgb <0.1, 0.6, 0.1>
              color rgb <0.0, 0.2, 0.0>]

}

#declare TextureL10 = texture {
	pigment {
    marble
    turbulence 1.8
    color_map { Jade_Map }
}
finish { ambient 0.3 diffuse 0.7 }
scale 200
}


#declare Lep_Map =
color_map {
    [0.0, 0.9 color rgb <0.9, 0.1, 0.1>
              color rgb <0.3, 0.0, 0.0>]
    [0.8, 1.0 color rgb <0.9, 0.1, 0.1>
              color rgb <0.2, 0.1, 0.0>]
}

#declare St_Map =
color_map {
            [0.18 colour rgbf <0.29020, 0.24706, 0.00000,0>]
            [0.35 colour rgbf <0.29020, 0.24706, 0.00000,0>]
            [0.45 colour rgbf <0.16471, 0.15294, 0.00000,0>]
            [0.90 colour rgbf <0.16471, 0.15294, 0.00000,0>]
            [1.00 colour rgbf <0.32941, 0.25882, 0.00000,0>]
        }


#declare TextureL1 = texture {
	pigment {
    marble
    turbulence 1.8
    color_map { Lep_Map }
}
finish { ambient 0.3 diffuse 0.7 }
scale 500
}

#declare TextureL2 =
texture  {
    pigment {
        granite
        turbulence 0.9
        colour_map  {St_Map}
        scale <0.825, 1.7, 0.25>
        rotate <10,5,40>
    }
    finish { brilliance 2.5 ambient 0.3 diffuse 0.7 phong 1 }
}
texture  {
    pigment {
        granite
        turbulence 0.85
        colour_map   {
            [0.05 colour rgbf <0.86275, 0.65490, 0.40392, 0.6250>]
            [0.35 colour rgbf <0.48627, 0.16471, 0.00000, 0.8250>]
            [0.60 colour rgbf <0.86275, 0.65490, 0.40392, 0.7150>]
            [0.85 colour rgbf <0.48627, 0.16471, 0.00000, 0.5450>]
            [1.00 colour rgbf <0.52941, 0.34118, 0.17647, 0.8975>]
        }
        scale <0.85, 1.6, 0.45>
        rotate <0,5,-50>
    }
    finish { ambient 0.275 diffuse 0.6925 crand 0.01975}
}

#declare TextureL3 = texture {
    pigment {
        marble
        turbulence 1.5
        omega 0.6235
        lambda 2.25
        colour_map  {
            [0.25 colour rgbf <0.03922, 0.20784, 0.92941, 0.0>]
            [0.45 colour rgbf <0.03922, 0.20784, 0.82941, 0.0>]
            [0.55 colour rgbf <0.22745, 0.23922, 0.52353, 0.0>]
            [0.75 colour rgbf <0.20784, 0.30980, 0.74118, 0.0>]
            [1.00 colour rgbf <0.20784, 0.30980, 0.54118, 0.0>]
        }
        rotate <0, 0, 85>
        scale <0.75, 1.33, 0.35>
        rotate <10, 5, 45>
    }
    finish { brilliance 1.825 }
}
texture  {
    pigment {
        granite
        turbulence  1.15
        colour_map  {
            [0.25 colour rgbf <0.20196, 0.25294, 0.68627, 0.600>]
            [0.45 colour rgbf <0.20196, 0.25294, 0.68627, 0.475>]
            [0.85 colour rgbf <0.17647, 0.24706, 0.69216, 0.715>]
            [1.00 colour rgbf <0.07647, 0.14706, 0.49216, 0.750>]
        }
        rotate <0,0,45>
       scale <0.78, 1.0, 0.4>
       rotate <5, 10, -55>
    }
    finish { ambient 0.225 diffuse 0.75 crand 0.01975}
}


camera {
    location <0,0,-30.5>
    look_at <0,0,0>
    direction <0,0,1.0>
    up <0,1,0>
    right <1.33,0,0>
}


light_source {<0,0,0>
colour Yellow
spotlight
point_at<0,0,0>
radius 10
falloff 15
}



light_source {
   <-30,11,20> color Yellow
}


light_source {
   <31, 12, -20> color rgb <1,1,1>
}

light_source {
   <-1.2,0.9,-32> color Yellow
}

light_source {
   <2,-0.9,32> color Yellow
}

light_source {
   <0,3,-32> color Yellow
}

light_source {
   <-3,-0.9,35> color Yellow
}

light_source {
   <-4,1,35> color Yellow
}




plane {
y,-1.5
texture { T_Stone28  
scale 4 rotate z*30 translate <-30,0,0>}
        normal {
            average
            normal_map {
                [ ripples 10 frequency 6 scale 10. phase 60 translate <0, 0, 10> ]
                [ wrinkles 5 scale 0.100  ]
  }
}
}



plane {
z, 10.5
texture{
  Star_}
}

// Select lbase object

  #declare l_base =
   union {
 object { cylinder { <0, 0, 0> < -0.1,0.4,-0.1 > 0.75 } }
 object { cylinder { <-0.1, 0.4, -0.1 > < 0.17, 0.8, 0.17 > 0.75 } }
 object { cylinder { <0.17, 0.8, 0.17> < 0.05, 1.2, 0.05 > 0.75 } }
 object { cylinder { <0.05, 1.2, 0.05> < 0, 1.5, 0 > 0.75 } }
}

// Textures for l_base object and leafs

#declare t_base = finish { ambient 0.3 diffuse 0.7 phong 1 }
#declare t_leaf = finish { ambient 0.3 diffuse 0.7 }

union{
#include "out1_.inc"
translate <-1100,-10,-180>
scale 0.013
rotate <-70,-50,-15>
}

union{
#include "out2__.inc"
translate <-1400,-800,-6500>
scale 0.0032
  //rotate <0,90,-30>
}

union{
#include "crysta__.inc"
translate <3500,2300,-4700>
scale 0.0034
rotate <-30,31,150>
    //rotate <-70,-50,-15>
}

union{
#include "flo_.inc"
translate <400,-1800,-2000>
scale 0.006
rotate <0,0,30>
}

union{
#include "flo_.inc"
translate <-75,-2800,-2500>
scale 0.0055
rotate <45,30,30>
}



