// ROBOTECH.INC
// Robotech/BattleTech/Manga robot stuff
// By Paul Clegg, 1996.
#declare BTECH_Medium_MG =
// Goes from x=0 to x=1  Radius at x=0 is 0.1
  difference {
    union {
      difference {
        cylinder {
          <0,0,0>,
          <0.9,0,0>,0.1
        }
        union {
          cylinder {
            <0.2,0,-1>,
            <0.2,0,1>,0.05
          }
          cylinder {
            <0.2,1,0>,
            <0.2,-1,0>,0.05
          }
          rotate x*30
        }
        union {
          cylinder {
            <0.4,0,-1>,
            <0.4,0,1>,0.05
          }
          cylinder {
            <0.4,1,0>,
            <0.4,-1,0>,0.05
          }
          rotate x*75
        }
        union {
          cylinder {
            <0.6,0,-1>,
            <0.6,0,1>,0.05
          }
          cylinder {
            <0.6,1,0>,
            <0.6,-1,0>,0.05
          }
          rotate x*30
        }
        union {
          cylinder {
            <0.8,0,-1>,
            <0.8,0,1>,0.05
          }
          cylinder {
            <0.8,1,0>,
            <0.8,-1,0>,0.05
          }
          rotate x*75
        }
      }
      cylinder {
        <0,0,0>,
        <1,0,0>,0.08
      }
    }
    cylinder {
      <0,0,0>,
      <1.1,0,0>,0.06
    }
    texture {
      pigment {
        gradient x
        color_map {
          [0.0, 0.7 color Gray60
                    color Gray60]
          [0.7, 0.95 color Gray60
                     color Gray30]
          [0.95, 1.0 color Gray30
                     color Gray30]
        }
      }
    }
    finish {
      Metal
    }
  }
     
#declare BTECH_Heavy_MG =
// Goes from x=0 to x=1  Radius at x=0 is 0.2
  difference {
    union {
      cylinder {
        <0,0,0>,
        <0.9,0,0>,0.2
      }
      cylinder {
        <0,0,0>,
        <1,0,0>,0.17
      }
    }
    cylinder {
      <0,0,0>,
      <1.1,0,0>,0.13
    }
    texture {
      pigment {
        gradient x
        color_map {
          [0.0, 0.7 color Gray60
                    color Gray60]
          [0.7, 0.95 color Gray60
                     color Gray30]
          [0.95, 1.0 color Gray30
                     color Gray30]
        }
      }
    }
    finish {
      Metal
    }
  }
     

#declare BTECH_SRM_Tip =
// Goes from x=0 to x=0.5  Radius at x=0 is 0.125
  intersection {
    object {
      Paraboloid_X
      rotate y*180
      scale <16,1,1>
      translate <1,0,0>
      texture {
        pigment {
          gradient x
          color_map {
            [0.0, 0.75 color red 1.0 green 1.0 blue 1.0
                       color red 1.0 green 1.0 blue 1.0]
            [0.75, 1.0 color red 1.0 green 0 blue 0
                       color red 1.0 green 0 blue 0]
          }
        }
      }
      scale 0.5
    }
    plane {
      -x,0
    }
  }

#declare BTECH_MRM_Tip =
// Goes from x=0 to x=0.5  Radius at x=0 is 0.2
  intersection {
    object {
      Paraboloid_X
      rotate y*180
      scale <20,1,1>
      translate <1,0,0>
      texture {
        pigment {
          gradient x
          color_map {
            [0.0, 0.75 color red 1.0 green 1.0 blue 1.0
                       color red 1.0 green 1.0 blue 1.0]
            [0.75, 1.0 color red 0 green 0 blue 1
                       color red 0 green 0 blue 1]
          }
        }
      }
      scale 0.5
    }
    plane {
      -x,0
    }
  }

#declare BTECH_Warhammer_PPC =
  merge {
// Exhaust cone
    cone {
      <0,0,0>,0.45,
      <-0.45,0,0>,0.3
      open
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    cone {
      <0,0,0>,0.2,
      <-0.45,0,0>,0.3
      open
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
// Beam casing
    intersection {
      box {
        <0,-0.5,-0.5>,
        <3,0.5,0.5>
      }
      box {
        <-0.1,-0.63,-0.63>
        <3.1,0.63,0.63>
        rotate x * 45
      }
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
// Heat sinks
    box {
      <1.8,-0.4,-0.55>,
      <2.1,0.4,-0.5>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    box {
      <2.2,-0.4,-0.55>,
      <2.5,0.4,-0.5>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    box {
      <2.6,-0.4,-0.55>,
      <2.9,0.4,-0.5>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    box {
      <1.8,-0.4,0.5>,
      <2.1,0.4,0.55>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    box {
      <2.2,-0.4,0.5>,
      <2.5,0.4,0.55>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    box {
      <2.6,-0.4,0.5>,
      <2.9,0.4,0.55>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
// access plate
    box {
      <0.1,-0.35,-0.55>,
      <1.3,0.35,-0.5>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    sphere {
      <0.15, 0.3, -0.55>, 0.025
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    sphere {
      <1.25, 0.3, -0.55>, 0.025
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    sphere {
      <0.15, -0.3, -0.55>, 0.025
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    sphere {
      <1.25, -0.3, -0.55>, 0.025
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    box {
      <1.3,-0.25,-0.52>,
      <1.8,0.25,-0.5>
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
// Barrel
    cylinder {
      <3,0,0>,
      <6.5,0,0>, 0.45
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    cylinder {
      <6.5,0,0>,
      <7.25,0,0>,0.4
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    difference {
      cylinder {
        <7.25,0,0>,
        <8.25,0,0>, 0.45
        texture {
          BTECH_Warhammer_Color_Main
        }
      }
      cone {
        <8.251,0,0>,0.3,
        <6,0,0>,0.1
        texture {
          pigment {
            color Gray30
          }
        }
        finish {
          Metal
        }
      }
    }
  }

#declare BTECH_Warhammer_Gun_Right =
  merge {
    object {
      BTECH_Warhammer_PPC
    }
// Pivot mount attached to PPC cannon.
    difference {
      box {
        <-1.25,-1.2,-0.2>,
        <1.25,1.2,0.2>
        rotate z*25
        translate <1.6,0,0>
      }
      box {
        <0,-2,-0.5>,
        <5,0,0.5>
      }
      box {
        <-1,-1,-0.5>,
        <1,1,0.5>
        rotate z * -10
        translate <2.5,2,0>
      }
      box {
        <0,0,-0.075>,
        <3,5,0.075>
      }
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
  }

#declare BTECH_Warhammer_Gun_Left =
  merge {
    object {
      BTECH_Warhammer_PPC
      rotate x*180
    }
    difference {
      box {
        <-1.25,-1.2,-0.2>,
        <1.25,1.2,0.2>
        rotate z*25
        translate <1.6,0,0>
      }
      box {
        <0,-2,-0.5>,
        <5,0,0.5>
      }
      box {
        <-1,-1,-0.5>,
        <1,1,0.5>
        rotate z * -10
        translate <2.5,2,0>
      }
      box {
        <0,0,-0.075>,
        <3,5,0.075>
      }
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
  }

#declare BTECH_Warhammer_ForeArm_Right =
  merge {
    object {
      BTECH_Warhammer_Gun_Right
      translate <-1.5,-0.75,0>
      rotate z * BTECH_Warhammer_Cannon_Angle_Right
    }
    cylinder {
      <0,0.35,-0.55>,
      <0,0.35,0.55>,0.25
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    difference {
      union {
        cylinder {
          <-0.5,3,0>,
          <0.5,3,0>,0.45
        }
        box {
          <-0.5,0,-0.45>,
          <0.5,3,0.45>
        }
      }
      box {
        <-1,-1,-0.5>,
        <1,1,0.5>
        rotate z* -10
        translate <1.31,0,0>
      }
      box {
        <-1,-1,-0.5>,
        <1,1,0.5>
        rotate z*10
        translate <-1.31,0,0>
      }
      box {
        <-1,-1,-0.2>,
        <1,1,0.2>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    translate <0,-3,0>
  }

#declare BTECH_Warhammer_ForeArm_Left =
  merge {
    object {
      BTECH_Warhammer_Gun_Left
      translate <-1.5,-0.75,0>
      rotate z * BTECH_Warhammer_Cannon_Angle_Left
    }
    cylinder {
      <0,0.35,-0.55>,
      <0,0.35,0.55>,0.25
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    difference {
      union {
        cylinder {
          <-0.5,3,0>,
          <0.5,3,0>,0.45
        }
        box {
          <-0.5,0,-0.45>,
          <0.5,3,0.45>
        }
      }
      box {
        <-1,-1,-0.5>,
        <1,1,0.5>
        rotate z* -10
        translate <1.31,0,0>
      }
      box {
        <-1,-1,-0.5>,
        <1,1,0.5>
        rotate z*10
        translate <-1.31,0,0>
      }
      box {
        <-1,-1,-0.2>,
        <1,1,0.2>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z* -90
      }
    }
    translate <0,-3,0>
  }


#declare BTECH_Warhammer_Shoulder_Mount =
  difference {
    box {
      <-1,-1,-0.5>,
      <1,1,0.5>
    }
    box {
      <-3,0,-3>,
      <3,3,0>
      rotate x* -15
      translate <0,1,0.5>
    }
    box {
      <-3,-3,-3>,
      <3,0,0>
      rotate x* 15
      translate <0,-1,0.5>
    }
    box {
      <-3,0,-3>,
      <3,3,3>
      rotate z * -45
      rotate x * -20
      translate <0.55,1,0.5>
    }
    box {
      <-3,0,-3>,
      <3,3,3>
      rotate z * 45
      rotate x * -20
      translate <-0.55,1,0.5>
    }
    box {
      <-3,-3,-3>,
      <3,0,3>
      rotate z * -45
      rotate x * 20
      translate <-0.55,-1,0.5>
    }
    box {
      <-3,-3,-3>,
      <3,0,3>
      rotate z * 45
      rotate x * 20
      translate <0.55,-1,0.5>
    }
    box {
      <0,-2,-1>,
      <3,2,1>
      rotate y*45
      translate <0.55,0,-0.5>
    }
    box {
      <-3,-2,-1>,
      <0,2,1>
      rotate y*-45
      translate <-0.55,0,-0.5>
    }
    box {
      <0,-2,-1>,
      <3,2,1>
      rotate y*15
      translate <1,0,0.5>
    }
    box {
      <-3,-2,-1>,
      <0,2,1>
      rotate y* -15
      translate <-1,0,0.5>
    }
    box {
      <-0.5,-2,-1>,
      <0.5,0.45,0.5>
    }
    cylinder {
      <-1,0,0>,
      <1,0,0>, 0.15
    }
  }

#declare BTECH_Warhammer_Arm_Right =
  union {
    object {
      BTECH_Warhammer_ForeArm_Right
      rotate x * BTECH_Warhammer_Arm_Angle_Right
    }
    object {
      BTECH_Warhammer_Shoulder_Mount
      texture {
        BTECH_Warhammer_Color_Main
        rotate y*90
      }
    }
    cylinder {
      <0.7,-0.15,0>,
      <0.7,0.15,0>,0.1
      texture {
        BTECH_Warhammer_Color_Bolts
      }
      rotate x * (BTECH_Warhammer_Arm_Angle_Right + 8)
    }
  }

#declare BTECH_Warhammer_Arm_Left =
  union {
    object {
      BTECH_Warhammer_ForeArm_Left
      rotate x * -BTECH_Warhammer_Arm_Angle_Left
    }
    object {
      BTECH_Warhammer_Shoulder_Mount
      rotate y*180
      texture {
        BTECH_Warhammer_Color_Main
        rotate y*90
      }
    }
    cylinder {
      <0.7,-0.15,0>,
      <0.7,0.15,0>,0.1
      texture {
        BTECH_Warhammer_Color_Bolts
      }
      rotate x * -(BTECH_Warhammer_Arm_Angle_Left + 18)
    }
  }

#declare BTECH_Warhammer_Missile_Cover =
  difference {
    union {
      box {
        <-0.75,-1.56,0>,
        <2.5,1.5,0.75>
      }
      cylinder {
        <-0.75,1.25,0>,
        <-0.75,1.25,0.75>, 0.25
      }
      texture {
        BTECH_Warhammer_Color_Missile_Covers
        rotate z*135
      }
    }
    box {
      <-0.25,0,0.2>,
      <1.1,1.25,0.55>
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    intersection {
      box {
        <-3,-1.6,-0.1>,
        <1.5,1.0,0.8>
      }
      box {
        <-8,-8,-0.1>,
        <0,8,1>
        rotate z* 30
        translate <0.6,1,0>
      }
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    box {
      <0,-8,-1>,
      <8,8,1>
      rotate z* 30
      translate <1.1,1.5,0>
      texture {
        BTECH_Warhammer_Color_Missile_Covers
        rotate z*135
      }
    }
    box {
      <0,-4,-1>,
      <4,4,1>
      rotate z* -30
      translate <2.5,-1,0>
      texture {
        BTECH_Warhammer_Color_Missile_Covers
        rotate z*135
      }
    }
    box {
      <1.4,-0.5,0.1>,
      <1.9,-2,0.65>
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    box {
      <-0.01,0,0.1>,
      <0.3,1.8,0.65>
      rotate z* 30
      translate <1.9,-0.56,0>
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    translate <0,0,-0.375>
  }


#declare BTECH_Warhammer_Torso_Left =
  union {
    object {
      BTECH_Warhammer_Arm_Left
      rotate z * BTECH_Warhammer_Shoulder_Angle_Left
      translate <0,0,0.6>
    }
    object {
      BTECH_Warhammer_Missile_Cover
      translate <0,0,-0.375>
      translate <0.75,-1.25,0>
      rotate z * 65 * (BTECH_Warhammer_Cover_Angle_Left/100)
      translate <-0.75,1.25,0>
    }
    intersection {
      merge {
        cylinder {
          <-0.75,0,0>,
          <0,0,0>, 0.15
          texture {
            pigment {
              gradient x
              color_map {
                [0.0, 0.7 color Gray30
                          color Gray30]
                [0.7, 0.95 color Gray30
                           color Gray60]
                [0.95, 1.0 color Gray60
                           color Gray60]
              }
              scale <0.75,1,1>
              translate <-0.75,0,0>
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,0,0>,
          <-0.5,0,0>, 0.1
          texture {
            pigment {
              color Gray80
            }
          }
          finish {
            Metal
          }
        }
        rotate z * -75 * (BTECH_Warhammer_Cover_Angle_Left/100)
        translate <0.45,1,-0.375>
      }
      plane {
        y,0
        rotate z * 65 * (BTECH_Warhammer_Cover_Angle_Left/100)
        translate <-0.75,1,0>
      }
    }
    difference {
      box {
        <-1,-3,-0.75>,
        <1.7,1,0.1>
      }
      box {
        <0,0,-1>,
        <3,3,0>
        rotate z* -60
        translate <0.6,1,0>
      }
      box {
        <0,0,-1>,
        <3,3,1>
        rotate z* -60
        translate <0.7,1.1,0>
      }
      box {
        <1.5,-3,-1>,
        <2,2,0>
      }
      box {
        <-3,-1,0>,
        <2,0,2>
        rotate x* -30
        translate <0,-3,-0.75>
      }
      box {
        <-3,-3,-1>,
        <0,-2,1>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    box {
      <1.5,-1.56,-0.7>,
      <1.55,-0.56,-0.05>
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-0.89,-0.25>
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-0.89,-0.5>
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-1.22,-0.25>
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-1.22,-0.5>
    }
    union {
      object {
        BTECH_SRM_Tip
        translate <0.05,0.45,-0.25>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,0.45,-0.5>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,0.9,-0.25>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,0.9,-0.5>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,1.35,-0.25>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,1.35,-0.5>
      }
      box {
        <0,0,-0.7>,
        <0.05,1.8,-0.05>
        texture {
          BTECH_Warhammer_Color_Bolts
        }
      }
      rotate z*30
      translate <1.5,-0.56,0>
    }
    object {
      BTECH_Heavy_MG
      translate <1,-1.9,-0.25>
    }
    object {
      BTECH_Medium_MG
      translate <1,-1.9,-0.6>
    }
    object {
      BTECH_Medium_MG
      translate <1,-2.4,-0.25>
    }
    object {
      BTECH_Medium_MG
      translate <1,-2.4,-0.6>
    }
  }

#declare BTECH_Warhammer_Torso_Right =
  union {
    object {
      BTECH_Warhammer_Arm_Right
      rotate z * BTECH_Warhammer_Shoulder_Angle_Right
      translate <0,0,-0.6>
    }
    object {
      BTECH_Warhammer_Missile_Cover
      translate <0,0,0.375>
      translate <0.75,-1.25,0>
      rotate z * 65 * (BTECH_Warhammer_Cover_Angle_Right/100)
      translate <-0.75,1.25,0>
    }
    intersection {
      union {
        cylinder {
          <-0.75,0,0>,
          <0,0,0>, 0.15
          texture {
            pigment {
              gradient x
              color_map {
                [0.0, 0.7 color Gray30
                          color Gray30]
                [0.7, 0.95 color Gray30
                           color Gray60]
                [0.95, 1.0 color Gray60
                           color Gray60]
              }
              scale <0.75,1,1>
              translate <-0.75,0,0>
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,0,0>,
          <-0.5,0,0>, 0.1
          texture {
            pigment {
              color Gray80
            }
          }
          finish {
            Metal
          }
        }
        rotate z * -75 * (BTECH_Warhammer_Cover_Angle_Right/100)
        translate <0.45,1,0.375>
      }
      plane {
        y,0
        rotate z * 65 * (BTECH_Warhammer_Cover_Angle_Right/100)
        translate <-0.75,1.25,0>
      }
    }
    difference {
      box {
        <-1,-3,-0.1>,
        <1.7,1,0.75>
      }
      box {
        <0,0,0>,
        <3,3,1>
        rotate z* -60
        translate <0.6,1,0>
      }
      box {
        <0,0,-1>,
        <3,3,1>
        rotate z* -60
        translate <0.7,1.1,0>
      }
      box {
        <1.5,-3,0>,
        <2,2,1>
      }
      box {
        <-3,-1,-2>,
        <2,0,0>
        rotate x* 30
        translate <0,-3,0.75>
      }
      box {
        <-3,-3,-1>,
        <0,-2,1>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-0.89,0.25>
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-0.89,0.5>
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-1.22,0.25>
    }
    object {
      BTECH_SRM_Tip
      translate <1.55,-1.22,0.5>
    }
    box {
      <1.5,-1.56,0.05>,
      <1.55,-0.56,0.7>
      texture {
        BTECH_Warhammer_Color_Bolts
      }
    }
    union {
      object {
        BTECH_SRM_Tip
        translate <0.05,0.45,0.25>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,0.45,0.5>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,0.9,0.25>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,0.9,0.5>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,1.35,0.25>
      }
      object {
        BTECH_SRM_Tip
        translate <0.05,1.35,0.5>
      }
      box {
        <0,0,0.05>,
        <0.05,1.8,0.7>
        texture {
          BTECH_Warhammer_Color_Bolts
        }
      }
      rotate z*30
      translate <1.5,-0.56,0>
    }
    object {
      BTECH_Heavy_MG
      translate <1,-1.9,0.25>
    }
    object {
      BTECH_Medium_MG
      translate <1,-1.9,0.6>
    }
    object {
      BTECH_Medium_MG
      translate <1,-2.4,0.25>
    }
    object {
      BTECH_Medium_MG
      translate <1,-2.4,0.6>
    }
  }

// Cockpit area:  <1.8,-0.2,0> to <1.8,0.15,0>, radius 0.4
#declare BTECH_Warhammer_Cockpit =
  union {
    cylinder {
      <1.8,-0.2,0>,
      <1.8,0.15,0>, 0.4
      texture {
        pigment {
          color red 1 green 0.4 blue 0.5 filter 0.7
        }
      }
      finish {
        reflection 0.2
        refraction 1
        ior 1.5
        phong 30
      }
    }
    intersection {
      cylinder {
        <1.8,-2,0>,
        <1.8,0.15,0>, 0.39
        texture {
          pigment {
            color Gray70
          }
        }
        finish {
          Metal
          ambient 0.3
        }
      }
      plane {
        x,1.7
      }
    }
/*    sphere {
      <1.8,0,0>, 0.15
      texture {
        pigment {
          color red 1 green 1 blue 1
        }
      }
      finish {
        ambient 0.4
      }
    }
    light_source {
      <2.19,-0.19,0>
      color red 1 green 0.7 blue 0.7
    }*/
  }

#declare BTECH_Warhammer_Rocket_Cap =
  merge {
    difference {
      box {
        <0,-0.25,-0.25>,
        <0.2,0.25,0.25>
      }
      box {
        <0,-2,0>,
        <1,2,2>
        rotate y*30
        translate <0,0,0.25>
      }
      box {
        <0,-2,-2>,
        <1,2,0>
        rotate y* -30
        translate <0,0,-0.25>
      }
      box {
        <-2,0,-2>,
        <2,2,2>
        rotate z* -30
        translate <0,0.25,0>
      }
      box {
        <-2,-2,-2>,
        <2,0,2>
        rotate z*30
        translate <0,-0.25,0>
      }
    }
    difference {
      cylinder {
        <-0.02,0,0>,
        <0,0,0>,0.2
      }
      cylinder {
        <-0.03,0,0>,
        <0,0,0>,0.1
      }
    }
    box {
      <0,-0.125,-0.4>,
      <0.1,0.125,0>
    }
    cylinder {
      <0.05,-0.125,-0.4>,
      <0.05,0.125,-0.4>,0.05
    }
  }

#declare BTECH_Warhammer_Backpack_Mount_Right =
// Six MRM pack included.
  union {
    // Mount point
    union {
      difference {
        box {
          <-2,-1,-2.8>,
          <-1.2,1.4,-2.1>
        }
        box {
          <-4,-4,-4>,
          <4,0,4>
          rotate x*15
          translate <-2,-1,-2.1>
        }
        box {
          <-4,0,-4>,
          <4,4,4>
          rotate x* -30
          translate <-2,1.4,-2.1>
        }
        box {
          <0,-4,-2>,
          <0.6,0,0>
          rotate x* 10
          translate <-1.9,0.968,-2.7>
        }
        box {
          <0,-4,-2>,
          <0.6,0,0>
          rotate x* 10
          translate <-1.9,0.315,-2.7>
        }
        box {
          <0,-4,-2>,
          <0.6,0,0>
          rotate x* 10
          translate <-1.9,-0.32,-2.7>
        }
      }
      intersection {
        box {
          <0,-0.5,-2>,
          <0.5,0,0>
          rotate x*45
          translate <-1.8,1.3,-2.1>
        }
        plane {
          y, 1.8
        }
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    // rocket pack
    union {
      difference {
        intersection {
          box {
            <-2.5,1.8,-3.5>,
            <-1,3.6,-2.25>
          }
          box {
            <-4,0,-4>,
            <4,2.125,4>
            rotate x* -45
            translate <-1,1.8,-2.3>
          }
          box {
            <-4,0,-4>,
            <4,2.125,4>
            rotate x*45
            translate <-1,1.8,-3.45>
          }
          texture {
            BTECH_Warhammer_Color_Main
            rotate z*90
          }
        }
        cylinder {
          <-2,3.25,-3.15>,
          <0,3.25,-3.15>,0.2
          texture {
            pigment {
              color Gray30
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,3.25,-2.6>,
          <0,3.25,-2.6>,0.2
          texture {
            pigment {
              color Gray30
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,2.7,-3.15>,
          <0,2.7,-3.15>,0.2
          texture {
            pigment {
              color Gray30
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,2.7,-2.6>,
          <0,2.7,-2.6>,0.2
          texture {
            pigment {
              color Gray30
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,2.15,-3.15>,
          <0,2.15,-3.15>,0.2
          texture {
            pigment {
              color Gray30
            }
          }
          finish {
            Metal
          }
        }
        cylinder {
          <-2,2.15,-2.6>,
          <0,2.15,-2.6>,0.2
          texture {
            pigment {
              color Gray30
            }
          }
          finish {
            Metal
          }
        }
      }
      difference {
        union {
          box {
            <-2.25,2.275,-2.25>,
            <-0.9,2.575,-2.15>
          }
          box {
            <-2.25,2.825,-2.25>,
            <-0.9,3.125,-2.15>
          }
          box {
            <-2.25,2.275,-3.6>,
            <-0.9,2.575,-3.5>
          }
          box {
            <-2.25,2.825,-3.6>,
            <-0.9,3.125,-3.5>
          }
        }
        box {
          <0,-4,-2>,
          <4,4,0>
          rotate y*30
          translate <-2.25,2.5,-3.5>
        }
        box {
          <0,-4,0>,
          <4,4,2>
          rotate y* -30
          translate <-2.25,2.5,-2.25>
        }
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
      }
      object {
        BTECH_MRM_Tip
        translate <-1.5,3.25,-3.15>
      }
      object {
        BTECH_Warhammer_Rocket_Cap
        translate <-1,3.25,-3.15>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
        translate <0.95,-3.25,3.55>
        rotate y* 90 * (BTECH_Warhammer_Rocket_1_Angle/100)
        translate <-0.95,3.25,-3.55>
      }    
      object {
        BTECH_MRM_Tip
        translate <-1.5,3.25,-2.6>
      }
      object {
        BTECH_Warhammer_Rocket_Cap
        rotate x*180
        translate <-1,3.25,-2.6>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
        translate <0.95,-3.25,2.2>
        rotate y* -90 * (BTECH_Warhammer_Rocket_2_Angle/100)
        translate <-0.95,3.25,-2.2>
      }    
      object {
        BTECH_MRM_Tip
        translate <-1.5,2.7,-3.15>
      }
      object {
        BTECH_Warhammer_Rocket_Cap
        translate <-1,2.7,-3.15>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
        translate <0.95,-2.7,3.55>
        rotate y* 90 * (BTECH_Warhammer_Rocket_3_Angle/100)
        translate <-0.95,2.7,-3.55>
      }    
      object {
        BTECH_MRM_Tip
        translate <-1.5,2.7,-2.6>
      }
      object {
        BTECH_Warhammer_Rocket_Cap
        rotate x*180
        translate <-1,2.7,-2.6>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
        translate <0.95,-2.7,2.2>
        rotate y* -90 * (BTECH_Warhammer_Rocket_4_Angle/100)
        translate <-0.95,2.7,-2.2>
      }    
      object {
        BTECH_MRM_Tip
        translate <-1.5,2.15,-3.15>
      }
      object {
        BTECH_Warhammer_Rocket_Cap
        translate <-1,2.15,-3.15>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
        translate <0.95,-2.15,3.55>
        rotate y* 90 * (BTECH_Warhammer_Rocket_5_Angle/100)
        translate <-0.95,2.15,-3.55>
      }    
      object {
        BTECH_MRM_Tip
        translate <-1.5,2.15,-2.6>
      }
      object {
        BTECH_Warhammer_Rocket_Cap
        rotate x*180
        translate <-1,2.15,-2.6>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
        translate <0.95,-2.15,2.2>
        rotate y* -90 * (BTECH_Warhammer_Rocket_6_Angle/100)
        translate <-0.95,2.15,-2.2>
      }    
    }
  }

#declare BTECH_Warhammer_Backpack_Mount_Left =
  union {
    difference {
      box {
        <-2,-1,2.3>,
        <-1.2,1.4,3.0>
      }
      box {
        <-4,-4,-4>,
        <4,0,4>
        rotate x* -15
        translate <-2,-1,2.3>
      }
      box {
        <-4,0,-4>,
        <4,4,4>
        rotate x* 30
        translate <-2,1.4,2.3>
      }
      box {
        <0,-4,0>,
        <0.6,0,2>
        rotate x* -10
        translate <-1.9,0.968,2.9>
      }
      box {
        <0,-4,0>,
        <0.6,0,2>
        rotate x* -10
        translate <-1.9,0.315,2.9>
      }
      box {
        <0,-4,0>,
        <0.6,0,2>
        rotate x* -10
        translate <-1.9,-0.32,2.9>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    intersection {
      box {
        <0,-0.5,0>,
        <0.5,0,2>
        rotate x* -45
        translate <-1.8,1.3,2.3>
      }
      plane {
        y, 1.8
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    // Spotlight pack
    union {
      difference {
        intersection {
          box {
            <-2.25,1.8,2.25>,
            <-1,2.9,3.75>
          }
          box {
            <-4,0,-4>,
            <4,4,4>
            rotate x * 45
            translate <-1.5,1.8,2.2>
          }
          box {
            <-4,0,-4>,
            <4,4,4>
            rotate x * -45
            translate <-1.5,1.8,3.7>
          }
        }
        box {
          <-2,1.9,2.4>,
          <0,2.8,3.6>
        }
        box {
          <-2,1.95,2.35>,
          <0,2.75,3.65>
        }
        cylinder {
          <-2,1.95,2.4>,
          <0,1.95,2.4>, 0.05
        }
        cylinder {
          <-2,1.95,3.6>,
          <0,1.95,3.6>, 0.05
        }
        cylinder {
          <-2,2.75,2.4>,
          <0,2.75,2.4>, 0.05
        }
        cylinder {
          <-2,2.75,3.6>,
          <0,2.75,3.6>, 0.05
        }
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
      }
      intersection {
        merge {
          box {
            <-1.99,1.9,2.4>,
            <0,2.8,3.6>
          }
          box {
            <-1.99,1.95,2.35>,
            <0,2.75,3.65>
          }
          cylinder {
            <-1.99,1.95,2.4>,
            <0,1.95,2.4>, 0.05
          }
          cylinder {
            <-1.99,1.95,3.6>,
            <0,1.95,3.6>, 0.05
          }
          cylinder {
            <-1.99,2.75,2.4>,
            <0,2.75,2.4>, 0.05
          }
          cylinder {
            <-1.99,2.75,3.6>,
            <0,2.75,3.6>, 0.05
          }
          texture {
            pigment {
              Gray70
            }
            finish {
              Metal
            }
          }
        }
        plane {
          x, -1.1
          texture {
            pigment {
              color Clear
            }
            finish {
              ambient 0
              diffuse 0
              reflection 0.5
              refraction 0.85
              ior 1.5
              phong 0.3
              phong_size 60
            }
          }
        }
      }
    } 
  }

#declare BTECH_Warhammer_Rocket_Exhaust =
  union {
    difference {
      box {
        <-1.15,-1,-0.8>,
        <0,0,0.8>
        texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
        }
      }
      box {
        <-2,-2,-2>,
        <0,0,2>
        rotate z * -30
        translate <0,-1,0>
      }
      box {
        <-1.05,-2,-0.7>,
        <-0.1,-0.1,0.7>
        texture {
          pigment {
            gradient y
            color_map {
              [0.0, 0.7 color Gray60
                        color Gray60]
              [0.7, 0.95 color Gray60
                         color Gray30]
              [0.95, 1.0 color Gray30
                         color Gray30]
            }
            rotate x*180
          }
        }
        finish {
          Metal
        }
      }
    }
    difference {
      cylinder {
        <-0.575,-0.1,-0.35>,
        <-0.575,-0.3,-0.35>, 0.3
      }
      cylinder {
        <-0.575,0,-0.35>,
        <-0.575,-0.4,-0.35>, 0.2
      }
      texture {
        pigment {
          Gray30
        }
      }
      finish {
        Metal
      }
    }
    difference {
      cylinder {
        <-0.575,-0.1,0.35>,
        <-0.575,-0.3,0.35>, 0.3
      }
      cylinder {
        <-0.575,0,0.35>,
        <-0.575,-0.4,0.35>, 0.2
      }
      texture {
        pigment {
          Gray30
        }
      }
      finish {
        Metal
      }
    }
    rotate z* -30
  }

#declare BTECH_Warhammer_Backpack =
  union {
    difference {
      box {
        <-2,-2.5,-2.1>
        <-1,2.6,2.1>
      }
      box {
        <-4,0,0>,
        <4,4,4>
        rotate x* -45
        translate <0,1.5,1.7>
      }
      box {
        <-4,0,0>,
        <4,4,4>
        translate <0,1.5,1.7>
      }
      box {
        <-4,0,-4>,
        <4,4,0>
        rotate x* 45
        translate <0,1.5,-1.7>
      }
      box {
        <-4,0,-4>,
        <4,4,0>
        translate <0,1.5,-1.7>
      }
      box {
        <-4,-4,-4>,
        <0,4,4>
        rotate z* 60
        translate <-1,-2,0>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    difference {
      box {
        <-1,1,-2.1>,
        <-0.25,1.5,-2.0>
      }
      box {
        <0,-2,-2>,
        <2,2,2>
        rotate z*30
        translate <-0.25,1,-2.05>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    difference {
      box {
        <-1,1,2.0>,
        <-0.25,1.5,2.1>
      }
      box {
        <0,-2,-2>,
        <2,2,2>
        rotate z*30
        translate <-0.25,1,2.05>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    object {
      BTECH_Warhammer_Backpack_Mount_Right
    }
    object {
      BTECH_Warhammer_Backpack_Mount_Left
    }
    object {
      BTECH_Warhammer_Rocket_Exhaust
      translate <-1,-2,-1.25>
    }
    object {
      BTECH_Warhammer_Rocket_Exhaust
      translate <-1,-2,1.25>
    }
  }

#declare BTECH_Warhammer_Torso =
  union {
    object {
      BTECH_Warhammer_Backpack
    }
    object {
      BTECH_Warhammer_Torso_Right
      translate <0,0,-2>
    }
    object {
      BTECH_Warhammer_Torso_Left
      translate <0,0,2>
    }
    difference {
      box {
        <-1,-3,-1.25>,
        <3,3,1.25>
      }
      box {
        <-4,-4,-4>,
        <0,-2,4>
      }
      box {
        <0,-8,-4>,
        <8,8,4>
        rotate z* -45
        translate <3,-1.7,0>
      }
      box {
        <0,-4,-4>,
        <4,4,4>
        rotate z*10
        translate <3,-1.7,0>
      }
      box {
        <-8,-8,0>,
        <8,8,8>
        rotate y* 20
        translate <1.25,0,1.25>
      }
      box {
        <-8,-8,-8>,
        <8,8,0>
        rotate y* -20
        translate <1.25,0,-1.25>
      }
      box {
        <0,-8,-4>,
        <8,8,4>
        rotate z*60
        translate <2.75,-0.7,0>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    difference {
      box {
        <-1,0,-1.25>,
        <0.7,3,1.25>
      }
      box {
        <-4,0,-4>,
        <4,4,4>
        rotate z* -30
        translate <-2,3,0>
      }
      box {
        <-4,0,-4>,
        <4,4,4>
        rotate x* 45
        rotate z* -30
        rotate y* 5
        translate <-2,3,0.7>
      }
      box {
        <-4,0,-4>,
        <4,4,4>
        rotate x* -45
        rotate z* -30
        rotate y* -5
        translate <-2,3,-0.7>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    // Cockpit Box:
    difference {
      box {
        <0.6,-0.5,-1.1>,
        <2.25,2,1.1>
      }
      box {
        <-4,0,-4>,
        <4,4,4>
        rotate z* -30
        translate <0.6,1.44,0>
      }
      box {
        <-4,-4,0>,
        <4,4,4>
        rotate y*20
        translate <0.6,0,1.1>
      }
      box {
        <-4,-4,-4>,
        <4,4,0>
        rotate y* -20
        translate <0.6,0,-1.1>
      }
      box {
        <-14,0,-4>,
        <14,4,4>
        rotate x* 45
        rotate z* -30
        rotate y* 5
        translate <-2,3,0.6>
      }
      box {
        <-14,0,-4>,
        <14,4,4>
        rotate x* -45
        rotate z* -30
        rotate y* -5
        translate <-2,3,-0.6>
      }
      box {
        <-4,0,0>,
        <4,4,4>
        rotate z* -20
        translate <0.6,1,0.3>
      }
      box {
        <-4,0,-0.2>,
        <4,4,0.2>
        rotate z* -20
        translate <0.6,1,0>
      }
      box {
        <-4,0,-4>,
        <4,4,0>
        rotate z* -20
        translate <0.6,1,-0.3>
      }
      difference {
        box {
          <1,-0.25,-1>,
          <3,0.1,1>
        }
        box {
          <-4,-4,-4>,
          <4,0,4>
          rotate z* -30
          translate <2.25,-0.25,0>
        }
      }
      // cockpit area:  <1.8,-0.2,0> to <1.8,0.15,0>, radius 0.4
      cylinder {
        <0,-0.35,0>,
        <0,0,0>, 0.4
        translate <1.8,0.15,0>
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    object {
      BTECH_Warhammer_Cockpit
    }
    object {
      BTECH_Medium_MG
      translate <1.2,0.7,0.6>
    }
    object {
      BTECH_Medium_MG
      translate <1.2,0.7,-0.6>
    }
    intersection {
      cone {
        <0,-2,0>,1,
        <0,-3,0>,0.75
        scale <1,1,1.25>
      }
      plane {
        x, 0
      }
      plane {
        y, 0
        rotate z*180
        rotate z* -45
        translate <-0.35,-3,0>
      }
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    intersection {
      cone {
        <0,-2,0>,0.9,
        <0,-3,0>,0.6
        scale <1,1,1.25>
      }
      plane {
        x, 0
      }
      texture {
        BTECH_Warhammer_Color_Main
      }
    }
    translate <0,3,0>
  }

#declare BTECH_Warhammer_Waist =
  merge {
    cone {
      <0,0,0>,1.5,
      <0,-0.1,0>,1.6
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    intersection {
      intersection {
        union {
          cone {
            <0,-0.1,0>,1.6,
            <0,-0.4,0>,2.0
          }
          box {
            <0,-1,-0.25>,
            <3,0,0.25>
          }
          box {
            <0,-1,-0.25>,
            <3,0,0.25>
            rotate y*30
          }
          box {
            <0,-1,-0.25>,
            <3,0,0.25>
            rotate y* -30
          }
        }
        cone {
          <0,-0.1,0>,1.6,
          <0,-0.4,0>,2.2
        }
      }
      plane {
        -x, 1.4
      }
      texture {
        BTECH_Warhammer_Color_Main
        rotate z*90
      }
    }
    intersection {
      difference {
        merge {
          cylinder {
            <0,-0.4,0>,
            <0,-2.5,0>, 2.2
          }
          cone {
            <0,-2.5,0>, 2.2,
            <0,-2.7,0>, 2.0
          }
        }
        box {
          <-3,-3,0.75>,
          <3,-1.25,3>
        }
        box {
          <-3,-3,-3>,
          <3,-1.25,-0.75>
        }  
        box {
          <-3,-3,0>,
          <3,0,3>
          rotate x * -15
          translate <0,-1.25,0.75>
        }
        box {
          <-3,-3,-3>,
          <3,0,0>
          rotate x * 15
          translate <0,-1.25,-0.75>
        }
        cylinder {
          <0,0,0>,
          <1,0,0>, 0.15
          translate <2.15,0,0>
          rotate y*20
          translate <0,-0.8,0>
        }
        cylinder {
          <0,0,0>,
          <1,0,0>, 0.15
          translate <2.15,0,0>
          rotate y* -20
          translate <0,-0.8,0>
        }
      }
      plane {
        -x, 1.4
      }
      texture {
          BTECH_Warhammer_Color_Main
          rotate z*90
      }
    }
  }


      
