#version 2.0
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
  location <0, 2, -10>
  look_at <0,1,0>
}

/*light_source {
  <0,5,-5>
  color red 1 green 1 blue 1
}*/
// Sun source
light_source {
  <500, 1000, -1000>
  color red 1 green 1 blue 1
}
light_source {
  <501, 1000, -999>
  color red 1 green 1 blue 1
}
light_source {
  <500.5, 1001, -999.5>
  color red 1 green 1 blue 1
}

/*light_source {
  <5,5,-10>
  color red 1 green 1 blue 1
}

light_source {
  <-10,10,-10>
  color red 1 green 1 blue 1
} */

#declare BTECH_Warhammer_Color_Bolts =
  texture {
    pigment {
        color red 0.5 green 0.4 blue 0.1
    }
  }
  texture {
    pigment {
      leopard
      color_map {
        [0.0, 0.5 color red 1.0 green 1.0 blue 1.0 filter 1.0
                  color red 1.0 green 1.0 blue 1.0 filter 1.0]
        [0.5, 1.0 color red 0.3 green 0.2 blue 0.1 filter 1.0
                  color red 0.3 green 0.2 blue 0.1 filter 0.0]
      }
      turbulence 0.6
    }
    scale 0.25
  }

#declare BTECH_Warhammer_Color_Main =
  texture {
    pigment {
      marble
      color_map {
        [0.0, 0.2 color red 0.1 green 0.1 blue 0.0
                  color red 0.1 green 0.1 blue 0.0]
        [0.2, 0.20001 color red 0.1 green 0.1 blue 0.0
                      color red 0.5 green 0.4 blue 0.1]
        [0.20001, 1.0 color red 0.5 green 0.4 blue 0.1
                      color red 0.6 green 0.5 blue 0.3]
      }
      turbulence 0.3
    }
  }
  texture {
    pigment {
      leopard
      color_map {
        [0.0, 0.3 color red 1.0 green 1.0 blue 1.0 filter 1.0
                  color red 1.0 green 1.0 blue 1.0 filter 1.0]
        [0.3, 1.0 color red 0.3 green 0.2 blue 0.1 filter 1.0
                  color red 0.3 green 0.2 blue 0.1 filter 0.0]
      }
      turbulence 0.6
    }
    scale 0.25
  }

#declare BTECH_Warhammer_Color_Missile_Covers =
  texture {
    pigment {
      checker
        color red 0.1 green 0.1 blue 0.0
        color red 0.5 green 0.4 blue 0.1
    }
    scale 0.5
    rotate x*45
  }
  texture {
    pigment {
      leopard
      color_map {
        [0.0, 0.3 color red 1.0 green 1.0 blue 1.0 filter 1.0
                  color red 1.0 green 1.0 blue 1.0 filter 1.0]
        [0.3, 1.0 color red 0.3 green 0.2 blue 0.1 filter 1.0
                  color red 0.3 green 0.2 blue 0.1 filter 0.0]
      }
      turbulence 0.6
    }
    scale 0.25
  }


#declare BTECH_Warhammer_Cannon_Angle_Right = 10
#declare BTECH_Warhammer_Cannon_Angle_Left = 20
#declare BTECH_Warhammer_Arm_Angle_Right = 20
#declare BTECH_Warhammer_Arm_Angle_Left = 40
#declare BTECH_Warhammer_Shoulder_Angle_Right = -10
#declare BTECH_Warhammer_Shoulder_Angle_Left = -20
#declare BTECH_Warhammer_Cover_Angle_Right = 100
#declare BTECH_Warhammer_Cover_Angle_Left = 0
#declare BTECH_Warhammer_Rocket_1_Angle = 0
#declare BTECH_Warhammer_Rocket_2_Angle = 0
#declare BTECH_Warhammer_Rocket_3_Angle = 0
#declare BTECH_Warhammer_Rocket_4_Angle = 0
#declare BTECH_Warhammer_Rocket_5_Angle = 0
#declare BTECH_Warhammer_Rocket_6_Angle = 100
#include "summer.inc"

merge {
  object {
    BTECH_Warhammer_Torso
  }
  object {
    BTECH_Warhammer_Waist
  }
  rotate z * 30
  rotate x * -30
  rotate y * 25
  translate <0.5,-0.25,0>
  finish {
    Dull
  }
}

#declare BTECH_Warhammer_Cannon_Angle_Right = -10
#declare BTECH_Warhammer_Cannon_Angle_Left = 20
#declare BTECH_Warhammer_Arm_Angle_Right = 45
#declare BTECH_Warhammer_Arm_Angle_Left = 40
#declare BTECH_Warhammer_Shoulder_Angle_Right = 10
#declare BTECH_Warhammer_Shoulder_Angle_Left = -20
#declare BTECH_Warhammer_Cover_Angle_Right = 100
#declare BTECH_Warhammer_Cover_Angle_Left = 0
#declare BTECH_Warhammer_Rocket_1_Angle = 0
#declare BTECH_Warhammer_Rocket_2_Angle = 0
#declare BTECH_Warhammer_Rocket_3_Angle = 0
#declare BTECH_Warhammer_Rocket_4_Angle = 0
#declare BTECH_Warhammer_Rocket_5_Angle = 0
#declare BTECH_Warhammer_Rocket_6_Angle = 100
#include "summer.inc"

object {
  BTECH_Warhammer_Arm_Right
  rotate x * 35
  rotate z * 5
  rotate y * 70
  translate <14,-0.25,16>
}


// Sand
object {
  height_field {
    tga "\povray\sand.tga"
    smooth
  }
  scale <250,2,250>
  translate <-125,-2,-125>
  texture {
    pigment {
      color red 0.6 green 0.5 blue 0.3
    }
  }
}

// Sky
sphere {
  <0,0,0>,500
  pigment {
    gradient <0,1,0>
    color_map {
      [0,0.4 color red 0.95 green 0.95 blue 1.0
             color red 0.7 green 0.7 blue 1.0]
      [0.4,1 color red 0.7 green 0.7 blue 1.0
             color red 0.5 green 0.5 blue 1.0]
    }
    scale <500,500,500>
  }
  finish {
    ambient 1.0 //0.6
    diffuse 0
  }
  scale <1,0.25,1>
  no_shadow
}


