/***************************************************************************/
//		bridge.inc
/***************************************************************************/
#declare Bridge_Plank_Texture =
texture{
  pigment{
    wood
    ramp_wave
    color_map{
      [0.0 (LightWood+Gold*3.5+White*1.25)/4.5]
      [0.4 (LightWood+Gold*3.5+White*1.25)/4.5]
      [0.9 (LightWood+Gold*3.5+White*1.25)/5.5]
      [1.0 (LightWood+Gold*3.5+White*1.25)/4.5]
    }
    turbulence 0.2
    warp{
      black_hole
      0, 0.5
      strength 3.5
      repeat <1.5,1.5,2>
      turbulence 0.5
      inverse
    }
    scale <0.15,0.15,1>
  }
  normal{
    bumps 0.25
    scale <0.1,0.1,2>
    turbulence 0.5
    omega 0.65
    lambda 4
  }
  scale 2
}
#declare Log_Texture =
texture{
  pigment{
    wood
    ramp_wave
    color_map{
      [0.0 (DarkWood+Gold+Tan)/3]
      [0.4 (DarkWood+Gold+Tan)/3]
      [0.9 (DarkWood+Gold+Tan)/4]
      [1.0 (DarkWood+Gold+Tan)/3]
    }
    turbulence 0.2
    warp{
      black_hole
      0, 0.5
      strength 3.5
      repeat <1.5,1.5,2>
      turbulence 0.5
      inverse
    }
    scale <0.15,0.15,1>
  }
  normal{
    bumps 1
    scale <0.1,0.1,2>
    turbulence 0.5
    omega 0.65
    lambda 4
  }
  scale 2
}
/***************************************************************************/
#declare Bridge_Planks =
union{
  height_field{ tga "planks.tga"
    translate <-0.5,0,-0.5>
    rotate <0,90,0>
    translate <0,0,0.5>
    scale <20,2,60>
    rotate <10,0,0>
    translate <0,0,30>
  }
  height_field{ tga "planks.tga"
    translate <-0.5,0,-0.5>
    rotate <0,90,0>
    scale <20,2,60>
  }
  height_field{ tga "planks.tga"
    translate <-0.5,0,-0.5>
    rotate <0,90,0>
    translate <0,0,-0.5>
    scale <20,2,60>
    rotate <-10,0,0>
    translate <0,0,-30>
  }
  texture{ Bridge_Plank_Texture rotate <0,90,0> }
}
/***************************************************************************/
#declare Bridge_Sides =
union{
  union{
    cylinder{ <10,1,30>,<10,1,-30>, 1 }
    cylinder{ <10,-1,30>,<10,-1,-30>, 1 }
    cylinder{ <-10,1,30>,<-10,1,-30>, 1 }
    cylinder{ <-10,-1,30>,<-10,-1,-30>, 1 }
    sphere{ <10,1,30>, 1 }
    sphere{ <10,1,-30>, 1 }
    sphere{ <-10,1,30>, 1 }
    sphere{ <-10,1,-30>, 1 }

    cylinder{ <10,10,30>,<10,10,-30>, 1 }	//railing
    cylinder{ <-10,10,30>,<-10,10,-30>, 1 }	//railing
    sphere{ <10,10,30>, 1 }			//corner of railing
    sphere{ <10,10,-30>, 1 }			//corner of railing
    sphere{ <-10,-10,30>, 1 }			//corner of railing
    sphere{ <-10,-10,-30>, 1 }			//corner of railing
    texture{ Log_Texture }
  }
  union{
    cylinder{ <10,0,0>,<10,0,60>, 1 rotate <10,0,0> translate <0,1,30> }
    cylinder{ <10,0,0>,<10,0,60>, 1 rotate <10,0,0> translate <0,-1,30> }
    cylinder{ <-10,0,0>,<-10,0,60>, 1 rotate <10,0,0> translate <0,1,30> }
    cylinder{ <-10,0,0>,<-10,0,60>, 1 rotate <10,0,0> translate <0,-1,30> }
    texture{ Log_Texture rotate <10,0,0> }
  }
  union{
    cylinder{ <10,0,0>,<10,0,-60>, 1 rotate <-10,0,0> translate <0,1,-30> }
    cylinder{ <10,0,0>,<10,0,-60>, 1 rotate <-10,0,0> translate <0,-1,-30> }
    cylinder{ <-10,0,0>,<-10,0,-60>, 1 rotate <-10,0,0> translate <0,1,-30> }
    cylinder{ <-10,0,0>,<-10,0,-60>, 1 rotate <-10,0,0> translate <0,-1,-30> }
    texture{ Log_Texture rotate <-10,0,0> }
  }
  union{
    cylinder{ <10,0,0>,<10,0,47>, 1 }	//railing
    cylinder{ <-10,0,0>,<-10,0,47>, 1 }	//railing
    rotate <10,0,0>
    translate <0,10,30>
    texture{ Log_Texture rotate <10,0,0> }
  }
  union{
    cylinder{ <10,0,0>,<10,0,-43>, 1 }	//railing
    cylinder{ <-10,0,0>,<-10,0,-43>, 1 }	//railing
    rotate <-10,0,0>
    translate <0,10,-30>
    texture{ Log_Texture rotate <-10,0,0> }
  }
}
/***************************************************************************/
#declare Supports =
union{
  cylinder{ <10,-20,30>,<10,10,30>, 1 }
  cylinder{ <10,-20,15>,<10,10,15>, 1 }
  cylinder{ <10,-20,0>,<10,10,0>, 1 }
  cylinder{ <10,-20,-15>,<10,10,-15>, 1 }
  cylinder{ <10,-20,-30>,<10,10,-30>, 1 }
  cylinder{ <-10,-20,30>,<-10,10,30>, 1 }
  cylinder{ <-10,-20,15>,<-10,10,15>, 1 }
  cylinder{ <-10,-20,0>,<-10,10,0>, 1 }
  cylinder{ <-10,-20,-15>,<-10,10,-15>, 1 }
  cylinder{ <-10,-20,-30>,<-10,10,-30>, 1 }
  union{
    cylinder{ <10,-20,0>,<10,10,0>, 1 rotate <-10,0,0> translate <0,0,22> }
    cylinder{ <10,-20,0>,<10,10,0>, 1 rotate <-10,0,0> translate <0,0,44> }
    cylinder{ <-10,-20,0>,<-10,10,0>, 1 rotate <-10,0,0> translate <0,0,22> }
    cylinder{ <-10,-20,0>,<-10,10,0>, 1 rotate <-10,0,0> translate <0,0,44> }
    rotate <10,0,0>
    translate <0,0,30>
  }
  union{
    cylinder{ <10,-20,0>,<10,10,0>, 1 rotate <10,0,0> translate <0,0,-20> }
    cylinder{ <10,-20,0>,<10,10,0>, 1 rotate <10,0,0> translate <0,0,-40> }
    cylinder{ <-10,-20,0>,<-10,10,0>, 1 rotate <10,0,0> translate <0,0,-20> }
    cylinder{ <-10,-20,0>,<-10,10,0>, 1 rotate <10,0,0> translate <0,0,-40> }
    rotate <-10,0,0>
    translate <0,0,-30>
  }
  texture{ Log_Texture rotate <90,0,0> }
}  
/***************************************************************************/
#declare Bridge =
union{
  object{ Bridge_Planks }
  object{ Bridge_Sides }
  object{ Supports }
}