/***************************************************************************/
//		misc.inc
/***************************************************************************/
#declare Cup_Texture =
texture{
  pigment{
    White filter 0.1 transmit 0.85
    quick_color (Yellow+MediumWood+Orange+Gold)/3.5
  }
  finish{
    ambient 0.05
    diffuse 0.85
    brilliance 0.75
    specular 0.35
    roughness 0.02
    reflection 0.035
    refraction 1
    ior 1.5
  }
}
#declare Lemonade_Texture =
texture{
  pigment{ color (Yellow+MediumWood+Orange+Gold)/3.5 filter 0.75 }
  finish{
    ambient 0.05
    diffuse 0.7
    brilliance 0.5
    refraction 1
    ior 2
  }
}
#declare Ice_Texture =
texture{
  pigment{ White filter 0.75 }
  finish{ ambient 0.15 diffuse 0.85 refraction 1 ior 2 }
}
/***************************************************************************/
//				The Straw
#declare Straw =
cylinder{ <0,0,0>,<0,1.5,0>, 0.015 open
  texture{
    pigment{
      radial
      frequency 2
      color_map{
        [0.0 Red]
        [0.2 Red]
        [0.2 White]
        [1.0 White]
      }
      rotate <0,70,0>
    }
    finish{ ambient 0.3 diffuse 0.9 }
  }
}
/***************************************************************************/
//				Ice Cube
#declare Ice =
superellipsoid{
  <0.25,0.25>
  texture{ Ice_Texture }
  scale 0.125
  scale 0.5
}
/***************************************************************************/
//				The Glass of Lemonade
#declare Lemonade_Glass =
union{
  merge{
    difference{
      cylinder{ <0,0,0>,<0,1,0>, 0.23 }
      cylinder{ <0,0.075,0>,<0,2,0>, 0.2 }
    }
    torus{ 0.215, 0.015 translate <0,1,0> }
  }
  cylinder{ <0,0.075,0>,<0,0.875,0>, 0.19
    texture{ Lemonade_Texture }
  }
  object{ Straw rotate <0,0,10> translate <0,0.1,0> }
  object{ Ice translate <0,0.875,0.1> }
  object{ Ice translate <0,0.875,-0.1> }
  object{ Ice translate <0,0.725,0> }
  object{ Ice translate <0,0.6,-0.1> }
  object{ Ice translate <0,0.475,0> }
  texture{ Cup_Texture }
}
/***************************************************************************/
