/***************************************************************************/
//		Porch.pov
/***************************************************************************/

#include "colors.inc"
#include "porch.inc"
#include "table.inc"
#include "misc.inc"
#include "chair.inc"
#include "bench.inc"
//#include "artstuff.inc"
#include "bridge.inc"

//#declare Direction = 1.4
//#declare Vector = <-16,3,-5*3.5>
//#declare Look_At = <-3.5,5,15>
//#declare Direction = 0.5
//#declare Vector = <50,49,150>
//#declare Look_At = <80,5,150>
/***************************************************************************/
//				From the Side

#declare Direction = 1
#declare Vector = <-19,10,2>
#declare Look_At = <-5,5,10>

/***************************************************************************/
//				From the Front Door
//#declare Direction = 1.4
//#declare Vector = <-15-1,13,-5*3.5>
//#declare Look_At = <-5+2.5,5,15>
/***************************************************************************/
camera{
  location Vector
  direction <0,0,Direction>
  up <0,1,0>
  right <4/3,0,0>
  look_at Look_At
  /*aperture 0.15
  focal_point <0,0,0>
  blur_samples 20
  confidence 0.25*/
}
light_source{ (Vector + <0,0,0>) color Gray75 }
//light_source{ <-500,500,1000> color Gray95 }
light_source{
  <-300,900,1000> color White
  area_light <50,50,0>, <-50,-50,0>,  5,5
  adaptive 1
  jitter
}
global_settings{
  max_trace_level 10
}
/***************************************************************************/
//				The Fog
fog{
  fog_type 2
  distance 2500
  color White transmit 0.125
  fog_offset 5
  fog_alt 75
}
/***************************************************************************/
//				The Objects

object{ Porch translate <0,0,0> }
object{ Table translate <-12,0,10> }
object{ Lemonade_Glass scale 1.65 translate <-13.5+3.5,5,10.5-1.5> }
object{ Chair rotate <0,-95,0> translate <-6.5,0,8> }
object{ Bench rotate <0,-90,0> translate <12,0,-2> }
//object{ Pencil rotate <0,-90,0> translate <-11,5,10.5> }
//object{ Drawing rotate <0,-70,0> translate <-11.5,5.001,9> }
object{ Bridge translate <110,-15,130> }
/***************************************************************************/
#declare Grass =
    pigment{
      bozo
      color_map{
        [0.0 ForestGreen]
        [1.0 ForestGreen*0.85]
      }
      scale <0.11,0.11,1>/30
      rotate <0,30,0>
      turbulence 1
      lambda 4
    }
#declare Dirt =
pigment{
  bozo
  color_map{
    [0.0 LightWood*0.85 transmit 0.15]
    [1.0 LightWood*0.75 transmit 0.15]
  }
  turbulence 0.5
  omega 0.25
  lambda 1
  scale 0.1
}
/***************************************************************************/
//				The Land
union{
  height_field{ gif "river3.gif"	//the river
    translate <-0.5,0,-0.5>
    scale <501,-10,250>
    translate <25,10,0>
  }
  difference{
    height_field{ gif "lake01.gif"	//the lake
      translate <0,0,-0.5>
      scale <801,10,801>
      translate <99,0,150>
    }
    height_field{ gif "river3.gif"	//the river
      translate <-0.5,0,-0.5>
      scale <500,-10,250>
      translate <50,10,0>
    }
  }

  box{ <100,10,125>, <-5000,-50,5000> }	//the banks of the river
  box{ <100,14,-125>, <-1250,-50,-500> }

  box{ <100,10,550>, <5000,-50,5000> }	//the banks of the lake
  box{ <100,10,-250>, <5000,-50,-5000> }
  box{ <900,10,5000>, <5000,-50,-5000> }
  translate <150,-30,150>
  texture{				//the grass
    pigment{ Grass scale 50 }
    finish{ ambient 0.1 diffuse 1 }
  }
  texture{				//the flowers
    pigment{
      bozo
      turbulence 1
      lambda 4
      pigment_map{
        [0.0 Grass]
        [0.6 Grass]
        //[0.6 Dirt]
        [1.0 Dirt]
      }
      scale 150
    }
    finish{ ambient 0.15 diffuse 0.85 }
    normal{ bumps 0.5 scale 40 }
  }
}
/***************************************************************************/
//				The River
union{
  box{ <5000,-23,5000>, <-5000,-30,-5000> }
  union{
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,52>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,30>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,15>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,0>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,-15>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,-30>
    }
    translate <100,0,130>
  }
  union{
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,52>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,30>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,15>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,0>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,-15>
    }
    height_field{ tga "ripples.tga"
      translate <-0.5,0,-0.5>
      scale <12,0.85,12>
      translate <0,-23.1,-30>
    }
    translate <120,0,130>
  }
  
  texture{
    pigment{ color (SkyBlue+SeaGreen*1.5)/6.5 }
    finish{
      ambient 0.1
      diffuse 0.7
      specular 0.5
      roughness 0.02
      reflection 0.7
    }
    /*normal{
      ripples 0.3 frequency 10 scale 15
      sine_wave
      //scale <2.5*1.5,2.5,2.5>/2
      scale <1,1,50>
      turbulence 0.05
      lambda 1
      translate <-150,-23,150>
    }*/
    normal{ bumps 0.1 scale <1,1,5>/1 }
  }
}

/***************************************************************************/
//				The Sky
//plane{ <0,1,0>, 50
sphere{ <0,0,0>, 50
  scale <100,1,100>
  texture{
    pigment{
      bozo
      color_map{
        [0.0 SkyBlue]
        [0.6 SkyBlue]
        [1.0 (White*2+SkyBlue)/3]
      }
      turbulence 0.5
      lambda 3
      scale 150
    }
    finish{ ambient 1 diffuse 0 }
  }
  hollow
  no_shadow
  scale 15
}
/***************************************************************************/
/*
cylinder{ <-10,0,0>,<10,0,0>, 200 open
  pigment{
    radial
    frequency 90
    color_map{
      [0.0 White]
      [0.5 White]
      [0.5 Black]
      [1.0 Black]
    }
    rotate <0,0,90>
  }
  scale <1,1,1>
  translate <110,-200,130>
}

union{
  box{ <-10,2,30>, <10,0,-30> }
  box{ <-10,2,0>, <10,0,60> rotate <10,0,0> translate <0,0,30> }
  box{ <-10,2,0>, <10,0,-60> rotate <-10,0,0> translate <0,0,-30> }
  
  pigment{ MediumWood }
  translate <110,-15,130>
}
*/