
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metals.inc"

#include "desk.pov"

#declare Trocket = on
#declare Tbook   = on
#declare Tglobe  = on
#declare Tthing  = on
#declare Tscene  = on

camera {
    location <600,200,-600>
    look_at  <600,200,0>
}

// Temporary light for test render
//light_source {<1000,1000,-1500> color White}


// Final render light
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  <1000,1000,-1500>
  color White  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <100, 0, 0> <0, 0, 100> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
}


#declare Wall2 =
box {<0,0,0><1,1,1>texture{pigment{image_map{gif "13scifi2.gif" map_type 0 interpolate 2}}}}

object {Wall2 translate<-.5,-.5,0> scale<10000,10000,1> translate<0,0,-1600>}

#declare Wall =
box {<2000,-1000,630><-2000,2000,640>
texture{pigment{image_map{gif "wall.gif" map_type 0 interpolate 2}scale 125}}
}

object {Wall}
object {Desk}

#if (Tscene = on)

#declare Board =
box {<0,0,0><3000,3000,10>
texture{pigment{
image_map {gif "cork.gif" map_type 0 interpolate 2}
scale <200,150,1>
}}
normal {
bump_map {gif "cork2.gif" map_type 0 interpolate 2 bump_size 0.5}
scale <200,150,1>
}
finish {phong .35}
}

#declare Frame=
union {
    difference {
        box {<-50,-50,0><3050,3050,-40>}
        box {<-45,-45,-35><3045,3045,-50>}
        box {<-25,-25,-25><3025,3025,-50>}
        box {<-10,-10,-15><3010,3010,-50>}
        box {<0,0,10><3000,3000,-50>}
    }
    cylinder {<-30,-30,-20><-30,3000,-20>,10}
    cylinder {<-30,-30,-20><3000,-30,-20>,10}
    sphere {<-30,-30,-20>,10}
}

#declare Picture1 =
box {<0,0,0><1,1,1>
texture{pigment{
image_map {gif "map.gif" map_type 0 interpolate 2}
}}
normal {wrinkles .3 scale .1}
finish {phong .35}
}

#declare Picture2 =
box {<0,0,0><1,1,1>
texture{pigment{
image_map {gif "mars.gif" map_type 0 interpolate 2}
}}
finish {phong .5}
}

object {Board translate <300,100,610>}
object {Frame translate <300,100,610> texture{pigment{crackle
color_map {
    [0.0 rgb <.3,.6,.2>]
    [0.1 rgb <.5,.8,.6>]
    [0.15 rgb <.1,.5,.3>]
    [0.3 rgb <.9,.9,.2>]
    [0.4 rgb <.5,.7,.6>]
    [0.6 rgb <.7,.9,.8>]
    [0.65 rgb <.4,.8,.5>]
    [0.7 rgb <.2,.6,.4>]
    [0.75 rgb <.2,.8,.5>]
    [0.9 rgb <.4,.8,.45>]
    [1.0 rgb <.45,.77,.5>]
}
turbulence .2
scale 20
}}
finish {phong .8 reflection .1}
}
object {Picture1 scale <1000,1800,1> translate<400,200,600>}
object {Picture2 scale <450,387,1> translate<600,150,599>}

#end

#if (Trocket = on)
#include "rocket.inc"
object {Rocket scale<1,1.2,1> rotate<0,45,0> translate<1000,0,225>}
#end

#if (Tbook = on)
#include "book.pov"
object {Book translate <0,18,0> scale 1.5 rotate<0,-60,0> translate<375,0,50>}
#end

#if (Tglobe = on)
#include "globe.pov"
object {Globe rotate<0,-75,0> scale 1.5 translate <0,54,0> translate<280,0,200>}
#end

#if (Tthing = on)
#include "ball.inc"
object {Ornament rotate<0,40,0> translate <1000,0,70>}
#end

#include "typew.pov"
object {Typewriter scale 1.3 rotate<0,180,0> translate<650,0,225>}

#include "pencil.pov"
object {Pencil translate<0,4,0> rotate<0,-160,0> translate<300,0,20>}
object {Pencil translate<0,4,0> rotate<0,45,0> translate<250,0,0>}
