// Babylon 4
// Sort of a psychadelic eclipse in Pink & Blue
// using overlapping halos with a blocker in the middle
// Try varying the clock between 0 and 1
// It will even animate in a loop if you sweep from 0 to 1

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

// Starz1, by Nick Stevens
#declare Starz1 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
            [ 0.88  0.85 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.91  0.88 color Gray40 color Gray60 ] // Very Faint Stars
            [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.93  0.93 color Gray80 color Gray95 ] // Medium White Stars
            [ 0.95  0.95 color Gray95 color White  ] // White Stars
            [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .01
    }
    finish { ambient 1 }
}

// Starz2, by Nick Stevens, (fainter)
#declare Starz2 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
            [ 0.88  0.85 color Gray20 color Gray30 ] // Very Very Faint Stars
            [ 0.91  0.88 color Gray40 color Gray50 ] // Very Faint Stars
            [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.93  0.93 color Gray80 color Gray85 ] // Medium White Stars
            [ 0.95  0.95 color Gray95 color Gray90  ] // White Stars
            [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .007
    }
    finish { ambient 1 }
}

// The Starry Background

#declare supersky=union {

// Ball of stars for even coverage
sphere { <0,0,0> 1
         texture {Starz1 scale 0.1}
         scale 2000000
         }

// The extra bands give the Milky Way effect
// Extra band of stars around the horizon, more distant
cylinder { <0,-0.1, 0> , <0, 0.1, 0> 1.2 open
         texture {Starz2 scale 0.1}
         scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.07, 0> , <0, 0.07, 0> 1.4 open
         texture {Starz2 scale 0.1}
         rotate <0, 90, 0>
         scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.05, 0> , <0, 0.05, 0> 1.5 open
         texture {Starz2 scale 0.1}
         rotate <0, 180, 0>
         scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.04, 0> , <0, 0.04, 0> 1.6 open
         texture {Starz2 scale 0.1}
         rotate <0, 270, 0>
         scale 2000000
}

} // end union

object {supersky
        rotate < 35, 0, 0 > // set inclination to horizon
        rotate < 0, -112, 0>  // spin about the zenith
 hollow
}


camera {
   location <0, 1, -70>
   direction <0,0,1.2>
   look_at <-0.54, 0, 0>
   angle 2.4
}

light_source{<-20,10,-40> colour White}
light_source{<40,40,-40> colour White}


// Some notes on experiences with halos:

// They seem to do odd things when scaled, so you might find it easier to
// get one that works, then build around it.

// Note the clever use of varying the turbulence in two different ways
// via cos(clock). By combining this with a rotation you get a nice looping
// churning effect when clock is swept from 0 to 1

// base flare
#declare Textur =
texture {
   pigment {colour Clear}
   halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      turbulence 0.3  + 0.2 * (cos (clock*2*3.14159))
          color_map {
              [0.0  color rgbt <0.0,0.0,0.0,1.0> ]
              [0.35 color rgbt <0.0,1.0,1.0,0.5>]
              [1.0  color rgbt <0.0,0.0,1.0,0.0>]
                    }
      samples 14
   }
}

//Red flarey bits:
#declare Textur2=
texture {
   pigment {colour Clear}
   halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      turbulence 1.4  - 0.6 * (cos (clock*2*3.14159))
          color_map {
              [0.0  color rgbt <1.0,0.0,0.5,1.0> ]
              [0.35 color rgbt <1.0,0.0,1.0,0.5>]
              [1.0  color rgbt <1.0,0.0,0.5,0.0>]
                    }
      samples 20
   }
}

#declare Metal2 =
texture {
    pigment { color Gray95 }
    finish {
        ambient 0.12
        diffuse 0.85
        reflection 0.15
        brilliance 5
        specular 0.8
        roughness 0.1
    }
}

sphere {<0,0,0> 2.0 hollow texture{ Textur } scale 1 rotate <0,clock*360,0> }
sphere {<0,0,0> 2.0 hollow texture{ Textur2 } scale 0.75 rotate <90,25,25> rotate <360*clock,0,0>}

sphere {<0,0,0> 0.55 color Black }


// Originally I just had the black hole eclipse thingy, but then I got the idea 
// of adding a tiny spaceship, to try and add more of a sense of scale. 
// Being something of a Babylon 5 fan, I first thought of that. Then it occured
// to me that as Babylon 4 was easier to model, and had last been seen
// vanishing into the past, it was a better sugbject!

// It's not a very detailed model, so won't look very good if you close 
// in on it.


// Add a tiny Babylon 4 space station

#declare b4=union{
lathe {
  linear_spline
  10, // number of points
  <0,0>
  <1,1>
  <0.5,3>  //3
  <1.7,3>
  <1.7,4>
  <3,4>    //6
  <3,10>
  <0.9,10>
  <0.9,16> //9
  <0, 16.5>
 texture {Metal2}
}

cylinder {<0,5,3> <0,7,3> 0.5 rotate <0,000,0> pigment {White} finish {Shiny} }
cylinder {<0,5,3> <0,7,3> 0.5 rotate <0,060,0> pigment {White} finish {Shiny} }
cylinder {<0,5,3> <0,7,3> 0.5 rotate <0,120,0> pigment {White} finish {Shiny} }
cylinder {<0,5,3> <0,7,3> 0.5 rotate <0,180,0> pigment {White} finish {Shiny} }
cylinder {<0,5,3> <0,7,3> 0.5 rotate <0,240,0> pigment {White} finish {Shiny} }
cylinder {<0,5,3> <0,7,3> 0.5 rotate <0,300,0> pigment {White} finish {Shiny} }

sphere {<0,10,0> 1.5 texture {Metal2}}
cone {<0,14,0> 1.3 <0,15,0> 0.7 pigment {SpringGreen} finish {Shiny}}

torus {2.5 0.5  translate <0, 3,0> pigment {SpringGreen} finish {Shiny}}
torus {2.5 0.5  translate <0,10,0> pigment {SpringGreen} finish {Shiny}}
torus {2.5 0.7  translate <0, 8,0> pigment {SpringGreen} finish {Shiny}}

torus {2 0.3 translate <0,0,0> texture {Metal2}}

cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 000, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 040, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 080, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 120, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 160, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 200, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 240, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 280, 0> texture {Metal2 pigment {Navy}} }
cone {<0,0,0> 0.8 <0,0,6> 0.5 scale <1,0.01,1> rotate <-10,0,0> translate <0,0,2.5> rotate <0, 320, 0> texture {Metal2 pigment {Navy}} }

scale 0.01
rotate <75,135,0>
translate <-1.4,-0.1,-3>

}

object {b4}
