
// Persistence of Vision Ray Tracer Scene Description File
// File: sf.pov
// Vers: 3
// Desc: Science Fiction
// Date: Sep/Oct 1996
// Auth: Roy Schulz

#include "colors.inc"

global_settings { max_trace_level 20 }

#declare Standard_Cam = camera {
  location <0, 2, -10>
  look_at <0, 0, 0>
}

#declare Vehicle_Cam = camera {
  location <0.4, 0.2, -7.4>
  look_at <0.4, 0.1, -6.8>
}

#declare Top_Cam = camera {
  location <0, 3, -6.6>
  look_at <0, 0, -6.6>
}

#declare Handy_Cam = camera {
  location <-3, 1, -5>
  look_at <0, 0, -7>
}

camera { Standard_Cam }
//camera { Vehicle_Cam }
//camera { Top_Cam }
//camera { Handy_Cam }

light_source { <-200000, 150000, 0> color Orange*1.5 }

light_source {
  <1.65, 1, 0>
  color Orange
  fade_power 2
  fade_distance 0.7
  shadowless
}

light_source {
  <3, 0.75, -3.7>
  color Orange
  fade_power 2
  fade_distance 0.7
  shadowless
}

light_source {
  <1.3, 0.25, -6.4>
  color Orange*0.6
  fade_power 10
  fade_distance 1.4
  shadowless
}

#declare Glass = texture {
  pigment { Gray50 }
  finish {
    specular 1
    roughness 0.0005
    reflection 0.5
  }
}


// --- Objects ---


#declare Sky = sphere {
  <0, -20000, 0>, 20100
  pigment {
    bozo
    turbulence 0.5
    color_map {
      [ 0 color rgb <0.8, 0.4, 0> ]
      [ 1 color rgb <1, 0.9, 0.5> ]
    }
    scale 100
  }
  finish { ambient 1 diffuse 0 }
  no_shadow
  hollow
  rotate x
}

#declare Tracks = union {
  cylinder { <2.5, 1, -2>, <-100, 1, -2>, 1.1 }
  cylinder { <2.5, 1, 2>, <-100, 1, 2>, 1.1 }
  pigment { Gray70 }
  normal { ripples scale 0.2 translate x*100 }
  scale 0.04
}

#declare Landing_Pads = union {
  #declare light=Green
  object { #include "slab.inc" }
  #declare light=Red
  object { #include "slab.inc" translate -x*2.3 }
  rotate -y*25
  translate <0.7, 0, -2.8>
}

#declare Cross = union {
  sphere { 0, 0.015 }
  #declare i=0.2
  #while (i<0.7)
    sphere { <-i, 0, 0>, 0.015 }
    sphere { <i, 0, 0>, 0.015 }
    sphere { <0, 0, -i>, 0.015 }
    sphere { <0, 0, i>, 0.015 }
    #declare i=i+0.1
  #end
}

#declare Ground = union {
  difference {
    union {
      height_field {
        tga "hills.tga"
        smooth
        translate <-0.5, 0, 0.01>
        scale <100, 10, 100>
      }
      plane { y, 0 }
    }
    object { Tracks rotate -y*60 translate <-0.6, 0, -6.6> }
    object { Tracks rotate -y*70 translate <-0.1, 0, -6.5> }
    object { Tracks rotate -y*60 translate <0.4, 0, -6.8> }
    union {
      cylinder {
        -y*0.001, y, 0.8
        pigment {
          image_map { gif "two.gif" once }
          rotate x*90
          scale 2
          translate <-1, 0, -1>
        }
        finish { ambient 0.2 }
      }
      cylinder {
        -y*0.3, y, 0.8
        pigment {
          image_map { gif "one.gif" once }
          rotate x*90
          scale 2
          translate <-1, 0, -1>
        }
        finish { ambient 0.2 }
        translate -x*2.3
      }
      rotate -y*25
      translate <0.7, 0, -2.8>
    }
  }
  union {
    object { Cross translate -y*0.001 }
    object { Cross translate <-2.3, -0.3, 0> }
    pigment { White }
    finish { ambient 0.4 }
    rotate -y*25
    translate <0.7, 0, -2.8>
  }
  pigment { Gray70 }
  normal {
    average
    normal_map {
      [ bumps 0.4 scale 0.25 ]
      [ bumps 0.4 scale 0.02 ]
    }
  }
  hollow
}

#declare Shuttle = union {
  prism {
    linear_sweep
    linear_spline
    0, 2,
    5,
    <-1, 0>, <1, 0>, <0.6, 1>, <-0.6, 1>, <-1, 0>
    rotate <0, 90, 90>
    translate x
  }
  polygon {
    6,
    <0, 0>, <-0.3, 3>, <-1.5, 3>, <-2.3, 0.5>, <-1.8, 0>, <0, 0>
    texture { pigment { color rgb <0.7, 1, 1> } }
    finish { diffuse 0.8 }
    texture {
      pigment {
        image_map { gif "sign.gif" once }
        translate <-0.5, -0.5, 0>
        scale 1.8
        translate <-1.05, 1.5, 0>
      }
    }
    finish { diffuse 0.8 }
    translate <1, 1.3, 0>
  }
  box { <-0.2, 0, -0.1>, <0.75, 1.6, 0.1> }
  difference {
    cylinder { <-1, 0.4, 0.8>, <0, 0.4, 0.8>, 0.2 }
    cylinder { <-1.1, 0.4, 0.8>, <-0.1, 0.4, 0.8>, 0.16 }
  }
  difference {
    cylinder { <-1, 0.4, -0.8>, <0, 0.4, -0.8>, 0.2 }
    cylinder { <-1.1, 0.4, -0.8>, <-0.1, 0.4, -0.8>, 0.16 }
  }
  cylinder { <-1, 0, -1>, <1, 0, -1>, 0.14 }
  cylinder { <-1, 0, 1>, <1, 0, 1>, 0.14 }
  sphere { <-1, 0, -1>, 0.14 }
  sphere { <-1, 0, 1>, 0.14 }
  union {
    polygon {
      5,
      <-1, 0>, <1, 0>, <1, -0.5>, <-1, -0.5>, <-1, 0>
    }
    polygon {
      5,
      <-1, 0>, <1, 0>, <0.5, -3>, <-0.5, -3>, <-1, 0>
      rotate x*45
      translate -y*0.5
    }
    translate -z
  }
  union {
    polygon { 5, <-1, 0>, <1, 0>, <1, -0.5>, <-1, -0.5>, <-1, 0> }
    polygon {
      5,
      <-1, 0>, <1, 0>, <0.5, -3>, <-0.5, -3>, <-1, 0>
      rotate -x*45
      translate -y*0.5
    }
    translate z
  }
  difference {
    difference {
      intersection {
        superellipsoid { <0.2, 0.2> }
        cylinder {
          <-2, -3, 0>, <2, 1, 0>, 1
          texture {
            gradient y
            texture_map {
              [ 0 pigment { color rgb <0.7, 1, 1>*2 } ]
              [ 0.2 pigment { color rgb <0.7, 1, 1>*2 } ]
              [ 0.21 pigment { Black } ]
              [ 0.79 pigment { Black } ]
              [ 0.8 pigment { color rgb <0.7, 1, 1>*2 } ]
              [ 1 pigment { color rgb <0.7, 1, 1>*2 } ]
            }
            translate y*0.45
            rotate -z*60
            scale 2

          }
        }
      }
      plane { <2, -1.1, 5>, -0.5 pigment { color rgb <0.7, 1, 1>*2 } }
      plane { <2, -1.1, -5>, -0.5 pigment { color rgb <0.7, 1, 1>*2 } }
      scale <1.4, 0.5, 1>
      rotate z*10
      translate <-1.5, 0.5, 0>
    }
    box { -1, 2 }
  }
  pigment { color rgb <0.7, 1, 1> }
  scale 0.2
  rotate -y*100
  translate -x*2.3
  rotate -y*25
  translate <0.7, 0.2, -2.8>
}

#declare Tire = difference {
  torus {
    2, 1.5
    scale <0.6, 1, 0.6>
    rotate <90, 0, 0>
  }
  #declare a=0
  #while (a<180)
    torus {
      2.15, 0.1
      rotate z*a
    }
    #declare a=a+10
  #end
  bounded_by { sphere { 0, 2.1 } }
  pigment { Gray40 }
  scale 0.5
  translate y*0.9
}

#declare Axle = union {
  cylinder { <0, 0.9, -2.5>, <0, 0.9, 2.5>, 0.15 }
  sphere { <0, 0.9, -2.5>, 0.2 }
  sphere { <0, 0.9, 2.5>, 0.2 }
  pigment { White }
}

#declare Explosion = sphere {
  0, 1
  pigment { color rgbf <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 0.5
    lambda 4
    color_map {
      [ 0.0 color rgbt <1, 0, 0, 1> ]
      [ 1.0 color rgbt <1, 1, 0, -2> ]
    }
    scale 0.7
  }
  hollow
}

#declare PinkExplosion = sphere {
  0, 1
  pigment { color rgbf <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 0.8
    color_map {
      [ 0.0 color rgbt <1, 0, 1, 1> ]
      [ 1.0 color rgbt <1, 0.8, 1, -4> ]
    }
    scale 0.5
  }
  hollow
}

#declare Jet = difference {
  sphere {
    0, 1
    scale <0.2, 0.2, 1>
  }
  sphere {
    0, 1
    scale <0.17, 0.17, 1.3>
  }
}

#declare JetHalo = sphere {
  0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  hollow
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [ 0 color rgbt <1, 1, 0, 1> ]
      [ 1 color rgbt <1, 1, 1, -1> ]
    }
  }
  scale <0.17, 0.17, 2>
  translate z
}

#declare Laser = cylinder {
  0, <0, 1, 0>, 1
  pigment { color rgbt <1, 1, 1, 1> }
  hollow
  halo {
    emitting
    cylindrical_mapping
    linear
    color_map {
      [ 0 color rgbt <1, 0.5, 0, 1> ]
      [ 1 color rgbt <1, 1, 1, -1> ]
    }
  }
  scale <0.05, 1000, 0.05>
  rotate -x*90
  translate -z*0.5
}

#declare Wings = difference {
  superellipsoid {
    <1, 0.3>
    scale <1.2, 0.9, 1.6>
  }
  cylinder { <0, 0, -2>, <0, 0, 2>, 1 }
}

#declare Hull = union {
  cylinder { <0, 0, -1>, <0, 0, 1>, 0.3 }
  sphere { <0, 0, -1>, 0.3 }
  sphere { <0, 0, 1>, 0.3 }
  cylinder { <-1.1, 0, 0>, <1.1, 0, 0>, 0.15 }
}

#declare Fighter = union {
  object { Hull }
  object { Jet translate x*0.6 }
  object { Jet translate -x*0.6 }
  object { JetHalo translate x*0.6 }
  object { JetHalo translate -x*0.6 }
  cylinder { <0.2, -0.2, -1.5>, <0.2, -0.2, -0.5>, 0.05 }
  cylinder { <-0.2, -0.2, -1.5>, <-0.2, -0.2, -0.5>, 0.05 }
  object { Wings }
  pigment { Green }
  finish {
    reflection 0.4
    specular 1
    roughness 0.001
    metallic
  }
  scale 0.25
}

#declare LaserFighter = union {
  object { Fighter }
  object { Laser translate <0.2, -0.2, -1> scale 0.25 }
  object { Laser translate <-0.2, -0.2, -1> scale 0.25 }
}

#declare Crash = union {
  object { Hull }
  object { Jet translate x*0.6 }
  object { JetHalo translate x*0.6 }
  object { Jet rotate -y*10 translate -x*0.7 }
  difference {
    object { Wings }
    box { <-2, -2, -2>, <0, 2, 2> }
  }
  difference {
    object { Wings }
    box { <0, -2, -2>, <2, 2, 2> }
    pigment { Green }
    finish {
      reflection 0.4
      specular 1
      roughness 0.001
      metallic
    }
    normal { bumps 0.5 scale 0.4 }
    rotate z*45
    rotate x*35
    translate <-0.6, 0.4, 0.5>
  }
  sphere {
    0, 1
    pigment { color rgbf <1, 1, 1, 1> }
    hollow
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 0.5
      lambda 4
      color_map {
        [ 0.0 color rgbt <1, 0, 0, 1> ]
        [ 1.0 color rgbt <1, 1, 0, -2> ]
      }
    }
    rotate < 0, 180, -90 >
    scale <1, 1, 3.2>
    rotate -y*20
    translate <-1, 0.3, 1>
  }
  cylinder {
    <0, 0, -2>, <0, 0, 20>, 3
    pigment { color rgbt <1, 1, 1, 1> }
    hollow
    #declare i=1
    #while (i<9)
      halo {
        emitting
        spherical_mapping
        linear
        turbulence 0.5+i/10
        lambda 4
        color_map {
          [ 0 color rgbt <0, 0, 0, 1> ]
          [ 1 color rgbt <0, 0, 0, 0+i/10> ]
        }
        rotate i*30
        scale <2-i/10, 2-i/10, 2>
        translate <0, 0, i*(3-i/10)>
      }
      #declare i=i+1
    #end
    rotate -y*25
    translate <-0.6, 1, 0>
  }
  pigment { Green }
  finish {
    reflection 0.4
    specular 1
    roughness 0.001
    metallic
  }
  scale 0.25
  rotate z*30
  rotate <-30, -45, 0>
  translate <1.4, 0.25, -6.4>
}

#declare Dome = union {
  sphere {
    0, 1
    texture { Glass }
  }
  intersection {
    sphere { 0, 1.01 }
    union {
      #declare i=0
      #while (i<75)
        box { <-2, sin(i*pi/180), -2>, <2, sin(i*pi/180)+0.02, 2> }
        #declare i=i+15
      #end
      box { <-2, sin(75*pi/180), -2>, <2, 2, 2> }
    }
    pigment { Gray50 }
  }
  #declare i=0
  #while (i<180)
    intersection {
      sphere { 0, 1.01 }
      box { <-2, -0.01, -2>, <2, 0.01, 2> }
      pigment { Gray50 }
      rotate < 90, i+11.25, 0 >
    }
    #declare i=i+22.5
  #end
}

#declare Passage = union {
  box {
    <-3, 0, sin(-11.25*pi/180)>, <0, sin(15*pi/180)+0.01, sin(11.25*pi/180)>
    texture { Glass }
  }
  union {
    box {  <-3, sin(15*pi/180), sin(-11.25*pi/180)-0.01>, <0, sin(15*pi/180)+0.02, sin(-11.25*pi/180)+0.01> }
    box {  <-3, sin(15*pi/180), sin(11.25*pi/180)-0.01>, <0, sin(15*pi/180)+0.02, sin(11.25*pi/180)+0.01> }
    box {  <-3, 0, sin(-11.25*pi/180)-0.01>, <0, 0.02, sin(-11.25*pi/180)+0.01> }
    box {  <-3, 0, sin(11.25*pi/180)-0.01>, <0, 0.02, sin(11.25*pi/180)+0.01> }
    #declare i=-3
    #while (i<1)
      box {
        <-0.01, 0, sin(-11.25*pi/180)-0.01>, <0.01, sin(15*pi/180)+0.02, sin(11.25*pi/180)+0.01>
        translate x*i
      }
      #declare i=i+0.3
    #end
    pigment { Gray50 }
  }
}

#declare Complex = union {
  object { Dome }
  object {
    Dome
    scale 0.6
    translate -x*3
  }
  object {
    Dome
    scale 0.6
    translate -x*3
    rotate -y*90
  }
  object { Passage }
  object { Passage rotate -y*90 }
  scale 2
  rotate -y*25
  translate <1.6, 0, 2>
}

#declare Protection = intersection {
  difference {
    sphere { 0, 1.1 }
    sphere { 0, 1 }
  }
  box { <0, 0, -2>, <2, 2, 2> }
  bounded_by { box { <0, 0, -1.11>, <1.11, 1.11, 1.11> } }
}

#declare Turret = union {
  superellipsoid {
    <0.2, 0.2>
    scale <0.5, 3, 0.5>
    translate y*1
  }
  difference {
    sphere { 0, 1 }
    box { <-2, 0, -2>, <2, 2, 2> finish { reflection 0.5 } }
    bounded_by { box { <-1.01, -1.01, -1.01>, <1.01, 0.01, 1.01> } }
    translate y*4
  }
  object {
    Protection
    rotate -z*60
    translate y*4
  }
  object {
    Protection
    rotate z*150
    translate y*4
  }
  pigment { Gray75 }
  finish { ambient 0.2 }
  scale 0.2
}

#declare Turrets = union {
  object { Turret rotate y*5 translate <-1.5, 0, -7> }
  object { Turret rotate -y*50 translate <-6.3, 0, 0.5> }
  object { Turret rotate y*45 translate <6.6, 0, 4> }
  #declare vertical=26
  #declare horizontal=128
  #declare length=12.1
  object { #include "laser.inc" translate <-1.5, 0, -7> }
  #declare vertical=40
  #declare horizontal=-13
  #declare length=20
  object { #include "laser.inc" translate <-6.3, 0, 0.5> }
  #declare vertical=39
  #declare horizontal=188
  #declare length=100
  object { #include "laser.inc" translate <6.6, 0, 4> }
}

#declare Fighters = union {
  object { LaserFighter rotate z*60 rotate <-10, -62, 0> translate <-2.6, 1.8, -0.6> }
  object { LaserFighter rotate z*10 rotate <-7, 189, 0> translate <0.28, 2.34, -8.4> }
  object { LaserFighter rotate -z*45 rotate <-36, 94, 0> translate <6.2, 3.2, 2> }
  union {
    object { Fighter rotate <10, 0, -30> translate <-0.7, 0, 0> }
    object { Fighter translate <0, 0.7, 0> }
    object { Fighter translate <0.7, 0, 0> }
    rotate z*30
    rotate <-30, -40, 0>
    translate <-6.4, 4.2, 4>
  }
}

#declare Explosions = union {
  object { Explosion rotate z*90 translate <1.65, 1, 0.2> }
  object { Explosion translate <3, 1, 2> }
  object { Explosion rotate z*180 scale 0.6 translate <3.1, 0.68, -3.7> }
  object { PinkExplosion scale 0.3 translate <0.32, 2.25, -8.6> }
  object { PinkExplosion scale 0.5 translate <-7, 3.8, 3.5> }
}

#declare Vehicles = union {
  #declare flag=Black
  #declare length=0
  #declare horizontal=15
  #declare vertical=25
  object { #include "vehicle.inc" rotate -y*60 translate <-0.6, 0, -6.6> }
  #declare flag=Red
  #declare length=20
  #declare horizontal=55
  #declare vertical=20
  object { #include "vehicle.inc" rotate -y*70 translate <-0.1, 0, -6.5> }
  #declare flag=Yellow
  #declare length=16
  #declare horizontal=20
  #declare vertical=10
  object { #include "vehicle.inc" rotate -y*60 translate <0.4, 0, -6.8> }
}


// --- Scene ---


object { Explosions }
object { Sky }
object { Ground }
object { Landing_Pads }
object { Shuttle }
object { Complex }
object { Turrets }
object { Vehicles }
object { Fighters }
object { Crash }
