
// Persistence of Vision Ray Tracer Include File
// File: vehicle.inc
// Vers: 3
// Desc: Mars Vehicle
// Date: Oct 1996
// Auth: Roy Schulz

union {
  object { Tire translate <-2.5, 0, -2> }
  object { Tire translate <-2.5, 0, 2> }
  object { Tire translate <2.5, 0, -2> }
  object { Tire translate <2.5, 0, 2> }
  object { Axle translate x*2.5 }
  object { Axle translate -x*2.5 }
  difference {
    superellipsoid {
      <0.2, 0.2>
      scale <3.4, 1.7, 2>
      translate y*2.5
    }
    sphere { 0, 1.3 scale <1, 1, 0.6> translate <-2.5, 0.9, -2> }
    sphere { 0, 1.3 scale <1, 1, 0.6> translate <-2.5, 0.9, 2> }
    sphere { 0, 1.3 scale <1, 1, 0.6> translate <2.5, 0.9, -2> }
    sphere { 0, 1.3 scale <1, 1, 0.6> translate <2.5, 0.9, 2> }
  }
  superellipsoid {
    <0.2, 0.2>
    scale <3.45, 0.1, 2.05>
    translate y*3
    pigment { White }
  }
  union {
    box { <-3, 4, 0>, <-1.5, 4.6, 1> }
    cylinder { <-3.6, 2, 0>, <-3.6, 3.7, 0>, 0.2 }
    cylinder { <-3.6, 2, -0.6>, <-3.6, 3.7, -0.6>, 0.3 }
    cylinder { <-3.6, 2, -1.2>, <-3.6, 3.7, -1.2>, 0.3 }
    pigment { color rgb <0.7, 1, 1> }
  }
  cylinder { <-3.48, 1.4, 1.2>, <-3.48, 8, 1.2>, 0.08 pigment { White } }
  sphere { <-3.48, 8, 1.2>, 0.2 pigment { White } }
  triangle {
    <-3.48, 7.9, 1.2>, <-3.48, 6.5, 1.2>, <-3.48, 7.2, 3.2>
    pigment { flag }
    finish { ambient 0.3 }
    normal { bumps 0.7 scale 0.3 }
  }
  sphere { <1, 4.2, 0>, 1.2 pigment { White } finish { reflection 0.5 } }
  union {
    cylinder { 0, <3, 0, 0>, 0.2 pigment { White } finish { reflection 0.5 } }
    #if (length>0)
      cylinder {
        <3, 0, 0>, <length, 0, 0>, 1
        pigment { color rgbt <1, 1, 1, 1> }
        hollow
        halo {
          emitting
          cylindrical_mapping
          linear
          color_map {
            [ 0 color rgbt <0, 1, 1, 1> ]
            [ 1 color rgbt <1, 1, 1, -1> ]
          }
          rotate z*90
        }
        scale <1, 0.2, 0.2>
      }
    #end
    rotate z*vertical
    rotate y*horizontal
    translate <1, 4.3, 0>
  }
  pigment { color rgb <0.3, 0.6, 1> }
  scale 0.04
}
