// B5_JUMP  961025 - Created for the ray-trace competision at www.povray.org
// A fighter about to enter hyperspace gate as five colleges returns
//
// Copyright David Eliasson 1996
// Comments to David@cebec.arosnet.se

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#include "starf.inc"
#include "gate.inc"
#include "space.inc"

camera
  {
    location  <15, 35, 10>
    direction <0, 0, 2>
    look_at   <0, 5, 120>
  }

light_source { <-60,100,60> color White
  looks_like
    {
      sphere{ <0,0,0>,5 pigment { White } finish { ambient 1 } }
    }
  }

//good test objects

// Fither close up
//object {starf scale 2 rotate <0,-30,0> translate <7,25,50> }
// Gube close up
//object {gube scale 1.2 rotate <0,-130,0> translate <7,30,50> }
// Light source to illuminate close up objects
//light_source { <0,35,0> color White }



// ok objects

object { starf scale 1 rotate <-15.8,-187.8,0> translate <15,34.2,11> } // We are sitting inside one...
object { starf scale 0.3 rotate <0,0,0> translate <18,18,80> }          // 5 fighters
object { starf scale 0.3 rotate <0,0,0> translate <2,18,80> }
object { starf scale 0.3 rotate <0,0,0> translate <14,19,65> }
object { starf scale 0.3 rotate <0,0,0> translate <6,19,65> }
object { starf scale 0.3 rotate <0,0,0> translate <10,20,50> }
object { gate translate <0,0,150> }                                     // The jump gate
object { space }                                                        // Background space



