
// Persistence of Vision Ray Tracer Scene Description File
// File: BGround.inc, used by BGSF2.pov

#declare BGClouds =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color Gray85 color Gray75]
        [0.1, 0.5   color Gray75 color Clear]
        [0.5, 1.001 color Clear  color Clear]
    }
    scale <6, 1, 6>
}

#declare Moon =
sphere {0, 1
    texture {
        pigment {
            bozo
            turbulence 0.6
            color_map {
                [0.00 color Red]
                [0.10 color Orange]
                [0.50 color Orange * 1.5]
                [1.00 color Orange]
            }
        }
    }
    scale 800
    rotate <0, -15, 65>
}

#declare Planet =
union {
    // Ground
    sphere {0, 1
        texture {
            pigment {
                bozo
                turbulence 0.6 omega 0.5 lambda 0.8
                color_map {
                    [0.00 color ForestGreen]
                    [0.25 color Khaki]
                    [0.70 color NewMidnightBlue * 0.75]
                }
            }
            scale 0.5
        }
    }
    // Clouds
    sphere {0, 1.05
        pigment {BGClouds
            rotate <0, 25, -35>
        }
        no_shadow
   }
   scale 5000
}

#declare Background =
union {
    object {Moon
        translate <0, 2000, 7000>
    }
    object {Planet
        translate <7000, 8750, 35000>
    }
}
