
// Persistence of Vision Ray Tracer Scene Description File
// File: Fighter.inc, used by BGSF2.pov

#declare BGFighterBodyTex =
texture {
    pigment {color SteelBlue}
    normal {hexagon}
    finish {
        diffuse 0.7
        metallic
        specular 0.80
        roughness 1/120
    }
}

#declare RightCannon = <5.5, 1.45, 0>
#declare LeftCannon = <-5.5, 1.45, 0>

#declare LaserLeft =
cylinder {0, <0, 0, 25>, 0.5
    pigment {color Green filter 0.5}
    finish {ambient 0.75}
    translate LeftCannon
}
#declare LaserRight =
cylinder {0, <0, 0, 25>, 0.5
    pigment {color Green filter 0.5}
    finish {ambient 0.75}
    translate RightCannon
}

#declare CCyl1 =
cylinder { 0, <0, 0, 1.3>, 0.025
    translate <-0.25, 0, -1.9>
    texture {Tinny_Brass}
}

#declare CCyl2 =
cylinder { 0.0, <0, 0, 1.5>, 0.025
    translate <-0.1, 0, -0.5>
    texture {Tinny_Brass}
}

#declare Cannon =
union {
    // Back
    torus { 0.2, 0.1 sturm
        rotate x * 90
        translate <0, 0, -1.9>
        texture {Tinny_Brass}
    }
    cylinder { 0, <0, 0, 1.5>, 0.2
        translate <0, 0, -2>
    }
    cylinder { 0, <0, -0.5, 0>, 0.025
        translate <0, -0.25, -1.6>
        texture {Tinny_Brass}
    }
    cylinder { 0, <0, -0.5, 0>, 0.025
        translate <0, -0.25, -0.9>
        texture {Tinny_Brass}
    }
    #declare rot = 0
    #while (rot < 360)
        object {CCyl1 rotate z * rot}
        #declare rot = rot + 45
    #end
    cylinder { 0, <0, 0, 1.3>, 0.025
        translate <0, 0.2, -1.9>
    }
    torus { 0.2, 0.1 sturm
        rotate x * 90
        translate <0, 0, -0.6>
        texture {Tinny_Brass}
    }
    // Middle part
    cylinder { 0, <0, 0, 1.5>, 0.1
        translate <0, 0, -0.5>
    }
    #declare rot = 0
    #while (rot < 360)
        object {CCyl2 rotate z * rot}
        #declare rot = rot + 90
    #end
    torus { 0.1, 0.05 sturm
        rotate x * 90
        translate <0, 0, 1>
        texture {Tinny_Brass}
    }
    // Top
    union {
        difference {
            cone {0, 0.1, <0, 0, 1>, 0.2}
            cone {0, 0.09, <0, 0, 1.1>, 0.19}
        }
        cone {0, 0.09, <0, 0, 0.5> 0}
        translate <0, 0, 1>
    }
    texture {T_Chrome_3E
        finish {reflection 0.2}
    }
}

#declare Fighter =
union {
    // Body
    difference {
        sphere { 0, 1
            scale <10, 1.4, 12>
        }
        cylinder { 0, <0.0, 4.5, 0.0>, 1
            scale <7, 1, 15>
            translate <0, -1.5, -13>
        }
    }
    // Engine
    union {
        intersection {
            sphere {0, 1
                scale <5, 1.25, 2>
                translate z * 1
            }
            cylinder { 0, <0.0, 4.5, 0.0>, 1
                scale <7, 1, 15>
                translate <0, -1.5, -13>
            }
            pigment {
                bozo
                color_map {
                    [0 color NeonPink]
                    [1 color NeonPink * 2]
                }
                scale 0.25
            }
            finish {ambient 0.75}
        }
        intersection {
            sphere {0, 1
                scale <5, 1.4, 1.7>
                translate z * 1
            }
            cylinder { 0, <0.0, 4.5, 0.0>, 1
                scale <7, 1, 15>
                translate <0, -1.5, -13>
            }
        }
    }
    // Cockpit
    difference {
        sphere {0, 1
            scale <5, 2, 6>
            translate y * 0.75
        }
        sphere { 0, 1
            scale <10, 1.4, 12>
        }
        cylinder { 0, <0, 4.2, 0>, 1
            scale <7, 1, 15>
            translate <0, -1.3, -13>
        }
        difference {
            cylinder {0, <0, 1, 0>, 1
                scale <4.5, 2.3, 5.5>
            }
            cylinder { 0, <0, 4.2, 0>, 1
                scale <7, 1, 15>
                translate <0, -1.3, -12>
            }
        }
    }
    // Window
    intersection {
        sphere {0, 1
            scale <5, 2, 6>
            translate y * 0.75
        }
        difference {
            cylinder {0, <0, 1, 0>, 1
                scale <4.5, 2.3, 5.5>
            }
            cylinder { 0, <0, 4.2, 0>, 1
                scale <7, 1, 15>
                translate <0, -1.3, -12>
            }
        }
        texture {T_Silver_1A}
    }
    object {Cannon translate LeftCannon}
    object {Cannon translate RightCannon}
    texture {BGFighterBodyTex}
}
