
// Persistence of Vision Ray Tracer Scene Description File
// File: SF.inc, used by BGSF2.pov

#declare Tinny_Brass =
texture {
    pigment { color rgb <0.70, 0.56, 0.37> }
    finish {
        metallic
        ambient 0.1
        diffuse 0.65
        specular 0.85
        roughness 0.01
        reflection 0.45
        brilliance 1.5
    }
}

#declare F_MetalA  =
finish {
    ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/20
    reflection 0.1
}

#declare F_MetalD  =
finish {
    ambient 0.15
    brilliance 5
    diffuse 0.6
    metallic
    specular 0.80
    roughness 1/100
    reflection 0.65
}

#declare F_MetalE  =
finish {
    ambient 0.1
    brilliance 6
    diffuse 0.7
    metallic
    specular 0.80
    roughness 1/120
    reflection 0.8
}

#declare P_Chrome3   = color rgb <0.50, 0.50, 0.50>
#declare P_Silver1   = color rgb <0.94, 0.93, 0.80>

#declare T_Chrome_3E =
texture {
    pigment {color Gray50}
    finish {F_MetalE}
}
#declare T_Silver_1A =
texture {
    pigment {P_Silver1}
    finish {F_MetalA}
}
/*
#declare P_Cloud1 =
pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color Gray85 color Gray75]
        [0.1, 0.5   color Gray75 color Clear]
        [0.5, 1.001 color Clear color Clear]
    }
    scale <6, 1, 6>
}
*/

#declare BGSpaceShipBodyTex =
texture {
   pigment {
      bozo
      color_map {
         [0.0 color NewMidnightBlue * 1.25]
         [0.5 color DarkGreen * 2]
         [1.0 color HuntersGreen * 2]
      }
      quick_color HuntersGreen
   }
   normal {wrinkles 1}
   finish {
      F_MetalD
      reflection 0
      ambient 0
   }
   scale 0.5
}

#declare BGStarField =
pigment {
    granite
    color_map {
        [0.00 0.72 color Black  color Black]    // No Stars in this area
        [0.72 0.75 color Gray20 color Gray40]   // Very Very Faint Stars
        [0.75 0.78 color Gray40 color Gray60]   // Very Faint Stars
        [0.78 0.81 color Gray60 color Gray80]   // Faint Stars
        [0.81 0.85 color Gray80 color Gray95]   // Medium White Stars
        [0.85 0.91 color Gray95 color White]    // White Stars
        [0.91 1.00 color Black  color Black]    // No Stars in this area
    }
    scale 0.015
}

#declare BGNebular =
pigment {
    gradient z
    pigment_map {
        [0.0 color Clear]
        [0.95 color Clear]
        [1.0
            bozo
            turbulence 0.6
            color_map {
                [0.00 color Clear]
                [0.19 color Clear]
                [0.50 color NewMidnightBlue]
                [0.76 color LightBlue]
                [1.00 color Clear]
            }
            scale 0.25
        ]
    }
}
