
// Persistence of Vision Ray Tracer Scene Description File
// File: BGSF2.pov
// Vers: 3
// Desc: Fighting Starships
// Date: 02.10. - 30.10.1996
// Auth: Bjoern Graf <bgraf@mail.pin-net.de>

#include "colors.inc"
#include "sf.inc"
#include "BGround.inc"
#include "Starship.inc"
#include "Fighter.inc"

global_settings {max_trace_level 10}

camera {
    location <0, 2, -5>
    look_at <0, 2, 0>
}

light_source {
    <-10000, 10000, -5000>
    color White
}

light_source {
    <0, 10000, 0>
    color White
/*    area_light <0, -100, -100>, <0, 100, 100>, 15, 15
    adaptive 2*/
//    jitter JITTER
}

sky_sphere {
    pigment {BGStarField}
    pigment {
        BGNebular
        rotate <-7, -24, 0>
    }
}

// Object declares
#declare Visor =
union {
    // Visor
    difference {
        intersection {
            sphere {0, 0.4}
            box {<-0.41, 0, 0>, <0.41, 0.41, 0.41> rotate x * 45}
        }
        sphere {0, 0.39}
        texture {T_Silver_1A
            finish {ambient 0.1 reflection 0.5}
        }
        texture {
            pigment {
                spotted
                turbulence 1
                color_map {
                    [0.0 color Clear]
                    [0.5 color P_Silver1 filter 1]
                    [1.0 color P_Silver1 * 0.5]
                }
            }
            scale 0.25
            rotate y * 45
        }
    }
    // top edge
    difference {
        cylinder {0, <0, 0.01, 0>, 0.41}
        cylinder {<0, -0.01, 0>, <0, 0.02, 0>, 0.39}
        box {<-0.42, -0.02, 0>, <0.42, 0.03, -0.42>}
        rotate x * -45
    }
    // bottom edge
    difference {
        cylinder {0, <0, 0.01, 0>, 0.41}
        cylinder {<0, -0.01, 0>, <0, 0.02, 0>, 0.39}
        box {<-0.42, -0.02, 0>, <0.42, 0.03, -0.42>}
        rotate x * 45
    }
    // Visorrest
    intersection {
        box {<-0.42, -0.11, -0.05>, <0.42, 0.11, 0.10>}
        difference {
            sphere {0, 0.41}
            sphere {0, 0.39}
        }
    }
}

#declare Helmet =
union {
    object {Visor}
    difference {
        sphere {0, 0.39}
        sphere {0, 0.38}
        cylinder {<0, 0, 0>, <0, -0.4, 0>, 0.27}
    }
    // verbindung
    difference {
        cylinder {<0, -0.27, 0>, <0, -0.30, 0>, 0.27}
        cylinder {<0, -0.26, 0>, <0, -0.31, 0>, 0.26}
    }
    texture {
        pigment {color White}
        finish {F_MetalA
            reflection 0
        }
    }
    texture {
        pigment {
            spotted
            turbulence 1
            color_map {
                [0.0 color Clear]
                [0.5 color Clear]
                [1.0 color Gray50]//White]
            }
        }
        scale 0.25
        rotate <-45, 0, -15>
    }
}

#declare SubHoleCM1 =
color_map {
    [0.0 color MidnightBlue filter 0.9]
    [0.25 color NewMidnightBlue]
    [1.0 color SteelBlue]
}

#declare SubHoleP1 =
pigment {
    gradient z
    color_map {
        [0.0 color White]
        [0.5 color NewMidnightBlue]
        [1.0 color Clear]
    }
}

#declare SubHoleP2 =
pigment {
    gradient z
    turbulence 0.25
    color_map {SubHoleCM1}
}

#declare SubHoleP3 =
pigment {
    spiral1 5
    turbulence 0.25
    pigment_map {
        [0.0 color Clear]
        [0.25 color Clear]
        [1.0 bozo
            color_map {SubHoleCM1}
            scale 0.5
        ]
    }
    scale 5
}

#declare SubHole =
union {
    difference {
        cylinder {0, <0, 0, 1>, 10}
        cone {0, 0, <0, 0, 1>, 10}
        pigment {
            bozo
            scale <1, 1, 2>
            pigment_map {
                [0.0 color Clear]
                [0.5 color Clear]
                [1.0 //SubHoleP1]
                    gradient z
                    color_map {
                        [0 color White filter 0.5]
                        [0.7 color Clear]
                    }
                ]
            }
        }
        finish {ambient 1}
        scale <1, 1, 10>
    }
    sphere {0, 1
        pigment {SubHoleP2 scale <1, 1, 1.1>}
        finish {ambient 1}
        scale <14, 14, 2.5>
        translate z * -2
    }
    disc {0, y, 30, 14
        rotate x * 90
        translate z * -2
        texture {
            pigment {SubHoleP3}
            finish {ambient 1}
        }
    }
    torus {22, 8
        rotate x * 90
        translate z * -2
        texture {
            pigment {
                bozo
                pigment_map {
                    [0.0 color Clear]
                    [0.1 color Clear]
                    [1.0 spiral1 5
                        turbulence 0.3
                        color_map {
                            [0.0 color White filter 0.5]
                            [0.75 color Clear]
                        }
                        scale 5
                    ]
                }
                scale 2
                rotate z * 45
            }
            finish {ambient 1}
        }
    }
}


object {Background}

// Astronaut
object {Helmet
    rotate <0, 180, -40>
    translate <-0.3, 1.75, -3.75>
}

// Spaceship (reflected in visor)
union {
    object {SpaceShip
        finish {ambient 0.35}
        translate z * -8
    }
    object {SubHole
        translate z * -16
        scale 2
    }
    scale 200
    rotate x * 15
    translate z * -2500
}

// Spaceship (lower right)
object {SpaceShip
    finish {ambient 0.25}
    scale 200
    rotate <-22, 0, 30>
    translate <2000, -1000, 6000>
}

union {
    object{LaserLeft translate z * 25}
    object{LaserRight translate z * 12}
    rotate y * -35
    rotate x * 45
    translate <200, 20, 400>
}

// Fighter (right above)
object {Fighter
    rotate y * -55
    rotate x * -45
    translate <200, 20, 400>
}

// Fighter (above)
union {
    object{LaserLeft translate z * 17}
    object{LaserRight translate z * 15}
    object {Fighter}
    rotate y * 150
    rotate x * -45
    translate <100, -10, 800>
}

// Fighter (above front)
object {Fighter
    rotate y * -155
    rotate x * -55
    rotate z * -25
    translate <25, 16, 50>
}

// Wreck
union {
    object {Cannon}
    intersection {
        difference {
            sphere {0, 1 scale <10, 1.4, 12>}
            sphere {0, 1 scale <9.8, 1.2, 11.8>}
        }
        union {
            box { 0, 2
                scale <1.12, 1, 0.7>
                translate <-1.12, 0, 0.77>
            }
            box { 0, 2
                scale <1.6, 1, 1>
                rotate <.0, 262.504, .0>
                translate <0.1950541, 0, -1.861>
            }
            box { 0, 2
                scale <1.16482, 1, 1>
                rotate <.0, 229.399, .0>
                translate <3.24245, 0, -1.10847>
            }
            box { 0, 2
                scale <1.6, 1, 1>
                rotate <.0, 29.0546, .0>
                translate <-0.5756803, 0, 0.6114857>
            }
            box { 0, 2
                scale <1.6, 1, 1>
                rotate <.0, 326.31, .0>
                translate <-2.04376, 0, -0.3867505>
            }
            box { 0, 2
                scale <1.6, 1, 1>
                translate <-1.6, 0, -1>
            }
            rotate y * 90
            translate x * 5.5
        }
        texture {BGFighterBodyTex}
        texture {
            pigment {
                bozo
                turbulence 1.25
                color_map {
                    [0.0 color Clear]
                    [0.5 color Clear]
                    [1.0 color Black]
                }
            }
        }
        translate <-5.5, -1.6, 0>
    }
    rotate <35, 115, 0>
    translate <-5, 7.5, 10>
}
