
// Persistence of Vision Ray Tracer Scene Description File
// File: Starship.inc, used by BGSF2.pov

#declare FrontHorn =
    union { //merge { // Poly_Pipe
        cone { <1.47711e-019, -1.22481e-009, -1.19493e-010>, 1, <2.17073e-011, -0.179995, -0.001381215>, 0.9742857 }
        sphere { <1.47711e-019, -1.22481e-009, -1.19493e-010>, 1 }
        cone { <2.17073e-011, -0.179995, -0.001381215>, 0.9742857, <4.36169e-011, -0.361668, 0.02930216>, 0.9485714 }
        sphere { <2.17073e-011, -0.179995, -0.001381215>, 0.9742857 }
        cone { <4.36169e-011, -0.361668, 0.02930216>, 0.9485714, <6.55525e-011, -0.5435563, 0.09180307>, 0.9228571 }
        sphere { <4.36169e-011, -0.361668, 0.02930216>, 0.9485714 }
        cone { <6.55525e-011, -0.5435563, 0.09180307>, 0.9228571, <8.73374e-011, -0.7241953, 0.1856183>, 0.8971429 }
        sphere { <6.55525e-011, -0.5435563, 0.09180307>, 0.9228571 }
        cone { <8.73374e-011, -0.7241953, 0.1856183>, 0.8971429, <1.08796e-010, -0.9021306, 0.3099925>, 0.8714286 }
        sphere { <8.73374e-011, -0.7241953, 0.1856183>, 0.8971429 }
        cone { <1.08796e-010, -0.9021306, 0.3099925>, 0.8714286, <1.29756e-010, -1.07593, 0.4639243>, 0.8457143 }
        sphere { <1.08796e-010, -0.9021306, 0.3099925>, 0.8714286 }
        cone { <1.29756e-010, -1.07593, 0.4639243>, 0.8457143, <1.50049e-010, -1.24419, 0.6461743>, 0.82 }
        sphere { <1.29756e-010, -1.07593, 0.4639243>, 0.8457143 }
        cone { <1.50049e-010, -1.24419, 0.6461743>, 0.82, <1.6951e-010, -1.40557, 0.8552752>, 0.7942857 }
        sphere { <1.50049e-010, -1.24419, 0.6461743>, 0.82 }
        cone { <1.6951e-010, -1.40557, 0.8552752>, 0.7942857, <1.87984e-010, -1.55875, 1.08954>, 0.7685714 }
        sphere { <1.6951e-010, -1.40557, 0.8552752>, 0.7942857 }
        cone { <1.87984e-010, -1.55875, 1.08954>, 0.7685714, <2.05322e-010, -1.70251, 1.34709>, 0.7428571 }
        sphere { <1.87984e-010, -1.55875, 1.08954>, 0.7685714 }
        cone { <2.05322e-010, -1.70251, 1.34709>, 0.7428571, <2.21383e-010, -1.83569, 1.62585>, 0.7171429 }
        sphere { <2.05322e-010, -1.70251, 1.34709>, 0.7428571 }
        cone { <2.21383e-010, -1.83569, 1.62585>, 0.7171429, <2.36039e-010, -1.95722, 1.92357>, 0.6914286 }
        sphere { <2.21383e-010, -1.83569, 1.62585>, 0.7171429 }
        cone { <2.36039e-010, -1.95722, 1.92357>, 0.6914286, <2.49172e-010, -2.06611, 2.23785>, 0.6657143 }
        sphere { <2.36039e-010, -1.95722, 1.92357>, 0.6914286 }
        cone { <2.49172e-010, -2.06611, 2.23785>, 0.6657143, <2.60676e-010, -2.1615, 2.56618>, 0.64 }
        sphere { <2.49172e-010, -2.06611, 2.23785>, 0.6657143 }
        cone { <2.60676e-010, -2.1615, 2.56618>, 0.64, <2.70458e-010, -2.24261, 2.90589>, 0.6142857 }
        sphere { <2.60676e-010, -2.1615, 2.56618>, 0.64 }
        cone { <2.70458e-010, -2.24261, 2.90589>, 0.6142857, <2.78439e-010, -2.3088, 3.25426>, 0.5885714 }
        sphere { <2.70458e-010, -2.24261, 2.90589>, 0.6142857 }
        cone { <2.78439e-010, -2.3088, 3.25426>, 0.5885714, <2.84556e-010, -2.35952, 3.60848>, 0.5628571 }
        sphere { <2.78439e-010, -2.3088, 3.25426>, 0.5885714 }
        cone { <2.84556e-010, -2.35952, 3.60848>, 0.5628571, <2.88759e-010, -2.39437, 3.96571>, 0.5371429 }
        sphere { <2.84556e-010, -2.35952, 3.60848>, 0.5628571 }
        cone { <2.88759e-010, -2.39437, 3.96571>, 0.5371429, <2.91015e-010, -2.41307, 4.32305>, 0.5114286 }
        sphere { <2.88759e-010, -2.39437, 3.96571>, 0.5371429 }
        cone { <2.91015e-010, -2.41307, 4.32305>, 0.5114286, <2.91304e-010, -2.41547, 4.67765>, 0.4857143 }
        sphere { <2.91015e-010, -2.41307, 4.32305>, 0.5114286 }
        cone { <2.91304e-010, -2.41547, 4.67765>, 0.4857143, <2.89625e-010, -2.40155, 5.02663>, 0.46 }
        sphere { <2.91304e-010, -2.41547, 4.67765>, 0.4857143 }
        cone { <2.89625e-010, -2.40155, 5.02663>, 0.46, <2.85991e-010, -2.37142, 5.3672>, 0.4342857 }
        sphere { <2.89625e-010, -2.40155, 5.02663>, 0.46 }
        cone { <2.85991e-010, -2.37142, 5.3672>, 0.4342857, <2.80432e-010, -2.32532, 5.6966>, 0.4085714 }
        sphere { <2.85991e-010, -2.37142, 5.3672>, 0.4342857 }
        cone { <2.80432e-010, -2.32532, 5.6966>, 0.4085714, <2.72992e-010, -2.26363, 6.0122>, 0.3828571 }
        sphere { <2.80432e-010, -2.32532, 5.6966>, 0.4085714 }
        cone { <2.72992e-010, -2.26363, 6.0122>, 0.3828571, <2.63731e-010, -2.18684, 6.31144>, 0.3571429 }
        sphere { <2.72992e-010, -2.26363, 6.0122>, 0.3828571 }
        cone { <2.63731e-010, -2.18684, 6.31144>, 0.3571429, <2.52724e-010, -2.09557, 6.59192>, 0.3314286 }
        sphere { <2.63731e-010, -2.18684, 6.31144>, 0.3571429 }
        cone { <2.52724e-010, -2.09557, 6.59192>, 0.3314286, <2.40059e-010, -1.99055, 6.85138>, 0.3057143 }
        sphere { <2.52724e-010, -2.09557, 6.59192>, 0.3314286 }
        cone { <2.40059e-010, -1.99055, 6.85138>, 0.3057143, <2.25839e-010, -1.87264, 7.08773>, 0.28 }
        sphere { <2.40059e-010, -1.99055, 6.85138>, 0.3057143 }
        cone { <2.25839e-010, -1.87264, 7.08773>, 0.28, <2.10177e-010, -1.74277, 7.29906>, 0.2542857 }
        sphere { <2.25839e-010, -1.87264, 7.08773>, 0.28 }
        cone { <2.10177e-010, -1.74277, 7.29906>, 0.2542857, <1.932e-010, -1.602, 7.48368>, 0.2285714 }
        sphere { <2.10177e-010, -1.74277, 7.29906>, 0.2542857 }
        cone { <1.932e-010, -1.602, 7.48368>, 0.2285714, <1.75045e-010, -1.45146, 7.6401>, 0.2028571 }
        sphere { <1.932e-010, -1.602, 7.48368>, 0.2285714 }
        cone { <1.75045e-010, -1.45146, 7.6401>, 0.2028571, <1.55858e-010, -1.29236, 7.76707>, 0.1771429 }
        sphere { <1.75045e-010, -1.45146, 7.6401>, 0.2028571 }
        cone { <1.55858e-010, -1.29236, 7.76707>, 0.1771429, <1.35793e-010, -1.12598, 7.86354>, 0.1514286 }
        sphere { <1.55858e-010, -1.29236, 7.76707>, 0.1771429 }
        cone { <1.35793e-010, -1.12598, 7.86354>, 0.1514286, <1.15012e-010, -0.9536676, 7.92876>, 0.1257143 }
        sphere { <1.35793e-010, -1.12598, 7.86354>, 0.1514286 }
        cone { <1.15012e-010, -0.9536676, 7.92876>, 0.1257143, <9.36815e-011, -0.7767997, 7.9622>, 0.1 }
        sphere { <1.15012e-010, -0.9536676, 7.92876>, 0.1257143 }
        sphere { <9.36815e-011, -0.7767997, 7.9622>, 0.1 }
}

#declare MiddleHorn =
union { //merge { // Poly_Pipe
   cone { <0, 0, 0>, 1, <0, 0.323992, -0.02559494>, 0.9441176 }
   sphere { <0, 0, 0>, 1 }
   cone { <0, 0.323992, -0.02559494>, 0.9441176, <0, 0.6452199, -0.1021614>, 0.8882353 }
   sphere { <0, 0.323992, -0.02559494>, 0.9441176 }
   cone { <0, 0.6452199, -0.1021614>, 0.8882353, <0, 0.960943, -0.2290461>, 0.8323529 }
   sphere { <0, 0.6452199, -0.1021614>, 0.8882353 }
   cone { <0, 0.960943, -0.2290461>, 0.8323529, <0, 1.26847, -0.4051666>, 0.7764706 }
   sphere { <0, 0.960943, -0.2290461>, 0.8323529 }
   cone { <0, 1.26847, -0.4051666>, 0.7764706, <0, 1.56517, -0.6290203>, 0.7205882 }
   sphere { <0, 1.26847, -0.4051666>, 0.7764706 }
   cone { <0, 1.56517, -0.6290203>, 0.7205882, <0, 1.84852, -0.8986972>, 0.6647059 }
   sphere { <0, 1.56517, -0.6290203>, 0.7205882 }
   cone { <0, 1.84852, -0.8986972>, 0.6647059, <0, 2.1161, -1.2119>, 0.6088235 }
   sphere { <0, 1.84852, -0.8986972>, 0.6647059 }
   cone { <0, 2.1161, -1.2119>, 0.6088235, <0, 2.36562, -1.56595>, 0.5529412 }
   sphere { <0, 2.1161, -1.2119>, 0.6088235 }
   cone { <0, 2.36562, -1.56595>, 0.5529412, <0, 2.59496, -1.95783>, 0.4970588 }
   sphere { <0, 2.36562, -1.56595>, 0.5529412 }
   cone { <0, 2.59496, -1.95783>, 0.4970588, <0, 2.80217, -2.38419>, 0.4411765 }
   sphere { <0, 2.59496, -1.95783>, 0.4970588 }
   cone { <0, 2.80217, -2.38419>, 0.4411765, <0, 2.98546, -2.84141>, 0.3852941 }
   sphere { <0, 2.80217, -2.38419>, 0.4411765 }
   cone { <0, 2.98546, -2.84141>, 0.3852941, <0, 3.14329, -3.32557>, 0.3294118 }
   sphere { <0, 2.98546, -2.84141>, 0.3852941 }
   cone { <0, 3.14329, -3.32557>, 0.3294118, <0, 3.27429, -3.83255>, 0.2735294 }
   sphere { <0, 3.14329, -3.32557>, 0.3294118 }
   cone { <0, 3.27429, -3.83255>, 0.2735294, <0, 3.37736, -4.35802>, 0.2176471 }
   sphere { <0, 3.27429, -3.83255>, 0.2735294 }
   cone { <0, 3.37736, -4.35802>, 0.2176471, <0, 3.45162, -4.8975>, 0.1617647 }
   sphere { <0, 3.37736, -4.35802>, 0.2176471 }
   cone { <0, 3.45162, -4.8975>, 0.1617647, <0, 3.49643, -5.44639>, 0.1058824 }
   sphere { <0, 3.45162, -4.8975>, 0.1617647 }
   cone { <0, 3.49643, -5.44639>, 0.1058824, <0, 3.51141, -6>, 0.05 }
   sphere { <0, 3.49643, -5.44639>, 0.1058824 }
   sphere { <0, 3.51141, -6>, 0.05 }
}

#declare WArmL =
union { //merge { // Poly_Pipe
   cone { <-1.11022e-016, 0, -8.88178e-016>, 0.1, <-1, -0.1, -1.77636e-015>, 0.08 }
   cone { <-1, -0.1, -1.77636e-015>, 0.08, <-2, -0.35, -2.66454e-015>, 0.06 }
   sphere { <-1, -0.1, -1.77636e-015>, 0.08 }
   cone { <-2, -0.35, -2.66454e-015>, 0.06, <-3, -0.75, -3.55271e-015>, 0.04 }
   sphere { <-2, -0.35, -2.66454e-015>, 0.06 }
   cone { <-3, -0.75, -3.55271e-015>, 0.04, <-4, -1.35, -4.44089e-015>, 0.02 }
   sphere { <-3, -0.75, -3.55271e-015>, 0.04 }
   cone { <-4, -1.35, -4.44089e-015>, 0.02, <-5, -2.25, -5.32907e-015>, 0 }
   sphere { <-4, -1.35, -4.44089e-015>, 0.02 }
}

#declare WArmR = object {WArmL rotate y * 180}

#declare Front =
union {
   object {FrontHorn}
   object {FrontHorn rotate z * 90}
   object {FrontHorn rotate z * 180}
   object {FrontHorn rotate z * 270}
   object {WArmL rotate y * -15 translate <-2.8, 0, 3>}
   object {WArmL translate <-2.8, 0, 4>}
   object {WArmL rotate y * 15 translate <-2.8, 0, 5>}
   object {WArmR rotate y * 15 translate <2.8, 0, 3>}
   object {WArmR translate <2.8, 0, 4>}
   object {WArmR rotate y * -15 translate <2.8, 0, 5>}
   sphere {0, 1
      scale <2, 2, 3>
      translate z * 3
   }
}

#declare MP1 =
union {
   object {MiddleHorn}
   object {MiddleHorn rotate z * 90}
   object {MiddleHorn rotate z * 180}
   object {MiddleHorn rotate z * 270}
}

#declare MPSideR =
union {
   object {FrontHorn}
   object {FrontHorn rotate z * 90}
   object {FrontHorn rotate z * 180}
   object {FrontHorn rotate z * 270}
   object {WArmR rotate <0, 15, 90> translate <0, 2.8, 3>}
   object {WArmR rotate z * 90 translate <0, 2.8, 4>}
   object {WArmR rotate <0, -15, 90> translate <0, 2.8, 5>}
   object {WArmR rotate y * 15 translate <2.8, 0, 3>}
   object {WArmR translate <2.8, 0, 4>}
   object {WArmR rotate y * -15 translate <2.8, 0, 5>}
   sphere {0, 1
      scale <2, 2, 3>
      translate z * 3
   }
   rotate z * -45
}

#declare MPSideL =
union {
   object {FrontHorn}
   object {FrontHorn rotate z * 90}
   object {FrontHorn rotate z * 180}
   object {FrontHorn rotate z * 270}
   object {WArmL rotate <0, -15, -90> translate <0, 2.8, 3>}
   object {WArmL rotate z * -90 translate <0, 2.8, 4>}
   object {WArmL rotate <0, 15, -90> translate <0, 2.8, 5>}
   object {WArmL rotate y * -15 translate <-2.8, 0, 3>}
   object {WArmL translate <-2.8, 0, 4>}
   object {WArmL rotate y * 15 translate <-2.8, 0, 5>}
   sphere {0, 1
      scale <2, 2, 3>
      translate z * 3
   }
   rotate z * 45
}

#declare MiddlePart =
union {
   object {MP1}
   object {MP1
      rotate y * 180
      translate z * -12
   }
   sphere {0, 1
      scale <3.5, 2.5, 6.5>
      translate z * -6
   }
   object {MPSideR translate <3, -3, -8>}
   object {MPSideL translate <-3, -3, -8>}
}

#declare SpaceShip =
union {
   object {MiddlePart}
   object {Front}
   texture {BGSpaceShipBodyTex}
}
