// Includefile for Bridge.pov describing a stonebridge. 
// Dimensions (L*H*W) : 17 * 20 * 3 units.
// Robert Fredriksson   1996-08-25

#include "chain.inc"

// Cylinder for making the valves
#declare B_Cyl = object{
   Cylinder_Z
   scale<1.0, 1.0, 3.0>   
}
   
// The upper part (Base)
#declare B_Base = difference{
   object{
      box{
         <0.0, 0.0, 0.0>,
         <17.0, 1.5, 3.0>
      }
   }
   object{
      B_Cyl
      translate<-0.5, 0.0, 0.0>
   }
   object{
      B_Cyl
      translate<2.5, 0.0, 0.0>
   }
   object{
      B_Cyl
      translate<5.5, 0.0, 0.0>
   } 
   object{
      B_Cyl
      translate<8.5, 0.0, 0.0>
   }
   object{
      B_Cyl
      translate<11.5, 0.0, 0.0>
   }
   object{
      B_Cyl
      translate<14.5, 0.0, 0.0>
   }
}

// The pillars
#declare B_Pillar = object{
   box{
      <0.0, 0.0, 0.0>,
      <1.0, 20.0, 3.0>
   }
}

//Pillar for the chain
#declare B_Pillar1 = object{
   cylinder{
      <0.0, 0.0, 0.0>,
      <0.0, 1.0, 0.0>,
      0.2
   }
/*   torus{
      0.20, 0.1
   }*/
   texture{
      Brick2
   }
   scale<1.0, 1.5, 1.0>
}

#declare B_Chain = difference{
   object{
      Chain
   }
   object{
      plane{
         -y,2
      }
   }
}

// The bridge
#declare B_Bridge = union{
   object{
      B_Base
      translate<0.0, 20.0, 0.0>
   }
   object{
      B_Pillar
      translate<0.5, 0.0, 0.0>
   }

   object{
      B_Pillar
      translate<3.5, 0.0, 0.0>
   }
   object{
      B_Pillar
      translate<6.5, 0.0, 0.0>
   }
   object{
      B_Pillar
      translate<9.5, 0.0, 0.0>
   }
   object{
      B_Pillar
      translate<12.5, 0.0, 0.0>
   }
   object{
      B_Pillar
      translate<15.5, 0.0, 0.0>
   }
   texture{
      Brick2
   }
}

#declare Bridge = union{
   object{
      B_Bridge
   }

  //Faraway side
   object{
      B_Pillar1
      translate<1.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<3.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<5.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<7.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<9.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<11.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<13.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<15.0, 21.5, 2.8>
   }
   object{
      B_Pillar1
      translate<17.0, 21.5, 2.8>
   }
   object{
      B_Chain
      translate<1.0, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<11.0, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<21.0, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<30.5, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<40.25, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<49.0, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<58.5, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<68.0, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<78.5, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<87.75, 66.5, 10.0>
      scale<0.2, 0.35, 0.2>
      scale 1.0
   }


  // Close side

   object{
      B_Pillar1
      translate<1.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<3.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<5.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<7.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<9.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<11.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<13.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<15.0, 21.5, 0.2>
   }
   object{
      B_Pillar1
      translate<17.0, 21.5, 0.2>
   }
   object{
      B_Chain
      translate<-8.0, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<2.75, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<13.5, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<24.5, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<35.25, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<46.25, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<57.0, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<68.0, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
   object{
      B_Chain
      translate<78.5, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }
/*   object{
      B_Chain
      translate<89.5, 72.5, 23.0>
      scale<0.23, 0.35, 0.2>
      scale 1.0
   }*/
}












