// ********  TEXTURES  *******

#include "model.tex"

// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******
// debut forteresse
#declare main_hall = union {
  cylinder { // main_hall_wall
    <0,0,1>, <0,0,0>, 1 
  }
  sphere { // main_hall_roof
    <0,0,0>,1
    scale <1.0, 1.0, 0.5>
    translate  1.0*z
  }
  cylinder { // main_hall_ring
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 0.2>
    translate  0.9*z
  }
  texture {
    pierre
  }
  translate  0.7*x
}
#declare tower_cylinder = difference {
  cylinder { // tower_cyl
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 2.0>
    translate  2.2*x
  }
  cylinder { // tower_cyl_cut
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    translate  2.2*x
  }
}
#declare door_cut_A_1 = merge {
  box { // door_cut_bottom
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -15.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_2 = merge {
  box { // door_cut_bott1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -45.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_3 = merge {
  box { // door_cut_bott2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -75.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_4 = merge {
  box { // door_cut_bott3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -105.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_5 = merge {
  box { // door_cut_bott4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -135.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_6 = merge {
  box { // door_cut_bott5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -165.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cuts_A = merge {
  object { door_cut_A_1 }
  object { door_cut_A_2 }
  object { door_cut_A_3 }
  object { door_cut_A_4 }
  object { door_cut_A_5 }
  object { door_cut_A_6 }
}
#declare tower_floor_a = difference {
  cylinder { // floor_a
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // floor_a_cut
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    translate  <2.2, 0.0, 2.0>
  }
  object { door_cuts_A }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare tower_rambarde = difference {
  cylinder { // ramb
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // ramb_cut
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.21>
    translate  <2.2, 0.0, 2.0>
  }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare beam_A_1 = difference {
  box { // beam_a
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_2 = difference {
  box { // beam_a1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -30.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_3 = difference {
  box { // beam_a2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -60.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_4 = difference {
  box { // beam_a3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -90.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_5 = difference {
  box { // beam_a4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -120.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_6 = difference {
  box { // beam_a5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -150.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beams_A = union {
  object { beam_A_1 }
  object { beam_A_2 }
  object { beam_A_3 }
  object { beam_A_4 }
  object { beam_A_5 }
  object { beam_A_6 }
  scale <1.0, 1.0, 0.5>
  translate  1.45*z
}
#declare Roof_A = union {
  cone { // tower_roof_a
    <0,0,0>, 0.45, <0,0,1>, 1.0
    texture {
      pierre
    }
    scale <0.9, 0.9, 0.3>
    rotate -180.0*x
    translate  <2.2, 0.0, 2.9>
  }
  object { beams_A }
  translate  -0.3*z
}
#declare door_cut_A_7 = merge {
  box { // door_cut_bott6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top6
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -15.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_8 = merge {
  box { // door_cut_bott7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top7
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -45.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_9 = merge {
  box { // door_cut_bott8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top8
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -75.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_10 = merge {
  box { // door_cut_bott9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top9
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -105.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_11 = merge {
  box { // door_cut_bot10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top10
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -135.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_12 = merge {
  box { // door_cut_bot11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top11
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -165.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cuts_A1 = merge {
  object { door_cut_A_7 }
  object { door_cut_A_8 }
  object { door_cut_A_9 }
  object { door_cut_A_10 }
  object { door_cut_A_11 }
  object { door_cut_A_12 }
}
#declare tower_floor_b = difference {
  cylinder { // floor_a1
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // floor_a_cut1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    translate  <2.2, 0.0, 2.0>
  }
  object { door_cuts_A1 }
  scale <0.7, 0.7, 0.4>
  translate  <0.66, 0.0, 1.8>
}
#declare beam_A_7 = difference {
  box { // beam_a6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_8 = difference {
  box { // beam_a7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -30.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_9 = difference {
  box { // beam_a8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -60.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_10 = difference {
  box { // beam_a9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -90.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_11 = difference {
  box { // beam_a10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -120.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_12 = difference {
  box { // beam_a11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -150.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beams_A1 = union {
  object { beam_A_7 }
  object { beam_A_8 }
  object { beam_A_9 }
  object { beam_A_10 }
  object { beam_A_11 }
  object { beam_A_12 }
  scale <1.0, 1.0, 0.5>
  translate  1.45*z
}
#declare Roof_B = union {
  cone { // tower_roof_a1
    <0,0,0>, 0.45, <0,0,1>, 1.0
    texture {
      pierre
    }
    scale <0.9, 0.9, 0.3>
    rotate -180.0*x
    translate  <2.2, 0.0, 2.9>
  }
  object { beams_A1 }
  scale <0.7, 0.7, 1.0>
  translate  <0.66, 0.0, 0.24>
}
#declare main_tower = union {
  object { tower_cylinder }
  object { tower_floor_a }
  object { tower_rambarde }
  cone { // tower_under_par
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 1.8>
  }
  cone { // tower_apex_1
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale 0.3
    translate  <2.2, 0.0, 2.92>
  }
  cone { // tower_apex_2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.3, 0.3, 0.5>
    rotate 180.0*x
    translate  <2.2, 0.0, 3.72>
  }
  object { Roof_A }
  object { tower_floor_b }
  cylinder { // balcon_B
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.1>
    translate  <2.2, 0.0, 2.53>
  }
  object { Roof_B }
  texture {
    pierre
  }
}
#declare High_Wall = difference {
  cone { // main_outer_wall
    <0,0,0>, 0.8, <0,0,1>, 1.0
    rotate 180.0*x
    translate  1.0*z
  }
  cylinder { // main_inner_wall
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 1.01>
  }
}
#declare renfort_1 = difference {
  box { // support_base_1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -15.0*z
}
#declare renfort_2 = difference {
  box { // support_base_2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -30.0*z
}
#declare renfort_3 = difference {
  box { // support_base_3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_3
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -45.0*z
}
#declare renfort_4 = difference {
  box { // support_base_4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_4
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -60.0*z
}
#declare renfort_5 = difference {
  box { // support_base_5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_5
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -75.0*z
}
#declare renfort_6 = difference {
  box { // support_base_6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_6
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -90.0*z
}
#declare renfort_7 = difference {
  box { // support_base_7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_7
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -105.0*z
}
#declare renfort_8 = difference {
  box { // support_base_8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_8
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -120.0*z
}
#declare renfort_9 = difference {
  box { // support_base_9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_9
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -135.0*z
}
#declare renfort_10 = difference {
  box { // support_base10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_10
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -150.0*z
}
#declare renfort_11 = difference {
  box { // support_base11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_11
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -165.0*z
}
#declare renfort_12 = difference {
  box { // support_base12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_12
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -180.0*z
}
#declare renfort_25 = difference {
  box { // support_base25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_25
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -195.0*z
}
#declare renfort_26 = difference {
  box { // support_base26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_26
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -210.0*z
}
#declare renfort_27 = difference {
  box { // support_base27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_27
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -225.0*z
}
#declare renfort_28 = difference {
  box { // support_base28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_28
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -240.0*z
}
#declare renfort_29 = difference {
  box { // support_base29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_29
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -255.0*z
}
#declare renfort_30 = difference {
  box { // support_base30
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_30
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -270.0*z
}
#declare renfort_31 = difference {
  box { // support_base31
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_31
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -285.0*z
}
#declare renfort_32 = difference {
  box { // support_base32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_32
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -300.0*z
}
#declare renfort_33 = difference {
  box { // support_base33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_33
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -315.0*z
}
#declare renfort_34 = difference {
  box { // support_base34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_34
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -330.0*z
}
#declare renfort_35 = difference {
  box { // support_base35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_35
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -345.0*z
}
#declare renfort_36 = difference {
  box { // support_base36
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_36
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -360.0*z
}
#declare enceinte_1 = union {
  object { High_Wall }
  object { renfort_1 }
  object { renfort_2 }
  object { renfort_3 }
  object { renfort_4 }
  object { renfort_5 }
  object { renfort_6 }
  object { renfort_7 }
  object { renfort_8 }
  object { renfort_9 }
  object { renfort_10 }
  object { renfort_11 }
  object { renfort_12 }
  object { renfort_25 }
  object { renfort_26 }
  object { renfort_27 }
  object { renfort_28 }
  object { renfort_29 }
  object { renfort_30 }
  object { renfort_31 }
  object { renfort_32 }
  object { renfort_33 }
  object { renfort_34 }
  object { renfort_35 }
  object { renfort_36 }
  texture {
    pierre
  }
  scale <2.65, 1.75, 1.0>
}
#declare High_Wall1 = difference {
  cone { // main_outer_wa2
    <0,0,0>, 0.8, <0,0,1>, 1.0
    rotate 180.0*x
    translate  1.0*z
  }
  cylinder { // main_inner_wa2
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 1.01>
  }
}
#declare renfort_13 = difference {
  box { // support_base13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_13
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -15.0*z
}
#declare renfort_14 = difference {
  box { // support_base14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_14
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -30.0*z
}
#declare renfort_15 = difference {
  box { // support_base15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_15
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -60.0*z
}
#declare renfort_16 = difference {
  box { // support_base16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_16
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -90.0*z
}
#declare renfort_17 = difference {
  box { // support_base17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_17
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -120.0*z
}
#declare renfort_18 = difference {
  box { // support_base18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_18
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -135.0*z
}
#declare renfort_20 = difference {
  box { // support_base20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_20
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -225.0*z
}
#declare renfort_21 = difference {
  box { // support_base21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_21
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -240.0*z
}
#declare renfort_22 = difference {
  box { // support_base22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_22
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -270.0*z
}
#declare renfort_23 = difference {
  box { // support_base23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_23
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -300.0*z
}
#declare renfort_24 = difference {
  box { // support_base24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_24
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate -330.0*z
}
#declare renfort_37 = difference {
  box { // support_base37
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.02, 0.52>
    rotate -11.0*y
    translate  <0.92, 0.0, 0.5>
  }
  box { // support_cut_37
    <-1, -1, -1>, <1, 1, 1>
    scale 0.1
    rotate 5.0*y
    translate  <0.85, -0.03, 0.94>
  }
  rotate 15.0*z
}
#declare enceinte_2 = union {
  object { High_Wall1 }
  object { renfort_13 }
  object { renfort_14 }
  object { renfort_15 }
  object { renfort_16 }
  object { renfort_17 }
  object { renfort_18 }
  object { renfort_20 }
  object { renfort_21 }
  object { renfort_22 }
  object { renfort_23 }
  object { renfort_24 }
  object { renfort_37 }
  texture {
    pierre
  }
  scale <2.65, 1.75, 1.0>
  translate  <4.0, 0.0, -0.4>
}
#declare Lat_cyl_1 = difference {
  cylinder { // tower_cyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 2.0>
    translate  2.2*x
  }
  cylinder { // tower_cyl_cut4
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    translate  2.2*x
  }
}
#declare door_cut_A_49 = merge {
  box { // door_cut_bot48
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top48
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -15.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_50 = merge {
  box { // door_cut_bot49
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top49
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -45.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_51 = merge {
  box { // door_cut_bot50
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top50
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -75.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_52 = merge {
  box { // door_cut_bot51
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top51
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -105.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_53 = merge {
  box { // door_cut_bot52
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top52
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -135.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_54 = merge {
  box { // door_cut_bot53
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top53
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -165.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cuts_A8 = merge {
  object { door_cut_A_49 }
  object { door_cut_A_50 }
  object { door_cut_A_51 }
  object { door_cut_A_52 }
  object { door_cut_A_53 }
  object { door_cut_A_54 }
}
#declare Lat_floor_a_1 = difference {
  cylinder { // floor_a8
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // floor_a_cut8
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    translate  <2.2, 0.0, 2.0>
  }
  object { door_cuts_A8 }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare Lat_rambard_1 = difference {
  cylinder { // ramb4
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // ramb_cut4
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.21>
    translate  <2.2, 0.0, 2.0>
  }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare beam_A_13 = difference {
  box { // beam_a12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_14 = difference {
  box { // beam_a13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -30.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_15 = difference {
  box { // beam_a14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -60.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_16 = difference {
  box { // beam_a15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -90.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_17 = difference {
  box { // beam_a16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -120.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_18 = difference {
  box { // beam_a17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -150.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beams_A2 = union {
  object { beam_A_13 }
  object { beam_A_14 }
  object { beam_A_15 }
  object { beam_A_16 }
  object { beam_A_17 }
  object { beam_A_18 }
  scale <1.0, 1.0, 0.5>
  translate  1.45*z
}
#declare Roof_A_1 = union {
  cone { // tower_roof_a2
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    texture {
      pierre
    }
    scale <0.9, 0.9, 0.3>
    rotate -180.0*x
    translate  <2.2, 0.0, 2.9>
  }
  object { beams_A2 }
  translate  -0.3*z
}
#declare lateral_1 = union {
  object { Lat_cyl_1 }
  object { Lat_floor_a_1 }
  object { Lat_rambard_1 }
  cone { // lat_under_A_1
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 1.8>
  }
  cone { // lat_apex_bot_1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 0.3
    translate  <2.2, 0.0, 2.35>
  }
  cone { // lat_apex_top_1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 0.3
    rotate 180.0*x
    translate  <2.2, 0.0, 2.95>
  }
  object { Roof_A_1 }
  texture {
    pierre
  }
  scale <0.5, 0.5, 0.7>
  translate  <4.7, 1.0, -0.4>
}
#declare Lat_cyl_2 = difference {
  cylinder { // tower_cyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 2.0>
    translate  2.2*x
  }
  cylinder { // tower_cyl_cut5
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    translate  2.2*x
  }
}
#declare door_cut_A_55 = merge {
  box { // door_cut_bot54
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top54
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -15.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_56 = merge {
  box { // door_cut_bot55
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top55
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -45.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_57 = merge {
  box { // door_cut_bot56
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top56
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -75.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_58 = merge {
  box { // door_cut_bot57
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top57
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -105.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_59 = merge {
  box { // door_cut_bot58
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top58
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -135.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_60 = merge {
  box { // door_cut_bot59
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top59
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -165.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cuts_A9 = merge {
  object { door_cut_A_55 }
  object { door_cut_A_56 }
  object { door_cut_A_57 }
  object { door_cut_A_58 }
  object { door_cut_A_59 }
  object { door_cut_A_60 }
}
#declare Lat_floor_a_2 = difference {
  cylinder { // floor_a9
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // floor_a_cut9
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    translate  <2.2, 0.0, 2.0>
  }
  object { door_cuts_A9 }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare Lat_rambard_2 = difference {
  cylinder { // ramb5
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // ramb_cut5
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.21>
    translate  <2.2, 0.0, 2.0>
  }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare beam_A_19 = difference {
  box { // beam_a18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_20 = difference {
  box { // beam_a19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -30.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_21 = difference {
  box { // beam_a20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -60.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_22 = difference {
  box { // beam_a21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -90.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_23 = difference {
  box { // beam_a22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -120.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_24 = difference {
  box { // beam_a23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -150.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beams_A3 = union {
  object { beam_A_19 }
  object { beam_A_20 }
  object { beam_A_21 }
  object { beam_A_22 }
  object { beam_A_23 }
  object { beam_A_24 }
  scale <1.0, 1.0, 0.5>
  translate  1.45*z
}
#declare Roof_A_2 = union {
  cone { // tower_roof_a3
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    texture {
      pierre
    }
    scale <0.9, 0.9, 0.3>
    rotate -180.0*x
    translate  <2.2, 0.0, 2.9>
  }
  object { beams_A3 }
  translate  -0.3*z
}
#declare lateral_2 = union {
  object { Lat_cyl_2 }
  object { Lat_floor_a_2 }
  object { Lat_rambard_2 }
  cone { // lat_under_A_2
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 1.8>
  }
  cone { // lat_apex_bot_2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 0.3
    translate  <2.2, 0.0, 2.35>
  }
  cone { // lat_apex_top_2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 0.3
    rotate 180.0*x
    translate  <2.2, 0.0, 2.95>
  }
  object { Roof_A_2 }
  texture {
    pierre
  }
  scale <0.5, 0.5, 0.7>
  translate  <4.7, -1.0, -0.4>
}
#declare Lat_cyl_3 = difference {
  cylinder { // tower_cyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 2.0>
    translate  2.2*x
  }
  cylinder { // tower_cyl_cut6
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    translate  2.2*x
  }
}
#declare door_cut_A_61 = merge {
  box { // door_cut_bot60
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top60
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -15.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_62 = merge {
  box { // door_cut_bot61
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top61
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -45.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_63 = merge {
  box { // door_cut_bot62
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top62
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -75.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_64 = merge {
  box { // door_cut_bot63
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top63
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -105.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_65 = merge {
  box { // door_cut_bot64
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top64
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -135.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_66 = merge {
  box { // door_cut_bot65
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top65
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -165.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cuts_A10 = merge {
  object { door_cut_A_61 }
  object { door_cut_A_62 }
  object { door_cut_A_63 }
  object { door_cut_A_64 }
  object { door_cut_A_65 }
  object { door_cut_A_66 }
}
#declare Lat_floor_a_3 = difference {
  cylinder { // floor_a10
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // floor_a_cut10
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    translate  <2.2, 0.0, 2.0>
  }
  object { door_cuts_A10 }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare Lat_rambard_3 = difference {
  cylinder { // ramb6
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // ramb_cut6
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.21>
    translate  <2.2, 0.0, 2.0>
  }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare beam_A_25 = difference {
  box { // beam_a24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_26 = difference {
  box { // beam_a25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -30.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_27 = difference {
  box { // beam_a26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -60.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_28 = difference {
  box { // beam_a27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -90.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_29 = difference {
  box { // beam_a28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -120.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_30 = difference {
  box { // beam_a29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -150.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beams_A4 = union {
  object { beam_A_25 }
  object { beam_A_26 }
  object { beam_A_27 }
  object { beam_A_28 }
  object { beam_A_29 }
  object { beam_A_30 }
  scale <1.0, 1.0, 0.5>
  translate  1.45*z
}
#declare Roof_A_3 = union {
  cone { // tower_roof_a4
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    texture {
      pierre
    }
    scale <0.9, 0.9, 0.3>
    rotate -180.0*x
    translate  <2.2, 0.0, 2.9>
  }
  object { beams_A4 }
  translate  -0.3*z
}
#declare lateral_3 = union {
  object { Lat_cyl_3 }
  object { Lat_floor_a_3 }
  object { Lat_rambard_3 }
  cone { // lat_under_A_3
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 1.8>
  }
  cone { // lat_apex_bot_3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 0.3
    translate  <2.2, 0.0, 2.35>
  }
  cone { // lat_apex_top_3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 0.3
    rotate 180.0*x
    translate  <2.2, 0.0, 2.95>
  }
  object { Roof_A_3 }
  texture {
    pierre
  }
  scale <0.5, 0.5, 0.7>
  translate  <-3.0, -1.0, 0.0>
}
#declare Lat_cyl_4 = difference {
  cylinder { // tower_cyl7
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 2.0>
    translate  2.2*x
  }
  cylinder { // tower_cyl_cut7
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    translate  2.2*x
  }
}
#declare door_cut_A_67 = merge {
  box { // door_cut_bot66
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top66
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -15.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_68 = merge {
  box { // door_cut_bot67
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top67
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -45.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_69 = merge {
  box { // door_cut_bot68
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top68
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -75.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_70 = merge {
  box { // door_cut_bot69
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top69
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -105.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_71 = merge {
  box { // door_cut_bot70
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top70
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -135.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cut_A_72 = merge {
  box { // door_cut_bot71
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.2>
    translate  0.1*z
  }
  cylinder { // door_cut_top71
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.0>
    rotate -90.0*x
    translate  <0.0, -1.0, 0.3>
  }
  rotate -165.0*z
  translate  <2.2, 0.0, 2.07>
}
#declare door_cuts_A11 = merge {
  object { door_cut_A_67 }
  object { door_cut_A_68 }
  object { door_cut_A_69 }
  object { door_cut_A_70 }
  object { door_cut_A_71 }
  object { door_cut_A_72 }
}
#declare Lat_floor_a_4 = difference {
  cylinder { // floor_a11
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // floor_a_cut11
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.6>
    translate  <2.2, 0.0, 2.0>
  }
  object { door_cuts_A11 }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare Lat_rambard_4 = difference {
  cylinder { // ramb7
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 2.0>
  }
  cylinder { // ramb_cut7
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.21>
    translate  <2.2, 0.0, 2.0>
  }
  scale <1.0, 1.0, 0.5>
  translate  1.0*z
}
#declare beam_A_31 = difference {
  box { // beam_a30
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a30
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b30
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_32 = difference {
  box { // beam_a31
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a31
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b31
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -30.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_33 = difference {
  box { // beam_a32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -60.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_34 = difference {
  box { // beam_a33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -90.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_35 = difference {
  box { // beam_a34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -120.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beam_A_36 = difference {
  box { // beam_a35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 0.1>
  }
  box { // beam_a_cut_a35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate -70.0*x
    translate  -1.0*y
  }
  box { // beam_a_cut_b35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.11, 0.3, 0.11>
    rotate 70.0*x
    translate  1.0*y
  }
  texture {
    bois1
  }
  scale <0.3, 0.9, 0.3>
  rotate -150.0*z
  translate  <2.2, 0.0, 2.27>
}
#declare beams_A5 = union {
  object { beam_A_31 }
  object { beam_A_32 }
  object { beam_A_33 }
  object { beam_A_34 }
  object { beam_A_35 }
  object { beam_A_36 }
  scale <1.0, 1.0, 0.5>
  translate  1.45*z
}
#declare Roof_A_4 = union {
  cone { // tower_roof_a5
    <0,0,0>, 0.3, <0,0,1>, 1.0
    open
    texture {
      pierre
    }
    scale <0.9, 0.9, 0.3>
    rotate -180.0*x
    translate  <2.2, 0.0, 2.9>
  }
  object { beams_A5 }
  translate  -0.3*z
}
#declare lateral_4 = union {
  object { Lat_cyl_4 }
  object { Lat_floor_a_4 }
  object { Lat_rambard_4 }
  cone { // lat_under_A_4
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    scale <0.8, 0.8, 0.2>
    translate  <2.2, 0.0, 1.8>
  }
  cone { // lat_apex_bot_4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 0.3
    translate  <2.2, 0.0, 2.35>
  }
  cone { // lat_apex_top_4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 0.3
    rotate 180.0*x
    translate  <2.2, 0.0, 2.95>
  }
  object { Roof_A_4 }
  texture {
    pierre
  }
  scale <0.5, 0.5, 0.7>
  translate  <-3.0, 1.0, 0.0>
}
#declare barrack_base_1 = difference {
  cylinder { // barrack_wall_1
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // barrack_roof_1
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 0.2>
    translate  0.9*z
  }
}
#declare barrack_1 = union {
  sphere { // barrack_dome_1
    <0,0,0>,1
    scale <0.8, 0.8, 0.3>
    translate  0.9*z
  }
  object { barrack_base_1 }
  texture {
    pierre
  }
  scale <0.4, 0.4, 1.0>
  translate  <3.23, 0.69, -0.4>
}
#declare barrack_2 = difference {
  box { // barrack_base_2
    <-1, -1, -1>, <1, 1, 1>
  }
  box { // barrack_roof_2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bois1
    }
    scale <0.9, 0.9, 0.2>
    translate  0.9*z
  }
  texture {
    pierre
  }
  scale <0.3, 0.3, 0.55>
  rotate 10.0*z
  translate  <3.91, 0.87, 0.15>
}
#declare entrance = difference {
  box { // entrance_base
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 1.0, 1.0>
    translate  <-0.22, 0.0, 0.01>
  }
  box { // entrance_roof
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bois1
    }
    scale <0.8, 0.8, 0.2>
    translate  <0.09, 0.0, 1.05>
  }
  box { // entrance_cut_1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      pierre
    }
    scale <0.5, 1.1, 2.0>
    rotate 15.0*y
    translate  <-1.55, 0.0, 0.5>
  }
  box { // entrance_hole_a
    <-1, -1, -1>, <1, 1, 1>
    scale <0.666667, 0.333333, 0.666667>
    translate  <0.5, 0.0, -0.333333>
  }
  texture {
    pierre
  }
  scale 0.3
  translate  <7.42, 0.0, -0.1>
}
#declare pilier_1 = difference {
  box { // door_frame_ba1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.5>
    rotate -11.0*y
    translate  6.5*x
  }
  box { // door_fram_cut5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.3>
    translate  <6.5, 0.0, 0.7>
  }
  box { // door_fram_cut6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.6>
    rotate 8.0*x
    translate  <6.5, 0.55, 0.03>
  }
  box { // door_fram_cut7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.6>
    rotate -8.0*x
    translate  <6.5, -0.55, 0.03>
  }
  texture {
    pierre
  }
  scale <0.3, 0.1, 0.5>
  rotate -45.0*z
  translate  <6.38, 1.07, -0.17>
}
#declare pilier_2 = difference {
  box { // door_frame_ba2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.5>
    rotate -11.0*y
    translate  6.5*x
  }
  box { // door_fram_cut8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.3>
    translate  <6.5, 0.0, 0.7>
  }
  box { // door_fram_cut9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.6>
    rotate 8.0*x
    translate  <6.5, 0.55, 0.03>
  }
  box { // door_fram_cu10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.6>
    rotate -8.0*x
    translate  <6.5, -0.55, 0.03>
  }
  texture {
    pierre
  }
  scale <0.3, 0.1, 0.5>
  rotate 45.0*z
  translate  <6.38, -1.07, -0.17>
}
#declare couloir = difference {
  box { // couloir_base
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.2, 0.2>
    translate  <6.92, 0.0, -0.19>
  }
  box { // couloir_roofcut
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bois1
    }
    scale <0.25, 0.15, 0.05>
    translate  6.91*x
  }
}
#declare allee = union {
  object { couloir }
  cylinder { // couloir_roof
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.11, 0.5>
    rotate -90.0*y
    translate  7.16*x
  }
  translate  -0.01*z
}
#declare door_frame = difference {
  box { // door_frame_base
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.3, 0.5>
    rotate -11.0*y
    translate  6.5*x
  }
  box { // door_fram_cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.5, 0.3>
    translate  <6.5, 0.0, 0.7>
  }
  box { // door_fram_cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.6>
    rotate 8.0*x
    translate  <6.5, 0.55, 0.03>
  }
  box { // door_fram_cut3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.3, 0.6>
    rotate -8.0*x
    translate  <6.5, -0.55, 0.03>
  }
  box { // door_fram_cut4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bois1
    }
    scale <0.2, 0.15, 0.1>
    translate  <6.37, 0.0, 0.43>
  }
  texture {
    pierre
  }
}
#declare doors = union {
  object { allee }
  object { door_frame }
  texture {
    pierre
  }
}
#declare bloc_portes = union {
  object { entrance }
  sphere { // dome_entrance
    <0,0,0>,1
    texture {
      pierre
    }
    scale <0.2, 0.2, 0.15>
    translate  <7.445, 0.0, 0.15>
  }
  object { pilier_1 }
  object { pilier_2 }
  object { doors }
}
#declare fortress = union {
  object { main_hall }
  object { main_tower }
  object { enceinte_1 }
  object { enceinte_2 }
  object { lateral_1 }
  object { lateral_2 }
  object { lateral_3 }
  object { lateral_4 }
  object { barrack_1 }
  object { barrack_2 }
  object { bloc_portes }
  scale 0.3
}
// fin forteresse


//--
// debut girl
#include "girlstnd.inc"

#declare demobabe2_Ref = object {
  demobabe2
  texture {
    peau
  }
  scale <0.0095, 0.01, 0.01>
  rotate <90.0, 0.0, -90.0>
}
#declare corps = union {
  sphere { // main1
    <0,0,0>,1
    texture {
      peau
    }
    scale <0.26, 0.22, 0.32>
    rotate <20.0, 0.0, 0.0>
    translate  <-2.02, 0.37, -0.59>
  }
  sphere { // main2
    <0,0,0>,1
    texture {
      peau
    }
    scale <0.26, 0.22, 0.32>
    rotate <-20.0, 0.0, 0.0>
    translate  <2.02, 0.37, -0.59>
  }
}
#declare bijoux = union {
  cylinder { // bracelet_cyl_1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Texture1
    }
    scale <0.29, 0.29, 0.28>
    rotate <10.30195, 14.693177, 3.52012>
    translate  <-1.45, -0.1, 1.31>
  }
  cylinder { // bracelet_cyl_2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Texture1
    }
    scale 0.28
    rotate <10.627584, -19.683498, 3.616441>
    translate  <1.47, -0.1, 1.26>
  }
  torus { // bracelet2
    1.8, 0.2  rotate -x*90
    texture {
      Copper_Textur1
    }
    scale 0.13
    rotate 30.0*y
    translate  <-1.92, 0.35, -0.34>
  }
  torus { // bracelet3
    1.8, 0.2  rotate -x*90
    texture {
      Copper_Textur1
    }
    scale 0.13
    rotate 30.0*y
    translate  <-1.92, 0.35, -0.28>
  }
}
#declare jupe_avant = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.827769, 0.146080, -3.135063>, <-2.495366, 0.172971, -3.691150>, <-1.533949, -0.105128, -4.116826>, <-1.092742, 0.451265, -4.617978>, 
      <-2.340636, -0.066043, -2.573779>, <-2.008233, 0.205101, -3.360293>, <-1.140504, -0.061646, -3.679667>, <-0.708136, 0.496518, -4.170860>, 
      <-1.853502, 0.168939, -2.260091>, <-1.521099, 0.707664, -2.955158>, <-0.747059, -0.018165, -3.242508>, <-0.307748, 0.340018, -3.758723>, 
      <-1.506256, 0.135415, -2.101626>, <-1.078102, 0.608679, -2.532518>, <-0.429129, 0.231388, -2.810817>, <0.052479, 0.396103, -3.203547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.506256, 0.135415, -2.101626>, <-1.078102, 0.608679, -2.532518>, <-0.429129, 0.231388, -2.810817>, <0.052479, 0.396103, -3.203547>, 
      <-1.159011, 0.101891, -1.943161>, <-0.635105, 0.509693, -2.109878>, <-0.111200, 0.480940, -2.379125>, <0.412706, 0.452188, -2.648372>, 
      <-0.888237, 0.348544, -1.458574>, <-0.364331, 0.774883, -1.619354>, <0.159574, 0.587810, -1.851181>, <0.683480, 0.504652, -2.127098>, 
      <-0.877230, 0.464993, -0.999638>, <-0.230583, 0.709614, -1.124715>, <0.158430, 0.384644, -1.260104>, <0.793243, 0.543047, -1.333900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.877230, 0.464993, -0.999638>, <-0.230583, 0.709614, -1.124715>, <0.158430, 0.384644, -1.260104>, <0.793243, 0.543047, -1.333900>, 
      <-0.866224, 0.581441, -0.540702>, <-0.096835, 0.644344, -0.630075>, <0.157286, 0.181479, -0.669026>, <0.903007, 0.581441, -0.540702>, 
      <-0.866224, 0.578257, 0.049033>, <-0.276480, 0.578257, 0.049033>, <0.313263, 0.578257, 0.049033>, <0.903007, 0.578257, 0.049033>, 
      <-0.700603, 0.223385, 0.674396>, <-0.276480, 0.666441, 0.638768>, <0.313263, 0.666441, 0.638768>, <0.754050, 0.216859, 0.674396>
    }
  }
  texture {
    toile_1
  }
}
#declare jupe_arr = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.486709, -1.236466, -3.662599>, <-1.985586, -2.399863, -3.641040>, <-0.881569, 0.037409, -4.400714>, <-0.354897, -1.786705, -4.666280>, 
      <-2.018370, -1.350494, -3.344924>, <-1.596862, -2.078165, -3.323346>, <-0.639680, -0.337159, -3.901534>, <-0.112880, -1.575805, -4.163812>, 
      <-1.568009, -1.122936, -3.027249>, <-1.208138, -1.756468, -3.005651>, <-0.397791, -0.118449, -3.402355>, <0.129138, -1.364906, -3.661344>, 
      <-1.400169, -1.043219, -2.548842>, <-0.966218, -1.552461, -2.652846>, <-0.155710, -0.732425, -2.950888>, <0.371155, -1.160809, -3.195364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.400169, -1.043219, -2.548842>, <-0.966218, -1.552461, -2.652846>, <-0.155710, -0.732425, -2.950888>, <0.371155, -1.160809, -3.195364>, 
      <-1.232329, -0.963501, -2.070435>, <-0.724299, -1.348455, -2.300040>, <0.086372, -1.346401, -2.499422>, <0.613172, -0.956712, -2.729383>, 
      <-1.093562, -0.551768, -1.324774>, <-0.585532, -0.939094, -1.550402>, <0.328389, -1.352620, -1.954523>, <0.855189, -0.962904, -2.184485>, 
      <-1.092473, -0.552347, -0.808287>, <-0.535759, -1.112539, -0.914828>, <0.374966, -1.319302, -1.116889>, <0.948051, -0.757915, -1.238142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.092473, -0.552347, -0.808287>, <-0.535759, -1.112539, -0.914828>, <0.374966, -1.319302, -1.116889>, <0.948051, -0.757915, -1.238142>, 
      <-1.091385, -0.552925, -0.291800>, <-0.485986, -1.285985, -0.279255>, <0.421542, -1.285985, -0.279255>, <1.040913, -0.552925, -0.291800>, 
      <-1.091385, -0.751026, 0.545480>, <-1.261300, -2.237334, 0.691814>, <1.740102, -2.323967, 0.691814>, <1.040913, -0.751026, 0.545480>, 
      <-0.710620, -0.120830, 0.899708>, <-0.484659, -0.585450, 0.917761>, <0.298982, -0.513029, 0.917761>, <0.692224, -0.035195, 0.917761>
    }
  }
  texture {
    toile_1
  }
}
#declare botte_1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809854, -0.053561, 0.748378>, <3.809854, -0.055593, 0.748378>, <3.809858, -0.057255, 0.748173>, <3.809862, -0.057255, 0.747922>, 
      <3.896445, 0.000000, 0.659026>, <3.896445, -0.550000, 0.659026>, <3.898291, -1.000000, 0.707260>, <3.804469, -1.000000, 1.052170>, 
      <3.396450, 0.000000, 0.661077>, <3.396450, -0.550000, 0.661077>, <3.398296, -1.000000, 0.709312>, <3.304474, -1.000000, 1.054221>, 
      <1.256327, 0.000000, 0.633064>, <1.256327, -0.550000, 0.633064>, <1.258173, -1.000000, 0.681299>, <2.239956, -1.000000, 0.951049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809862, -0.057255, 0.747922>, <3.809867, -0.057255, 0.747671>, <3.809870, -0.055593, 0.747466>, <3.809870, -0.053561, 0.747466>, 
      <3.804469, -1.000000, 1.052170>, <3.710647, -1.000000, 1.397080>, <3.434351, -0.550000, 1.507124>, <3.434351, 0.000000, 1.507124>, 
      <3.304474, -1.000000, 1.054221>, <3.210652, -1.000000, 1.399131>, <2.755655, -0.550000, 1.424871>, <2.755655, 0.000000, 1.424871>, 
      <2.239956, -1.000000, 0.951049>, <3.221739, -1.000000, 1.220800>, <2.995163, -0.550000, 1.458668>, <2.995163, 0.000000, 1.458668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809870, -0.053561, 0.747466>, <3.809870, -0.051530, 0.747466>, <3.809867, -0.049868, 0.747671>, <3.809862, -0.049868, 0.747922>, 
      <3.434351, 0.000000, 1.507124>, <3.434351, 0.550000, 1.507124>, <3.710647, 1.000000, 1.397080>, <3.804469, 1.000000, 1.052170>, 
      <2.755655, 0.000000, 1.424871>, <2.755655, 0.550000, 1.424871>, <3.210652, 1.000000, 1.399131>, <3.304474, 1.000000, 1.054221>, 
      <2.995163, 0.000000, 1.458668>, <2.995163, 0.550000, 1.458668>, <3.221739, 1.000000, 1.220800>, <2.239956, 1.000000, 0.951049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809862, -0.049868, 0.747922>, <3.809858, -0.049868, 0.748173>, <3.809854, -0.051530, 0.748378>, <3.809854, -0.053561, 0.748378>, 
      <3.804469, 1.000000, 1.052170>, <3.898291, 1.000000, 0.707260>, <3.896445, 0.550000, 0.659026>, <3.896445, 0.000000, 0.659026>, 
      <3.304474, 1.000000, 1.054221>, <3.398296, 1.000000, 0.709312>, <3.396450, 0.550000, 0.661077>, <3.396450, 0.000000, 0.661077>, 
      <2.239956, 1.000000, 0.951049>, <1.258173, 1.000000, 0.681299>, <1.256327, 0.550000, 0.633064>, <1.256327, 0.000000, 0.633064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.256327, 0.000000, 0.633064>, <1.256327, -0.550000, 0.633064>, <1.258173, -1.000000, 0.681299>, <2.239956, -1.000000, 0.951049>, 
      <-0.883796, 0.000000, 0.605051>, <-0.883796, -0.550000, 0.605051>, <-0.881950, -1.000000, 0.653286>, <1.175438, -1.000000, 0.847878>, 
      <-1.305161, 0.000000, 0.376903>, <-1.305161, -0.550000, 0.376903>, <-1.303378, -1.000000, 0.433858>, <0.165979, -0.726184, 0.859444>, 
      <-1.152580, 0.000000, 1.188098>, <-1.152580, -0.364641, 1.188098>, <-0.926689, -0.662983, 1.216575>, <0.088219, -0.505523, 1.336055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.239956, -1.000000, 0.951049>, <3.221739, -1.000000, 1.220800>, <2.995163, -0.550000, 1.458668>, <2.995163, 0.000000, 1.458668>, 
      <1.175438, -1.000000, 0.847878>, <3.232826, -1.000000, 1.042469>, <3.234672, -0.550000, 1.492465>, <3.234672, 0.000000, 1.492465>, 
      <0.165979, -0.726184, 0.859444>, <1.635337, -0.452369, 1.285029>, <2.082421, -0.411286, 1.717451>, <2.082421, 0.000000, 1.717451>, 
      <0.088219, -0.505523, 1.336055>, <1.103127, -0.348062, 1.455534>, <1.255817, -0.272676, 2.064122>, <1.255817, 0.000000, 2.064122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.995163, 0.000000, 1.458668>, <2.995163, 0.550000, 1.458668>, <3.221739, 1.000000, 1.220800>, <2.239956, 1.000000, 0.951049>, 
      <3.234672, 0.000000, 1.492465>, <3.234672, 0.550000, 1.492465>, <3.232826, 1.000000, 1.042469>, <1.175438, 1.000000, 0.847878>, 
      <2.082421, 0.000000, 1.717451>, <2.082421, 0.411286, 1.717451>, <1.635337, 0.452369, 1.285029>, <0.165979, 0.726184, 0.859444>, 
      <1.255817, 0.000000, 2.064122>, <1.255817, 0.272676, 2.064122>, <1.103127, 0.348062, 1.455534>, <0.088219, 0.505523, 1.336055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.239956, 1.000000, 0.951049>, <1.258173, 1.000000, 0.681299>, <1.256327, 0.550000, 0.633064>, <1.256327, 0.000000, 0.633064>, 
      <1.175438, 1.000000, 0.847878>, <-0.881950, 1.000000, 0.653286>, <-0.883796, 0.550000, 0.605051>, <-0.883796, 0.000000, 0.605051>, 
      <0.165979, 0.726184, 0.859444>, <-1.303378, 1.000000, 0.433858>, <-1.305161, 0.550000, 0.376903>, <-1.305161, 0.000000, 0.376903>, 
      <0.088219, 0.505523, 1.336055>, <-0.926689, 0.662983, 1.216575>, <-1.152580, 0.364641, 1.188098>, <-1.152580, 0.000000, 1.188098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.152580, 0.000000, 1.188098>, <-1.152580, -0.364641, 1.188098>, <-0.926689, -0.662983, 1.216575>, <0.088219, -0.505523, 1.336055>, 
      <-1.000000, 0.000000, 1.999293>, <-1.000000, -0.179282, 1.999293>, <-0.550000, -0.325967, 1.999293>, <0.010459, -0.284861, 1.812666>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -0.550000, 4.000000>, <-0.550000, -1.000000, 4.000000>, <0.000000, -1.000000, 4.000000>, 
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-0.550000, -1.000000, 4.500000>, <0.000000, -1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.088219, -0.505523, 1.336055>, <1.103127, -0.348062, 1.455534>, <1.255817, -0.272676, 2.064122>, <1.255817, 0.000000, 2.064122>, 
      <0.010459, -0.284861, 1.812666>, <0.570917, -0.243756, 1.626039>, <0.429214, -0.134066, 2.410794>, <0.429214, 0.000000, 2.410794>, 
      <0.000000, -1.000000, 4.000000>, <0.550000, -1.000000, 4.000000>, <1.000000, -0.550000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <0.000000, -1.000000, 4.500000>, <0.550000, -1.000000, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.255817, 0.000000, 2.064122>, <1.255817, 0.272676, 2.064122>, <1.103127, 0.348062, 1.455534>, <0.088219, 0.505523, 1.336055>, 
      <0.429214, 0.000000, 2.410794>, <0.429214, 0.134066, 2.410794>, <0.570917, 0.243756, 1.626039>, <0.010459, 0.284861, 1.812666>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 0.550000, 4.000000>, <0.550000, 1.000000, 4.000000>, <0.000000, 1.000000, 4.000000>, 
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.550000, 1.000000, 4.500000>, <0.000000, 1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.088219, 0.505523, 1.336055>, <-0.926689, 0.662983, 1.216575>, <-1.152580, 0.364641, 1.188098>, <-1.152580, 0.000000, 1.188098>, 
      <0.010459, 0.284861, 1.812666>, <-0.550000, 0.325967, 1.999293>, <-1.000000, 0.179282, 1.999293>, <-1.000000, 0.000000, 1.999293>, 
      <0.000000, 1.000000, 4.000000>, <-0.550000, 1.000000, 4.000000>, <-1.000000, 0.550000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <0.000000, 1.000000, 4.500000>, <-0.550000, 1.000000, 4.500000>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-0.550000, -1.000000, 4.500000>, <0.000000, -1.000000, 4.500000>, 
      <-1.000000, 0.000000, 5.000000>, <-1.000000, -0.550000, 5.000000>, <-0.550000, -1.000000, 5.000000>, <0.000000, -1.000000, 5.000000>, 
      <-1.969556, 0.000000, 6.803019>, <-1.969556, -0.801367, 6.803019>, <-1.191637, -1.457031, 6.803019>, <-0.240846, -1.457031, 6.803019>, 
      <-1.438451, 0.000000, 3.847199>, <-1.438451, -0.593753, 3.847199>, <-0.839526, -1.079551, 3.747466>, <-0.107506, -1.079551, 3.625569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 4.500000>, <0.550000, -1.000000, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>, 
      <0.000000, -1.000000, 5.000000>, <0.550000, -1.000000, 5.000000>, <1.000000, -0.550000, 5.000000>, <1.000000, 0.000000, 5.000000>, 
      <-0.240846, -1.457031, 6.803019>, <0.709944, -1.457031, 6.803019>, <1.487864, -0.801367, 6.803019>, <1.487864, 0.000000, 6.803019>, 
      <-0.107506, -1.079551, 3.625569>, <0.624514, -1.079551, 3.503673>, <1.223439, -0.593753, 3.403939>, <1.223439, 0.000000, 3.403939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.550000, 1.000000, 4.500000>, <0.000000, 1.000000, 4.500000>, 
      <1.000000, 0.000000, 5.000000>, <1.000000, 0.550000, 5.000000>, <0.550000, 1.000000, 5.000000>, <0.000000, 1.000000, 5.000000>, 
      <1.487864, 0.000000, 6.803019>, <1.487864, 0.801367, 6.803019>, <0.709944, 1.457031, 6.803019>, <-0.240846, 1.457031, 6.803019>, 
      <1.223439, 0.000000, 3.403939>, <1.223439, 0.593753, 3.403939>, <0.624514, 1.079551, 3.503673>, <-0.107506, 1.079551, 3.625569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 4.500000>, <-0.550000, 1.000000, 4.500000>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>, 
      <0.000000, 1.000000, 5.000000>, <-0.550000, 1.000000, 5.000000>, <-1.000000, 0.550000, 5.000000>, <-1.000000, 0.000000, 5.000000>, 
      <-0.240846, 1.457031, 6.803019>, <-1.191637, 1.457031, 6.803019>, <-1.969556, 0.801367, 6.803019>, <-1.969556, 0.000000, 6.803019>, 
      <-0.107506, 1.079551, 3.625569>, <-0.839526, 1.079551, 3.747466>, <-1.438451, 0.593753, 3.847199>, <-1.438451, 0.000000, 3.847199>
    }
  }
  texture {
    cuir_bottes
  }
  scale 0.33
  rotate <3.0, 0.0, 90.0>
  translate  <-0.77, -0.23, -6.48>
}
#declare botte_2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809854, -0.053561, 0.748378>, <3.809854, -0.055593, 0.748378>, <3.809858, -0.057255, 0.748173>, <3.809862, -0.057255, 0.747922>, 
      <3.896445, 0.000000, 0.659026>, <3.896445, -0.550000, 0.659026>, <3.898291, -1.000000, 0.707260>, <3.804469, -1.000000, 1.052170>, 
      <3.396450, 0.000000, 0.661077>, <3.396450, -0.550000, 0.661077>, <3.398296, -1.000000, 0.709312>, <3.304474, -1.000000, 1.054221>, 
      <1.256327, 0.000000, 0.633064>, <1.256327, -0.550000, 0.633064>, <1.258173, -1.000000, 0.681299>, <2.239956, -1.000000, 0.951049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809862, -0.057255, 0.747922>, <3.809867, -0.057255, 0.747671>, <3.809870, -0.055593, 0.747466>, <3.809870, -0.053561, 0.747466>, 
      <3.804469, -1.000000, 1.052170>, <3.710647, -1.000000, 1.397080>, <3.434351, -0.550000, 1.507124>, <3.434351, 0.000000, 1.507124>, 
      <3.304474, -1.000000, 1.054221>, <3.210652, -1.000000, 1.399131>, <2.755655, -0.550000, 1.424871>, <2.755655, 0.000000, 1.424871>, 
      <2.239956, -1.000000, 0.951049>, <3.221739, -1.000000, 1.220800>, <2.995163, -0.550000, 1.458668>, <2.995163, 0.000000, 1.458668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809870, -0.053561, 0.747466>, <3.809870, -0.051530, 0.747466>, <3.809867, -0.049868, 0.747671>, <3.809862, -0.049868, 0.747922>, 
      <3.434351, 0.000000, 1.507124>, <3.434351, 0.550000, 1.507124>, <3.710647, 1.000000, 1.397080>, <3.804469, 1.000000, 1.052170>, 
      <2.755655, 0.000000, 1.424871>, <2.755655, 0.550000, 1.424871>, <3.210652, 1.000000, 1.399131>, <3.304474, 1.000000, 1.054221>, 
      <2.995163, 0.000000, 1.458668>, <2.995163, 0.550000, 1.458668>, <3.221739, 1.000000, 1.220800>, <2.239956, 1.000000, 0.951049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.809862, -0.049868, 0.747922>, <3.809858, -0.049868, 0.748173>, <3.809854, -0.051530, 0.748378>, <3.809854, -0.053561, 0.748378>, 
      <3.804469, 1.000000, 1.052170>, <3.898291, 1.000000, 0.707260>, <3.896445, 0.550000, 0.659026>, <3.896445, 0.000000, 0.659026>, 
      <3.304474, 1.000000, 1.054221>, <3.398296, 1.000000, 0.709312>, <3.396450, 0.550000, 0.661077>, <3.396450, 0.000000, 0.661077>, 
      <2.239956, 1.000000, 0.951049>, <1.258173, 1.000000, 0.681299>, <1.256327, 0.550000, 0.633064>, <1.256327, 0.000000, 0.633064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.256327, 0.000000, 0.633064>, <1.256327, -0.550000, 0.633064>, <1.258173, -1.000000, 0.681299>, <2.239956, -1.000000, 0.951049>, 
      <-0.883796, 0.000000, 0.605051>, <-0.883796, -0.550000, 0.605051>, <-0.881950, -1.000000, 0.653286>, <1.175438, -1.000000, 0.847878>, 
      <-1.305161, 0.000000, 0.376903>, <-1.305161, -0.550000, 0.376903>, <-1.303378, -1.000000, 0.433858>, <0.165979, -0.726184, 0.859444>, 
      <-1.152580, 0.000000, 1.188098>, <-1.152580, -0.364641, 1.188098>, <-0.926689, -0.662983, 1.216575>, <0.088219, -0.505523, 1.336055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.239956, -1.000000, 0.951049>, <3.221739, -1.000000, 1.220800>, <2.995163, -0.550000, 1.458668>, <2.995163, 0.000000, 1.458668>, 
      <1.175438, -1.000000, 0.847878>, <3.232826, -1.000000, 1.042469>, <3.234672, -0.550000, 1.492465>, <3.234672, 0.000000, 1.492465>, 
      <0.165979, -0.726184, 0.859444>, <1.635337, -0.452369, 1.285029>, <2.082421, -0.411286, 1.717451>, <2.082421, 0.000000, 1.717451>, 
      <0.088219, -0.505523, 1.336055>, <1.103127, -0.348062, 1.455534>, <1.255817, -0.272676, 2.064122>, <1.255817, 0.000000, 2.064122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.995163, 0.000000, 1.458668>, <2.995163, 0.550000, 1.458668>, <3.221739, 1.000000, 1.220800>, <2.239956, 1.000000, 0.951049>, 
      <3.234672, 0.000000, 1.492465>, <3.234672, 0.550000, 1.492465>, <3.232826, 1.000000, 1.042469>, <1.175438, 1.000000, 0.847878>, 
      <2.082421, 0.000000, 1.717451>, <2.082421, 0.411286, 1.717451>, <1.635337, 0.452369, 1.285029>, <0.165979, 0.726184, 0.859444>, 
      <1.255817, 0.000000, 2.064122>, <1.255817, 0.272676, 2.064122>, <1.103127, 0.348062, 1.455534>, <0.088219, 0.505523, 1.336055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.239956, 1.000000, 0.951049>, <1.258173, 1.000000, 0.681299>, <1.256327, 0.550000, 0.633064>, <1.256327, 0.000000, 0.633064>, 
      <1.175438, 1.000000, 0.847878>, <-0.881950, 1.000000, 0.653286>, <-0.883796, 0.550000, 0.605051>, <-0.883796, 0.000000, 0.605051>, 
      <0.165979, 0.726184, 0.859444>, <-1.303378, 1.000000, 0.433858>, <-1.305161, 0.550000, 0.376903>, <-1.305161, 0.000000, 0.376903>, 
      <0.088219, 0.505523, 1.336055>, <-0.926689, 0.662983, 1.216575>, <-1.152580, 0.364641, 1.188098>, <-1.152580, 0.000000, 1.188098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.152580, 0.000000, 1.188098>, <-1.152580, -0.364641, 1.188098>, <-0.926689, -0.662983, 1.216575>, <0.088219, -0.505523, 1.336055>, 
      <-1.000000, 0.000000, 1.999293>, <-1.000000, -0.179282, 1.999293>, <-0.550000, -0.325967, 1.999293>, <0.010459, -0.284861, 1.812666>, 
      <-1.000000, 0.000000, 4.000000>, <-1.000000, -0.550000, 4.000000>, <-0.550000, -1.000000, 4.000000>, <0.000000, -1.000000, 4.000000>, 
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-0.550000, -1.000000, 4.500000>, <0.000000, -1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.088219, -0.505523, 1.336055>, <1.103127, -0.348062, 1.455534>, <1.255817, -0.272676, 2.064122>, <1.255817, 0.000000, 2.064122>, 
      <0.010459, -0.284861, 1.812666>, <0.570917, -0.243756, 1.626039>, <0.429214, -0.134066, 2.410794>, <0.429214, 0.000000, 2.410794>, 
      <0.000000, -1.000000, 4.000000>, <0.550000, -1.000000, 4.000000>, <1.000000, -0.550000, 4.000000>, <1.000000, 0.000000, 4.000000>, 
      <0.000000, -1.000000, 4.500000>, <0.550000, -1.000000, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.255817, 0.000000, 2.064122>, <1.255817, 0.272676, 2.064122>, <1.103127, 0.348062, 1.455534>, <0.088219, 0.505523, 1.336055>, 
      <0.429214, 0.000000, 2.410794>, <0.429214, 0.134066, 2.410794>, <0.570917, 0.243756, 1.626039>, <0.010459, 0.284861, 1.812666>, 
      <1.000000, 0.000000, 4.000000>, <1.000000, 0.550000, 4.000000>, <0.550000, 1.000000, 4.000000>, <0.000000, 1.000000, 4.000000>, 
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.550000, 1.000000, 4.500000>, <0.000000, 1.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.088219, 0.505523, 1.336055>, <-0.926689, 0.662983, 1.216575>, <-1.152580, 0.364641, 1.188098>, <-1.152580, 0.000000, 1.188098>, 
      <0.010459, 0.284861, 1.812666>, <-0.550000, 0.325967, 1.999293>, <-1.000000, 0.179282, 1.999293>, <-1.000000, 0.000000, 1.999293>, 
      <0.000000, 1.000000, 4.000000>, <-0.550000, 1.000000, 4.000000>, <-1.000000, 0.550000, 4.000000>, <-1.000000, 0.000000, 4.000000>, 
      <0.000000, 1.000000, 4.500000>, <-0.550000, 1.000000, 4.500000>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 4.500000>, <-1.000000, -0.550000, 4.500000>, <-0.550000, -1.000000, 4.500000>, <0.000000, -1.000000, 4.500000>, 
      <-1.000000, 0.000000, 5.000000>, <-1.000000, -0.550000, 5.000000>, <-0.550000, -1.000000, 5.000000>, <0.000000, -1.000000, 5.000000>, 
      <-1.969556, 0.000000, 6.803019>, <-1.969556, -0.801367, 6.803019>, <-1.191637, -1.457031, 6.803019>, <-0.240846, -1.457031, 6.803019>, 
      <-1.438451, 0.000000, 3.847199>, <-1.438451, -0.593753, 3.847199>, <-0.839526, -1.079551, 3.747466>, <-0.107506, -1.079551, 3.625569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.000000, 4.500000>, <0.550000, -1.000000, 4.500000>, <1.000000, -0.550000, 4.500000>, <1.000000, 0.000000, 4.500000>, 
      <0.000000, -1.000000, 5.000000>, <0.550000, -1.000000, 5.000000>, <1.000000, -0.550000, 5.000000>, <1.000000, 0.000000, 5.000000>, 
      <-0.240846, -1.457031, 6.803019>, <0.709944, -1.457031, 6.803019>, <1.487864, -0.801367, 6.803019>, <1.487864, 0.000000, 6.803019>, 
      <-0.107506, -1.079551, 3.625569>, <0.624514, -1.079551, 3.503673>, <1.223439, -0.593753, 3.403939>, <1.223439, 0.000000, 3.403939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 4.500000>, <1.000000, 0.550000, 4.500000>, <0.550000, 1.000000, 4.500000>, <0.000000, 1.000000, 4.500000>, 
      <1.000000, 0.000000, 5.000000>, <1.000000, 0.550000, 5.000000>, <0.550000, 1.000000, 5.000000>, <0.000000, 1.000000, 5.000000>, 
      <1.487864, 0.000000, 6.803019>, <1.487864, 0.801367, 6.803019>, <0.709944, 1.457031, 6.803019>, <-0.240846, 1.457031, 6.803019>, 
      <1.223439, 0.000000, 3.403939>, <1.223439, 0.593753, 3.403939>, <0.624514, 1.079551, 3.503673>, <-0.107506, 1.079551, 3.625569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 4.500000>, <-0.550000, 1.000000, 4.500000>, <-1.000000, 0.550000, 4.500000>, <-1.000000, 0.000000, 4.500000>, 
      <0.000000, 1.000000, 5.000000>, <-0.550000, 1.000000, 5.000000>, <-1.000000, 0.550000, 5.000000>, <-1.000000, 0.000000, 5.000000>, 
      <-0.240846, 1.457031, 6.803019>, <-1.191637, 1.457031, 6.803019>, <-1.969556, 0.801367, 6.803019>, <-1.969556, 0.000000, 6.803019>, 
      <-0.107506, 1.079551, 3.625569>, <-0.839526, 1.079551, 3.747466>, <-1.438451, 0.593753, 3.847199>, <-1.438451, 0.000000, 3.847199>
    }
  }
  texture {
    cuir_bottes
  }
  scale 0.33
  rotate <-3.0, 0.0, 90.0>
  translate  <0.75, -0.23, -6.45>
}
#declare vetements = union {
  object { jupe_avant }
  object { jupe_arr }
  cone { // ceinture
    <0,0,0>, 0.9, <0,0,1>, 1.0
    open
    texture {
      pour_ceinture
    }
    scale <0.86, 0.69, 0.24>
    rotate 165.0*x
    translate  <0.0, 0.01, 0.89>
  }
  object { botte_1 }
  object { botte_2 }
}
#declare targui = union {
  object { corps }
  object { bijoux }
  object { vetements }
}
#declare veste = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.305263, -1.816330, -7.312021>, <-0.849123, -1.816330, -7.312021>, <1.020217, -2.772123, -9.534426>, <-0.463535, -2.354576, -4.770062>, 
      <-1.305263, -1.819594, -6.304005>, <-0.849123, -1.819594, -6.304005>, <-1.218111, -2.180889, -4.582149>, <-1.582699, -2.060552, -2.293393>, 
      <-1.305263, -1.822857, -5.295989>, <-0.849123, -1.822857, -5.295989>, <-0.849119, -1.930191, -3.683700>, <-1.398203, -1.936797, -1.843638>, 
      <-2.064627, -1.909716, -4.148060>, <-1.380416, -1.909716, -4.338745>, <-0.849119, -1.933357, -2.683705>, <-1.398203, -1.939973, -1.343109>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.064627, -1.909716, -4.148060>, <-1.380416, -1.909716, -4.338745>, <-0.849119, -1.933357, -2.683705>, <-1.398203, -1.939973, -1.343109>, 
      <-2.823990, -1.996574, -3.000132>, <-1.911710, -1.996574, -3.381501>, <-0.849119, -1.936522, -1.683710>, <-1.398203, -1.943149, -0.842581>, 
      <-6.000000, -0.314729, 0.896124>, <-4.278874, -0.314729, -0.052713>, <-3.432027, -0.314729, -0.052713>, <-2.716014, -0.314729, -0.026357>, 
      <-6.000000, 0.685271, 0.896124>, <-4.278874, 0.685271, -0.052713>, <-3.432027, 0.685271, -0.052713>, <-2.716014, 0.685271, -0.026357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 0.685271, 0.896124>, <-4.278874, 0.685271, -0.052713>, <-3.432027, 0.685271, -0.052713>, <-2.716014, 0.685271, -0.026357>, 
      <-6.000000, 1.685271, 0.896124>, <-4.278874, 1.685271, -0.052713>, <-3.432027, 1.685271, -0.052713>, <-2.716014, 1.685271, -0.026357>, 
      <-3.434380, 1.531041, -2.751640>, <-2.545754, 1.526912, -3.139002>, <-2.101441, 1.630111, -3.139002>, <-2.186886, 1.888691, -2.131756>, 
      <-3.227310, 1.196319, -4.238563>, <-2.572011, 1.240293, -4.358887>, <-2.117683, 1.337932, -4.748091>, <-2.195329, 1.604774, -3.436298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.227310, 1.196319, -4.238563>, <-2.572011, 1.240293, -4.358887>, <-2.117683, 1.337932, -4.748091>, <-2.195329, 1.604774, -3.436298>, 
      <-3.020240, 0.861597, -5.725486>, <-2.598267, 0.953675, -5.578773>, <-2.133925, 1.045753, -6.357180>, <-2.203772, 1.320857, -4.740840>, 
      <-2.816016, 1.319258, -6.600099>, <-2.394043, 1.411335, -6.453386>, <-1.972071, 1.503413, -6.306672>, <-2.123166, 1.551073, -5.215585>, 
      <-2.273279, 1.776918, -7.766883>, <-2.189819, 1.868996, -7.327998>, <-2.106359, 1.961073, -6.889113>, <-2.226496, 1.481282, -6.174461>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.463535, -2.354576, -4.770062>, <-1.947287, -1.937029, -0.005699>, <-1.000000, 1.918993, -0.045979>, <0.000000, 1.918993, -0.045979>, 
      <-1.582699, -2.060552, -2.293393>, <-1.947287, -1.940215, -0.004637>, <-1.000000, 1.915650, -0.052073>, <0.000000, 1.915650, -0.052073>, 
      <-1.398203, -1.936797, -1.843638>, <-1.947287, -1.943402, -0.003576>, <-1.000000, 1.912307, -0.058166>, <0.000000, 1.912307, -0.058166>, 
      <-1.398203, -1.939973, -1.343109>, <-1.947287, -1.946589, -0.002514>, <-1.000000, 1.908965, -0.064259>, <0.000000, 1.908965, -0.064259>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.398203, -1.939973, -1.343109>, <-1.947287, -1.946589, -0.002514>, <-1.000000, 1.908965, -0.064259>, <0.000000, 1.908965, -0.064259>, 
      <-1.398203, -1.943149, -0.842581>, <-1.947287, -1.949776, -0.001452>, <-1.000000, 1.905622, -0.070353>, <0.000000, 1.905622, -0.070353>, 
      <-2.716014, -0.314729, -0.026357>, <-2.000000, -0.314729, 0.000000>, <-1.000000, 1.820728, 0.000000>, <0.000000, 1.820728, 0.000000>, 
      <-2.716014, 0.685271, -0.026357>, <-2.000000, 0.685271, 0.000000>, <-0.973643, 1.605161, -0.046404>, <0.026357, 1.605161, -0.046404>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.716014, 0.685271, -0.026357>, <-2.000000, 0.685271, 0.000000>, <-0.973643, 1.605161, -0.046404>, <0.026357, 1.605161, -0.046404>, 
      <-2.716014, 1.685271, -0.026357>, <-2.000000, 1.685271, 0.000000>, <-0.947287, 1.389593, -0.092809>, <0.052713, 1.389593, -0.092809>, 
      <-2.186886, 1.888691, -2.131756>, <-2.272331, 2.147272, -1.124509>, <-1.000000, 2.355999, -1.217318>, <0.000000, 2.355999, -1.217318>, 
      <-2.195329, 1.604774, -3.436298>, <-2.272975, 1.871617, -2.124505>, <-1.000000, 2.189980, -2.170910>, <0.000000, 2.168927, -2.170910>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.195329, 1.604774, -3.436298>, <-2.272975, 1.871617, -2.124505>, <-1.000000, 2.189980, -2.170910>, <0.000000, 2.168927, -2.170910>, 
      <-2.203772, 1.320857, -4.740840>, <-2.273619, 1.595962, -3.124501>, <-1.000000, 2.023961, -3.124501>, <0.000000, 2.023961, -3.124501>, 
      <-2.123166, 1.551073, -5.215585>, <-2.274262, 1.598733, -4.124497>, <-1.000000, 1.900490, -4.124497>, <0.000000, 1.900490, -4.124497>, 
      <-2.226496, 1.481282, -6.174461>, <-2.346632, 1.001491, -5.459810>, <-0.125000, 1.763525, -4.062541>, <0.000000, 1.763525, -4.062541>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.918993, -0.045979>, <1.000000, 1.918993, -0.045979>, <2.368992, -1.937029, -0.005699>, <1.965326, -1.930445, -4.981109>, 
      <0.000000, 1.915650, -0.052073>, <1.000000, 1.915650, -0.052073>, <2.368992, -1.940215, -0.004637>, <1.529986, -1.933621, -2.344166>, 
      <0.000000, 1.912307, -0.058166>, <1.000000, 1.912307, -0.058166>, <2.368992, -1.943402, -0.003576>, <1.714482, -1.936797, -1.843638>, 
      <0.000000, 1.908965, -0.064259>, <1.000000, 1.908965, -0.064259>, <2.368992, -1.946589, -0.002514>, <1.714482, -1.939973, -1.343109>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.908965, -0.064259>, <1.000000, 1.908965, -0.064259>, <2.368992, -1.946589, -0.002514>, <1.714482, -1.939973, -1.343109>, 
      <0.000000, 1.905622, -0.070353>, <1.000000, 1.905622, -0.070353>, <2.368992, -1.949776, -0.001452>, <1.714482, -1.943149, -0.842581>, 
      <0.000000, 1.820728, 0.000000>, <1.000000, 1.820728, 0.000000>, <2.000000, -0.314729, 0.000000>, <2.671374, -0.314729, -0.026357>, 
      <0.026357, 1.605161, -0.046404>, <1.026357, 1.605161, -0.046404>, <2.000000, 0.685271, 0.000000>, <2.671374, 0.685271, -0.026357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.026357, 1.605161, -0.046404>, <1.026357, 1.605161, -0.046404>, <2.000000, 0.685271, 0.000000>, <2.671374, 0.685271, -0.026357>, 
      <0.052713, 1.389593, -0.092809>, <1.052713, 1.389593, -0.092809>, <2.000000, 1.685271, 0.000000>, <2.671374, 1.685271, -0.026357>, 
      <0.000000, 2.355999, -1.217318>, <1.000000, 2.355999, -1.217318>, <2.259226, 2.155108, -1.124509>, <2.173035, 1.892985, -2.131756>, 
      <0.000000, 2.168927, -2.170910>, <1.000000, 2.189980, -2.170910>, <2.259755, 1.879477, -2.124505>, <2.371720, 1.609071, -3.504672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 2.168927, -2.170910>, <1.000000, 2.189980, -2.170910>, <2.259755, 1.879477, -2.124505>, <2.371720, 1.609071, -3.504672>, 
      <0.000000, 2.023961, -3.124501>, <1.000000, 2.023961, -3.124501>, <2.260283, 1.603846, -3.124501>, <2.570406, 1.325156, -4.877589>, 
      <0.000000, 1.900490, -4.124497>, <1.000000, 1.900490, -4.124497>, <2.260812, 1.606642, -4.124497>, <2.491575, 1.555395, -5.406560>, 
      <0.000000, 1.763525, -4.062541>, <0.125000, 1.763525, -4.062541>, <2.504533, 1.008569, -5.785098>, <2.845590, 1.485200, -6.418434>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.965326, -1.930445, -4.981109>, <1.561660, -1.923861, -9.956519>, <3.047723, -1.983520, -7.497322>, <3.499211, -1.983520, -7.432339>, 
      <1.529986, -1.933621, -2.344166>, <0.690980, -1.927026, -4.683694>, <2.904118, -1.986783, -6.499587>, <3.355606, -1.986783, -6.434604>, 
      <1.714482, -1.936797, -1.843638>, <1.059972, -1.930191, -3.683700>, <2.760513, -1.990047, -5.501853>, <3.212001, -1.990047, -5.436869>, 
      <1.714482, -1.939973, -1.343109>, <1.059972, -1.933357, -2.683705>, <2.327480, -1.993310, -4.429860>, <3.053491, -1.993310, -4.171976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.714482, -1.939973, -1.343109>, <1.059972, -1.933357, -2.683705>, <2.327480, -1.993310, -4.429860>, <3.053491, -1.993310, -4.171976>, 
      <1.714482, -1.943149, -0.842581>, <1.059972, -1.936522, -1.683710>, <1.894447, -1.996574, -3.357868>, <2.894982, -1.996574, -2.907083>, 
      <2.671374, -0.314729, -0.026357>, <3.342747, -0.314729, -0.052713>, <4.189594, -0.314729, -0.052713>, <6.000000, -0.314729, 0.896124>, 
      <2.671374, 0.685271, -0.026357>, <3.342747, 0.685271, -0.052713>, <4.189594, 0.685271, -0.052713>, <6.000000, 0.685271, 0.896124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.671374, 0.685271, -0.026357>, <3.342747, 0.685271, -0.052713>, <4.189594, 0.685271, -0.052713>, <6.000000, 0.685271, 0.896124>, 
      <2.671374, 1.685271, -0.026357>, <3.342747, 1.685271, -0.052713>, <4.189594, 1.685271, -0.052713>, <6.000000, 1.685271, 0.896124>, 
      <2.173035, 1.892985, -2.131756>, <2.086844, 1.630862, -3.139002>, <2.535036, 1.546082, -3.139002>, <3.431421, 1.376520, -2.751640>, 
      <2.371720, 1.609071, -3.504672>, <2.483686, 1.338665, -4.884839>, <2.655978, 1.258452, -4.429882>, <3.316322, 1.135849, -4.161520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.371720, 1.609071, -3.504672>, <2.483686, 1.338665, -4.884839>, <2.655978, 1.258452, -4.429882>, <3.316322, 1.135849, -4.161520>, 
      <2.570406, 1.325156, -4.877589>, <2.880528, 1.046467, -6.630677>, <2.776921, 0.970822, -5.720762>, <3.201224, 0.895178, -5.571401>, 
      <2.491575, 1.555395, -5.406560>, <2.722338, 1.504149, -6.688624>, <3.146641, 1.428504, -6.539262>, <3.570944, 1.352860, -6.389900>, 
      <2.845590, 1.485200, -6.418434>, <3.186647, 1.961830, -7.051771>, <3.516362, 1.886186, -7.357762>, <3.846076, 1.810541, -7.663752>
    }
  }
  texture {
    toile_1
  }
  scale <0.3, 0.45, 0.3>
  rotate 180.0*z
  translate  <0.0, -0.04, 3.11>
}
#declare lien_veste_1 = difference {
  torus { // lien_base_1
    1.9, 0.1  rotate -x*90
    scale <0.3, 0.2, 0.3>
    rotate -90.0*x
    translate  <0.0, 0.65, 2.29>
  }
  box { // lien_cut_1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.5>
    translate  <0.0, 0.69, 2.67>
  }
  texture {
    cuir_bottes
  }
  rotate 5.0*x
  translate  0.32*y
}
#declare lien_veste_2 = difference {
  torus { // lien_base_2
    1.9, 0.1  rotate -x*90
    scale <0.3, 0.2, 0.3>
    rotate -90.0*x
    translate  <0.0, 0.65, 2.29>
  }
  box { // lien_cut_2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.5>
    translate  <0.0, 0.69, 2.67>
  }
  texture {
    cuir_bottes
  }
  rotate 5.0*x
  translate  <0.0, 0.32, -0.16>
}
#declare lien_veste_3 = difference {
  torus { // lien_base_3
    1.9, 0.1  rotate -x*90
    scale <0.3, 0.2, 0.3>
    rotate -90.0*x
    translate  <0.0, 0.65, 2.29>
  }
  box { // lien_cut_3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.5>
    translate  <0.0, 0.69, 2.67>
  }
  texture {
    cuir_bottes
  }
  rotate 5.0*x
  translate  <0.0, 0.32, -0.32>
}
#declare lien_veste_4 = difference {
  torus { // lien_base_4
    1.9, 0.1  rotate -x*90
    scale <0.3, 0.2, 0.3>
    rotate -90.0*x
    translate  <0.0, 0.65, 2.29>
  }
  box { // lien_cut_4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.5>
    translate  <0.0, 0.69, 2.67>
  }
  texture {
    cuir_bottes
  }
  rotate 5.0*x
  translate  <0.0, 0.32, -0.46>
}
#declare liens_veste = union {
  object { lien_veste_1 }
  object { lien_veste_2 }
  object { lien_veste_3 }
  object { lien_veste_4 }
  scale <0.79, 1.0, 1.0>
  rotate 5.0*y
  translate  <-0.33, 0.0, 0.01>
}
#declare baton = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000433, 1.705111, 6.349172>, <-0.000433, 1.705111, 6.349210>, <-0.000238, 1.705110, 6.349242>, <0.000000, 1.705110, 6.349242>, 
      <-0.048117, 1.696044, 6.260918>, <-0.048117, 1.624180, 6.279993>, <-0.026465, 1.565383, 6.295599>, <0.000000, 1.565383, 6.295599>, 
      <-0.186104, 1.440319, 5.529410>, <-0.186104, 1.358431, 5.627452>, <-0.102357, 1.291432, 5.707669>, <0.000000, 1.291432, 5.707669>, 
      <-0.146713, 1.185869, 4.618721>, <-0.146713, 1.132182, 4.671308>, <-0.094013, 1.088257, 4.714334>, <-0.029602, 1.088257, 4.714334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.705110, 6.349242>, <0.000238, 1.705110, 6.349242>, <0.000433, 1.705111, 6.349210>, <0.000433, 1.705111, 6.349172>, 
      <0.000000, 1.565383, 6.295599>, <0.026465, 1.565383, 6.295599>, <0.048117, 1.624180, 6.279993>, <0.048117, 1.696044, 6.260918>, 
      <0.000000, 1.291432, 5.707669>, <0.102357, 1.291432, 5.707669>, <0.186104, 1.358431, 5.627452>, <0.186104, 1.440319, 5.529410>, 
      <-0.029602, 1.088257, 4.714334>, <0.034809, 1.088257, 4.714334>, <0.087508, 1.132182, 4.671308>, <0.087508, 1.185869, 4.618721>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000433, 1.705111, 6.349172>, <0.000433, 1.705111, 6.349133>, <0.000238, 1.705112, 6.349102>, <0.000000, 1.705112, 6.349102>, 
      <0.048117, 1.696044, 6.260918>, <0.048117, 1.767908, 6.241844>, <0.026465, 1.826705, 6.226238>, <0.000000, 1.826705, 6.226238>, 
      <0.186104, 1.440319, 5.529410>, <0.186104, 1.522207, 5.431368>, <0.102357, 1.589207, 5.351151>, <0.000000, 1.589207, 5.351151>, 
      <0.087508, 1.185869, 4.618721>, <0.087508, 1.239556, 4.566134>, <0.034809, 1.283481, 4.523108>, <-0.029602, 1.283481, 4.523108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.705112, 6.349102>, <-0.000238, 1.705112, 6.349102>, <-0.000433, 1.705111, 6.349133>, <-0.000433, 1.705111, 6.349172>, 
      <0.000000, 1.826705, 6.226238>, <-0.026465, 1.826705, 6.226238>, <-0.048117, 1.767908, 6.241844>, <-0.048117, 1.696044, 6.260918>, 
      <0.000000, 1.589207, 5.351151>, <-0.102357, 1.589207, 5.351151>, <-0.186104, 1.522207, 5.431368>, <-0.186104, 1.440319, 5.529410>, 
      <-0.029602, 1.283481, 4.523108>, <-0.094013, 1.283481, 4.523108>, <-0.146713, 1.239556, 4.566134>, <-0.146713, 1.185869, 4.618721>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.146713, 1.185869, 4.618721>, <-0.146713, 1.132182, 4.671308>, <-0.094013, 1.088257, 4.714334>, <-0.029602, 1.088257, 4.714334>, 
      <-0.107322, 0.931419, 3.708032>, <-0.107322, 0.905933, 3.715163>, <-0.085669, 0.885081, 3.720998>, <-0.059205, 0.885081, 3.720998>, 
      <-0.048117, 0.500450, 2.514849>, <-0.048117, 0.474964, 2.521981>, <-0.026465, 0.454113, 2.527815>, <0.000000, 0.454113, 2.527815>, 
      <0.028205, 0.321104, 1.609124>, <0.028205, 0.305020, 1.614113>, <0.055476, 0.291861, 1.618195>, <0.088807, 0.291861, 1.618195>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.029602, 1.088257, 4.714334>, <0.034809, 1.088257, 4.714334>, <0.087508, 1.132182, 4.671308>, <0.087508, 1.185869, 4.618721>, 
      <-0.059205, 0.885081, 3.720998>, <-0.032740, 0.885081, 3.720998>, <-0.011087, 0.905933, 3.715163>, <-0.011087, 0.931419, 3.708032>, 
      <0.000000, 0.454113, 2.527815>, <0.026465, 0.454113, 2.527815>, <0.048117, 0.474964, 2.521981>, <0.048117, 0.500450, 2.514849>, 
      <0.088807, 0.291861, 1.618195>, <0.122138, 0.291861, 1.618195>, <0.149408, 0.305020, 1.614113>, <0.149408, 0.321104, 1.609124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.087508, 1.185869, 4.618721>, <0.087508, 1.239556, 4.566134>, <0.034809, 1.283481, 4.523108>, <-0.029602, 1.283481, 4.523108>, 
      <-0.011087, 0.931419, 3.708032>, <-0.011087, 0.956904, 3.700900>, <-0.032740, 0.977756, 3.695065>, <-0.059205, 0.977756, 3.695065>, 
      <0.048117, 0.500450, 2.514849>, <0.048117, 0.525936, 2.507717>, <0.026465, 0.546787, 2.501882>, <0.000000, 0.546787, 2.501882>, 
      <0.149408, 0.321104, 1.609124>, <0.149408, 0.337188, 1.604135>, <0.122138, 0.350347, 1.600052>, <0.088807, 0.350347, 1.600052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.029602, 1.283481, 4.523108>, <-0.094013, 1.283481, 4.523108>, <-0.146713, 1.239556, 4.566134>, <-0.146713, 1.185869, 4.618721>, 
      <-0.059205, 0.977756, 3.695065>, <-0.085669, 0.977756, 3.695065>, <-0.107322, 0.956904, 3.700900>, <-0.107322, 0.931419, 3.708032>, 
      <0.000000, 0.546787, 2.501882>, <-0.026465, 0.546787, 2.501882>, <-0.048117, 0.525936, 2.507717>, <-0.048117, 0.500450, 2.514849>, 
      <0.088807, 0.350347, 1.600052>, <0.055476, 0.350347, 1.600052>, <0.028205, 0.337188, 1.604135>, <0.028205, 0.321104, 1.609124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.028205, 0.321104, 1.609124>, <0.028205, 0.305020, 1.614113>, <0.055476, 0.291861, 1.618195>, <0.088807, 0.291861, 1.618195>, 
      <0.104528, 0.141758, 0.703399>, <0.104528, 0.135076, 0.706245>, <0.137417, 0.129609, 0.708575>, <0.177614, 0.129609, 0.708575>, 
      <-0.048117, -0.607949, -1.775382>, <-0.048117, -0.635209, -1.768250>, <-0.026465, -0.657513, -1.762415>, <0.000000, -0.657513, -1.762415>, 
      <-0.048117, -0.872345, -2.790951>, <-0.048117, -0.898718, -2.783819>, <-0.026465, -0.920296, -2.777984>, <0.000000, -0.920296, -2.777984>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.088807, 0.291861, 1.618195>, <0.122138, 0.291861, 1.618195>, <0.149408, 0.305020, 1.614113>, <0.149408, 0.321104, 1.609124>, 
      <0.177614, 0.129609, 0.708575>, <0.217811, 0.129609, 0.708575>, <0.250699, 0.135076, 0.706245>, <0.250699, 0.141758, 0.703399>, 
      <0.000000, -0.657513, -1.762415>, <0.026465, -0.657513, -1.762415>, <0.048117, -0.635209, -1.768250>, <0.048117, -0.607949, -1.775382>, 
      <0.000000, -0.920296, -2.777984>, <0.026465, -0.920296, -2.777984>, <0.048117, -0.898718, -2.783819>, <0.048117, -0.872345, -2.790951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.149408, 0.321104, 1.609124>, <0.149408, 0.337188, 1.604135>, <0.122138, 0.350347, 1.600052>, <0.088807, 0.350347, 1.600052>, 
      <0.250699, 0.141758, 0.703399>, <0.250699, 0.148440, 0.700552>, <0.217811, 0.153906, 0.698222>, <0.177614, 0.153906, 0.698222>, 
      <0.048117, -0.607949, -1.775382>, <0.048117, -0.580689, -1.782513>, <0.026465, -0.558385, -1.788348>, <0.000000, -0.558385, -1.788348>, 
      <0.048117, -0.872345, -2.790951>, <0.048117, -0.845972, -2.798082>, <0.026465, -0.824394, -2.803917>, <0.000000, -0.824394, -2.803917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.088807, 0.350347, 1.600052>, <0.055476, 0.350347, 1.600052>, <0.028205, 0.337188, 1.604135>, <0.028205, 0.321104, 1.609124>, 
      <0.177614, 0.153906, 0.698222>, <0.137417, 0.153906, 0.698222>, <0.104528, 0.148440, 0.700552>, <0.104528, 0.141758, 0.703399>, 
      <0.000000, -0.558385, -1.788348>, <-0.026465, -0.558385, -1.788348>, <-0.048117, -0.580689, -1.782513>, <-0.048117, -0.607949, -1.775382>, 
      <0.000000, -0.824394, -2.803917>, <-0.026465, -0.824394, -2.803917>, <-0.048117, -0.845972, -2.798082>, <-0.048117, -0.872345, -2.790951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.048117, -0.872345, -2.790951>, <-0.048117, -0.898718, -2.783819>, <-0.026465, -0.920296, -2.777984>, <0.000000, -0.920296, -2.777984>, 
      <-0.048117, -1.136741, -3.806520>, <-0.048117, -1.162226, -3.799388>, <-0.026465, -1.183078, -3.793553>, <0.000000, -1.183078, -3.793553>, 
      <-0.048117, -1.420926, -4.822089>, <-0.048117, -1.446411, -4.814957>, <-0.026465, -1.467263, -4.809122>, <0.000000, -1.467263, -4.809122>, 
      <-0.048117, -1.705111, -5.837658>, <-0.048117, -1.730596, -5.830527>, <-0.026465, -1.751448, -5.824692>, <0.000000, -1.751448, -5.824692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.920296, -2.777984>, <0.026465, -0.920296, -2.777984>, <0.048117, -0.898718, -2.783819>, <0.048117, -0.872345, -2.790951>, 
      <0.000000, -1.183078, -3.793553>, <0.026465, -1.183078, -3.793553>, <0.048117, -1.162226, -3.799388>, <0.048117, -1.136741, -3.806520>, 
      <0.000000, -1.467263, -4.809122>, <0.026465, -1.467263, -4.809122>, <0.048117, -1.446411, -4.814957>, <0.048117, -1.420926, -4.822089>, 
      <0.000000, -1.751448, -5.824692>, <0.026465, -1.751448, -5.824692>, <0.048117, -1.730596, -5.830527>, <0.048117, -1.705111, -5.837658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.048117, -0.872345, -2.790951>, <0.048117, -0.845972, -2.798082>, <0.026465, -0.824394, -2.803917>, <0.000000, -0.824394, -2.803917>, 
      <0.048117, -1.136741, -3.806520>, <0.048117, -1.111255, -3.813651>, <0.026465, -1.090403, -3.819486>, <0.000000, -1.090403, -3.819486>, 
      <0.048117, -1.420926, -4.822089>, <0.048117, -1.395440, -4.829221>, <0.026465, -1.374588, -4.835055>, <0.000000, -1.374588, -4.835055>, 
      <0.048117, -1.705111, -5.837658>, <0.048117, -1.679625, -5.844790>, <0.026465, -1.658773, -5.850625>, <0.000000, -1.658773, -5.850625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.824394, -2.803917>, <-0.026465, -0.824394, -2.803917>, <-0.048117, -0.845972, -2.798082>, <-0.048117, -0.872345, -2.790951>, 
      <0.000000, -1.090403, -3.819486>, <-0.026465, -1.090403, -3.819486>, <-0.048117, -1.111255, -3.813651>, <-0.048117, -1.136741, -3.806520>, 
      <0.000000, -1.374588, -4.835055>, <-0.026465, -1.374588, -4.835055>, <-0.048117, -1.395440, -4.829221>, <-0.048117, -1.420926, -4.822089>, 
      <0.000000, -1.658773, -5.850625>, <-0.026465, -1.658773, -5.850625>, <-0.048117, -1.679625, -5.844790>, <-0.048117, -1.705111, -5.837658>
    }
  }
  texture {
    bois_baton
  }
  translate  <-2.15, 0.52, -0.63>
}
#declare girl = union {
  object { demobabe2_Ref }
  object { targui }
  object { veste }
  object { liens_veste }
  object { baton }
  scale 0.04
  rotate 45.0*z
  translate  <8.61, -5.96, 0.32>
}
// fin girl
//++
// debut paysage
#declare montagnes = object { 
  height_field {
    tga "C:\RT\RESSOURC\RANGE.TGA"
    water_level 0.0
//    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    sable
  }
  scale <22, 8, 4>
  rotate 35.0*z
  translate  <-21, 26, 3>
}
#declare Sand2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.395340, -6.000000, 0.000000>, <-11.395340, -6.000000, 0.000000>, <-10.395340, -6.000000, 0.000000>, <-9.314498, -6.000000, 0.000000>, 
      <-12.395340, -5.000000, 0.000000>, <-11.395340, -5.000000, 0.000000>, <-10.395340, -5.000000, 0.000000>, <-9.314498, -5.000000, 0.000000>, 
      <-12.395340, -4.000000, 0.000000>, <-11.395340, -4.000000, 0.000000>, <-10.395340, -4.000000, 0.000000>, <-9.314498, -4.000000, 0.000000>, 
      <-12.395340, -3.000000, 0.000000>, <-11.395340, -3.000000, 0.281053>, <-10.395340, -3.000000, 0.281053>, <-9.314498, -3.000000, 0.281053>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.395340, -3.000000, 0.000000>, <-11.395340, -3.000000, 0.281053>, <-10.395340, -3.000000, 0.281053>, <-9.314498, -3.000000, 0.281053>, 
      <-12.395340, -2.000000, 0.000000>, <-11.395340, -2.000000, 0.562105>, <-10.395340, -2.000000, 0.562105>, <-9.314498, -2.000000, 0.562105>, 
      <-12.395340, -1.000000, 0.000000>, <-11.395340, -1.000000, 1.061754>, <-10.395340, -1.000000, 1.061754>, <-9.427044, -1.000000, 0.949147>, 
      <-12.395340, 0.000000, 0.000000>, <-11.395340, 0.000000, 0.992681>, <-10.395340, 0.000000, 0.992681>, <-9.427044, 0.000000, 1.030216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.395340, 0.000000, 0.000000>, <-11.395340, 0.000000, 0.992681>, <-10.395340, 0.000000, 0.992681>, <-9.427044, 0.000000, 1.030216>, 
      <-12.395340, 1.000000, 0.000000>, <-11.395340, 1.000000, 0.923607>, <-10.395340, 1.000000, 0.923607>, <-9.427044, 1.000000, 1.036214>, 
      <-12.395340, 2.000000, 0.000000>, <-11.395340, 2.000000, 0.562105>, <-10.395340, 2.000000, 0.562105>, <-9.314498, 2.000000, 0.562105>, 
      <-12.395340, 3.000000, 0.000000>, <-11.395340, 3.000000, 0.281053>, <-10.395340, 3.000000, 0.281053>, <-9.314498, 3.000000, 0.281053>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.395340, 3.000000, 0.000000>, <-11.395340, 3.000000, 0.281053>, <-10.395340, 3.000000, 0.281053>, <-9.314498, 3.000000, 0.281053>, 
      <-12.395340, 4.000000, 0.000000>, <-11.395340, 4.000000, 0.000000>, <-10.395340, 4.000000, 0.000000>, <-9.314498, 4.000000, 0.000000>, 
      <-12.395340, 5.000000, 0.000000>, <-11.395340, 5.000000, 0.000000>, <-10.395340, 5.000000, 0.000000>, <-9.314498, 5.000000, 0.000000>, 
      <-12.395340, 6.000000, 0.000000>, <-11.395340, 6.000000, 0.000000>, <-10.395340, 6.000000, 0.000000>, <-9.314498, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-9.314498, -6.000000, 0.000000>, <-8.233657, -6.000000, 0.000000>, <-7.233657, -6.000000, 0.000000>, <-5.667767, -6.000000, 0.000000>, 
      <-9.314498, -5.000000, 0.000000>, <-8.233657, -5.000000, 0.000000>, <-7.233657, -5.000000, 0.000000>, <-5.667767, -5.000000, 0.000000>, 
      <-9.314498, -4.000000, 0.000000>, <-8.233657, -4.000000, 0.000000>, <-7.233657, -4.000000, 0.000000>, <-5.667767, -4.000000, 0.000000>, 
      <-9.314498, -3.000000, 0.281053>, <-8.233657, -3.000000, 0.281053>, <-7.233657, -3.000000, 0.000000>, <-5.667767, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-9.314498, -3.000000, 0.281053>, <-8.233657, -3.000000, 0.281053>, <-7.233657, -3.000000, 0.000000>, <-5.667767, -3.000000, 0.000000>, 
      <-9.314498, -2.000000, 0.562105>, <-8.233657, -2.000000, 0.562105>, <-7.233657, -2.000000, 0.000000>, <-5.667767, -2.000000, 0.000000>, 
      <-9.427044, -1.000000, 0.949147>, <-8.458749, -1.000000, 0.836540>, <-7.233657, -1.000000, 0.499649>, <-5.667767, -1.000000, 0.249825>, 
      <-9.427044, 0.000000, 1.030216>, <-8.458749, 0.000000, 0.992681>, <-7.233657, 0.000000, 0.655789>, <-5.667767, 0.000000, 0.327895>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-9.427044, 0.000000, 1.030216>, <-8.458749, 0.000000, 0.992681>, <-7.233657, 0.000000, 0.655789>, <-5.667767, 0.000000, 0.327895>, 
      <-9.427044, 1.000000, 1.036214>, <-8.458749, 1.000000, 1.148821>, <-7.233657, 1.000000, 0.811930>, <-5.667767, 1.000000, 0.405965>, 
      <-9.314498, 2.000000, 0.562105>, <-8.233657, 2.000000, 0.562105>, <-7.233657, 2.000000, 0.000000>, <-5.667767, 2.000000, 0.000000>, 
      <-9.314498, 3.000000, 0.281053>, <-8.233657, 3.000000, 0.281053>, <-7.233657, 3.000000, 0.000000>, <-5.687992, 2.921930, 0.424733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-9.314498, 3.000000, 0.281053>, <-8.233657, 3.000000, 0.281053>, <-7.233657, 3.000000, 0.000000>, <-5.687992, 2.921930, 0.424733>, 
      <-9.314498, 4.000000, 0.000000>, <-8.233657, 4.000000, 0.000000>, <-7.233657, 4.000000, 0.000000>, <-5.708218, 3.843860, 0.849465>, 
      <-9.314498, 5.000000, 0.000000>, <-8.233657, 5.000000, 0.000000>, <-7.233657, 5.000000, 0.000000>, <-5.667767, 5.000000, 0.000000>, 
      <-9.314498, 6.000000, 0.000000>, <-8.233657, 6.000000, 0.000000>, <-7.233657, 6.000000, 0.000000>, <-5.667767, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.667767, -6.000000, 0.000000>, <-4.101877, -6.000000, 0.000000>, <-3.101877, -6.000000, 0.000000>, <-1.616828, -6.000000, 0.000000>, 
      <-5.667767, -5.000000, 0.000000>, <-4.101877, -5.000000, 0.000000>, <-3.101877, -5.000000, 0.000000>, <-1.616828, -5.000000, 0.000000>, 
      <-5.667767, -4.000000, 0.000000>, <-4.101877, -4.000000, 0.000000>, <-3.101877, -4.000000, 0.000000>, <-1.616828, -4.000000, 0.000000>, 
      <-5.667767, -3.000000, 0.000000>, <-4.101877, -3.000000, 0.000000>, <-3.101877, -3.000000, 0.000000>, <-1.616828, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.667767, -3.000000, 0.000000>, <-4.101877, -3.000000, 0.000000>, <-3.101877, -3.000000, 0.000000>, <-1.616828, -3.000000, 0.000000>, 
      <-5.667767, -2.000000, 0.000000>, <-4.101877, -2.000000, 0.000000>, <-3.101877, -2.000000, 0.000000>, <-1.616828, -2.000000, 0.000000>, 
      <-5.667767, -1.000000, 0.249825>, <-4.101877, -1.000000, 0.000000>, <-3.101877, -1.000000, 0.000000>, <-1.616828, -1.000000, 0.000000>, 
      <-5.667767, 0.000000, 0.327895>, <-4.101877, 0.000000, 0.000000>, <-3.101877, 0.000000, 0.000000>, <-1.616828, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.667767, 0.000000, 0.327895>, <-4.101877, 0.000000, 0.000000>, <-3.101877, 0.000000, 0.000000>, <-1.616828, 0.000000, 0.000000>, 
      <-5.667767, 1.000000, 0.405965>, <-4.101877, 1.000000, 0.000000>, <-3.101877, 1.000000, 0.000000>, <-1.616828, 1.000000, 0.000000>, 
      <-5.667767, 2.000000, 0.000000>, <-4.101877, 2.000000, 0.000000>, <-3.101877, 2.000000, 0.000000>, <-1.616828, 2.000000, 0.000000>, 
      <-5.687992, 2.921930, 0.424733>, <-4.142328, 2.843860, 0.849465>, <-3.101877, 3.000000, 0.000000>, <-1.616828, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.687992, 2.921930, 0.424733>, <-4.142328, 2.843860, 0.849465>, <-3.101877, 3.000000, 0.000000>, <-1.616828, 3.000000, 0.000000>, 
      <-5.708218, 3.843860, 0.849465>, <-4.182779, 3.687719, 1.698931>, <-3.101877, 4.000000, 0.000000>, <-1.616828, 4.000000, 0.000000>, 
      <-5.667767, 5.000000, 0.000000>, <-4.101877, 5.000000, 0.000000>, <-3.101877, 5.000000, 0.000000>, <-1.616828, 5.000000, 0.000000>, 
      <-5.667767, 6.000000, 0.000000>, <-4.101877, 6.000000, 0.000000>, <-3.101877, 6.000000, 0.000000>, <-1.616828, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.616828, -6.000000, 0.000000>, <-0.131780, -6.000000, 0.000000>, <0.868220, -6.000000, 0.000000>, <2.434110, -6.000000, 0.000000>, 
      <-1.616828, -5.000000, 0.000000>, <-0.131780, -5.000000, 0.000000>, <0.868220, -5.000000, 0.000000>, <2.434110, -5.000000, 0.000000>, 
      <-1.616828, -4.000000, 0.000000>, <-0.131780, -4.000000, 0.000000>, <0.868220, -4.000000, 0.000000>, <2.434110, -4.000000, 0.000000>, 
      <-1.616828, -3.000000, 0.000000>, <-0.131780, -3.000000, 0.000000>, <0.868220, -3.000000, 0.000000>, <2.434110, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.616828, -3.000000, 0.000000>, <-0.131780, -3.000000, 0.000000>, <0.868220, -3.000000, 0.000000>, <2.434110, -3.000000, 0.000000>, 
      <-1.616828, -2.000000, 0.000000>, <-0.131780, -2.000000, 0.000000>, <0.868220, -2.000000, 0.000000>, <2.434110, -2.000000, 0.000000>, 
      <-1.616828, -1.000000, 0.000000>, <-0.131780, -1.000000, 0.000000>, <0.868220, -1.000000, 0.000000>, <2.434110, -1.000000, 0.000000>, 
      <-1.616828, 0.000000, 0.000000>, <-0.131780, 0.000000, 0.000000>, <0.868220, 0.000000, 0.374737>, <2.434110, 0.000000, 0.187368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.616828, 0.000000, 0.000000>, <-0.131780, 0.000000, 0.000000>, <0.868220, 0.000000, 0.374737>, <2.434110, 0.000000, 0.187368>, 
      <-1.616828, 1.000000, 0.000000>, <-0.131780, 1.000000, 0.000000>, <0.868220, 1.000000, 0.749474>, <2.434110, 1.000000, 0.374737>, 
      <-1.616828, 2.000000, 0.000000>, <-0.131780, 2.000000, 0.000000>, <0.868220, 2.000000, 0.749474>, <2.434110, 2.000000, 0.374737>, 
      <-1.616828, 3.000000, 0.000000>, <-0.131780, 3.000000, 0.000000>, <0.868220, 3.000000, 0.374737>, <2.434110, 3.000000, 0.187368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.616828, 3.000000, 0.000000>, <-0.131780, 3.000000, 0.000000>, <0.868220, 3.000000, 0.374737>, <2.434110, 3.000000, 0.187368>, 
      <-1.616828, 4.000000, 0.000000>, <-0.131780, 4.000000, 0.000000>, <0.868220, 4.000000, 0.000000>, <2.434110, 4.000000, 0.000000>, 
      <-1.616828, 5.000000, 0.000000>, <-0.131780, 5.000000, 0.000000>, <0.868220, 5.000000, 0.000000>, <2.434110, 5.000000, 0.000000>, 
      <-1.616828, 6.000000, 0.000000>, <-0.131780, 6.000000, 0.000000>, <0.868220, 6.000000, 0.000000>, <2.434110, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.434110, -6.000000, 0.000000>, <4.000000, -6.000000, 0.000000>, <5.000000, -6.000000, 0.000000>, <6.000000, -6.000000, 0.000000>, 
      <2.434110, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>, <5.000000, -5.000000, 0.000000>, <6.000000, -5.000000, 0.000000>, 
      <2.434110, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, <5.000000, -4.000000, 0.000000>, <6.000000, -4.000000, 0.000000>, 
      <2.434110, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, <5.000000, -3.000000, 0.000000>, <6.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.434110, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, <5.000000, -3.000000, 0.000000>, <6.000000, -3.000000, 0.000000>, 
      <2.434110, -2.000000, 0.000000>, <4.000000, -2.000000, 0.000000>, <5.000000, -2.000000, 0.000000>, <6.000000, -2.000000, 0.000000>, 
      <2.434110, -1.000000, 0.000000>, <4.000000, -1.000000, 0.000000>, <5.000000, -1.000000, 0.000000>, <6.000000, -1.000000, 0.000000>, 
      <2.434110, 0.000000, 0.187368>, <4.000000, 0.000000, 0.000000>, <5.000000, 0.000000, 0.000000>, <6.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.434110, 0.000000, 0.187368>, <4.000000, 0.000000, 0.000000>, <5.000000, 0.000000, 0.000000>, <6.000000, 0.000000, 0.000000>, 
      <2.434110, 1.000000, 0.374737>, <4.000000, 1.000000, 0.000000>, <5.000000, 1.000000, 0.000000>, <6.000000, 1.000000, 0.000000>, 
      <2.434110, 2.000000, 0.374737>, <4.000000, 2.000000, 0.000000>, <5.000000, 2.000000, 0.000000>, <6.000000, 2.000000, 0.000000>, 
      <2.434110, 3.000000, 0.187368>, <4.000000, 3.000000, 0.000000>, <5.000000, 3.000000, 0.000000>, <6.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.434110, 3.000000, 0.187368>, <4.000000, 3.000000, 0.000000>, <5.000000, 3.000000, 0.000000>, <6.000000, 3.000000, 0.000000>, 
      <2.434110, 4.000000, 0.000000>, <4.000000, 4.000000, 0.000000>, <5.000000, 4.000000, 0.000000>, <6.000000, 4.000000, 0.000000>, 
      <2.434110, 5.000000, 0.000000>, <4.000000, 5.000000, 0.000000>, <5.000000, 5.000000, 0.000000>, <6.000000, 5.000000, 0.000000>, 
      <2.434110, 6.000000, 0.000000>, <4.000000, 6.000000, 0.000000>, <5.000000, 6.000000, 0.000000>, <6.000000, 6.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, -6.000000, 0.000000>, <7.000000, -6.000000, 0.000000>, <8.000000, -6.000000, 0.000000>, <9.000000, -6.000000, 0.000000>, 
      <6.000000, -5.000000, 0.000000>, <7.000000, -5.000000, 0.000000>, <8.000000, -5.000000, 0.000000>, <9.000000, -5.000000, 0.000000>, 
      <6.000000, -4.000000, 0.000000>, <7.000000, -4.000000, 0.000000>, <8.000000, -4.000000, 0.000000>, <9.000000, -4.000000, 0.000000>, 
      <6.000000, -3.000000, 0.000000>, <7.000000, -3.000000, 0.000000>, <8.000000, -3.000000, 0.000000>, <9.000000, -3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, -3.000000, 0.000000>, <7.000000, -3.000000, 0.000000>, <8.000000, -3.000000, 0.000000>, <9.000000, -3.000000, 0.000000>, 
      <6.000000, -2.000000, 0.000000>, <7.000000, -2.000000, 0.000000>, <8.000000, -2.000000, 0.000000>, <9.000000, -2.000000, 0.000000>, 
      <6.000000, -1.000000, 0.000000>, <7.000000, -1.000000, 0.000000>, <8.000000, -1.000000, 0.000000>, <9.000000, -1.000000, 0.000000>, 
      <6.000000, 0.000000, 0.000000>, <7.000000, 0.000000, 0.000000>, <8.000000, 0.000000, 0.000000>, <9.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, 0.000000, 0.000000>, <7.000000, 0.000000, 0.000000>, <8.000000, 0.000000, 0.000000>, <9.000000, 0.000000, 0.000000>, 
      <6.000000, 1.000000, 0.000000>, <7.000000, 1.000000, 0.000000>, <8.000000, 1.000000, 0.000000>, <9.000000, 1.000000, 0.000000>, 
      <6.000000, 2.000000, 0.000000>, <7.000000, 2.000000, 0.000000>, <8.000000, 2.000000, 0.000000>, <9.000000, 2.000000, 0.000000>, 
      <6.000000, 3.000000, 0.000000>, <7.000000, 3.000000, 0.000000>, <8.000000, 3.000000, 0.000000>, <9.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.000000, 3.000000, 0.000000>, <7.000000, 3.000000, 0.000000>, <8.000000, 3.000000, 0.000000>, <9.000000, 3.000000, 0.000000>, 
      <6.000000, 4.000000, 0.000000>, <7.000000, 4.000000, 0.000000>, <8.000000, 4.000000, 0.000000>, <9.000000, 4.000000, 0.000000>, 
      <6.000000, 5.000000, 0.000000>, <7.000000, 5.000000, 0.000000>, <8.000000, 5.000000, 0.000000>, <9.000000, 5.000000, 0.000000>, 
      <6.000000, 6.000000, 0.000000>, <7.000000, 6.000000, 0.000000>, <8.000000, 6.000000, 0.000000>, <9.000000, 6.000000, 0.000000>
    }
  }
  texture {
    sable
  }
  translate  <-0.98, 12.93, -0.2>
}
#declare Sand = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -8.000000, 0.000000>, <-5.000000, -8.000000, 0.000000>, <-4.000000, -8.000000, 0.000000>, <-3.000000, -8.000000, 0.000000>, 
      <-6.000000, -7.000000, 0.000000>, <-5.000000, -7.000000, 0.000000>, <-4.000000, -7.000000, 0.000000>, <-3.000000, -7.000000, 0.000000>, 
      <-6.000000, -6.000000, 0.000000>, <-5.000000, -6.000000, 0.000000>, <-4.000000, -6.000000, 0.000000>, <-3.000000, -6.000000, 0.000000>, 
      <-6.000000, -5.000000, 0.000000>, <-5.000000, -5.000000, 0.281053>, <-4.000000, -5.000000, 0.281053>, <-3.000000, -5.000000, 0.140526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -5.000000, 0.000000>, <-5.000000, -5.000000, 0.281053>, <-4.000000, -5.000000, 0.281053>, <-3.000000, -5.000000, 0.140526>, 
      <-6.000000, -4.000000, 0.000000>, <-5.000000, -4.000000, 0.562105>, <-4.000000, -4.000000, 0.562105>, <-3.000000, -4.000000, 0.281053>, 
      <-6.000000, -3.000000, 0.000000>, <-5.000000, -3.000000, 0.562105>, <-4.000000, -3.000000, 0.562105>, <-3.000000, -3.000000, 0.281053>, 
      <-6.000000, -2.000000, 0.000000>, <-5.000000, -2.000000, 0.811930>, <-4.000000, -2.000000, 0.811930>, <-3.000000, -2.000000, 0.405965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -2.000000, 0.000000>, <-5.000000, -2.000000, 0.811930>, <-4.000000, -2.000000, 0.811930>, <-3.000000, -2.000000, 0.405965>, 
      <-6.000000, -1.000000, 0.000000>, <-5.000000, -1.000000, 1.061754>, <-4.000000, -1.000000, 1.061754>, <-3.000000, -1.000000, 0.530877>, 
      <-6.000000, 0.000000, 0.000000>, <-5.000000, -0.062456, 1.623860>, <-4.000000, 0.000000, 1.061754>, <-3.000000, 0.000000, 0.530877>, 
      <-6.000000, 1.000000, 0.000000>, <-5.000000, 0.937544, 0.936842>, <-4.000000, 1.000000, 0.530877>, <-3.000000, 1.000000, 0.265439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 1.000000, 0.000000>, <-5.000000, 0.937544, 0.936842>, <-4.000000, 1.000000, 0.530877>, <-3.000000, 1.000000, 0.265439>, 
      <-6.000000, 2.000000, 0.000000>, <-5.000000, 1.937544, 0.249825>, <-4.000000, 2.000000, 0.000000>, <-3.000000, 2.000000, 0.000000>, 
      <-6.000000, 3.000000, 0.000000>, <-5.000000, 2.937544, 0.249825>, <-4.000000, 3.000000, 0.000000>, <-3.000000, 3.000000, 0.000000>, 
      <-6.000000, 4.000000, 0.000000>, <-5.000000, 3.906316, 0.405965>, <-4.000000, 3.937544, 0.281053>, <-3.000000, 3.968772, 0.062456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 4.000000, 0.000000>, <-5.000000, 3.906316, 0.405965>, <-4.000000, 3.937544, 0.281053>, <-3.000000, 3.968772, 0.062456>, 
      <-6.000000, 5.000000, 0.000000>, <-5.000000, 4.875088, 0.562105>, <-4.000000, 4.875088, 0.562105>, <-3.000000, 4.937544, 0.124912>, 
      <-6.000000, 6.000000, 0.000000>, <-5.000000, 5.875088, 2.997895>, <-4.000000, 5.875088, 0.562105>, <-3.000000, 5.937544, 0.281053>, 
      <-6.000000, 7.000000, -0.249825>, <-5.000000, 7.000000, -0.249825>, <-4.000000, 7.000000, -0.249825>, <-3.000000, 7.000000, -0.249825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -8.000000, 0.000000>, <-2.000000, -8.000000, 0.000000>, <-1.000000, -8.000000, 0.000000>, <0.000000, -8.000000, 0.000000>, 
      <-3.000000, -7.000000, 0.000000>, <-2.000000, -7.000000, 0.000000>, <-1.000000, -7.000000, 0.000000>, <0.000000, -7.000000, 0.000000>, 
      <-3.000000, -6.000000, 0.000000>, <-2.000000, -6.000000, 0.000000>, <-1.000000, -6.000000, 0.000000>, <0.000000, -6.000000, -0.124912>, 
      <-3.000000, -5.000000, 0.140526>, <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, -0.124912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -5.000000, 0.140526>, <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, -0.124912>, 
      <-3.000000, -4.000000, 0.281053>, <-2.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, -0.124912>, 
      <-3.000000, -3.000000, 0.281053>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.405965>, <-2.000000, -2.000000, 0.000000>, <-0.786771, -2.000000, 0.013610>, <0.058978, -2.000000, 0.015298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -2.000000, 0.405965>, <-2.000000, -2.000000, 0.000000>, <-0.786771, -2.000000, 0.013610>, <0.058978, -2.000000, 0.015298>, 
      <-3.000000, -1.000000, 0.530877>, <-2.000000, -1.000000, 0.000000>, <-0.573541, -1.000000, 0.027221>, <0.117957, -1.000000, 0.030597>, 
      <-3.000000, 0.000000, 0.530877>, <-2.000000, 0.000000, 0.000000>, <-0.573541, 0.000000, 0.027221>, <0.117957, 0.000000, 0.030597>, 
      <-3.000000, 1.000000, 0.265439>, <-2.000000, 1.000000, 0.000000>, <-0.786771, 1.000000, 0.013610>, <0.058978, 1.000000, 0.015298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 1.000000, 0.265439>, <-2.000000, 1.000000, 0.000000>, <-0.786771, 1.000000, 0.013610>, <0.058978, 1.000000, 0.015298>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>, 
      <-3.000000, 3.968772, 0.062456>, <-2.000000, 4.000000, -0.156140>, <-1.000000, 4.000000, 0.000000>, <0.000000, 4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 3.968772, 0.062456>, <-2.000000, 4.000000, -0.156140>, <-1.000000, 4.000000, 0.000000>, <0.000000, 4.000000, 0.000000>, 
      <-3.000000, 4.937544, 0.124912>, <-2.000000, 5.000000, -0.312281>, <-1.000000, 5.000000, 0.000000>, <0.000000, 5.000000, 0.000000>, 
      <-3.000000, 5.937544, 0.281053>, <-2.000000, 6.000000, 0.000000>, <-1.000000, 6.000000, 1.498947>, <0.000000, 6.000000, 1.436491>, 
      <-3.000000, 7.000000, -0.249825>, <-2.000000, 7.000000, -0.249825>, <-1.000000, 7.000000, -0.249825>, <0.000000, 7.000000, -0.249825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -8.000000, 0.000000>, <1.000000, -8.000000, 0.000000>, <2.000000, -8.000000, 0.000000>, <3.000000, -8.000000, 0.000000>, 
      <0.000000, -7.000000, 0.000000>, <1.000000, -7.000000, 0.000000>, <2.000000, -7.000000, 0.000000>, <3.000000, -7.000000, 0.000000>, 
      <0.000000, -6.000000, -0.124912>, <1.000000, -6.000000, -0.249825>, <2.000000, -6.000000, -0.249825>, <3.000000, -6.000000, -0.124912>, 
      <0.000000, -5.000000, -0.124912>, <1.000000, -5.000000, -0.249825>, <2.000000, -5.000000, -0.091930>, <3.000000, -5.000000, -0.119123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -5.000000, -0.124912>, <1.000000, -5.000000, -0.249825>, <2.000000, -5.000000, -0.091930>, <3.000000, -5.000000, -0.119123>, 
      <0.000000, -4.000000, -0.124912>, <1.000000, -4.000000, -0.249825>, <2.000000, -4.000000, 0.065965>, <3.000000, -4.000000, -0.113333>, 
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, -0.052632>, 
      <0.058978, -2.000000, 0.015298>, <0.904727, -2.000000, 0.016987>, <2.245614, -2.210526, -0.058978>, <3.226043, -2.087195, -0.276873>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058978, -2.000000, 0.015298>, <0.904727, -2.000000, 0.016987>, <2.245614, -2.210526, -0.058978>, <3.226043, -2.087195, -0.276873>, 
      <0.117957, -1.000000, 0.030597>, <0.809455, -1.000000, 0.033973>, <2.491228, -1.421053, -0.117957>, <3.381911, -1.209478, -0.501115>, 
      <0.117957, 0.000000, 0.030597>, <0.809455, 0.000000, 0.033973>, <3.473684, 0.000000, -0.117957>, <3.873139, 0.001048, -0.407430>, 
      <0.058978, 1.000000, 0.015298>, <0.904727, 1.000000, 0.016987>, <2.736842, 1.000000, -0.058978>, <3.436570, 1.000524, -0.203715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058978, 1.000000, 0.015298>, <0.904727, 1.000000, 0.016987>, <2.736842, 1.000000, -0.058978>, <3.436570, 1.000524, -0.203715>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>, 
      <0.000000, 4.000000, 0.000000>, <1.000000, 4.000000, 0.000000>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.124912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 4.000000, 0.000000>, <1.000000, 4.000000, 0.000000>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.124912>, 
      <0.000000, 5.000000, 0.000000>, <1.000000, 5.000000, 0.000000>, <2.000000, 5.000000, 0.000000>, <3.000000, 5.000000, 0.249825>, 
      <0.000000, 6.000000, 1.436491>, <1.000000, 6.000000, 1.374035>, <2.000000, 6.000000, 0.000000>, <3.000000, 6.000000, 0.000000>, 
      <0.000000, 7.000000, -0.249825>, <1.000000, 7.000000, -0.249825>, <2.000000, 7.000000, -0.249825>, <3.000000, 7.000000, -0.249825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, -8.000000, 0.000000>, <4.000000, -8.000000, 0.000000>, <7.672064, -7.832996, 0.000000>, <10.163743, -8.000000, 0.000000>, 
      <3.000000, -7.000000, 0.000000>, <4.000000, -7.000000, 0.000000>, <7.672064, -6.832996, 0.578947>, <10.163743, -7.000000, 0.000000>, 
      <3.000000, -6.000000, -0.124912>, <4.000000, -6.000000, 0.000000>, <7.672064, -5.832996, 0.000000>, <10.163743, -6.000000, 0.000000>, 
      <3.000000, -5.000000, -0.119123>, <4.000000, -5.000000, -0.146316>, <6.336032, -4.947726, 0.259649>, <10.163743, -5.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, -5.000000, -0.119123>, <4.000000, -5.000000, -0.146316>, <6.336032, -4.947726, 0.259649>, <10.163743, -5.000000, 0.000000>, 
      <3.000000, -4.000000, -0.113333>, <4.000000, -4.000000, -0.292632>, <5.000000, -4.062456, 0.519298>, <10.163743, -4.000000, 0.000000>, 
      <3.000000, -3.000000, -0.052632>, <4.000000, -3.000000, -0.105263>, <5.000000, -3.062456, 0.519298>, <10.163743, -3.000000, -0.105263>, 
      <3.226043, -2.087195, -0.276873>, <4.136297, -1.998952, -0.494768>, <5.432343, -2.031228, -0.024592>, <10.163743, -2.000000, -0.355088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.226043, -2.087195, -0.276873>, <4.136297, -1.998952, -0.494768>, <5.432343, -2.031228, -0.024592>, <10.163743, -2.000000, -0.355088>, 
      <3.381911, -1.209478, -0.501115>, <4.272595, -0.997904, -0.884272>, <5.864686, -1.000000, -0.568483>, <10.163743, -1.000000, -0.604912>, 
      <3.873139, 0.001048, -0.407430>, <4.272595, 0.002096, -0.696904>, <5.864686, 0.000000, -0.381115>, <10.163743, 0.000000, -0.604912>, 
      <3.436570, 1.000524, -0.203715>, <4.136297, 1.001048, -0.348452>, <5.432343, 1.000000, 0.277864>, <10.163743, 1.000000, -0.302456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.436570, 1.000524, -0.203715>, <4.136297, 1.001048, -0.348452>, <5.432343, 1.000000, 0.277864>, <10.163743, 1.000000, -0.302456>, 
      <3.000000, 2.000000, 0.000000>, <4.000000, 2.000000, 0.000000>, <5.000000, 2.000000, 0.936842>, <10.163743, 2.000000, 0.000000>, 
      <3.000000, 3.000000, 0.000000>, <4.000000, 3.000000, 0.000000>, <5.000000, 3.000000, 0.936842>, <10.163743, 3.000000, 0.000000>, 
      <3.000000, 4.000000, 0.124912>, <4.000000, 4.000000, 0.249825>, <5.000000, 4.000000, 0.468421>, <10.163743, 4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.000000, 4.000000, 0.124912>, <4.000000, 4.000000, 0.249825>, <5.000000, 4.000000, 0.468421>, <10.163743, 4.000000, 0.000000>, 
      <3.000000, 5.000000, 0.249825>, <4.000000, 5.000000, 0.499649>, <5.000000, 5.000000, 0.000000>, <10.163743, 5.000000, 0.000000>, 
      <3.000000, 6.000000, 0.000000>, <4.000000, 6.000000, 0.000000>, <5.000000, 6.000000, 0.000000>, <10.163743, 6.000000, 0.000000>, 
      <3.000000, 7.000000, -0.249825>, <4.000000, 7.000000, -0.249825>, <5.000000, 7.000000, -0.249825>, <10.163743, 7.000000, -0.249825>
    }
  }
  texture {
    sable
  }
}
#declare paysage = union {
  object { montagnes }
  sphere { // lune
    <0,0,0>,1
    texture {
      pour_lune
    }
    rotate y*30
    scale 20
    translate  <-40, 90, 10>
  }
  sphere { // ciel
    <0,0,0>,1
    hollow
    texture {
      pour_fond
    }
    scale 5000
  }
  plane { // sous_sol
    z,0
    texture {
      sable
    }
    translate  -0.55*z
  }
  object { Sand2 }
  object { Sand }
}
// fin paysage

//--
// debut tricers
#include "tricer_1.inc"

#declare tricer_1_Ref = object {
  tricer_1
  texture {
    peau_tricer
  }
  scale 0.05
  rotate <90.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare dossier = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.002325, 0.000000, 0.000000>, <-2.002325, -0.110610, 0.000000>, <-1.101279, -0.201110, 0.000000>, <0.000000, -0.201110, 0.000000>, 
      <-1.765012, 0.000000, 0.562835>, <-1.765012, -0.110610, 0.562835>, <-0.970757, -0.201110, 0.562835>, <0.000000, -0.201110, 0.562835>, 
      <-1.285203, 0.000000, 1.057277>, <-1.285203, -0.110610, 1.057277>, <-0.706862, -0.201110, 1.057277>, <0.000000, -0.201110, 1.057277>, 
      <-1.170995, 0.000000, 1.528639>, <-1.170995, -0.110610, 1.528639>, <-0.641206, -0.201110, 1.528639>, <0.006314, -0.201110, 1.528639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.201110, 0.000000>, <1.101279, -0.201110, 0.000000>, <2.002325, -0.110610, 0.000000>, <2.002325, 0.000000, 0.000000>, 
      <0.000000, -0.201110, 0.562835>, <0.970757, -0.201110, 0.562835>, <1.765012, -0.110610, 0.562835>, <1.765012, 0.000000, 0.562835>, 
      <0.000000, -0.201110, 1.057277>, <0.706862, -0.201110, 1.057277>, <1.285203, -0.110610, 1.057277>, <1.285203, 0.000000, 1.057277>, 
      <0.006314, -0.201110, 1.528639>, <0.653834, -0.201110, 1.528639>, <1.183623, -0.110610, 1.528639>, <1.183623, 0.000000, 1.528639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.002325, 0.000000, 0.000000>, <2.002325, 0.110610, 0.000000>, <1.101279, 0.201110, 0.000000>, <0.000000, 0.201110, 0.000000>, 
      <1.765012, 0.000000, 0.562835>, <1.765012, 0.110610, 0.562835>, <0.970757, 0.201110, 0.562835>, <0.000000, 0.201110, 0.562835>, 
      <1.285203, 0.000000, 1.057277>, <1.285203, 0.110610, 1.057277>, <0.706862, 0.201110, 1.057277>, <0.000000, 0.201110, 1.057277>, 
      <1.183623, 0.000000, 1.528639>, <1.183623, 0.110610, 1.528639>, <0.653834, 0.201110, 1.528639>, <0.006314, 0.201110, 1.528639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.201110, 0.000000>, <-1.101279, 0.201110, 0.000000>, <-2.002325, 0.110610, 0.000000>, <-2.002325, 0.000000, 0.000000>, 
      <0.000000, 0.201110, 0.562835>, <-0.970757, 0.201110, 0.562835>, <-1.765012, 0.110610, 0.562835>, <-1.765012, 0.000000, 0.562835>, 
      <0.000000, 0.201110, 1.057277>, <-0.706862, 0.201110, 1.057277>, <-1.285203, 0.110610, 1.057277>, <-1.285203, 0.000000, 1.057277>, 
      <0.006314, 0.201110, 1.528639>, <-0.641206, 0.201110, 1.528639>, <-1.170995, 0.110610, 1.528639>, <-1.170995, 0.000000, 1.528639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.170995, 0.000000, 1.528639>, <-1.170995, -0.110610, 1.528639>, <-0.641206, -0.201110, 1.528639>, <0.006314, -0.201110, 1.528639>, 
      <-1.056787, 0.000000, 2.000000>, <-1.056787, -0.110610, 2.000000>, <-0.575550, -0.201110, 2.000000>, <0.012628, -0.201110, 2.000000>, 
      <-0.951634, 0.000000, 2.500000>, <-0.951634, -0.110610, 2.500000>, <-0.518281, -0.201110, 2.500000>, <0.011372, -0.201110, 2.500000>, 
      <-1.004210, 0.000000, 3.000000>, <-1.004210, -0.110610, 3.000000>, <-0.546916, -0.201110, 3.000000>, <0.012000, -0.201110, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006314, -0.201110, 1.528639>, <0.653834, -0.201110, 1.528639>, <1.183623, -0.110610, 1.528639>, <1.183623, 0.000000, 1.528639>, 
      <0.012628, -0.201110, 2.000000>, <0.600806, -0.201110, 2.000000>, <1.082043, -0.110610, 2.000000>, <1.082043, 0.000000, 2.000000>, 
      <0.011372, -0.201110, 2.500000>, <0.541025, -0.201110, 2.500000>, <0.974377, -0.110610, 2.500000>, <0.974377, 0.000000, 2.500000>, 
      <0.012000, -0.201110, 3.000000>, <0.570915, -0.201110, 3.000000>, <1.028210, -0.110610, 3.000000>, <1.028210, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.183623, 0.000000, 1.528639>, <1.183623, 0.110610, 1.528639>, <0.653834, 0.201110, 1.528639>, <0.006314, 0.201110, 1.528639>, 
      <1.082043, 0.000000, 2.000000>, <1.082043, 0.110610, 2.000000>, <0.600806, 0.201110, 2.000000>, <0.012628, 0.201110, 2.000000>, 
      <0.974377, 0.000000, 2.500000>, <0.974377, 0.110610, 2.500000>, <0.541025, 0.201110, 2.500000>, <0.011372, 0.201110, 2.500000>, 
      <1.028210, 0.000000, 3.000000>, <1.028210, 0.110610, 3.000000>, <0.570915, 0.201110, 3.000000>, <0.012000, 0.201110, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.006314, 0.201110, 1.528639>, <-0.641206, 0.201110, 1.528639>, <-1.170995, 0.110610, 1.528639>, <-1.170995, 0.000000, 1.528639>, 
      <0.012628, 0.201110, 2.000000>, <-0.575550, 0.201110, 2.000000>, <-1.056787, 0.110610, 2.000000>, <-1.056787, 0.000000, 2.000000>, 
      <0.011372, 0.201110, 2.500000>, <-0.518281, 0.201110, 2.500000>, <-0.951634, 0.110610, 2.500000>, <-0.951634, 0.000000, 2.500000>, 
      <0.012000, 0.201110, 3.000000>, <-0.546916, 0.201110, 3.000000>, <-1.004210, 0.110610, 3.000000>, <-1.004210, 0.000000, 3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.004210, 0.000000, 3.000000>, <-1.004210, -0.110610, 3.000000>, <-0.546916, -0.201110, 3.000000>, <0.012000, -0.201110, 3.000000>, 
      <-1.056787, 0.000000, 3.500000>, <-1.056787, -0.110610, 3.500000>, <-0.575550, -0.201110, 3.500000>, <0.012628, -0.201110, 3.500000>, 
      <-3.057143, 0.000000, 4.769061>, <-3.057143, -0.110610, 4.769061>, <-1.681429, -0.201110, 4.000000>, <0.000000, -0.201110, 4.000000>, 
      <-1.505321, 0.000000, 4.836453>, <-1.505321, -0.110610, 4.836453>, <-0.827926, -0.201110, 4.451923>, <0.000000, -0.201110, 4.451923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.012000, -0.201110, 3.000000>, <0.570915, -0.201110, 3.000000>, <1.028210, -0.110610, 3.000000>, <1.028210, 0.000000, 3.000000>, 
      <0.012628, -0.201110, 3.500000>, <0.600806, -0.201110, 3.500000>, <1.082043, -0.110610, 3.500000>, <1.082043, 0.000000, 3.500000>, 
      <0.000000, -0.201110, 4.000000>, <1.681429, -0.201110, 4.000000>, <3.057143, -0.110610, 4.769061>, <3.057143, 0.000000, 4.769061>, 
      <0.000000, -0.201110, 4.451923>, <0.827926, -0.201110, 4.451923>, <1.505321, -0.110610, 4.836453>, <1.505321, 0.000000, 4.836453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.028210, 0.000000, 3.000000>, <1.028210, 0.110610, 3.000000>, <0.570915, 0.201110, 3.000000>, <0.012000, 0.201110, 3.000000>, 
      <1.082043, 0.000000, 3.500000>, <1.082043, 0.110610, 3.500000>, <0.600806, 0.201110, 3.500000>, <0.012628, 0.201110, 3.500000>, 
      <3.057143, 0.000000, 4.769061>, <3.057143, 0.110610, 4.769061>, <1.681429, 0.201110, 4.000000>, <0.000000, 0.201110, 4.000000>, 
      <1.505321, 0.000000, 4.836453>, <1.505321, 0.110610, 4.836453>, <0.827926, 0.201110, 4.451923>, <0.000000, 0.201110, 4.451923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.012000, 0.201110, 3.000000>, <-0.546916, 0.201110, 3.000000>, <-1.004210, 0.110610, 3.000000>, <-1.004210, 0.000000, 3.000000>, 
      <0.012628, 0.201110, 3.500000>, <-0.575550, 0.201110, 3.500000>, <-1.056787, 0.110610, 3.500000>, <-1.056787, 0.000000, 3.500000>, 
      <0.000000, 0.201110, 4.000000>, <-1.681429, 0.201110, 4.000000>, <-3.057143, 0.110610, 4.769061>, <-3.057143, 0.000000, 4.769061>, 
      <0.000000, 0.201110, 4.451923>, <-0.827926, 0.201110, 4.451923>, <-1.505321, 0.110610, 4.836453>, <-1.505321, 0.000000, 4.836453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.505321, 0.000000, 4.836453>, <-1.505321, -0.110610, 4.836453>, <-0.827926, -0.201110, 4.451923>, <0.000000, -0.201110, 4.451923>, 
      <0.046502, 0.000000, 4.903846>, <0.046502, -0.110610, 4.903846>, <0.025576, -0.201110, 4.903846>, <0.000000, -0.201110, 4.903846>, 
      <-1.175824, 0.000000, 5.500000>, <-1.175824, -0.110610, 5.500000>, <-0.646703, -0.201110, 5.500000>, <0.000000, -0.201110, 5.500000>, 
      <0.005154, 0.000000, 5.668508>, <0.005154, 0.000485, 5.668508>, <0.002835, 0.000881, 5.668508>, <0.000000, 0.000881, 5.668508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.201110, 4.451923>, <0.827926, -0.201110, 4.451923>, <1.505321, -0.110610, 4.836453>, <1.505321, 0.000000, 4.836453>, 
      <0.000000, -0.201110, 4.903846>, <-0.025576, -0.201110, 4.903846>, <-0.046502, -0.110610, 4.903846>, <-0.046502, 0.000000, 4.903846>, 
      <0.000000, -0.201110, 5.500000>, <0.646703, -0.201110, 5.500000>, <1.175824, -0.110610, 5.500000>, <1.175824, 0.000000, 5.500000>, 
      <0.000000, 0.000881, 5.668508>, <-0.002835, 0.000881, 5.668508>, <-0.005154, 0.000485, 5.668508>, <-0.005154, 0.000000, 5.668508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.505321, 0.000000, 4.836453>, <1.505321, 0.110610, 4.836453>, <0.827926, 0.201110, 4.451923>, <0.000000, 0.201110, 4.451923>, 
      <-0.046502, 0.000000, 4.903846>, <-0.046502, 0.110610, 4.903846>, <-0.025576, 0.201110, 4.903846>, <0.000000, 0.201110, 4.903846>, 
      <1.175824, 0.000000, 5.500000>, <1.175824, 0.110610, 5.500000>, <0.646703, 0.201110, 5.500000>, <0.000000, 0.201110, 5.500000>, 
      <-0.005154, 0.000000, 5.668508>, <-0.005154, -0.000485, 5.668508>, <-0.002835, -0.000881, 5.668508>, <0.000000, -0.000881, 5.668508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.201110, 4.451923>, <-0.827926, 0.201110, 4.451923>, <-1.505321, 0.110610, 4.836453>, <-1.505321, 0.000000, 4.836453>, 
      <0.000000, 0.201110, 4.903846>, <0.025576, 0.201110, 4.903846>, <0.046502, 0.110610, 4.903846>, <0.046502, 0.000000, 4.903846>, 
      <0.000000, 0.201110, 5.500000>, <-0.646703, 0.201110, 5.500000>, <-1.175824, 0.110610, 5.500000>, <-1.175824, 0.000000, 5.500000>, 
      <0.000000, -0.000881, 5.668508>, <0.002835, -0.000881, 5.668508>, <0.005154, -0.000485, 5.668508>, <0.005154, 0.000000, 5.668508>
    }
  }
  texture {
    pour_selle
  }
  scale <1.0, 1.0, 1.62>
  rotate <-10.0, 0.0, 0.0>
  translate  <0.0, 2.02, -0.07>
}
#declare selle = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.145891, -3.975274, -0.771987>, <0.838258, -4.686866, -0.050454>, <1.530625, -4.065564, -0.682378>, <2.389083, -4.422256, -0.264321>, 
      <-0.575654, -4.687036, -0.079631>, <0.116713, -4.625414, 1.855213>, <0.809080, -4.316760, 1.203017>, <1.501447, -4.008105, 0.550821>, 
      <-1.297200, -4.090527, -0.629630>, <-0.604832, -4.329241, 1.229391>, <0.087535, -4.020587, 0.577194>, <0.779902, -3.711932, -0.075002>, 
      <-2.152879, -4.484025, -0.196711>, <-1.326378, -4.033068, 0.603568>, <-0.634011, -3.724414, -0.048628>, <0.058356, -3.066505, -0.206114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.152879, -4.484025, -0.196711>, <-1.326378, -4.033068, 0.603568>, <-0.634011, -3.724414, -0.048628>, <0.058356, -3.066505, -0.206114>, 
      <-3.008558, -4.877523, 0.236208>, <-2.047923, -3.736896, -0.022254>, <-1.355556, -3.428241, -0.674451>, <-0.663189, -2.421077, -0.337225>, 
      <-3.259814, -5.192728, -0.678951>, <-3.018718, -4.297419, -1.053512>, <-2.077101, -2.164636, 0.000000>, <-1.384734, -1.443091, 0.000000>, 
      <-3.511070, -3.707860, -1.814274>, <-3.269974, -2.899433, -1.677037>, <-2.678618, -1.472269, -0.825764>, <-2.046265, -0.750724, -0.412882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.511070, -3.707860, -1.814274>, <-3.269974, -2.899433, -1.677037>, <-2.678618, -1.472269, -0.825764>, <-2.046265, -0.750724, -0.412882>, 
      <-3.762326, -2.222993, -2.949596>, <-3.521230, -1.501447, -2.300562>, <-3.280135, -0.779902, -1.651528>, <-2.707796, -0.058356, -0.825764>, 
      <-4.013582, -1.530625, -3.625982>, <-3.772487, -0.809080, -2.976948>, <-3.531391, -0.087535, -2.327914>, <-3.290295, 0.634011, -1.678880>, 
      <-4.264839, -0.838258, -4.302368>, <-4.023743, -0.116713, -3.653334>, <-3.782647, 0.604832, -3.004300>, <-3.189543, 1.246586, -0.867115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.389083, -4.422256, -0.264321>, <3.247541, -4.778947, 0.153736>, <3.463495, -5.064895, -0.779858>, <3.679448, -3.541820, -1.809977>, 
      <1.501447, -4.008105, 0.550821>, <2.193814, -3.699451, -0.101376>, <3.238441, -4.149061, -1.112424>, <3.454394, -2.737720, -1.633485>, 
      <0.779902, -3.711932, -0.075002>, <1.472269, -3.403278, -0.727198>, <2.164636, -2.077101, 0.000000>, <2.804965, -1.355556, -0.734498>, 
      <0.058356, -3.066505, -0.206114>, <0.750724, -2.408595, -0.363599>, <1.443091, -1.384734, 0.000000>, <2.109439, -0.663189, -0.367249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.058356, -3.066505, -0.206114>, <0.750724, -2.408595, -0.363599>, <1.443091, -1.384734, 0.000000>, <2.109439, -0.663189, -0.367249>, 
      <-0.663189, -2.421077, -0.337225>, <0.029178, -1.413913, 0.000000>, <0.721545, -0.692367, 0.000000>, <1.413913, 0.029178, 0.000000>, 
      <-1.384734, -1.443091, 0.000000>, <-0.692367, -0.721545, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.692367, 0.721545, 0.000000>, 
      <-2.046265, -0.750724, -0.412882>, <-1.413913, -0.029178, 0.000000>, <-0.721545, 0.692367, 0.000000>, <-0.029178, 1.601257, 0.608178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.046265, -0.750724, -0.412882>, <-1.413913, -0.029178, 0.000000>, <-0.721545, 0.692367, 0.000000>, <-0.029178, 1.601257, 0.608178>, 
      <-2.707796, -0.058356, -0.825764>, <-2.135458, 0.663189, 0.000000>, <-1.443091, 1.384734, 0.000000>, <-0.750724, 2.480969, 1.216356>, 
      <-3.290295, 0.634011, -1.678880>, <-3.049199, 1.355556, -1.029846>, <-1.702901, 3.593534, 1.244163>, <-1.241401, 2.820434, 1.205044>, 
      <-3.189543, 1.246586, -0.867115>, <-2.596440, 1.888340, 1.270071>, <-2.406772, 2.521525, 0.982606>, <-1.954110, 2.276899, 0.728164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.679448, -3.541820, -1.809977>, <3.895402, -2.018745, -2.840096>, <4.111355, -1.297200, -3.497923>, <4.312119, -0.575654, -4.160715>, 
      <3.454394, -2.737720, -1.633485>, <3.670347, -1.326378, -2.154546>, <3.886301, -0.604832, -2.812373>, <4.102254, 0.116713, -3.470200>, 
      <2.804965, -1.355556, -0.734498>, <3.445293, -0.634011, -1.468997>, <3.661247, 0.087535, -2.126824>, <3.877200, 0.809080, -2.784651>, 
      <2.109439, -0.663189, -0.367249>, <2.775786, 0.058356, -0.734498>, <3.436192, 0.779902, -1.441274>, <3.286632, 1.493429, -0.787038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.109439, -0.663189, -0.367249>, <2.775786, 0.058356, -0.734498>, <3.436192, 0.779902, -1.441274>, <3.286632, 1.493429, -0.787038>, 
      <1.413913, 0.029178, 0.000000>, <2.106280, 0.750724, 0.000000>, <3.211138, 1.472269, -0.755724>, <2.696063, 2.177778, 1.210575>, 
      <0.692367, 0.721545, 0.000000>, <1.384734, 1.443091, 0.000000>, <1.634038, 3.591630, 1.209958>, <2.519015, 2.848104, 0.934202>, 
      <-0.029178, 1.601257, 0.608178>, <0.663189, 2.510147, 1.216356>, <1.134024, 2.819164, 1.173356>, <1.922696, 2.439554, 0.674791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.029178, 1.601257, 0.608178>, <0.663189, 2.510147, 1.216356>, <1.134024, 2.819164, 1.173356>, <1.922696, 2.439554, 0.674791>, 
      <-0.750724, 2.480969, 1.216356>, <-0.058356, 3.577203, 2.432712>, <0.634011, 2.046699, 1.136754>, <1.326378, 2.031003, 0.415380>, 
      <-1.241401, 2.820434, 1.205044>, <-0.779902, 2.047333, 1.165926>, <-0.087535, 2.031638, 0.444551>, <0.604832, 2.015942, -0.276824>, 
      <-1.954110, 2.276899, 0.728164>, <-1.501447, 2.032272, 0.473722>, <-0.809080, 2.016577, -0.247652>, <-0.116713, 2.000881, -0.969027>
    }
  }
  texture {
    pour_selle
  }
}
#declare selle_cuir = union {
  object { dossier }
  object { selle }
  scale 0.015
  rotate <-5.0, 0.0, -120.0>
  translate  <9.071772, -6.041437, 0.43>
}
#declare harnais_arr_1 = union {
  torus { // anneau_queue
    1.5, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale <0.77, 0.38, 1.0>
    rotate <180.0, -80.0, -180.0>
    translate  <-5.9, 0.0, 1.02>
  }
  torus { // ann_queue_1
    1.5, 0.3  rotate -x*90
    texture {
      bronze
    }
    scale 0.15
    rotate <-90.0, 0.0, -15.0>
    translate  <-5.6, -0.6, 0.6>
  }
  torus { // ann_queue_2
    1.5, 0.3  rotate -x*90
    texture {
      bronze
    }
    scale 0.15
    rotate <-90.0, 0.0, 15.0>
    translate  <-5.6, 0.6, 0.6>
  }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare bride_arr_2 = difference {
  torus { // bride_arr_base2
    1.5, 0.05  rotate -x*90
    scale <1.54, 0.73, 1.0>
    rotate <-100.0, -13.0, -45.0>
    translate  <-4.11, -2.12, 0.77>
  }
  box { // brid_arr_2_cut1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-5.29, -0.98, 1.38>
  }
  box { // brid_arr_2_cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.37, 2.0, 1.0>
    translate  <-2.85, -2.74, 1.64>
  }
}
#declare bride_arr_1 = difference {
  torus { // bride_arr_base_1
    1.5, 0.05  rotate -x*90
    scale <1.54, 0.73, 1.0>
    rotate <-100.0, -13.0, 45.0>
    translate  <-4.11, 2.12, 0.77>
  }
  box { // brid_arr_1_cut1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-5.29, 0.98, 1.38>
  }
  box { // brid_arr_1_cut2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.37, 2.0, 1.0>
    translate  <-2.85, 2.74, 1.64>
  }
}
#declare brides_arr = union {
  object { bride_arr_2 }
  object { bride_arr_1 }
  texture {
    bois
  }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <8.993167, -5.9949, 0.240741>
}
#declare longe = difference {
  torus { // longe_base
    2.25, 0.25  rotate -x*90
    scale <0.02, 0.01, 0.01>
    rotate <-90.142891, 19.980314, -0.90567>
    translate  <8.69, -5.89, 0.31>
  }
  box { // longe_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.03>
    rotate <-2.903072, 30.634855, -1.57474>
    translate  <8.705064, -5.888706, 0.326627>
  }
  texture {
    bois
  }
  scale 20.0
  rotate -150.0*z
  translate  <215.739995, -14.01, -6.13>
}
#declare bride_gauche = difference {
  torus { // bride_gauchbase
    1.5, 0.04  rotate -x*90
    scale <1.99, 0.81, 1.0>
    rotate <88.0, 15.0, -18.0>
    translate  <3.18, 1.8, 0.2>
  }
  box { // bride_g_cut_1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.63, 1.0>
    translate  <5.15, 1.0, 0.56>
  }
  box { // bride_g_cut_2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.67, 1.63, 0.93>
    translate  <1.98, 2.16, 1.16>
  }
  texture {
    bois
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare bride_droite = difference {
  torus { // bride_droitebase
    1.5, 0.04  rotate -x*90
    scale <1.99, 0.81, 1.0>
    rotate <-88.0, 15.0, 18.0>
    translate  <3.18, -1.8, 0.2>
  }
  box { // bride_d_cut_1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.63, 1.0>
    translate  <5.15, -1.06, 0.56>
  }
  box { // bride_d_cut_2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.67, 1.63, 0.93>
    translate  <1.98, -2.16, 1.16>
  }
  texture {
    bois
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare le_mors = union {
  torus { // anneau_mors
    1.5, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale 0.54
    rotate -50.0*y
    translate  <5.99, 0.0, -0.06>
  }
  torus { // anneau_mors1
    1.3, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale <0.1, 0.1, 0.5>
    rotate -90.0*x
    translate  <5.99, -0.76, -0.46>
  }
  torus { // anneau_mors2
    1.3, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale <0.1, 0.1, 0.5>
    rotate -90.0*x
    translate  <5.99, 0.75, -0.45>
  }
  cylinder { // mors
    <0,0,1>, <0,0,0>, 1 
    texture {
      bronze
    }
    scale <0.05, 0.05, 1.6>
    rotate 90.0*x
    translate  <5.89, 0.8, -0.31>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare harnais_tete = union {
  object { longe }
  object { bride_gauche }
  object { bride_droite }
  object { le_mors }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare container_bas1 = difference {
  sphere { // cont_base_out1
    <0,0,0>,1
    scale <2.0, 2.0, 4.0>
  }
  sphere { // cont_base_cut1
    <0,0,0>,1
    texture {
      bronze
    }
    scale <1.8, 1.8, 3.8>
  }
  box { // cont_cut_a1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bronze
    }
    scale 2.0
    translate  4.27*z
  }
  texture {
    pour_container
  }
}
#declare container1 = union {
  object { container_bas1 }
  torus { // cont_ann_a1
    1.5, 0.1  rotate -x*90
    scale 1.2
    translate  2.0*z
  }
  torus { // cont_ann_b1
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  1.43*z
  }
  torus { // cont_ann_c1
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  -1.52*z
  }
  texture {
    bois
  }
  scale 0.7
  rotate <-10.0, -10.0, 0.0>
  translate  <-2.8, -3.0, 2.6>
}
#declare container_base = difference {
  sphere { // cont_base_out
    <0,0,0>,1
    scale <2.0, 2.0, 4.0>
  }
  sphere { // cont_base_cut
    <0,0,0>,1
    texture {
      bronze
    }
    scale <1.8, 1.8, 3.8>
  }
  box { // cont_cut_a
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bronze
    }
    scale 2.0
    translate  4.27*z
  }
  texture {
    pour_container
  }
}
#declare container0 = union {
  object { container_base }
  torus { // cont_ann_a
    1.5, 0.1  rotate -x*90
    scale 1.2
    translate  2.0*z
  }
  torus { // cont_ann_b
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  1.43*z
  }
  torus { // cont_ann_c
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  -1.52*z
  }
  texture {
    bois
  }
  scale 0.7
  rotate <-10.0, 10.0, 0.0>
  translate  <0.27, -3.0, 2.6>
}
#declare container_bas2 = difference {
  sphere { // cont_base_out2
    <0,0,0>,1
    scale <2.0, 2.0, 4.0>
  }
  sphere { // cont_base_cut2
    <0,0,0>,1
    texture {
      bronze
    }
    scale <1.8, 1.8, 3.8>
  }
  box { // cont_cut_a2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bronze
    }
    scale 2.0
    translate  4.27*z
  }
  texture {
    pour_container
  }
}
#declare container2 = union {
  object { container_bas2 }
  torus { // cont_ann_a2
    1.5, 0.1  rotate -x*90
    scale 1.2
    translate  2.0*z
  }
  torus { // cont_ann_b2
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  1.43*z
  }
  torus { // cont_ann_c2
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  -1.52*z
  }
  texture {
    bois
  }
  scale 0.7
  rotate <10.0, -10.0, 0.0>
  translate  <-2.8, 3.0, 2.6>
}
#declare container_bas3 = difference {
  sphere { // cont_base_out3
    <0,0,0>,1
    scale <2.0, 2.0, 4.0>
  }
  sphere { // cont_base_cut3
    <0,0,0>,1
    texture {
      bronze
    }
    scale <1.8, 1.8, 3.8>
  }
  box { // cont_cut_a3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bronze
    }
    scale 2.0
    translate  4.27*z
  }
  texture {
    pour_container
  }
}
#declare container3 = union {
  object { container_bas3 }
  torus { // cont_ann_a3
    1.5, 0.1  rotate -x*90
    scale 1.2
    translate  2.0*z
  }
  torus { // cont_ann_b3
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  1.43*z
  }
  torus { // cont_ann_c3
    1.5, 0.1  rotate -x*90
    scale 1.27
    translate  -1.52*z
  }
  texture {
    bois
  }
  scale 0.7
  rotate <10.0, 10.0, 0.0>
  translate  <0.27, 3.0, 2.6>
}
#declare containers = union {
  object { container1 }
  object { container0 }
  object { container2 }
  object { container3 }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare montant_avant = difference {
  torus { // montant_av_base
    1.5, 0.1  rotate -x*90
    scale <1.62, 1.43, 1.54>
    rotate -75.0*y
    translate  <0.71, 0.0, 1.09>
  }
  box { // montant_av_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 1.0>
    rotate 15.0*y
    translate  <0.06, 0.0, -0.81>
  }
}
#declare montant_arr = difference {
  torus { // montant_arr_base
    1.5, 0.1  rotate -x*90
    scale <2.17, 1.4, 1.36>
    rotate <180.0, -75.0, 180.0>
    translate  <-2.99, 0.0, 0.35>
  }
  box { // montant_arr_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.07, 3.0, 1.7>
    rotate -15.0*y
    translate  <-2.37, 0.0, -1.51>
  }
}
#declare harnais_dorsal = union {
  object { montant_avant }
  object { montant_arr }
  texture {
    bronze
  }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare triceratops = union {
  object { tricer_1_Ref }
  object { selle_cuir }
  object { harnais_arr_1 }
  object { brides_arr }
  object { harnais_tete }
  object { containers }
  object { harnais_dorsal }
}
#declare tricer_2_Ref = object {
  tricer_1
  texture {
    peau_tricer
  }
  scale 0.05
  rotate <90.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare harnais_arr_2 = union {
  torus { // anneau_queue1
    1.5, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale <0.77, 0.38, 1.0>
    rotate <180.0, -80.0, -180.0>
    translate  <-5.9, 0.0, 1.02>
  }
  torus { // ann_queue_3
    1.5, 0.3  rotate -x*90
    texture {
      bronze
    }
    scale 0.15
    rotate <-90.0, 0.0, -15.0>
    translate  <-5.6, -0.6, 0.6>
  }
  torus { // ann_queue_4
    1.5, 0.3  rotate -x*90
    texture {
      bronze
    }
    scale 0.15
    rotate <-90.0, 0.0, 15.0>
    translate  <-5.6, 0.6, 0.6>
  }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare bride_arr_3 = difference {
  torus { // bride_arr_bas3
    1.5, 0.05  rotate -x*90
    scale <1.54, 0.73, 1.0>
    rotate <-100.0, -13.0, -45.0>
    translate  <-4.11, -2.12, 0.77>
  }
  box { // brid_arr_2_cu2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-5.29, -0.98, 1.38>
  }
  box { // brid_arr_2_cu3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.37, 2.0, 1.0>
    translate  <-2.85, -2.74, 1.64>
  }
}
#declare bride_arr_4 = difference {
  torus { // bride_arr_bas2
    1.5, 0.05  rotate -x*90
    scale <1.54, 0.73, 1.0>
    rotate <-100.0, -13.0, 45.0>
    translate  <-4.11, 2.12, 0.77>
  }
  box { // brid_arr_1_cu2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-5.29, 0.98, 1.38>
  }
  box { // brid_arr_1_cu3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.37, 2.0, 1.0>
    translate  <-2.85, 2.74, 1.64>
  }
}
#declare brides_arr1 = union {
  object { bride_arr_3 }
  object { bride_arr_4 }
  texture {
    bois
  }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <8.993167, -5.9949, 0.240741>
}
#declare longe1 = difference {
  torus { // longe_base1
    2.25, 0.2  rotate -x*90
    scale <0.1, 0.02, 0.01>
    rotate <-90.364105, 29.969, -1.431385>
    translate  <8.69, -5.89, 0.31>
  }
  box { // longe_cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.08, 0.03>
    rotate <-2.903072, 30.634855, -1.57474>
    translate  <8.71, -5.89, 0.33>
  }
  texture {
    bois
  }
  scale 20.0
  rotate -150.0*z
  translate  <218.479995, -12.64, -4.33>
}
#declare bride_gauche1 = difference {
  torus { // bride_gauchba1
    1.5, 0.04  rotate -x*90
    scale <1.99, 0.81, 1.0>
    rotate <88.0, 15.0, -18.0>
    translate  <3.18, 1.8, 0.2>
  }
  box { // bride_g_cut_3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.63, 1.0>
    translate  <5.15, 1.0, 0.56>
  }
  box { // bride_g_cut_4
    <-1, -1, -1>, <1, 1, 1>
    scale <2.67, 1.63, 0.93>
    translate  <1.98, 2.16, 1.16>
  }
  texture {
    bois
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare bride_droite1 = difference {
  torus { // bride_droiteb1
    1.5, 0.04  rotate -x*90
    scale <1.99, 0.81, 1.0>
    rotate <-88.0, 15.0, 18.0>
    translate  <3.18, -1.8, 0.2>
  }
  box { // bride_d_cut_3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.63, 1.0>
    translate  <5.15, -1.06, 0.56>
  }
  box { // bride_d_cut_4
    <-1, -1, -1>, <1, 1, 1>
    scale <2.67, 1.63, 0.93>
    translate  <1.98, -2.16, 1.16>
  }
  texture {
    bois
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare le_mors1 = union {
  torus { // anneau_mors3
    1.5, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale 0.54
    rotate -50.0*y
    translate  <5.99, 0.0, -0.06>
  }
  torus { // anneau_mors4
    1.3, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale <0.1, 0.1, 0.5>
    rotate -90.0*x
    translate  <5.99, -0.76, -0.46>
  }
  torus { // anneau_mors5
    1.3, 0.1  rotate -x*90
    texture {
      bronze
    }
    scale <0.1, 0.1, 0.5>
    rotate -90.0*x
    translate  <5.99, 0.75, -0.45>
  }
  cylinder { // mors1
    <0,0,1>, <0,0,0>, 1 
    texture {
      bronze
    }
    scale <0.05, 0.05, 1.6>
    rotate 90.0*x
    translate  <5.89, 0.8, -0.31>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare harnais_tete1 = union {
  object { longe1 }
  object { bride_gauche1 }
  object { bride_droite1 }
  object { le_mors1 }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare montant_avant1 = difference {
  torus { // montant_av_ba1
    1.5, 0.1  rotate -x*90
    scale <1.62, 1.43, 1.54>
    rotate -75.0*y
    translate  <0.71, 0.0, 1.09>
  }
  box { // montant_av_cu1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 1.0>
    rotate 15.0*y
    translate  <0.06, 0.0, -0.81>
  }
}
#declare montant_arr1 = difference {
  torus { // montant_arr_b1
    1.5, 0.1  rotate -x*90
    scale <2.17, 1.4, 1.36>
    rotate <180.0, -75.0, 180.0>
    translate  <-2.99, 0.0, 0.35>
  }
  box { // montant_arr_c1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.07, 3.0, 1.7>
    rotate -15.0*y
    translate  <-2.37, 0.0, -1.51>
  }
}
#declare harnais_dorsa1 = union {
  object { montant_avant1 }
  object { montant_arr1 }
  texture {
    bronze
  }
  scale 0.05
  rotate <0.0, -5.0, 150.0>
  translate  <9.0, -6.0, 0.24>
}
#declare baby = union {
  object { tricer_2_Ref }
  object { harnais_arr_2 }
  object { brides_arr1 }
  object { harnais_tete1 }
  object { harnais_dorsa1 }
  scale 0.3
  translate  <6.63, -4.09, 0.02>
}
// fin tricers


union { // scene
  object { fortress }
  object { girl }
  object { paysage }
  object { triceratops }
  object { baby }
rotate x*-90
rotate y*180
}


