/*  Source for "OTHERWORLDLY ARTIFACT" by Charles Fusner */
/*  Composition and original elements copyright (c) 1996 by C Fusner */

/* ****************** */
/* BASIC DECLARATIONS */
/* ****************** */

#declare Copper_Metal = 
texture { //straight outta textures.inc, nothing new here yet...
        pigment{ color red 0.72 green 0.45 blue 0.20 } 
        finish {
                metallic
                ambient 0.2
                diffuse 0.7
                brilliance 6
                reflection 0.25
                phong 0.75
                phong_size 80
        }
        
}

#declare Grey = color red 0.752941 green 0.752941 blue 0.752941

#declare Randseed = seed(0)

#declare Button1 =
box { //the square type
        <-.2, -.2, 0>, <.2, .2, -.8>
}

#declare Button2 =
box { //the rectagular type
        <-.5, -.2, 0>, <.5, .2, -.8>
}

#include "leaves.inc" /* #declare's the basic leaf shape, finish and normal.
                         I left it in the original .INC file: Leaf shape was 
                         developed separately and patched (ahem, sorry) in 
                         when done */


/* ****************** */
/* LIGHTS AND CAMERA  */
/* ****************** */

camera {  
        location <2,20,-12>
        sky <0.0, 1.0, 0.0>  
        up <0.0, 1.0,  0.0>  
        right <1.3333,  0.0,  0.0>
        angle 30        
        look_at  <0,1,.25>
}

light_source { //The main light, meant to represent the sun's light

        <-50,55,-40>
        color rgb<.9,.9,.89>
        area_light <8,0,0>,<0,8,0>, 5, 5
        jitter
        adaptive 2
}

light_source { /*a bit of counter-angle lighting. Might represent sunlight
                 reflected off an unseen cliff or something +Z of the object*/
        
        <2, 25,30>, 
        color rgb<.25,.25,.24>
}


/* ****************** */
/*    THE GROUND      */
/* ****************** */

height_field { 
        tga "basefld.tga"
        translate<-.5,0,-.5>
        rotate <0,90,0>
        scale <16,2,16>

        pigment {  //was going for a sort of salt-and-pepper granite...
                granite
                color_map {
                [0 rgb<0,0,0>]
                [.2 rgb<.5,.5,.5>]
                [.3 rgb<1,1,1> ]
                [ 1 rgb<.75,.75,.75>]
                }
                frequency 5
                turbulence .7
                omega .9
        }
        finish { crand .086 }
}


/* ******************* */
/* THE ARTIFACT ITSELF */
/* ******************* */

union { // complete "Artifact" object

difference { /*For the sake of understanding the display window pieces, 
               remember the object is initially declared standing upright 
               along the Y axis */

        superellipsoid { //the main box...
                <.2 .2>
                scale <3.5, 4, .5>
        
                texture { 
                        Copper_Metal 
                        normal { dents .85 }
                }
        }//end superellipsoid        

        box { //...minus the place for the display window
                <-2.5, 2.0, -.6>, <2.5, 3.5, 0>
        
                texture { 
                        Copper_Metal 
                }
        } //end box

}

/*Start DISPLAY WINDOW*/
box { // a bit of greyness (like an LCD) below the surface...
        <-2.5, 2.0, -.05>,<2.5, 3.5, 0.001>
        pigment { Grey }
}


box { // ...and a slightly iridescent but otherwise glasslike surface
        <-2.4999, 1.9999, -.5>, <2.4999, 3.4999, .05001>
        texture { 
                pigment { color rgbf <0.98, 0.98, 0.98, 0.9> }
                finish  {
                        ambient 0.1
                        diffuse 0.1
                        reflection 0.1
                        refraction 0.9
                        ior 1.45
                        specular 0.8
                        roughness 0.0003
                        phong 1 
                        phong_size 400
                        irid { 
                                .2
                                thickness .4
                                turbulence .25
                        }//end irid

                }//end finish
        }//end texture
}//end irid glass surface
/*Display Window complete*/


union { //the button union

        #declare Transvarx = 0
        #declare Transvary = 1

        #while ( Transvary > -3)
                #while ( Transvarx < 3 )

                        object { Button1 
                                rotate< rand(Randseed), rand(Randseed), 0 >
                                translate <Transvarx, Transvary, 0 >
                        }

                        #declare Transvarx= Transvarx + .6

                #end
                #declare Transvarx= 0
                #declare Transvary= Transvary - .6
        #end


        #declare Transvary = 0

        #while ( Transvary > -3)

                object { Button2 
                        rotate< rand(Randseed), rand(Randseed), 0 >
                        translate <-2, Transvary, 0 >
                }
        
                #declare Transvary= Transvary - .6

        #end

        #declare Transvarx = -2.3

        #while ( Transvarx < -1 )

                object { Button1 
                        rotate< rand(Randseed), rand(Randseed), 0 >
                        translate <Transvarx, 1, 0 >
                }
        
                #declare Transvarx= Transvarx + .6

        #end

        pigment {
                image_map {
                        tga "overlay.tga"
                        interpolate 2
                }
                translate <-.5,-.5,0>
                scale <7, 8, 1>
        }

} //end button union

/*Whole Artifact Union transformations*/        
rotate <80,0,-3> 
translate <0,2,0>

} // end complete "Artifact" object


/* ******************** */
/* ALL THEM DARN LEAVES */
/* ******************** */

object { Leaf //A ...left side, upper
        pigment { rgb<.8,.35,0>  }
        rotate <0,63,0>
        translate <-5.6, 1.5, 4.1>
}

object { Leaf //B ...leaning against the device
        pigment { 
                bozo
                color_map {
                [0 rgb<.65,.164,.164> ]
                [.05 rgb<.8,0,0>]
                [ .1 rgb<.15,.8,0> ]
                [ 1 rgb<.15,.8,0> ]
                }
        }

        rotate <0,0,-55>
        translate <3.94, 1.9, 3.3>
}

object { Leaf //C ...right side, upper
        pigment { rgb<.8,0,0> }
        rotate <0,28,0>
        translate <4.8, 1.5, -1.25>
}
 
object { Leaf //D ..right side, lower
        pigment { rgb<.8,.45,0> }
        rotate <0,128,0>
        translate <4.4, 1.5, -3.75>
}

object { Leaf //E ..left side, lower
        pigment {
                bozo
                color_map {
                [ 0 rgb<0,.8,0> ]
                [ .1 rgb<.45,.8,0> ]
                [ 1 rgb<.55,.8,0> ]
                }
        }
        rotate <0,-57,0>
        translate <-5.72, 1.5, 1.5>
}

object { Leaf //F...on the device top
        pigment { rgb<.55,.8,0> }
        rotate <0,4,0>
        translate <-2.1, 3.2, 2.7>
}

object { Leaf //G...wafting to the ground
        pigment { rgb<.8,.75,0> }
        rotate <10,-57,45>
        translate <-2.3, 6.75, -4>
}

